/*
 * Decompiled with CFR 0.152.
 */
package org.qsos.transformation;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.qsos.data.IElement;
import org.qsos.data.ISheet;
import org.qsos.data.Sheet;
import org.qsos.transformation.IDesXMLizer;

public class DesXMLizer
implements IDesXMLizer {
    public ISheet transformFromXML(URL url) throws JDOMException, IOException {
        SAXBuilder sax = new SAXBuilder();
        try {
            Document docJDom = sax.build(url);
            Element document = docJDom.getRootElement();
            Sheet sheet = new Sheet(this.transformAnElement(document));
            return sheet;
        }
        catch (JDOMException jDOMException) {
            return null;
        }
    }

    public IElement transformAnElement(Element target) {
        org.qsos.data.Element item = new org.qsos.data.Element();
        List children = target.getChildren();
        item.setMeta(target.getName());
        if (target.getText() != null) {
            if (target.getText().startsWith("\n")) {
                item.setText("\n");
            } else if (target.getText() == "") {
                item.setText("\n");
            } else {
                item.setText(target.getText());
            }
        } else {
            item.setText("\n");
        }
        item.setTitle(target.getAttributeValue("title"));
        item.setName(target.getAttributeValue("name"));
        if (children != null) {
            for (Element elChild : children) {
                if (elChild.getName().equals("desc")) {
                    item.setDesc(elChild.getText());
                    continue;
                }
                if (elChild.getName().equals("desc0")) {
                    item.setDesc0(elChild.getText());
                    continue;
                }
                if (elChild.getName().equals("desc1")) {
                    item.setDesc1(elChild.getText());
                    continue;
                }
                if (elChild.getName().equals("desc2")) {
                    item.setDesc2(elChild.getText());
                    continue;
                }
                if (elChild.getName().equals("comment")) {
                    item.setComment(elChild.getText());
                    continue;
                }
                if (elChild.getName().equals("score")) {
                    if (elChild.getText() == "") continue;
                    try {
                        item.setScore(elChild.getText());
                    }
                    catch (IOException e) {
                        System.err.println("Invalid value score must be between 0 and 2");
                    }
                    continue;
                }
                IElement child = this.transformAnElement(elChild);
                child.setContainer(item);
                item.addElement(child);
            }
        }
        return item;
    }
}

