# -*- coding: utf-8 -*-
# Author:   $Author: merkosh $
# Revision: $Rev: 685 $
############################################################################
#    Copyright (C) 2006 by Uwe Mayer                                       #
#    merkosh@hadiko.de                                                     #
#                                                                          #
#    This is free software; you can redistribute it and/or modify it       #
#    under the terms of the GNU Lesser General Public License as           #
#    published by the Free Software Foundation; either version 2.1 of      #
#    the License, or (at your option) any later version.                   #
#                                                                          #
#    This software is distributed in the hope that it will be useful,      #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      #
#    Lesser General Public License for more details.                       #
#                                                                          #
#    You should have received a copy of the GNU Lesser General Public      #
#    License along with this software; if not, write to the                #
#    Free Software Foundation, Inc.,                                       #
#    51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.         #
############################################################################
"""
"""
from sndfile import *


class Sndfile(object):
    """ """
    def __init__(self, f, mode, format=None, autoclose=False):
        """open sndfile object for read (/write) access

        Sndfile(filename, mode, format)
        Sndfile(fd, mode, format, autoclose=False)

        Param:
          filename  - filename to open (string)
          fd        - file descriptor (int)
          mode      - mode-string how to open the file (see fopen(3))

          format    - if `mode` is \"w\" this must specify a libsndfile
                      major and minor mode
                      i.e. SF_FORMAT_WAV|SF_FORMAT_FLOAT
          autoclose - if passing a file descriptor `autoclose` specifies
                      wether the file should be closed when the sndfile
                      object is discarded
        """
        self._info = SF_INFO()
        if (mode == "w"):
            if (format == None): raise ValueError("no format specified")
            self._info.format = format
        if (type(filename) is int):
            self._file = sf_open_fd(f, mode, self._info, autoclose)
        else:
            self._file = sf_open(filename, mode, self._info)
        if (self._file == None): raise IOError('could not open file "%s"'%filename)

    def get_samplerate(self):
        """ """
        return self._info.samplerate

    def get_channels(self):
        """ """
        return self._info.channels

    def get_format(self):
        """ """
        return self._info.format
        
    def close(self):
        """ """
        return sf_close(self._file) == 0

    @staticmethod
    def format_check(format):
        """ """
        info = SF_INFO(format)
        return sf_format_check(info)

    def read_short(self, count):
        """ """
        pass

    def read_int(self, count):
        """ """
        pass

    def read_float(self, count):
        """ """
        pass

    def read_double(self, count):
        """ """
        pass

    def write(self, data):
        """ """
        pass

    
        
