/***************************************************************************/
/*   Copyright (C) 2006 by Uwe Mayer                                       */
/*   merkosh@hadiko.de                                                     */
/*                                                                         */
/*   This is free software; you can redistribute it and/or modify it       */
/*   under the terms of the GNU Lesser General Public License as           */
/*   published by the Free Software Foundation; either version 2.1 of      */
/*   the License, or (at your option) any later version.                   */
/*                                                                         */
/*   This software is distributed in the hope that it will be useful,      */
/*   but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      */
/*   Lesser General Public License for more details.                       */
/*                                                                         */
/*   You should have received a copy of the GNU Lesser General Public      */
/*   License along with this software; if not, write to the                */
/*   Free Software Foundation, Inc.,                                       */
/*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.         */
/***************************************************************************/

#ifndef _pysndfile_h_
#define _pysndfile_h_

#include <config.h>
#include <Python.h>
#include <sndfile.h>

inline SNDFILE* pysf_open_fd(int fd, int mode, SF_INFO *sfinfo, bool close_desc=false) {
  return sf_open_fd(fd, mode, sfinfo, close_desc);
}


PyObject *pysf_command(SNDFILE *sndfile, int cmd);
PyObject *pysf_command(SNDFILE *sndfile, int cmd, long long value);
PyObject *pysf_command(SNDFILE *sndfile, int cmd, SF_FORMAT_INFO *info);
PyObject *pysf_command(SNDFILE *sndfile, int cmd, SF_EMBED_FILE_INFO *info);


#endif
