#PySciTrivia
#Copyright (C) 2005, 2006 Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os, sys, pygame, random, math
from pygame.locals import *

from category import LoopCategory
from question_screen import LoopQuestion
from win_screen import WinScreen

class LoopPlay:
	def __init__(self, screen, background):
		p1score = 0; p2score = 0; p3score = 0
		
		lastcat = -1
	
		roundnum = 1
		running = 1
		while (running == 1):
			gsfile = open('settings/game.txt', 'r')
			gsfile.seek(0)
			numplayers = gsfile.readline(1)
			gsfile.seek(1)
			roundlimit = int(gsfile.readline(1))*5
			gsfile.seek(2)
			scorelimit = int(gsfile.readline(1))*6
			gsfile.close()
			
			numpint = int(numplayers)
			whowillchoose = random.randint(1, numpint)
			
			
			#category screen
			lc = LoopCategory(screen, background, whowillchoose, roundnum, lastcat)
			if lc.backtomenu == 1:
				running = 0
			else:
				#go to question screen using category choice
				lq = LoopQuestion(screen, background, lc.categorychoice, p1score, p2score, p3score, numpint, roundnum)
				
				lastcat = lc.categorychoice
				
				whowillchoose = lq.whowasright
				if whowillchoose == 0:
					whowillchoose = random.randint(1,numpint)
				else: whowillchoose = lq.whowasright
				
				if lq.backtomenu == 1:
					running = 0
				else:	
					p1score = lq.p1score_q
					p2score = lq.p2score_q
					p3score = lq.p3score_q
					
				roundnum += 1
				
				if scorelimit != 0:
					if p1score >= scorelimit:
						print "yay 1"
						WinScreen(screen, background, 1, p1score, p2score, p3score, numpint)
						running = 0
					elif p2score >= scorelimit:
						print "yay 2"
						WinScreen(screen, background, 2, p1score, p2score, p3score, numpint)
						running = 0
					elif p3score >= scorelimit:
						print "yay 3"
						WinScreen(screen, background, 3, p1score, p2score, p3score, numpint)
						running = 0
					
				#roundlimit = 1
				if (roundnum >= roundlimit + 1 and roundlimit != 0):
					scorewin = max(p1score, p2score, p3score)
					sw = scorewin
					if (p1score == sw and p2score != sw and p3score != sw):
						WinScreen(screen, background, 1, p1score, p2score, p3score, numpint)
					elif (p2score == sw and p1score != sw and p3score != sw):
						WinScreen(screen, background, 2, p1score, p2score, p3score, numpint)
					elif (p3score == sw and p1score != sw and p2score != sw):
						WinScreen(screen, background, 3, p1score, p2score, p3score, numpint)
					elif (p1score == sw and p2score == sw):
						WinScreen(screen, background, 12, p1score, p2score, p3score, numpint)
					elif (p1score == sw and p3score == sw):
						WinScreen(screen, background, 13, p1score, p2score, p3score, numpint)
					elif (p2score == sw and p3score == sw):
						WinScreen(screen, background, 23, p1score, p2score, p3score, numpint)
					elif (p1score == sw and p2score == sw and p3score == sw):
						WinScreen(screen, background, 123, p1score, p2score, p3score, numpint)
						
					running = 0
