#PySciTrivia
#Copyright (C) 2005, 2006 Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os, sys, pygame, random, math
from pygame.locals import *

from scale import res, title2color, itemspacing, titleborder, cs
from scale import titlefont, title2font, itemfont 
from scale import bgcolor, titlecolor, itemcolor, boxcolor, box2color, item2color, alpha
import scale

bindspacing = int(res[0]*.05)

class MakeInputsettings:
	def __init__(self, screen, background):
		self.screen = screen
		self.background = background
		
		#create surfaces
		if cs == 2:
			self.title = scale.is_header
		else:
			self.title = titlefont.render("Input Settings", 1, titlecolor)
		self.title2 = title2font.render("bind normal keys, like letters or punctuation, don't use shift, control etc", 1, title2color)
		self.item1 = itemfont.render("Player 1 Buzzer", 1, itemcolor)
		self.item2 = itemfont.render("Player 2 Buzzer", 1, itemcolor)
		self.item3 = itemfont.render("Player 3 Buzzer", 1, itemcolor)
		
		#create rects
		self.titlerect = self.title.get_rect()
		self.title2rect = self.title2.get_rect()
		self.item1rect = self.item1.get_rect()
		self.item2rect = self.item2.get_rect()
		self.item3rect = self.item3.get_rect()
		
		#move rects
		self.titlerect.centerx = screen.get_rect().centerx
		self.title2rect.centerx = screen.get_rect().centerx
		self.title2rect.top = self.titlerect.bottom + titleborder
		self.item1rect.centerx = self.item2rect.centerx = self.item3rect.centerx = screen.get_rect().centerx
		self.item1rect.centery = screen.get_rect().centery
		self.item2rect.top = self.item1rect.top + itemspacing
		self.item3rect.top = self.item2rect.top + itemspacing
	
	def drawscreen(self):
		self.screen.blit(self.title, self.titlerect)
		self.screen.blit(self.title2, self.title2rect)
		self.screen.blit(self.item1, self.item1rect)
		self.screen.blit(self.item2, self.item2rect)
		self.screen.blit(self.item3, self.item3rect)
	
	def drawselection(self, pos, color):
		self.srect = self.item1.get_rect()
		self.srect.width *= 1.2
		self.srect.centerx = self.screen.get_rect().centerx
		self.srect.top = self.item1rect.top

		background2 = pygame.Surface((self.srect.w, self.srect.h))
		background2.set_alpha(alpha)
		background2.fill(color)
		self.srect.top = self.srect.top + itemspacing*(pos - 1)
		
		self.screen.blit(background2, self.srect)
		
	def drawbind(self, key1, key2, key3):
		#make surfaces
		self.bind1 = itemfont.render(key1, 1, item2color)
		self.bind2 = itemfont.render(key2, 1, item2color)
		self.bind3 = itemfont.render(key3, 1, item2color)
		#make rects
		self.bind1rect = self.bind1.get_rect()
		self.bind2rect = self.bind2.get_rect()
		self.bind3rect = self.bind3.get_rect()
		#set rect positions
		self.bind1rect.top = self.item1rect.top
		self.bind2rect.top = self.item2rect.top
		self.bind3rect.top = self.item3rect.top
		self.bind1rect.left = self.bind2rect.left = self.bind3rect.left = self.item1rect.right + bindspacing
		#blit 
		self.screen.blit(self.bind1, self.bind1rect)
		self.screen.blit(self.bind2, self.bind2rect)
		self.screen.blit(self.bind3, self.bind3rect)
		
class LoopInputsettings:
	def __init__(self, screen, background):
		
		mi = MakeInputsettings(screen, background)
		
		isfile = open('settings/input.txt', 'r')
		isfile.seek(0); a = isfile.readline(1)
		isfile.seek(1); b = isfile.readline(1)
		isfile.seek(2); c = isfile.readline(1)
		isfile.close()

		pos = 1
		running = 1
		while (running == 1):
			background.fill(bgcolor)
			screen.blit(background, (0,0))
			mi.drawbind(a, b, c)
			mi.drawselection(pos, boxcolor)
			mi.drawscreen()
			pygame.display.flip()
			pygame.time.wait(10)
			
			mousepos = pygame.mouse.get_pos()
			if mousepos[1] > mi.item1rect.y and  mousepos[1] < mi.item2rect.y:
				pos = 1
			elif mousepos[1] > mi.item2rect.y and  mousepos[1] < mi.item3rect.y:
				pos = 2
			elif mousepos[1] > mi.item3rect.y and  mousepos[1] < mi.item3rect.y + itemspacing:
				pos = 3

			for event in pygame.event.get():
				if event.type is MOUSEBUTTONDOWN:
					screen.blit(background, (0,0))
					mi.drawselection(pos, box2color)
					mi.drawbind(a, b, c)
					mi.drawscreen()
					pygame.display.flip()
					pygame.time.wait(10)
					
					if pos == 1:
						bindrunning = 1
						while (bindrunning == 1):
							for event in pygame.event.get():
								if event.type is KEYUP:
									if event.key == K_ESCAPE: bindrunning = 0
								elif event.type is KEYDOWN:
										newbind = pygame.key.name(event.key)
										if len(newbind) == 1:
											isfile = open('settings/input.txt', 'r+w')
											isfile.seek(0); isfile.write(newbind)
											
											a = newbind
											if a == b:
												isfile.seek(1); isfile.write(" ")
											elif a == c:
												isfile.seek(2); isfile.write(" ")
												
											isfile.close()
											bindrunning = 0
							pygame.time.delay(10)
							
					elif pos == 2:
						bindrunning = 1
						while (bindrunning == 1):
							for event in pygame.event.get():
								if event.type is KEYUP:
									if event.key == K_ESCAPE: bindrunning = 0
								elif event.type is KEYDOWN:
									newbind = pygame.key.name(event.key)
									if len(newbind) == 1:
										isfile = open('settings/input.txt', 'r+w')
										isfile.seek(1); isfile.write(newbind)
		
										b = newbind
										if b == a:
											isfile.seek(0); isfile.write(" ")
										elif b == c:
											isfile.seek(2); isfile.write(" ")
										isfile.close()
										bindrunning = 0
							pygame.time.delay(10)
							
					elif pos == 3:
							bindrunning = 1
							while (bindrunning == 1):
								for event in pygame.event.get():
									if event.type is KEYUP:
										if event.key == K_ESCAPE:
											bindrunning = 0
									elif event.type is KEYDOWN:
										newbind = pygame.key.name(event.key)
										if len(newbind) == 1:
											isfile = open('settings/input.txt', 'r+w')
											isfile.seek(2); isfile.write(newbind)
											
											c = newbind
											if c == a:
												isfile.seek(0); isfile.write(" ")
											elif c == b:
												isfile.seek(1); isfile.write(" ")
											isfile.close()
											bindrunning = 0
								pygame.time.delay(10)
								
				elif event.type is KEYDOWN:
					if event.key == K_ESCAPE: running =  0
						
				elif event.type is QUIT:
					sys.exit()
					
				isfile = open('settings/input.txt', 'r')
				isfile.seek(0); a = isfile.readline(1)
				isfile.seek(1); b = isfile.readline(1)
				isfile.seek(2); c = isfile.readline(1)
				isfile.close()