#PySciTrivia
#Copyright (C) 2005, 2006 Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os, sys, pygame, random, math
from pygame.locals import *

from scale import res, cs, bgcolor, titlecolor, boxcolor, itemcolor, item2color, alpha, whocolor, numcolor, titlefont, itemfont, numfont, itemspacing
from scale import title2font
import scale
from esc import Esc

sys.path.append('data/questions/question_modules')

from physics import qnum_p
from physics_history import qnum_ph
from mathematics import qnum_m
from math_history import qnum_mh
from chemistry import qnum_c
from chemistry_history import qnum_ch
from astronomy import qnum_a
from astronomy_history import qnum_ah
from biology import qnum_b
from biology_history import qnum_bh
from compsci import qnum_cs
from compsci_history import qnum_csh
from techeng import qnum_te
from techeng_history import qnum_teh
from earthsci import qnum_es
from earthsci_history import qnum_esh

#set some stuff according to the resolution
#itemspacing_y = int(.15*res[1])
numshift_x =  int(0.032*res[0])
itemshift_x =  int(0.1*res[0])
headerborder_y = int(0.125*res[1])
heightincrease = int(0.025*res[1])

#category elements, n+1
category = [0]*16

#create the strings in the category list
category[0] = "Physics"
category[1] = "Physics History"
category[2] = "Mathematics"
category[3] = "Mathematics History"
category[4] = "Chemistry"
category[5] = "Chemistry History"
category[6] = "Astronomy"
category[7] = "Astronomy History"
category[8] = "Biology"
category[9] = "Biology History"
category[10] = "Computer Science"
category[11] = "Computer Science History"
category[12] = "Technology and Engineering"
category[13] = "Technology and Engineering History"
category[14] = "Earth Sciences"
category[15] = "Earth Sciences History"
#I'll be lumping medicine in with technology and engineering for now
#category[16] = "Medicine"
#category[17] = "Medicine History"

#number of categories
n = 15

def catweight(qnum):
	
	weight = 0
	i = 1
	while (i <= qnum):
		test = random.randint(0,1)
		if test == 1:
			weight += 1
		else: pass
		i += 1
	return weight
					

class MakeCategoryScreen:
	def __init__(self, screen, background, who, roundnum, lastcat):
		self.screen = screen
		self.background = background
		self.who = who
		
		weight_p = catweight(qnum_p)
		weight_ph = catweight(qnum_ph)
		weight_m = catweight(qnum_m)
		weight_mh = catweight(qnum_mh)
		weight_c = catweight(qnum_c)
		weight_ch = catweight(qnum_ch)
		weight_a = catweight(qnum_a)
		weight_ah = catweight(qnum_ah)
		weight_b = catweight(qnum_b)
		weight_bh = catweight(qnum_bh)
		weight_cs = catweight(qnum_cs)
		weight_csh = catweight(qnum_csh)
		weight_te = catweight(qnum_te)
		weight_teh = catweight(qnum_teh)
		weight_es = catweight(qnum_es)
		weight_esh = catweight(qnum_esh)
		
		w = {"0":weight_p, "1":weight_ph, "2":weight_m, "3":weight_mh, "4":weight_c, "5":weight_ch, \
			"6":weight_a, "7":weight_ah, "8":weight_b, "9":weight_bh, "10":weight_cs, "11":weight_csh, \
			"12":weight_te, "13":weight_teh, "14":weight_es, "15":weight_esh}
		
		items = [(v, k) for k, v in w.items()]
		random.shuffle(items)
		items.sort()
		items.reverse()
		items = [(k, v) for v, k in items]
		
		wsorted = [a for a,b in items]
		
		self.cat1 = int(wsorted[0])
		if self.cat1 == lastcat:
			self.cat1 = int(wsorted[1])
			self.cat2 = int(wsorted[2])
			self.cat3 = int(wsorted[3])
		else:
			self.cat2 = int(wsorted[1])
			self.cat3 = int(wsorted[2])
			if self.cat2 == lastcat:
				self.cat2 =  int(wsorted[2])
				self.cat3 = int(wsorted[3])
			else:
				self.cat3 = int(wsorted[2])
				if self.cat3 == lastcat:
					self.cat3 = int(wsorted[4])
		
		#create surfaces
		if cs == 2:
			self.title = scale.pick_header
		else:
			self.title = titlefont.render("Pick a Category",1, titlecolor)
		self.num1 = numfont.render("1", 1, numcolor)
		self.num2 = numfont.render("2",1, numcolor)
		self.num3 = numfont.render("3",1, numcolor)
		self.item1 = itemfont.render(category[self.cat1],1, itemcolor)
		self.item2 = itemfont.render(category[self.cat2],1, itemcolor)
		self.item3 = itemfont.render(category[self.cat3],1, itemcolor)
		#create rects
		self.titlerect = self.title.get_rect()
		self.num1rect = self.num1.get_rect()
		self.num2rect = self.num2.get_rect()
		self.num3rect = self.num3.get_rect()
		self.item1rect = self.item1.get_rect()
		self.item2rect = self.item2.get_rect()
		self.item3rect = self.item3.get_rect()
		#move rects
		self.titlerect.top += headerborder_y
		self.titlerect.centerx = screen.get_rect().centerx
		
		self.num1rect.left = self.num2rect.left = self.num3rect.left = self.num1rect.left + numshift_x
		self.num1rect.top = self.titlerect.top + int(3*itemspacing)
		self.num2rect.top = self.num1rect.top + int(1.5*itemspacing)
		self.num3rect.top = self.num2rect.top + int(1.5*itemspacing)
		self.item1rect.left = self.item2rect.left = self.item3rect.left = self.item1rect.left + itemshift_x
		self.item1rect.centery = self.num1rect.centery
		self.item2rect.centery = self.num2rect.centery
		self.item3rect.centery = self.num3rect.centery
		
		roundstring = "Round " + str(roundnum)
		self.round = title2font.render(roundstring, 1, titlecolor)
		self.roundrect = self.round.get_rect()
		self.roundrect.top = self.screen.get_rect().top + self.roundrect.h*(.1)
		self.roundrect.right = self.screen.get_rect().right - self.roundrect.h*(.1)
		
	def drawscreen(self):
		self.screen.blit(self.title, self.titlerect)
		self.screen.blit(self.num1, self.num1rect)
		self.screen.blit(self.num2, self.num2rect)
		self.screen.blit(self.num3, self.num3rect)
		self.screen.blit(self.item1, self.item1rect)
		self.screen.blit(self.item2, self.item2rect)
		self.screen.blit(self.item3, self.item3rect)
		self.screen.blit(self.round, self.roundrect)
	
	def drawselection(self, pos):
		self.selectionrect = self.item1.get_rect()
		self.selectionrect.height += heightincrease
		self.selectionrect.centery = self.item1rect.centery
		background2 = pygame.Surface((res[0], self.selectionrect.height))
		background2.set_alpha(alpha)
		background2.fill(boxcolor)
		self.selectionrect.centery = self.selectionrect.centery + int(1.5*itemspacing)*(pos - 1)
		self.screen.blit(background2, self.selectionrect)
		
	def whochooses(self):
		if self.who == 1: choose = itemfont.render("Player 1", 1, whocolor)
		elif self.who == 2: choose = itemfont.render("Player 2", 1, whocolor)
		elif self.who == 3: choose = itemfont.render("Player 3", 1, whocolor)
		chooserect = choose.get_rect()
		chooserect.top = self.screen.get_rect().top + headerborder_y*.25
		chooserect.centerx = self.screen.get_rect().centerx
		self.screen.blit(choose, chooserect)
			
class LoopCategory:
	def __init__(self, screen, background, who, roundnum, lastcat):
		self.backtomenu = 0
		
		mc = MakeCategoryScreen(screen, background, who, roundnum, lastcat)
		escape = Esc(screen, background)
	
		position = 1
		running = 1
		while (running==1):
			background.fill(bgcolor)
			screen.blit(background, (0,0))
			mc.drawselection(position)
			mc.drawscreen()
			mc.whochooses()
			pygame.display.flip()
			pygame.time.wait(10)
			
			#set mouse pos
			mousepos = pygame.mouse.get_pos()
			if mousepos[1] > mc.num1rect.top and mousepos[1] < mc.num1rect.bottom:
					position = 1
			elif mousepos[1] > mc.num2rect.top and mousepos[1] < mc.num2rect.bottom:
					position = 2
			elif mousepos[1] > mc.num3rect.top and mousepos[1] < mc.num3rect.bottom:
					position = 3
			
			for event in pygame.event.get():	
				if event.type is KEYDOWN:
					if event.key == K_1: self.categorychoice = mc.cat1; running = 0
					elif event.key == K_2: self.categorychoice = mc.cat2; running = 0
					elif event.key == K_3: self.categorychoice = mc.cat3; running = 0
						
					elif event.key == K_ESCAPE:
						escape.loop()	
				
				elif event.type is QUIT:
					sys.exit()
				
				elif event.type is MOUSEBUTTONDOWN:
					if position == 1: self.categorychoice = mc.cat1
					elif position == 2: self.categorychoice = mc.cat2
					elif position == 3: self.categorychoice = mc.cat3
					running = 0
						
			self.backtomenu = escape.backtomenu
			if self.backtomenu == 1: running = 0
			