#PySciTrivia
#Copyright (C) 2005, 2006 Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import modules
import os, sys, pygame, random, math
from pygame.locals import *

sys.path.append('sounds')

#initialize pygame
pygame.init()

#unicode
sup_0 = u'\u2070'
sup_1 = u'\u00B9'
sup_2 = u'\u00B2'
sup_3 = u'\u00B3'
sup_4 = u'\u2074'
sup_5 = u'\u2075'
sup_6 = u'\u2076'
sup_7 = u'\u2077'
sup_8 = u'\u2078'
sup_9 = u'\u2079'
sup_plus = u'\u207A'
sup_minus = u'\u207B'
sup_n = u'\u207F'
notequal = u'\u2260'
divide = u'\u00F7'
pi = u'\u03C0'
delta = u'\u0394'
multiply = u'\u00D7'

path = "data/questions/voice/m/"
def checksound(sound):
	try:
		soundfile = path + sound
		open(soundfile)
		return pygame.mixer.Sound(soundfile)
	except IOError:
		return 0



qnum_m = 9

n = qnum_m+1

question_m = [0]*n
answer_m = [0]*n
choice1_m = [0]*n
choice2_m = [0]*n
choice3_m = [0]*n
choice4_m = [0]*n
sound_m = [0]*n


question_m[0] = "The area bounded by a curve and the horizontal axis is equivalent to the curve's?"
choice1_m[0] = "integral"
choice2_m[0] = "derivative"
choice3_m[0] = "second derivative"
choice4_m[0] = "average value"
answer_m[0] = 1
sound_m[0] = checksound('m000.ogg')

question_m[1] = u'Multplying A \u00D7 B, where B \u003E 1, can be thought of the same as which of the following?'
choice1_m[1] = 'repeated subtraction of A, B times'
choice2_m[1] = 'repeated addition of A, B times'
choice3_m[1] = u'B \u00F7 A'
choice4_m[1] = 'none of the above'
answer_m[1] = 2
sound_m[1] = checksound('m001.ogg')

question_m[2] = 'In trigonometry, the sine of an angle in a triangle is equal to the proportion of what sides?'
choice1_m[2] = "opposite / adjacent"
choice2_m[2] = "adjacent / opposite"
choice3_m[2] = "opposite / hypotenuse"
choice4_m[2] = "hypotenus / adjacent"
answer_m[2] = 3
sound_m[2] = checksound('m002.ogg')

question_m[3] = "With the Pythagorean theorem, we know that the hypotenuse of a triangle, side c, is equal to? (with a and b being the other 2 sides of the triangle)"
choice1_m[3] = 'a + b'
choice2_m[3] = u'a\u00B2 + b\u00B2'
choice3_m[3] = u'a \u00D7 b'
choice4_m[3] = u'\u221A(a\u00B2 + b\u00B2)'
answer_m[3] = 4
sound_m[3] = checksound('m003.ogg')

question_m[4] = 'The commutative rule of addition states:'
choice1_m[4] = u'a + b = a \u00D7 b'
choice2_m[4] = 'a + b = b + a'
choice3_m[4] = u'a + b \u2260 b + a'
choice4_m[4] = u'a + b = a \u00F7 b'
answer_m[4] = 2
sound_m[4] = checksound('m004.ogg')

question_m[5] = "Fubini's theorem states that with double integrals, you can do what with them and arrive at the same value?"
choice1_m[5] = 'subtract them'
choice2_m[5] = 'add them'
choice3_m[5] = 'reverse their order'
choice4_m[5] = 'multiply by infinity'
answer_m[5] = 3
sound_m[5] = checksound('m005.ogg')

question_m[6] = "What's the derivative of 3x" + sup_2 + " ?"
choice1_m[6] = '0'
choice2_m[6] = 'x' + sup_3
choice3_m[6] = '5x'
choice4_m[6] = '6x'
answer_m[6] = 4
sound_m[6] = checksound('m006.ogg')

question_m[7] = "Fraction exponents, such as x^(1/n) are really the same as what?"
choice1_m[7] = '"nth roots" of x'
choice2_m[7] = 'x' + sup_n
choice3_m[7] = 'x ' + divide + ' n'
choice4_m[7] = 'nx'
answer_m[7] = 1
sound_m[7] = checksound('m007.ogg')

question_m[8] = "What is the formula for the area of a circle? (where r is the radius)"
choice1_m[8] = pi + "r"
choice2_m[8] = pi + "r" + sup_3
choice3_m[8] = pi + "r" + sup_2
choice4_m[8] = "2" + pi + "r" + sup_2
answer_m[8] = 3
sound_m[8] = checksound('m008.ogg')

question_m[9] = "The slope of a line is equal to?"
choice1_m[9] = delta + "x/" + delta + "y"
choice2_m[9] = delta + "y/" + delta + "x"
choice3_m[9] = delta + "x " + multiply + delta + " y"
choice4_m[9] = delta + "y"
answer_m[9] = 2
sound_m[9] = checksound('m009.ogg')




