#!/usr/local/bin/python
#coding: latin-1

#PySciTrivia
#Copyright (C) 2005, 2006 Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import modules
import os, sys, pygame, random, math
from pygame.locals import *

sys.path.append('sounds')

#initialize pygame
pygame.init()

path = "data/questions/voice/mh/"
def checksound(sound):
	try:
		soundfile = path + sound
		open(soundfile)
		return pygame.mixer.Sound(soundfile)
	except IOError:
		return 0


qnum_mh = 9
n = qnum_mh+1

question_mh = [0]*n
answer_mh = [0]*n
choice1_mh = [0]*n
choice2_mh = [0]*n
choice3_mh = [0]*n
choice4_mh = [0]*n
sound_mh = [0]*n


question_mh[0] = 'Who introduced the notation "e" for the natural base exponential?'
choice1_mh[0] = 'Leonhard Euler'
choice2_mh[0] = 'Gottfried Leibniz'
choice3_mh[0] = 'Pierre de Fermat'
choice4_mh[0] = 'Mikhail Vasilievich Ostrogradsky'
answer_mh[0] = 1
sound_mh[0] = checksound('mh000.ogg')

question_mh[1] = u'What chinese matematician was sucessful in estimating \u03C0 to 7 digits that remained the most accurate estimate for about a millenium?'
choice1_mh[1] = 'Zu Chongzhi'
choice2_mh[1] = 'Liu Hui'
choice3_mh[1] = 'Zu Geng'
choice4_mh[1] = 'Zhu Shijie'
answer_mh[1] = 1
sound_mh[1] = checksound('mh001.ogg')

question_mh[2] = "The most common numerals used around the world (the ones you're using now, such as 1, 2) originated from where?"
choice1_mh[2] = 'Arabian Peninsula'
choice2_mh[2] = 'India'
choice3_mh[2] = 'England'
choice4_mh[2] = 'Japan'
answer_mh[2] = 2
sound_mh[2] = checksound('mh002.ogg')

question_mh[3] = 'Who is credited to have developed calculus independantly from Issac Newton?'
choice1_mh[3] = 'Leonhard Euler'
choice2_mh[3] = 'Brook Taylor'
choice3_mh[3] = 'Carl Friedrich Gauss'
choice4_mh[3] = 'Gottfried Leibniz'
answer_mh[3] = 4
sound_mh[3] = checksound('mh003.ogg')

question_mh[4] = 'Who is credited with developing differential operators?'
choice1_mh[4] = u"Guillaume de l'H\u00F4pital"
choice2_mh[4] = 'Issac Newton'
choice3_mh[4] = 'Oliver Heaviside'
choice4_mh[4] = 'Paul Dirac'
answer_mh[4] = 3
sound_mh[4] = checksound('mh004.ogg')

question_mh[5] = 'You can approximate the area boundend under/above a curve and the x-axis with a sum technique named after who?'
choice1_mh[5] = 'Leonhard Euler'
choice2_mh[5] = 'Bernhard Riemann'
choice3_mh[5] = 'Issac Newton'
choice4_mh[5] = 'Pierre-Simon Laplace'
answer_mh[5] = 2
sound_mh[5] = checksound('mh005.ogg')

question_mh[6] = "Euclid's \"Elements\" was written around what year?"
choice1_mh[6] = "1700"
choice2_mh[6] = '600 BC'
choice3_mh[6] = '300 BC'
choice4_mh[6] = '1450'
answer_mh[6] = 3
sound_mh[6] = checksound('mh006.ogg')

question_mh[7] = "Bhaskara, an Indian mathematician, is known for developing a simple to follow proof for which of the following?"
choice1_mh[7] = 'Pythagorean theorem'
choice2_mh[7] = "Fermat's theorem"
choice3_mh[7] = "Stokes theorem"
choice4_mh[7] = "Sturm's theorem"
answer_mh[7] = 1
sound_mh[7] = checksound('mh007.ogg')

question_mh[8] = "Joost Brgi is credited for having developed what type of function which greatly simplified difficult arithematic calculations?"
choice1_mh[8] = "logarithms"
choice2_mh[8] = "trigonometric"
choice3_mh[8] = "exponentials"
choice4_mh[8] = "Sturm's theorem"
answer_mh[8] = 1
sound_mh[8] = checksound('mh008.ogg')

question_mh[9] = "Leonhard Euler produced about how many seperate volumes of text that were not all published until the earth 20th century?"
choice1_mh[9] = '2'
choice2_mh[9] = '10'
choice3_mh[9] = '20'
choice4_mh[9] = '70'
answer_mh[9] = 2
sound_mh[9] = checksound('mh009.ogg')

