#PySciTrivia
#Copyright (C) 2005, 2006 Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import modules
import os, sys, pygame, random, math
from pygame.locals import *

sys.path.append('sounds')

#initialize pygame
pygame.init()

path = "data/questions/voice/es/"
def checksound(sound):
	try:
		soundfile = path + sound
		open(soundfile)
		return pygame.mixer.Sound(soundfile)
	except IOError:
		return 0

qnum_es = 9
n = qnum_es+1

question_es = [0]*n
answer_es = [0]*n
choice1_es = [0]*n
choice2_es = [0]*n
choice3_es = [0]*n
choice4_es = [0]*n
sound_es = [0]*n

question_es[0] = "The radius of the earth is approximately?"
choice1_es[0] = "6000 km"
choice2_es[0] = "3000 km"
choice3_es[0] = "500 km"
choice4_es[0] = "10,000 km"
answer_es[0] = 1
sound_es[0] = checksound("es000.ogg")

question_es[1] = "The average lightning bolt dissipates how much energy?"
choice1_es[1] = "10 J"
choice2_es[1] = "1 kJ"
choice3_es[1] = "1 MJ"
choice4_es[1] = "500 MJ"
answer_es[1] = 4
sound_es[1] = checksound("es001.ogg")

question_es[2] = "The surface area of the earth is about what percent water?"
choice1_es[2] = "50"
choice2_es[2] = "30"
choice3_es[2] = "70"
choice4_es[2] = "80"
answer_es[2] = 3
sound_es[2] = checksound("es002.ogg")

question_es[3] = "Tectonic plates about how thick?"
choice1_es[3] = "10 km"
choice2_es[3] = "100 km"
choice3_es[3] = "50 km"
choice4_es[3] = "1 km"
answer_es[3] = 2
sound_es[3] = checksound("es003.ogg")

question_es[4] = "The spin associated with hurricanes is caused mostly because of?"
choice1_es[4] = "convection"
choice2_es[4] = "air currents"
choice3_es[4] = "ocean currents"
choice4_es[4] = "the coriolis effect"
answer_es[4] = 4
sound_es[4] = checksound("es004.ogg")

question_es[5] = "Which of the following is usually the most abundant gas released during volcanic activity?"
choice1_es[5] = "water vapor"
choice2_es[5] = "ozone"
choice3_es[5] = "methyl mercury"
choice4_es[5] = "argon"
answer_es[5] = 1
sound_es[5] = checksound("es005.ogg")

question_es[6] = "The upper most part of the earth's surface, including the crust and mantle is known as the:"
choice1_es[6] = "stratosphere"
choice2_es[6] = "hydrosphere"
choice3_es[6] = "lithosphere"
choice4_es[6] = "core"
answer_es[6] = 3
sound_es[6] = checksound("es006.ogg")

question_es[7] = "The Antarctic Circumpolar Current flows in which direction?"
choice1_es[7] = "west to east"
choice2_es[7] = "east to west"
choice3_es[7] = "north to south"
choice4_es[7] = "south to north"
answer_es[7] = 1
sound_es[7] = checksound("es007.ogg")

question_es[8] = "What principle of geology states that processes that have modified the planet throughout time are the same types of processes going on now?"
choice1_es[8] = "principle of uniformitarianism"
choice2_es[8] = "principle of time invariance"
choice3_es[8] = "principle of consistency"
choice4_es[8] = "principle of continuity"
answer_es[8] = 1
sound_es[8] = checksound("es008.ogg")

question_es[9] = "What's the appoximate speed of a wave in granite?"
choice1_es[9] = "1000 m/s"
choice2_es[9] = "5000 m/s"
choice3_es[9] = "1500 m/s"
choice4_es[9] = "300 m/s"
answer_es[9] = 2
sound_es[9] = checksound("es009.ogg")




