#PySciTrivia
#Copyright (C) 2005, 2006 Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import modules
import os, sys, pygame, random, math
from pygame.locals import *

sys.path.append('sounds')

#initialize pygame
pygame.init()

#unicode
sup_0 = u'\u2070'
sup_1 = u'\u00B9'
sup_2 = u'\u00B2'
sup_3 = u'\u00B3'
sup_4 = u'\u2074'
sup_5 = u'\u2075'
sup_6 = u'\u2076'
sup_7 = u'\u2077'
sup_8 = u'\u2078'
sup_9 = u'\u2079'
sup_plus = u'\u207A'
sup_minus = u'\u207B'
sup_n = u'\u207F'
notequal = u'\u2260'
divide = u'\u00F7'
pi = u'\u03C0'
delta = u'\u0394'
multiply = u'\u00D7'

path = "data/questions/voice/c/"
def checksound(sound):
	try:
		soundfile = path + sound
		open(soundfile)
		return pygame.mixer.Sound(soundfile)
	except IOError:
		return 0

qnum_c = 9

n = qnum_c +1
question_c = [0]*n
answer_c = [0]*n
choice1_c = [0]*n
choice2_c = [0]*n
choice3_c = [0]*n
choice4_c = [0]*n
sound_c = [0]*n


question_c[0] = 'Au is the abbreviation for which element?'
choice1_c[0] = 'Silver'
choice2_c[0] = 'Gold'
choice3_c[0] = 'Copper'
choice4_c[0] = 'Americium'
answer_c[0] = 2
sound_c[0] = checksound("c000.ogg")

question_c[1] = "A mole, or Avogadro's number, is approximately equal to?"
choice1_c[1] = u'1.38 x 10\u207B\u00B2\u00B3'
choice2_c[1] = '4.184'
choice3_c[1] = u'1.00 x 10\u00B2\u00B3'
choice4_c[1] = u'6.02 x 10\u00B2\u00B3'
answer_c[1] = 4
sound_c[1] = checksound("c001.ogg")

question_c[2] = 'atomic ions are which of the following?'
choice1_c[2] = 'only negatively charged atoms'
choice2_c[2] = 'only positively charged atoms'
choice3_c[2] = 'negative or positive charged atoms'
choice4_c[2] = 'none of the above'
answer_c[2] = 3
sound_c[2] = checksound("c002.ogg")

question_c[3] = 'Table salt, a common choice for a simple ionic compound is made up of what 2 ions?'
choice1_c[3] = 'sodium and fluoride'
choice2_c[3] = 'potassium and chloride'
choice3_c[3] = 'sodium and iodide'
choice4_c[3] = 'sodium and chloride'
answer_c[3] = 4
sound_c[3] = checksound("c003.ogg")

question_c[4] = 'A proton is about how many times more massive than an electron?'
choice1_c[4] = '1800'
choice2_c[4] = '1 million'
choice3_c[4] = '2'
choice4_c[4] = '10'
answer_c[4] = 1
sound_c[4] = checksound("c004.ogg")

question_c[5] = 'An acid is a solution that readily can give up what?'
choice1_c[5] = 'H' + sup_plus
choice2_c[5] = 'H' + sup_minus
choice3_c[5] = 'OH' + sup_minus
choice4_c[5] = 'electrons'
answer_c[5] = 1
sound_c[5] = checksound("c005.ogg")

question_c[6] = 'An acid is a solution that readily can give up what?'
choice1_c[6] = 'H' + sup_plus
choice2_c[6] = 'H' + sup_minus
choice3_c[6] = 'OH' + sup_minus
choice4_c[6] = 'electrons'
answer_c[6] = 1
sound_c[6] = checksound("c006.ogg")

question_c[7] = 'What is the chemical abbreviation for Arsenic?'
choice1_c[7] = 'Ar'
choice2_c[7] = 'As'
choice3_c[7] = 'Ac'
choice4_c[7] = 'An'
answer_c[7] = 2
sound_c[7] = checksound("c007.ogg")

question_c[8] = 'Most of the normal oxygen molecules in our atmosphere that we breathe is made up out of how many atoms of oxygen?'
choice1_c[8] = '1'
choice2_c[8] = '2'
choice3_c[8] = '3'
choice4_c[8] = 'random'
answer_c[8] = 2
sound_c[8] = checksound("c008.ogg")

question_c[9] = 'A neutron has what type of electric charge?'
choice1_c[9] = 'positive'
choice2_c[9] = 'negative'
choice3_c[9] = 'sometimes +, sometimes -'
choice4_c[9] = 'no charge'
answer_c[9] = 4
sound_c[9] = checksound("c009.ogg")