; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "Pyreb"
!define PRODUCT_VERSION "0.1.3"
!define PRODUCT_PUBLISHER "Giuseppe 'Cowo' Corbelli"
!define PRODUCT_WEB_SITE "http://pyreb.nongnu.org"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\start.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

SetCompressor bzip2

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "dist\${PRODUCT_NAME}-${PRODUCT_VERSION}-Setup.exe"
LoadLanguageFile "${NSISDIR}\Contrib\Language files\English.nlf"
InstallDir "$PROGRAMFILES\Pyreb"
Icon "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
UninstallIcon "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
DirText "Setup will install $(^Name) in the following folder.$\r$\n$\r$\nTo install in a different folder, click Browse and select another folder."
LicenseText "If you accept all the terms of the agreement, choose I Agree to continue. You must accept the agreement to install $(^Name)."
LicenseData "LICENSE"
ShowInstDetails show
ShowUnInstDetails show

Section "MainSection" SEC01
  SetOutPath "$INSTDIR"
  SetOverwrite try
  File "dist\bz2.pyd"
  File "dist\library.zip"
  File "dist\MSVCR71.dll"
  File "dist\pyexpat.pyd"
  SetOutPath "$INSTDIR\Pyreb-doc"
  File "dist\Pyreb-doc\AUTHORS"
  File "dist\Pyreb-doc\LICENSE"
  File "dist\Pyreb-doc\README"
  SetOutPath "$INSTDIR"
  File "dist\python24.dll"
  SetOutPath "$INSTDIR\Resource"
  File "dist\Resource\PreMade.list"
  File "dist\Resource\pyreb_wxglade.xrc"
  SetOutPath "$INSTDIR"
  File "dist\select.pyd"
  File "dist\start.exe"
  CreateDirectory "$SMPROGRAMS\Pyreb"
  CreateShortCut "$SMPROGRAMS\Pyreb\Pyreb.lnk" "$INSTDIR\start.exe"
  CreateShortCut "$DESKTOP\Pyreb.lnk" "$INSTDIR\start.exe"
  File "dist\unicodedata.pyd"
  File "dist\w9xpopen.exe"
  File "dist\wxmsw26h_gizmos_vc.dll"
  File "dist\wxmsw26h_stc_vc.dll"
  File "dist\wxmsw26h_vc.dll"
  File "dist\zlib.pyd"
  File "dist\_controls_.pyd"
  File "dist\_core_.pyd"
  File "dist\_gdi_.pyd"
  File "dist\_gizmos.pyd"
  File "dist\_misc_.pyd"
  File "dist\_socket.pyd"
  File "dist\_stc.pyd"
  File "dist\_windows_.pyd"
  File "dist\_xrc.pyd"
SectionEnd

Section -AdditionalIcons
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateShortCut "$SMPROGRAMS\Pyreb\Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\Pyreb\Uninstall.lnk" "$INSTDIR\uninst.exe"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\start.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\start.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "Pyreb was successfully removed from your computer."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove Pyreb and all of its components?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  Delete "$INSTDIR\${PRODUCT_NAME}.url"
  Delete "$INSTDIR\uninst.exe"
  Delete "$INSTDIR\_xrc.pyd"
  Delete "$INSTDIR\_windows_.pyd"
  Delete "$INSTDIR\_stc.pyd"
  Delete "$INSTDIR\_socket.pyd"
  Delete "$INSTDIR\_misc_.pyd"
  Delete "$INSTDIR\_gizmos.pyd"
  Delete "$INSTDIR\_gdi_.pyd"
  Delete "$INSTDIR\_core_.pyd"
  Delete "$INSTDIR\_controls_.pyd"
  Delete "$INSTDIR\zlib.pyd"
  Delete "$INSTDIR\wxmsw26h_vc.dll"
  Delete "$INSTDIR\wxmsw26h_stc_vc.dll"
  Delete "$INSTDIR\wxmsw26h_gizmos_vc.dll"
  Delete "$INSTDIR\w9xpopen.exe"
  Delete "$INSTDIR\unicodedata.pyd"
  Delete "$INSTDIR\start.exe"
  Delete "$INSTDIR\select.pyd"
  Delete "$INSTDIR\Resource\pyreb_wxglade.xrc"
  Delete "$INSTDIR\Resource\PreMade.list"
  Delete "$INSTDIR\python24.dll"
  Delete "$INSTDIR\Pyreb-doc\README"
  Delete "$INSTDIR\Pyreb-doc\LICENSE"
  Delete "$INSTDIR\Pyreb-doc\AUTHORS"
  Delete "$INSTDIR\Pyreb-0.1.2.win32.zip"
  Delete "$INSTDIR\pyexpat.pyd"
  Delete "$INSTDIR\MSVCR71.dll"
  Delete "$INSTDIR\library.zip"
  Delete "$INSTDIR\bz2.pyd"

  Delete "$SMPROGRAMS\Pyreb\Uninstall.lnk"
  Delete "$SMPROGRAMS\Pyreb\Website.lnk"
  Delete "$DESKTOP\Pyreb.lnk"
  Delete "$SMPROGRAMS\Pyreb\Pyreb.lnk"

  RMDir "$SMPROGRAMS\Pyreb"
  RMDir "$INSTDIR\Resource"
  RMDir "$INSTDIR\Pyreb-doc"
  RMDir "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd
