## This file is part of PyQLogger.
## 
## Copyright (c) 2004 Eli Yukelzon a.k.a Reflog 		
##
## PyQLogger is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
## 
## PyQLogger is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
## 
## You should have received a copy of the GNU General Public License
## along with PyQLogger; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

""" Background workers """
from qt import *
from threading import *
import sys
from datetime import date

class BackGround:
	""" class that provides a timer that checks on background processes,
	and method for adding new background workers. all workers should provide following methods:
	notify(),ui(),bg() """
	def __init__(self):
		self.workers = {}
		self.checkTimer = QTimer()
		self.checkTimer.connect(self.checkTimer, SIGNAL("timeout()"), self.check)
		self.checkTimer.start(500)
	
	def check(self):
		for worker in self.workers.keys():
			if not self.workers[worker].THREAD.isAlive():
				self.workers[worker].notify()
				self.workers[worker].ui()
				if self.workers[worker].SENDER: 
					self.workers[worker].SENDER.setEnabled(True)
				del self.workers[worker]
			else:
				self.workers[worker].status()


	def add(self,worker,sender=None):		
		if self.workers.has_key(str(worker)): # only add unique workers!
			return False		
		worker.THREAD = Thread(args=[worker],target=worker.bg)
		worker.THREAD.start()
		if sender:
			sender.setEnabled(False)			
		worker.SENDER = sender
		self.workers[str(worker)] = worker
		return True
	

class bgWorker:
	def __init__(self,atomBlog,OSD,parent,statusmsg):
		self.OSD = OSD
		self.parent = parent
		self.atomBlog = atomBlog
		self.result = None
		self.statusmsg = statusmsg

	def status(self):
		self.OSD.status(self.statusmsg)

class blogFetchWorker(bgWorker):
	""" class for fetching list of blogs in background """

	def bg(self,*args):
		try:
			blogs = self.atomBlog.getBlogs ()
			self.result = len(blogs)
			self.parent.settings["blogs"] = blogs
		except:
			self.result = None
		
	def notify(self):
		if self.result:
			self.OSD.info("%d Blogs fetched!"%(self.result))
		else:
			self.OSD.error("Couldn't fetch blogs!")
		
	def ui(self):
		self.parent.comboBlogs.clear()
		for blog in self.parent.settings["blogs"].keys():
			self.parent.comboBlogs.insertItem(blog)					
		idx = [i for i in range(0,self.parent.comboBlogs.count()) if self.parent.comboBlogs.text(i) == self.parent.settings["selectedblog"]]
		self.parent.comboBlogs.setCurrentItem( idx [0] )


class postFetchWorker(bgWorker):
	""" class for fetching list of posts in background """
	def bg(self,*args):
		try:
			blogid = self.parent.settings["blogs"][self.parent.settings["selectedblog"]]['id']
			self.PublishedPosts = self.atomBlog.getPosts(blogid)
		except:
			self.result = 666

		
	def notify(self):
		if not self.result:
			self.OSD.info("%d posts fetched!"%(len(self.PublishedPosts)))
		else:
			self.OSD.error("Couldn't fetch posts from blog!")
		
	def ui(self):
		if not self.result:
			self.parent.PublishedItems = {}
			self.parent.PublishedPosts  = self.PublishedPosts
			self.parent.listPublishedPosts.clear()
			for post in self.parent.PublishedPosts :
				i = QListBoxText(self.parent.listPublishedPosts,post['title'])
				self.parent.PublishedItems[i] = post


class postDeleteWorker(bgWorker):
	""" class for deleting current post in background """
	def bg(self,*args):
		try:
			post = self.parent.PublishedItems [ self.parent.listPublishedPosts.selectedItem () ]
			del self.parent.PublishedItems [ self.parent.listPublishedPosts.selectedItem () ]
			blogid = self.parent.settings["blogs"][self.parent.settings["selectedblog"]]['id']
			self.atomBlog.deletePost(blogid, post["id"])
			self.parent.PublishedPosts.remove(post)
		except:
			self.result = sys.exc_info()[0].__doc__

		
	def notify(self):
		if not self.result:
			self.OSD.info("Post deleted!")
		else:
			self.OSD.error("Couldn't fetch posts from blog! Error:"+self.result)
		
	def ui(self):
		i = self.parent.listPublishedPosts.currentItem()
		self.parent.listPublishedPosts.removeItem(i)


class newPostWorker(bgWorker):
	""" class for posting new blog item (or reposting) in background """
	def bg(self,*args):
		self.item_to_update = None
		self.result = False
		p = self.parent
		blogId = p.settings["blogs"][p.settings["selectedblog"]]['id']
		title = str(p.editPostTitle.text())
		content = str(p.sourceEditor.text())
		# are we editing?
		if p.current_post and p.current_post.has_key('id'): #yes!
			#yes, edit it
			try:
				self.atomBlog.editPost(blogId,p.current_post['id'],	title,content)
				self.result = True
				idx = p.PublishedPosts.index(p.current_post)
				p.PublishedPosts[idx]['date'] = date.today()
				p.PublishedPosts[idx]["title"] = title
				p.PublishedPosts[idx]["content"] = content
				self.item_to_update = p.PublishedPosts[idx] 
			except:
				self.result = False
					
		else: #no, we are creating
			try:
				idx = self.atomBlog.newPost(blogId,title,content)
				if idx:
					self.result = True
					item = {
						"id":idx,
						"date":date.today(),
						"title":title,
						"content":content,
						}
					i = QListBoxText(p.listPublishedPosts,title)
					p.PublishedPosts += [ item ]
					p.PublishedItems [ i ] = item
			except:
				self.result = False

	def notify(self):
		if self.result:
			self.OSD.info("Publishing success!")
		else:
			self.OSD.error("Couldn't post to blog!")
		
	def ui(self):
		self.parent.current_post = None
		self.parent.editPostTitle.setText("")
		self.parent.sourceEditor.setText("")
		if self.item_to_update:
			for (k,v) in self.parent.PublishedItems.items():
				if v == self.item_to_update:
					k.setText(v['title'])
					self.parent.listPublishedPosts.updateItem(k)
