#!/usr/bin/python
##  This file is part of psg, PostScript Generator.
##
##  Copyright 2006 by Diedrich Vorberg <diedrich@tux4web.de>
##
##  All Rights Reserved
##
##  For more Information on orm see the README file.
##
##  This program is free software; you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation; either version 2 of the License, or
##  (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##
##  You should have received a copy of the GNU General Public License
##  along with this program; if not, write to the Free Software
##  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##
##  I have added a copy of the GPL in the file gpl.txt.


#
# $Log: encoding_tables.py,v $
# Revision 1.3  2006/10/16 12:52:43  diedrich
# Changed my CVS Root to Savannah, commiting changes since the upload.
#
# Revision 1.3  2006/10/14 22:25:42  t4w00-diedrich
# Massive docstring update for epydoc.
#
# Revision 1.2  2006/08/29 01:09:23  t4w00-diedrich
# Many things are working now and I'm to tired for the details.
#
# Revision 1.1  2006/08/24 13:59:59  t4w00-diedrich
# Initial commit
#
#
#


"""
@var tables: Dict that maps PostScript encoding names to encoding
  tables. Encoding tables are dicts themselves mapping font char code to
  unicode char code. 
"""


adobe_standard_to_unicode = { 0x20:0x20,0x21:0x21,0x22:0x22,0x23:0x23,0x24:0x24,0x25:0x25,0x26:0x26,0x27:0x27,0x28:0x28,0x29:0x29,0x2a:0x2a,0x2b:0x2b,0x2c:0x2c,0x2d:0x2d,0x2e:0x2e,0x2f:0x2f,0x30:0x30,0x31:0x31,0x32:0x32,0x33:0x33,0x34:0x34,0x35:0x35,0x36:0x36,0x37:0x37,0x38:0x38,0x39:0x39,0x3a:0x3a,0x3b:0x3b,0x3c:0x3c,0x3d:0x3d,0x3e:0x3e,0x3f:0x3f,0x40:0x40,0x41:0x41,0x42:0x42,0x43:0x43,0x44:0x44,0x45:0x45,0x46:0x46,0x47:0x47,0x48:0x48,0x49:0x49,0x4a:0x4a,0x4b:0x4b,0x4c:0x4c,0x4d:0x4d,0x4e:0x4e,0x4f:0x4f,0x50:0x50,0x51:0x51,0x52:0x52,0x53:0x53,0x54:0x54,0x55:0x55,0x56:0x56,0x57:0x57,0x58:0x58,0x59:0x59,0x5a:0x5a,0x5b:0x5b,0x5c:0x5c,0x5d:0x5d,0x5e:0x5e,0x5f:0x5f,0x60:0x60,0x61:0x61,0x62:0x62,0x63:0x63,0x64:0x64,0x65:0x65,0x66:0x66,0x67:0x67,0x68:0x68,0x69:0x69,0x6a:0x6a,0x6b:0x6b,0x6c:0x6c,0x6d:0x6d,0x6e:0x6e,0x6f:0x6f,0x70:0x70,0x71:0x71,0x72:0x72,0x73:0x73,0x74:0x74,0x75:0x75,0x76:0x76,0x77:0x77,0x78:0x78,0x79:0x79,0x7a:0x7a,0x7b:0x7b,0x7c:0x7c,0x7d:0x7d,0x7e:0x7e,0x90:0x131,0x91:0x300,0x92:0x301,0x93:0x302,0x94:0x303,0x95:0x304,0x96:0x306,0x97:0x307,0x98:0x308,0x9a:0x30a,0x9b:0x327,0x9d:0x30b,0x9e:0x328,0x9f:0x30c,0xa0:0xa0,0xa1:0xa1,0xa2:0xa2,0xa3:0xa3,0xa4:0xa4,0xa5:0xa5,0xa6:0xa6,0xa7:0xa7,0xa8:0xa8,0xa9:0xa9,0xaa:0xaa,0xab:0xab,0xac:0xac,0xad:0xad,0xae:0xae,0xaf:0xaf,0xb0:0xb0,0xb1:0xb1,0xb2:0xb2,0xb3:0xb3,0xb4:0xb4,0xb5:0xb5,0xb6:0xb6,0xb7:0xb7,0xb8:0xb8,0xb9:0xb9,0xba:0xba,0xbb:0xbb,0xbc:0xbc,0xbd:0xbd,0xbe:0xbe,0xbf:0xbf,0xc0:0xc0,0xc1:0xc1,0xc2:0xc2,0xc3:0xc3,0xc4:0xc4,0xc5:0xc5,0xc6:0xc6,0xc7:0xc7,0xc8:0xc8,0xc9:0xc9,0xca:0xca,0xcb:0xcb,0xcc:0xcc,0xcd:0xcd,0xce:0xce,0xcf:0xcf,0xd0:0xd0,0xd1:0xd1,0xd2:0xd2,0xd3:0xd3,0xd4:0xd4,0xd5:0xd5,0xd6:0xd6,0xd7:0xd7,0xd8:0xd8,0xd9:0xd9,0xda:0xda,0xdb:0xdb,0xdc:0xdc,0xdd:0xdd,0xde:0xde,0xdf:0xdf,0xe0:0xe0,0xe1:0xe1,0xe2:0xe2,0xe3:0xe3,0xe4:0xe4,0xe5:0xe5,0xe6:0xe6,0xe7:0xe7,0xe8:0xe8,0xe9:0xe9,0xea:0xea,0xeb:0xeb,0xec:0xec,0xed:0xed,0xee:0xee,0xef:0xef,0xf0:0xf0,0xf1:0xf1,0xf2:0xf2,0xf3:0xf3,0xf4:0xf4,0xf5:0xf5,0xf6:0xf6,0xf7:0xf7,0xf8:0xf8,0xf9:0xf9,0xfa:0xfa,0xfb:0xfb,0xfc:0xfc,0xfd:0xfd,0xfe:0xfe,0xff:0xff }

adobe_symbol_to_unicode = { 0x20:0x20,0x21:0x21,0x22:0x22,0x23:0x23,0x24:0x24,0x25:0x25,0x26:0x26,0x27:0x27,0x28:0x28,0x29:0x29,0x2a:0x2a,0x2b:0x2b,0x2c:0x2c,0x2d:0x2d,0x2e:0x2e,0x2f:0x2f,0x30:0x30,0x31:0x31,0x32:0x32,0x33:0x33,0x34:0x34,0x35:0x35,0x36:0x36,0x37:0x37,0x38:0x38,0x39:0x39,0x3a:0x3a,0x3b:0x3b,0x3c:0x3c,0x3d:0x3d,0x3e:0x3e,0x3f:0x3f,0x40:0x40,0x41:0x41,0x42:0x42,0x43:0x43,0x44:0x44,0x45:0x45,0x46:0x46,0x47:0x47,0x48:0x48,0x49:0x49,0x4a:0x4a,0x4b:0x4b,0x4c:0x4c,0x4d:0x4d,0x4e:0x4e,0x4f:0x4f,0x50:0x50,0x51:0x51,0x52:0x52,0x53:0x53,0x54:0x54,0x55:0x55,0x56:0x56,0x57:0x57,0x58:0x58,0x59:0x59,0x5a:0x5a,0x5b:0x5b,0x5c:0x5c,0x5d:0x5d,0x5e:0x5e,0x5f:0x5f,0x60:0x60,0x61:0x61,0x62:0x62,0x63:0x63,0x64:0x64,0x65:0x65,0x66:0x66,0x67:0x67,0x68:0x68,0x69:0x69,0x6a:0x6a,0x6b:0x6b,0x6c:0x6c,0x6d:0x6d,0x6e:0x6e,0x6f:0x6f,0x70:0x70,0x71:0x71,0x72:0x72,0x73:0x73,0x74:0x74,0x75:0x75,0x76:0x76,0x77:0x77,0x78:0x78,0x79:0x79,0x7a:0x7a,0x7b:0x7b,0x7c:0x7c,0x7d:0x7d,0x7e:0x7e,0xa2:0x2032,0xa3:0x2264,0xa4:0x2215,0xa5:0x221e,0xa6:0x192,0xa7:0x2663,0xa8:0x2666,0xa9:0x2665,0xaa:0x2660,0xab:0x2194,0xac:0x2190,0xad:0x2191,0xae:0x2192,0xaf:0x2193,0xb0:0xb0,0xb1:0xb1,0xb2:0x2033,0xb3:0x2265,0xb4:0xd7,0xb5:0x221d,0xb6:0x2202,0xb7:0x2219,0xb8:0xf7,0xb9:0x2260,0xba:0x2261,0xbb:0x2248,0xbc:0x22ef,0xc6:0x2205,0xc7:0x2229,0xc8:0x222a,0xc9:0x2283,0xca:0x2287,0xcc:0x2282,0xcd:0x2286,0xce:0x2208,0xd0:0x2220,0xd1:0x2207,0xd5:0x220f,0xd6:0x221a,0xd7:0x22c5,0xd8:0xac,0xd9:0x2227,0xda:0x2228,0xdb:0x21d4,0xdc:0x21d0,0xdd:0x21d1,0xde:0x21d2,0xdf:0x21d3,0xe0:0x25ca,0xe1:0x2329,0xe5:0x2211,0xf1:0x232a,0xf2:0x222b }

apple_roman_to_unicode = { 0x20:0x20,0x21:0x21,0x22:0x22,0x23:0x23,0x24:0x24,0x25:0x25,0x26:0x26,0x27:0x27,0x28:0x28,0x29:0x29,0x2a:0x2a,0x2b:0x2b,0x2c:0x2c,0x2d:0x2d,0x2e:0x2e,0x2f:0x2f,0x30:0x30,0x31:0x31,0x32:0x32,0x33:0x33,0x34:0x34,0x35:0x35,0x36:0x36,0x37:0x37,0x38:0x38,0x39:0x39,0x3a:0x3a,0x3b:0x3b,0x3c:0x3c,0x3d:0x3d,0x3e:0x3e,0x3f:0x3f,0x40:0x40,0x41:0x41,0x42:0x42,0x43:0x43,0x44:0x44,0x45:0x45,0x46:0x46,0x47:0x47,0x48:0x48,0x49:0x49,0x4a:0x4a,0x4b:0x4b,0x4c:0x4c,0x4d:0x4d,0x4e:0x4e,0x4f:0x4f,0x50:0x50,0x51:0x51,0x52:0x52,0x53:0x53,0x54:0x54,0x55:0x55,0x56:0x56,0x57:0x57,0x58:0x58,0x59:0x59,0x5a:0x5a,0x5b:0x5b,0x5c:0x5c,0x5d:0x5d,0x5e:0x5e,0x5f:0x5f,0x60:0x60,0x61:0x61,0x62:0x62,0x63:0x63,0x64:0x64,0x65:0x65,0x66:0x66,0x67:0x67,0x68:0x68,0x69:0x69,0x6a:0x6a,0x6b:0x6b,0x6c:0x6c,0x6d:0x6d,0x6e:0x6e,0x6f:0x6f,0x70:0x70,0x71:0x71,0x72:0x72,0x73:0x73,0x74:0x74,0x75:0x75,0x76:0x76,0x77:0x77,0x78:0x78,0x79:0x79,0x7a:0x7a,0x7b:0x7b,0x7c:0x7c,0x7d:0x7d,0x7e:0x7e,0x80:0xc4,0x81:0xc5,0x82:0xc7,0x83:0xc9,0x84:0xd1,0x85:0xd6,0x86:0xdc,0x87:0xe1,0x88:0xe0,0x89:0xe2,0x8a:0xe4,0x8b:0xe3,0x8c:0xe5,0x8d:0xe7,0x8e:0xe9,0x8f:0xe8,0x90:0xea,0x91:0xeb,0x92:0xed,0x93:0xec,0x94:0xee,0x95:0xef,0x96:0xf1,0x97:0xf3,0x98:0xf2,0x99:0xf4,0x9a:0xf6,0x9b:0xf5,0x9c:0xfa,0x9d:0xf9,0x9e:0xfb,0x9f:0xfc,0xa0:0x2020,0xa1:0xb0,0xa2:0xa2,0xa3:0xa3,0xa4:0xa7,0xa5:0x2219,0xa6:0xb6,0xa7:0xdf,0xa8:0xae,0xa9:0xa9,0xaa:0x2122,0xab:0xb4,0xac:0xa8,0xad:0x2260,0xae:0xc6,0xaf:0xd8,0xb0:0x221e,0xb1:0xb1,0xb2:0x2264,0xb3:0x2265,0xb4:0xa5,0xb5:0xb5,0xb6:0x2202,0xb7:0x2211,0xb8:0x220f,0xb9:0x3c0,0xba:0x222b,0xbb:0xaa,0xbc:0xba,0xbd:0x3a9,0xbe:0xe6,0xbf:0xf8,0xc0:0xbf,0xc1:0xa1,0xc2:0xac,0xc3:0x221a,0xc4:0x192,0xc5:0x2248,0xc6:0x394,0xc7:0xab,0xc8:0xbb,0xc9:0x22ef,0xca:0xa0,0xcb:0xc0,0xcc:0xc3,0xcd:0xd5,0xce:0x152,0xcf:0x153,0xd0:0x2013,0xd1:0x2014,0xd2:0x201c,0xd3:0x201d,0xd4:0x2018,0xd5:0x2019,0xd6:0xf7,0xd7:0x25ca,0xd8:0xff,0xd9:0x178,0xda:0x2044,0xdb:0xa4,0xdc:0x2039,0xdd:0x203a,0xde:0xfb01,0xdf:0xfb02,0xe0:0x2021,0xe1:0xb7,0xe2:0x201a,0xe3:0x201e,0xe4:0x2030,0xe5:0xc2,0xe6:0xca,0xe7:0xc1,0xe8:0xcb,0xe9:0xc8,0xea:0xcd,0xeb:0xce,0xec:0xcf,0xed:0xcc,0xee:0xd3,0xef:0xd4,0xf1:0xd2,0xf2:0xda,0xf3:0xdb,0xf4:0xd9,0xf5:0x131,0xf6:0x302,0xf7:0x303,0xf8:0xaf,0xf9:0x2d8,0xfa:0x2d9,0xfb:0x2da,0xfc:0xb8,0xfd:0x2dd,0xfe:0x2db,0xff:0x2c7 }

iso_latin1_to_unicode = { 0x20:0x20,0x21:0x21,0x22:0x22,0x23:0x23,0x24:0x24,0x25:0x25,0x26:0x26,0x27:0x27,0x28:0x28,0x29:0x29,0x2a:0x2a,0x2b:0x2b,0x2c:0x2c,0x2d:0x2d,0x2e:0x2e,0x2f:0x2f,0x30:0x30,0x31:0x31,0x32:0x32,0x33:0x33,0x34:0x34,0x35:0x35,0x36:0x36,0x37:0x37,0x38:0x38,0x39:0x39,0x3a:0x3a,0x3b:0x3b,0x3c:0x3c,0x3d:0x3d,0x3e:0x3e,0x3f:0x3f,0x40:0x40,0x41:0x41,0x42:0x42,0x43:0x43,0x44:0x44,0x45:0x45,0x46:0x46,0x47:0x47,0x48:0x48,0x49:0x49,0x4a:0x4a,0x4b:0x4b,0x4c:0x4c,0x4d:0x4d,0x4e:0x4e,0x4f:0x4f,0x50:0x50,0x51:0x51,0x52:0x52,0x53:0x53,0x54:0x54,0x55:0x55,0x56:0x56,0x57:0x57,0x58:0x58,0x59:0x59,0x5a:0x5a,0x5b:0x5b,0x5c:0x5c,0x5d:0x5d,0x5e:0x5e,0x5f:0x5f,0x60:0x60,0x61:0x61,0x62:0x62,0x63:0x63,0x64:0x64,0x65:0x65,0x66:0x66,0x67:0x67,0x68:0x68,0x69:0x69,0x6a:0x6a,0x6b:0x6b,0x6c:0x6c,0x6d:0x6d,0x6e:0x6e,0x6f:0x6f,0x70:0x70,0x71:0x71,0x72:0x72,0x73:0x73,0x74:0x74,0x75:0x75,0x76:0x76,0x77:0x77,0x78:0x78,0x79:0x79,0x7a:0x7a,0x7b:0x7b,0x7c:0x7c,0x7d:0x7d,0x7e:0x7e,0x90:0x131,0x91:0x300,0x92:0x301,0x93:0x302,0x94:0x303,0x95:0x304,0x96:0x306,0x97:0x307,0x98:0x308,0x9a:0x30a,0x9b:0x327,0x9d:0x30b,0x9e:0x328,0x9f:0x30c,0xa0:0xa0,0xa1:0xa1,0xa2:0xa2,0xa3:0xa3,0xa4:0xa4,0xa5:0xa5,0xa6:0xa6,0xa7:0xa7,0xa8:0xa8,0xa9:0xa9,0xaa:0xaa,0xab:0xab,0xac:0xac,0xad:0xad,0xae:0xae,0xaf:0xaf,0xb0:0xb0,0xb1:0xb1,0xb2:0xb2,0xb3:0xb3,0xb4:0xb4,0xb5:0xb5,0xb6:0xb6,0xb7:0xb7,0xb8:0xb8,0xb9:0xb9,0xba:0xba,0xbb:0xbb,0xbc:0xbc,0xbd:0xbd,0xbe:0xbe,0xbf:0xbf,0xc0:0xc0,0xc1:0xc1,0xc2:0xc2,0xc3:0xc3,0xc4:0xc4,0xc5:0xc5,0xc6:0xc6,0xc7:0xc7,0xc8:0xc8,0xc9:0xc9,0xca:0xca,0xcb:0xcb,0xcc:0xcc,0xcd:0xcd,0xce:0xce,0xcf:0xcf,0xd0:0xd0,0xd1:0xd1,0xd2:0xd2,0xd3:0xd3,0xd4:0xd4,0xd5:0xd5,0xd6:0xd6,0xd7:0xd7,0xd8:0xd8,0xd9:0xd9,0xda:0xda,0xdb:0xdb,0xdc:0xdc,0xdd:0xdd,0xde:0xde,0xdf:0xdf,0xe0:0xe0,0xe1:0xe1,0xe2:0xe2,0xe3:0xe3,0xe4:0xe4,0xe5:0xe5,0xe6:0xe6,0xe7:0xe7,0xe8:0xe8,0xe9:0xe9,0xea:0xea,0xeb:0xeb,0xec:0xec,0xed:0xed,0xee:0xee,0xef:0xef,0xf0:0xf0,0xf1:0xf1,0xf2:0xf2,0xf3:0xf3,0xf4:0xf4,0xf5:0xf5,0xf6:0xf6,0xf7:0xf7,0xf8:0xf8,0xf9:0xf9,0xfa:0xfa,0xfb:0xfb,0xfc:0xfc,0xfd:0xfd,0xfe:0xfe,0xff:0xff }


# Generated from glyphlist.txt available from
# http://partners.adobe.com/asn/developer/typeforum/unicodegn.html
# 
glyph_name_to_unicode = { 'A':0x41,'AE':0xc6,'AEacute':0x1fc,'AEmacron':0x1e2,'AEsmall':0xf7e6,'Aacute':0xc1,'Aacutesmall':0xf7e1,'Abreve':0x102,'Abreveacute':0x1eae,'Abrevecyrillic':0x4d0,'Abrevedotbelow':0x1eb6,'Abrevegrave':0x1eb0,'Abrevehookabove':0x1eb2,'Abrevetilde':0x1eb4,'Acaron':0x1cd,'Acircle':0x24b6,'Acircumflex':0xc2,'Acircumflexacute':0x1ea4,'Acircumflexdotbelow':0x1eac,'Acircumflexgrave':0x1ea6,'Acircumflexhookabove':0x1ea8,'Acircumflexsmall':0xf7e2,'Acircumflextilde':0x1eaa,'Acute':0xf6c9,'Acutesmall':0xf7b4,'Acyrillic':0x410,'Adblgrave':0x200,'Adieresis':0xc4,'Adieresiscyrillic':0x4d2,'Adieresismacron':0x1de,'Adieresissmall':0xf7e4,'Adotbelow':0x1ea0,'Adotmacron':0x1e0,'Agrave':0xc0,'Agravesmall':0xf7e0,'Ahookabove':0x1ea2,'Aiecyrillic':0x4d4,'Ainvertedbreve':0x202,'Alpha':0x391,'Alphatonos':0x386,'Amacron':0x100,'Amonospace':0xff21,'Aogonek':0x104,'Aring':0xc5,'Aringacute':0x1fa,'Aringbelow':0x1e00,'Aringsmall':0xf7e5,'Asmall':0xf761,'Atilde':0xc3,'Atildesmall':0xf7e3,'Aybarmenian':0x531,'B':0x42,'Bcircle':0x24b7,'Bdotaccent':0x1e02,'Bdotbelow':0x1e04,'Becyrillic':0x411,'Benarmenian':0x532,'Beta':0x392,'Bhook':0x181,'Blinebelow':0x1e06,'Bmonospace':0xff22,'Brevesmall':0xf6f4,'Bsmall':0xf762,'Btopbar':0x182,'C':0x43,'Caarmenian':0x53e,'Cacute':0x106,'Caron':0xf6ca,'Caronsmall':0xf6f5,'Ccaron':0x10c,'Ccedilla':0xc7,'Ccedillaacute':0x1e08,'Ccedillasmall':0xf7e7,'Ccircle':0x24b8,'Ccircumflex':0x108,'Cdot':0x10a,'Cdotaccent':0x10a,'Cedillasmall':0xf7b8,'Chaarmenian':0x549,'Cheabkhasiancyrillic':0x4bc,'Checyrillic':0x427,'Chedescenderabkhasiancyrillic':0x4be,'Chedescendercyrillic':0x4b6,'Chedieresiscyrillic':0x4f4,'Cheharmenian':0x543,'Chekhakassiancyrillic':0x4cb,'Cheverticalstrokecyrillic':0x4b8,'Chi':0x3a7,'Chook':0x187,'Circumflexsmall':0xf6f6,'Cmonospace':0xff23,'Coarmenian':0x551,'Csmall':0xf763,'D':0x44,'DZ':0x1f1,'DZcaron':0x1c4,'Daarmenian':0x534,'Dafrican':0x189,'Dcaron':0x10e,'Dcedilla':0x1e10,'Dcircle':0x24b9,'Dcircumflexbelow':0x1e12,'Dcroat':0x110,'Ddotaccent':0x1e0a,'Ddotbelow':0x1e0c,'Decyrillic':0x414,'Deicoptic':0x3ee,'Delta':0x2206,'Deltagreek':0x394,'Dhook':0x18a,'Dieresis':0xf6cb,'DieresisAcute':0xf6cc,'DieresisGrave':0xf6cd,'Dieresissmall':0xf7a8,'Digammagreek':0x3dc,'Djecyrillic':0x402,'Dlinebelow':0x1e0e,'Dmonospace':0xff24,'Dotaccentsmall':0xf6f7,'Dslash':0x110,'Dsmall':0xf764,'Dtopbar':0x18b,'Dz':0x1f2,'Dzcaron':0x1c5,'Dzeabkhasiancyrillic':0x4e0,'Dzecyrillic':0x405,'Dzhecyrillic':0x40f,'E':0x45,'Eacute':0xc9,'Eacutesmall':0xf7e9,'Ebreve':0x114,'Ecaron':0x11a,'Ecedillabreve':0x1e1c,'Echarmenian':0x535,'Ecircle':0x24ba,'Ecircumflex':0xca,'Ecircumflexacute':0x1ebe,'Ecircumflexbelow':0x1e18,'Ecircumflexdotbelow':0x1ec6,'Ecircumflexgrave':0x1ec0,'Ecircumflexhookabove':0x1ec2,'Ecircumflexsmall':0xf7ea,'Ecircumflextilde':0x1ec4,'Ecyrillic':0x404,'Edblgrave':0x204,'Edieresis':0xcb,'Edieresissmall':0xf7eb,'Edot':0x116,'Edotaccent':0x116,'Edotbelow':0x1eb8,'Efcyrillic':0x424,'Egrave':0xc8,'Egravesmall':0xf7e8,'Eharmenian':0x537,'Ehookabove':0x1eba,'Eightroman':0x2167,'Einvertedbreve':0x206,'Eiotifiedcyrillic':0x464,'Elcyrillic':0x41b,'Elevenroman':0x216a,'Emacron':0x112,'Emacronacute':0x1e16,'Emacrongrave':0x1e14,'Emcyrillic':0x41c,'Emonospace':0xff25,'Encyrillic':0x41d,'Endescendercyrillic':0x4a2,'Eng':0x14a,'Enghecyrillic':0x4a4,'Enhookcyrillic':0x4c7,'Eogonek':0x118,'Eopen':0x190,'Epsilon':0x395,'Epsilontonos':0x388,'Ercyrillic':0x420,'Ereversed':0x18e,'Ereversedcyrillic':0x42d,'Escyrillic':0x421,'Esdescendercyrillic':0x4aa,'Esh':0x1a9,'Esmall':0xf765,'Eta':0x397,'Etarmenian':0x538,'Etatonos':0x389,'Eth':0xd0,'Ethsmall':0xf7f0,'Etilde':0x1ebc,'Etildebelow':0x1e1a,'Euro':0x20ac,'Ezh':0x1b7,'Ezhcaron':0x1ee,'Ezhreversed':0x1b8,'F':0x46,'Fcircle':0x24bb,'Fdotaccent':0x1e1e,'Feharmenian':0x556,'Feicoptic':0x3e4,'Fhook':0x191,'Fitacyrillic':0x472,'Fiveroman':0x2164,'Fmonospace':0xff26,'Fourroman':0x2163,'Fsmall':0xf766,'G':0x47,'GBsquare':0x3387,'Gacute':0x1f4,'Gamma':0x393,'Gammaafrican':0x194,'Gangiacoptic':0x3ea,'Gbreve':0x11e,'Gcaron':0x1e6,'Gcedilla':0x122,'Gcircle':0x24bc,'Gcircumflex':0x11c,'Gcommaaccent':0x122,'Gdot':0x120,'Gdotaccent':0x120,'Gecyrillic':0x413,'Ghadarmenian':0x542,'Ghemiddlehookcyrillic':0x494,'Ghestrokecyrillic':0x492,'Gheupturncyrillic':0x490,'Ghook':0x193,'Gimarmenian':0x533,'Gjecyrillic':0x403,'Gmacron':0x1e20,'Gmonospace':0xff27,'Grave':0xf6ce,'Gravesmall':0xf760,'Gsmall':0xf767,'Gsmallhook':0x29b,'Gstroke':0x1e4,'H':0x48,'H18533':0x25cf,'H18543':0x25aa,'H18551':0x25ab,'H22073':0x25a1,'HPsquare':0x33cb,'Haabkhasiancyrillic':0x4a8,'Hadescendercyrillic':0x4b2,'Hardsigncyrillic':0x42a,'Hbar':0x126,'Hbrevebelow':0x1e2a,'Hcedilla':0x1e28,'Hcircle':0x24bd,'Hcircumflex':0x124,'Hdieresis':0x1e26,'Hdotaccent':0x1e22,'Hdotbelow':0x1e24,'Hmonospace':0xff28,'Hoarmenian':0x540,'Horicoptic':0x3e8,'Hsmall':0xf768,'Hungarumlaut':0xf6cf,'Hungarumlautsmall':0xf6f8,'Hzsquare':0x3390,'I':0x49,'IAcyrillic':0x42f,'IJ':0x132,'IUcyrillic':0x42e,'Iacute':0xcd,'Iacutesmall':0xf7ed,'Ibreve':0x12c,'Icaron':0x1cf,'Icircle':0x24be,'Icircumflex':0xce,'Icircumflexsmall':0xf7ee,'Icyrillic':0x406,'Idblgrave':0x208,'Idieresis':0xcf,'Idieresisacute':0x1e2e,'Idieresiscyrillic':0x4e4,'Idieresissmall':0xf7ef,'Idot':0x130,'Idotaccent':0x130,'Idotbelow':0x1eca,'Iebrevecyrillic':0x4d6,'Iecyrillic':0x415,'Ifraktur':0x2111,'Igrave':0xcc,'Igravesmall':0xf7ec,'Ihookabove':0x1ec8,'Iicyrillic':0x418,'Iinvertedbreve':0x20a,'Iishortcyrillic':0x419,'Imacron':0x12a,'Imacroncyrillic':0x4e2,'Imonospace':0xff29,'Iniarmenian':0x53b,'Iocyrillic':0x401,'Iogonek':0x12e,'Iota':0x399,'Iotaafrican':0x196,'Iotadieresis':0x3aa,'Iotatonos':0x38a,'Ismall':0xf769,'Istroke':0x197,'Itilde':0x128,'Itildebelow':0x1e2c,'Izhitsacyrillic':0x474,'Izhitsadblgravecyrillic':0x476,'J':0x4a,'Jaarmenian':0x541,'Jcircle':0x24bf,'Jcircumflex':0x134,'Jecyrillic':0x408,'Jheharmenian':0x54b,'Jmonospace':0xff2a,'Jsmall':0xf76a,'K':0x4b,'KBsquare':0x3385,'KKsquare':0x33cd,'Kabashkircyrillic':0x4a0,'Kacute':0x1e30,'Kacyrillic':0x41a,'Kadescendercyrillic':0x49a,'Kahookcyrillic':0x4c3,'Kappa':0x39a,'Kastrokecyrillic':0x49e,'Kaverticalstrokecyrillic':0x49c,'Kcaron':0x1e8,'Kcedilla':0x136,'Kcircle':0x24c0,'Kcommaaccent':0x136,'Kdotbelow':0x1e32,'Keharmenian':0x554,'Kenarmenian':0x53f,'Khacyrillic':0x425,'Kheicoptic':0x3e6,'Khook':0x198,'Kjecyrillic':0x40c,'Klinebelow':0x1e34,'Kmonospace':0xff2b,'Koppacyrillic':0x480,'Koppagreek':0x3de,'Ksicyrillic':0x46e,'Ksmall':0xf76b,'L':0x4c,'LJ':0x1c7,'LL':0xf6bf,'Lacute':0x139,'Lambda':0x39b,'Lcaron':0x13d,'Lcedilla':0x13b,'Lcircle':0x24c1,'Lcircumflexbelow':0x1e3c,'Lcommaaccent':0x13b,'Ldot':0x13f,'Ldotaccent':0x13f,'Ldotbelow':0x1e36,'Ldotbelowmacron':0x1e38,'Liwnarmenian':0x53c,'Lj':0x1c8,'Ljecyrillic':0x409,'Llinebelow':0x1e3a,'Lmonospace':0xff2c,'Lslash':0x141,'Lslashsmall':0xf6f9,'Lsmall':0xf76c,'M':0x4d,'MBsquare':0x3386,'Macron':0xf6d0,'Macronsmall':0xf7af,'Macute':0x1e3e,'Mcircle':0x24c2,'Mdotaccent':0x1e40,'Mdotbelow':0x1e42,'Menarmenian':0x544,'Mmonospace':0xff2d,'Msmall':0xf76d,'Mturned':0x19c,'Mu':0x39c,'N':0x4e,'NJ':0x1ca,'Nacute':0x143,'Ncaron':0x147,'Ncedilla':0x145,'Ncircle':0x24c3,'Ncircumflexbelow':0x1e4a,'Ncommaaccent':0x145,'Ndotaccent':0x1e44,'Ndotbelow':0x1e46,'Nhookleft':0x19d,'Nineroman':0x2168,'Nj':0x1cb,'Njecyrillic':0x40a,'Nlinebelow':0x1e48,'Nmonospace':0xff2e,'Nowarmenian':0x546,'Nsmall':0xf76e,'Ntilde':0xd1,'Ntildesmall':0xf7f1,'Nu':0x39d,'O':0x4f,'OE':0x152,'OEsmall':0xf6fa,'Oacute':0xd3,'Oacutesmall':0xf7f3,'Obarredcyrillic':0x4e8,'Obarreddieresiscyrillic':0x4ea,'Obreve':0x14e,'Ocaron':0x1d1,'Ocenteredtilde':0x19f,'Ocircle':0x24c4,'Ocircumflex':0xd4,'Ocircumflexacute':0x1ed0,'Ocircumflexdotbelow':0x1ed8,'Ocircumflexgrave':0x1ed2,'Ocircumflexhookabove':0x1ed4,'Ocircumflexsmall':0xf7f4,'Ocircumflextilde':0x1ed6,'Ocyrillic':0x41e,'Odblacute':0x150,'Odblgrave':0x20c,'Odieresis':0xd6,'Odieresiscyrillic':0x4e6,'Odieresissmall':0xf7f6,'Odotbelow':0x1ecc,'Ogoneksmall':0xf6fb,'Ograve':0xd2,'Ogravesmall':0xf7f2,'Oharmenian':0x555,'Ohm':0x2126,'Ohookabove':0x1ece,'Ohorn':0x1a0,'Ohornacute':0x1eda,'Ohorndotbelow':0x1ee2,'Ohorngrave':0x1edc,'Ohornhookabove':0x1ede,'Ohorntilde':0x1ee0,'Ohungarumlaut':0x150,'Oi':0x1a2,'Oinvertedbreve':0x20e,'Omacron':0x14c,'Omacronacute':0x1e52,'Omacrongrave':0x1e50,'Omega':0x2126,'Omegacyrillic':0x460,'Omegagreek':0x3a9,'Omegaroundcyrillic':0x47a,'Omegatitlocyrillic':0x47c,'Omegatonos':0x38f,'Omicron':0x39f,'Omicrontonos':0x38c,'Omonospace':0xff2f,'Oneroman':0x2160,'Oogonek':0x1ea,'Oogonekmacron':0x1ec,'Oopen':0x186,'Oslash':0xd8,'Oslashacute':0x1fe,'Oslashsmall':0xf7f8,'Osmall':0xf76f,'Ostrokeacute':0x1fe,'Otcyrillic':0x47e,'Otilde':0xd5,'Otildeacute':0x1e4c,'Otildedieresis':0x1e4e,'Otildesmall':0xf7f5,'P':0x50,'Pacute':0x1e54,'Pcircle':0x24c5,'Pdotaccent':0x1e56,'Pecyrillic':0x41f,'Peharmenian':0x54a,'Pemiddlehookcyrillic':0x4a6,'Phi':0x3a6,'Phook':0x1a4,'Pi':0x3a0,'Piwrarmenian':0x553,'Pmonospace':0xff30,'Psi':0x3a8,'Psicyrillic':0x470,'Psmall':0xf770,'Q':0x51,'Qcircle':0x24c6,'Qmonospace':0xff31,'Qsmall':0xf771,'R':0x52,'Raarmenian':0x54c,'Racute':0x154,'Rcaron':0x158,'Rcedilla':0x156,'Rcircle':0x24c7,'Rcommaaccent':0x156,'Rdblgrave':0x210,'Rdotaccent':0x1e58,'Rdotbelow':0x1e5a,'Rdotbelowmacron':0x1e5c,'Reharmenian':0x550,'Rfraktur':0x211c,'Rho':0x3a1,'Ringsmall':0xf6fc,'Rinvertedbreve':0x212,'Rlinebelow':0x1e5e,'Rmonospace':0xff32,'Rsmall':0xf772,'Rsmallinverted':0x281,'Rsmallinvertedsuperior':0x2b6,'S':0x53,'SF010000':0x250c,'SF020000':0x2514,'SF030000':0x2510,'SF040000':0x2518,'SF050000':0x253c,'SF060000':0x252c,'SF070000':0x2534,'SF080000':0x251c,'SF090000':0x2524,'SF100000':0x2500,'SF110000':0x2502,'SF190000':0x2561,'SF200000':0x2562,'SF210000':0x2556,'SF220000':0x2555,'SF230000':0x2563,'SF240000':0x2551,'SF250000':0x2557,'SF260000':0x255d,'SF270000':0x255c,'SF280000':0x255b,'SF360000':0x255e,'SF370000':0x255f,'SF380000':0x255a,'SF390000':0x2554,'SF400000':0x2569,'SF410000':0x2566,'SF420000':0x2560,'SF430000':0x2550,'SF440000':0x256c,'SF450000':0x2567,'SF460000':0x2568,'SF470000':0x2564,'SF480000':0x2565,'SF490000':0x2559,'SF500000':0x2558,'SF510000':0x2552,'SF520000':0x2553,'SF530000':0x256b,'SF540000':0x256a,'Sacute':0x15a,'Sacutedotaccent':0x1e64,'Sampigreek':0x3e0,'Scaron':0x160,'Scarondotaccent':0x1e66,'Scaronsmall':0xf6fd,'Scedilla':0x15e,'Schwa':0x18f,'Schwacyrillic':0x4d8,'Schwadieresiscyrillic':0x4da,'Scircle':0x24c8,'Scircumflex':0x15c,'Scommaaccent':0x218,'Sdotaccent':0x1e60,'Sdotbelow':0x1e62,'Sdotbelowdotaccent':0x1e68,'Seharmenian':0x54d,'Sevenroman':0x2166,'Shaarmenian':0x547,'Shacyrillic':0x428,'Shchacyrillic':0x429,'Sheicoptic':0x3e2,'Shhacyrillic':0x4ba,'Shimacoptic':0x3ec,'Sigma':0x3a3,'Sixroman':0x2165,'Smonospace':0xff33,'Softsigncyrillic':0x42c,'Ssmall':0xf773,'Stigmagreek':0x3da,'T':0x54,'Tau':0x3a4,'Tbar':0x166,'Tcaron':0x164,'Tcedilla':0x162,'Tcircle':0x24c9,'Tcircumflexbelow':0x1e70,'Tcommaaccent':0x162,'Tdotaccent':0x1e6a,'Tdotbelow':0x1e6c,'Tecyrillic':0x422,'Tedescendercyrillic':0x4ac,'Tenroman':0x2169,'Tetsecyrillic':0x4b4,'Theta':0x398,'Thook':0x1ac,'Thorn':0xde,'Thornsmall':0xf7fe,'Threeroman':0x2162,'Tildesmall':0xf6fe,'Tiwnarmenian':0x54f,'Tlinebelow':0x1e6e,'Tmonospace':0xff34,'Toarmenian':0x539,'Tonefive':0x1bc,'Tonesix':0x184,'Tonetwo':0x1a7,'Tretroflexhook':0x1ae,'Tsecyrillic':0x426,'Tshecyrillic':0x40b,'Tsmall':0xf774,'Twelveroman':0x216b,'Tworoman':0x2161,'U':0x55,'Uacute':0xda,'Uacutesmall':0xf7fa,'Ubreve':0x16c,'Ucaron':0x1d3,'Ucircle':0x24ca,'Ucircumflex':0xdb,'Ucircumflexbelow':0x1e76,'Ucircumflexsmall':0xf7fb,'Ucyrillic':0x423,'Udblacute':0x170,'Udblgrave':0x214,'Udieresis':0xdc,'Udieresisacute':0x1d7,'Udieresisbelow':0x1e72,'Udieresiscaron':0x1d9,'Udieresiscyrillic':0x4f0,'Udieresisgrave':0x1db,'Udieresismacron':0x1d5,'Udieresissmall':0xf7fc,'Udotbelow':0x1ee4,'Ugrave':0xd9,'Ugravesmall':0xf7f9,'Uhookabove':0x1ee6,'Uhorn':0x1af,'Uhornacute':0x1ee8,'Uhorndotbelow':0x1ef0,'Uhorngrave':0x1eea,'Uhornhookabove':0x1eec,'Uhorntilde':0x1eee,'Uhungarumlaut':0x170,'Uhungarumlautcyrillic':0x4f2,'Uinvertedbreve':0x216,'Ukcyrillic':0x478,'Umacron':0x16a,'Umacroncyrillic':0x4ee,'Umacrondieresis':0x1e7a,'Umonospace':0xff35,'Uogonek':0x172,'Upsilon':0x3a5,'Upsilon1':0x3d2,'Upsilonacutehooksymbolgreek':0x3d3,'Upsilonafrican':0x1b1,'Upsilondieresis':0x3ab,'Upsilondieresishooksymbolgreek':0x3d4,'Upsilonhooksymbol':0x3d2,'Upsilontonos':0x38e,'Uring':0x16e,'Ushortcyrillic':0x40e,'Usmall':0xf775,'Ustraightcyrillic':0x4ae,'Ustraightstrokecyrillic':0x4b0,'Utilde':0x168,'Utildeacute':0x1e78,'Utildebelow':0x1e74,'V':0x56,'Vcircle':0x24cb,'Vdotbelow':0x1e7e,'Vecyrillic':0x412,'Vewarmenian':0x54e,'Vhook':0x1b2,'Vmonospace':0xff36,'Voarmenian':0x548,'Vsmall':0xf776,'Vtilde':0x1e7c,'W':0x57,'Wacute':0x1e82,'Wcircle':0x24cc,'Wcircumflex':0x174,'Wdieresis':0x1e84,'Wdotaccent':0x1e86,'Wdotbelow':0x1e88,'Wgrave':0x1e80,'Wmonospace':0xff37,'Wsmall':0xf777,'X':0x58,'Xcircle':0x24cd,'Xdieresis':0x1e8c,'Xdotaccent':0x1e8a,'Xeharmenian':0x53d,'Xi':0x39e,'Xmonospace':0xff38,'Xsmall':0xf778,'Y':0x59,'Yacute':0xdd,'Yacutesmall':0xf7fd,'Yatcyrillic':0x462,'Ycircle':0x24ce,'Ycircumflex':0x176,'Ydieresis':0x178,'Ydieresissmall':0xf7ff,'Ydotaccent':0x1e8e,'Ydotbelow':0x1ef4,'Yericyrillic':0x42b,'Yerudieresiscyrillic':0x4f8,'Ygrave':0x1ef2,'Yhook':0x1b3,'Yhookabove':0x1ef6,'Yiarmenian':0x545,'Yicyrillic':0x407,'Yiwnarmenian':0x552,'Ymonospace':0xff39,'Ysmall':0xf779,'Ytilde':0x1ef8,'Yusbigcyrillic':0x46a,'Yusbigiotifiedcyrillic':0x46c,'Yuslittlecyrillic':0x466,'Yuslittleiotifiedcyrillic':0x468,'Z':0x5a,'Zaarmenian':0x536,'Zacute':0x179,'Zcaron':0x17d,'Zcaronsmall':0xf6ff,'Zcircle':0x24cf,'Zcircumflex':0x1e90,'Zdot':0x17b,'Zdotaccent':0x17b,'Zdotbelow':0x1e92,'Zecyrillic':0x417,'Zedescendercyrillic':0x498,'Zedieresiscyrillic':0x4de,'Zeta':0x396,'Zhearmenian':0x53a,'Zhebrevecyrillic':0x4c1,'Zhecyrillic':0x416,'Zhedescendercyrillic':0x496,'Zhedieresiscyrillic':0x4dc,'Zlinebelow':0x1e94,'Zmonospace':0xff3a,'Zsmall':0xf77a,'Zstroke':0x1b5,'a':0x61,'aabengali':0x986,'aacute':0xe1,'aadeva':0x906,'aagujarati':0xa86,'aagurmukhi':0xa06,'aamatragurmukhi':0xa3e,'aarusquare':0x3303,'aavowelsignbengali':0x9be,'aavowelsigndeva':0x93e,'aavowelsigngujarati':0xabe,'abbreviationmarkarmenian':0x55f,'abbreviationsigndeva':0x970,'abengali':0x985,'abopomofo':0x311a,'abreve':0x103,'abreveacute':0x1eaf,'abrevecyrillic':0x4d1,'abrevedotbelow':0x1eb7,'abrevegrave':0x1eb1,'abrevehookabove':0x1eb3,'abrevetilde':0x1eb5,'acaron':0x1ce,'acircle':0x24d0,'acircumflex':0xe2,'acircumflexacute':0x1ea5,'acircumflexdotbelow':0x1ead,'acircumflexgrave':0x1ea7,'acircumflexhookabove':0x1ea9,'acircumflextilde':0x1eab,'acute':0xb4,'acutebelowcmb':0x317,'acutecmb':0x301,'acutecomb':0x301,'acutedeva':0x954,'acutelowmod':0x2cf,'acutetonecmb':0x341,'acyrillic':0x430,'adblgrave':0x201,'addakgurmukhi':0xa71,'adeva':0x905,'adieresis':0xe4,'adieresiscyrillic':0x4d3,'adieresismacron':0x1df,'adotbelow':0x1ea1,'adotmacron':0x1e1,'ae':0xe6,'aeacute':0x1fd,'aekorean':0x3150,'aemacron':0x1e3,'afii00208':0x2015,'afii08941':0x20a4,'afii10017':0x410,'afii10018':0x411,'afii10019':0x412,'afii10020':0x413,'afii10021':0x414,'afii10022':0x415,'afii10023':0x401,'afii10024':0x416,'afii10025':0x417,'afii10026':0x418,'afii10027':0x419,'afii10028':0x41a,'afii10029':0x41b,'afii10030':0x41c,'afii10031':0x41d,'afii10032':0x41e,'afii10033':0x41f,'afii10034':0x420,'afii10035':0x421,'afii10036':0x422,'afii10037':0x423,'afii10038':0x424,'afii10039':0x425,'afii10040':0x426,'afii10041':0x427,'afii10042':0x428,'afii10043':0x429,'afii10044':0x42a,'afii10045':0x42b,'afii10046':0x42c,'afii10047':0x42d,'afii10048':0x42e,'afii10049':0x42f,'afii10050':0x490,'afii10051':0x402,'afii10052':0x403,'afii10053':0x404,'afii10054':0x405,'afii10055':0x406,'afii10056':0x407,'afii10057':0x408,'afii10058':0x409,'afii10059':0x40a,'afii10060':0x40b,'afii10061':0x40c,'afii10062':0x40e,'afii10063':0xf6c4,'afii10064':0xf6c5,'afii10065':0x430,'afii10066':0x431,'afii10067':0x432,'afii10068':0x433,'afii10069':0x434,'afii10070':0x435,'afii10071':0x451,'afii10072':0x436,'afii10073':0x437,'afii10074':0x438,'afii10075':0x439,'afii10076':0x43a,'afii10077':0x43b,'afii10078':0x43c,'afii10079':0x43d,'afii10080':0x43e,'afii10081':0x43f,'afii10082':0x440,'afii10083':0x441,'afii10084':0x442,'afii10085':0x443,'afii10086':0x444,'afii10087':0x445,'afii10088':0x446,'afii10089':0x447,'afii10090':0x448,'afii10091':0x449,'afii10092':0x44a,'afii10093':0x44b,'afii10094':0x44c,'afii10095':0x44d,'afii10096':0x44e,'afii10097':0x44f,'afii10098':0x491,'afii10099':0x452,'afii10100':0x453,'afii10101':0x454,'afii10102':0x455,'afii10103':0x456,'afii10104':0x457,'afii10105':0x458,'afii10106':0x459,'afii10107':0x45a,'afii10108':0x45b,'afii10109':0x45c,'afii10110':0x45e,'afii10145':0x40f,'afii10146':0x462,'afii10147':0x472,'afii10148':0x474,'afii10192':0xf6c6,'afii10193':0x45f,'afii10194':0x463,'afii10195':0x473,'afii10196':0x475,'afii10831':0xf6c7,'afii10832':0xf6c8,'afii10846':0x4d9,'afii299':0x200e,'afii300':0x200f,'afii301':0x200d,'afii57381':0x66a,'afii57388':0x60c,'afii57392':0x660,'afii57393':0x661,'afii57394':0x662,'afii57395':0x663,'afii57396':0x664,'afii57397':0x665,'afii57398':0x666,'afii57399':0x667,'afii57400':0x668,'afii57401':0x669,'afii57403':0x61b,'afii57407':0x61f,'afii57409':0x621,'afii57410':0x622,'afii57411':0x623,'afii57412':0x624,'afii57413':0x625,'afii57414':0x626,'afii57415':0x627,'afii57416':0x628,'afii57417':0x629,'afii57418':0x62a,'afii57419':0x62b,'afii57420':0x62c,'afii57421':0x62d,'afii57422':0x62e,'afii57423':0x62f,'afii57424':0x630,'afii57425':0x631,'afii57426':0x632,'afii57427':0x633,'afii57428':0x634,'afii57429':0x635,'afii57430':0x636,'afii57431':0x637,'afii57432':0x638,'afii57433':0x639,'afii57434':0x63a,'afii57440':0x640,'afii57441':0x641,'afii57442':0x642,'afii57443':0x643,'afii57444':0x644,'afii57445':0x645,'afii57446':0x646,'afii57448':0x648,'afii57449':0x649,'afii57450':0x64a,'afii57451':0x64b,'afii57452':0x64c,'afii57453':0x64d,'afii57454':0x64e,'afii57455':0x64f,'afii57456':0x650,'afii57457':0x651,'afii57458':0x652,'afii57470':0x647,'afii57505':0x6a4,'afii57506':0x67e,'afii57507':0x686,'afii57508':0x698,'afii57509':0x6af,'afii57511':0x679,'afii57512':0x688,'afii57513':0x691,'afii57514':0x6ba,'afii57519':0x6d2,'afii57534':0x6d5,'afii57636':0x20aa,'afii57645':0x5be,'afii57658':0x5c3,'afii57664':0x5d0,'afii57665':0x5d1,'afii57666':0x5d2,'afii57667':0x5d3,'afii57668':0x5d4,'afii57669':0x5d5,'afii57670':0x5d6,'afii57671':0x5d7,'afii57672':0x5d8,'afii57673':0x5d9,'afii57674':0x5da,'afii57675':0x5db,'afii57676':0x5dc,'afii57677':0x5dd,'afii57678':0x5de,'afii57679':0x5df,'afii57680':0x5e0,'afii57681':0x5e1,'afii57682':0x5e2,'afii57683':0x5e3,'afii57684':0x5e4,'afii57685':0x5e5,'afii57686':0x5e6,'afii57687':0x5e7,'afii57688':0x5e8,'afii57689':0x5e9,'afii57690':0x5ea,'afii57694':0xfb2a,'afii57695':0xfb2b,'afii57700':0xfb4b,'afii57705':0xfb1f,'afii57716':0x5f0,'afii57717':0x5f1,'afii57718':0x5f2,'afii57723':0xfb35,'afii57793':0x5b4,'afii57794':0x5b5,'afii57795':0x5b6,'afii57796':0x5bb,'afii57797':0x5b8,'afii57798':0x5b7,'afii57799':0x5b0,'afii57800':0x5b2,'afii57801':0x5b1,'afii57802':0x5b3,'afii57803':0x5c2,'afii57804':0x5c1,'afii57806':0x5b9,'afii57807':0x5bc,'afii57839':0x5bd,'afii57841':0x5bf,'afii57842':0x5c0,'afii57929':0x2bc,'afii61248':0x2105,'afii61289':0x2113,'afii61352':0x2116,'afii61573':0x202c,'afii61574':0x202d,'afii61575':0x202e,'afii61664':0x200c,'afii63167':0x66d,'afii64937':0x2bd,'agrave':0xe0,'agujarati':0xa85,'agurmukhi':0xa05,'ahiragana':0x3042,'ahookabove':0x1ea3,'aibengali':0x990,'aibopomofo':0x311e,'aideva':0x910,'aiecyrillic':0x4d5,'aigujarati':0xa90,'aigurmukhi':0xa10,'aimatragurmukhi':0xa48,'ainarabic':0x639,'ainfinalarabic':0xfeca,'aininitialarabic':0xfecb,'ainmedialarabic':0xfecc,'ainvertedbreve':0x203,'aivowelsignbengali':0x9c8,'aivowelsigndeva':0x948,'aivowelsigngujarati':0xac8,'akatakana':0x30a2,'akatakanahalfwidth':0xff71,'akorean':0x314f,'alef':0x5d0,'alefarabic':0x627,'alefdageshhebrew':0xfb30,'aleffinalarabic':0xfe8e,'alefhamzaabovearabic':0x623,'alefhamzaabovefinalarabic':0xfe84,'alefhamzabelowarabic':0x625,'alefhamzabelowfinalarabic':0xfe88,'alefhebrew':0x5d0,'aleflamedhebrew':0xfb4f,'alefmaddaabovearabic':0x622,'alefmaddaabovefinalarabic':0xfe82,'alefmaksuraarabic':0x649,'alefmaksurafinalarabic':0xfef0,'alefmaksurainitialarabic':0xfef3,'alefmaksuramedialarabic':0xfef4,'alefpatahhebrew':0xfb2e,'alefqamatshebrew':0xfb2f,'aleph':0x2135,'allequal':0x224c,'alpha':0x3b1,'alphatonos':0x3ac,'amacron':0x101,'amonospace':0xff41,'ampersand':0x26,'ampersandmonospace':0xff06,'ampersandsmall':0xf726,'amsquare':0x33c2,'anbopomofo':0x3122,'angbopomofo':0x3124,'angkhankhuthai':0xe5a,'angle':0x2220,'anglebracketleft':0x3008,'anglebracketleftvertical':0xfe3f,'anglebracketright':0x3009,'anglebracketrightvertical':0xfe40,'angleleft':0x2329,'angleright':0x232a,'angstrom':0x212b,'anoteleia':0x387,'anudattadeva':0x952,'anusvarabengali':0x982,'anusvaradeva':0x902,'anusvaragujarati':0xa82,'aogonek':0x105,'apaatosquare':0x3300,'aparen':0x249c,'apostrophearmenian':0x55a,'apostrophemod':0x2bc,'apple':0xf8ff,'approaches':0x2250,'approxequal':0x2248,'approxequalorimage':0x2252,'approximatelyequal':0x2245,'araeaekorean':0x318e,'araeakorean':0x318d,'arc':0x2312,'arighthalfring':0x1e9a,'aring':0xe5,'aringacute':0x1fb,'aringbelow':0x1e01,'arrowboth':0x2194,'arrowdashdown':0x21e3,'arrowdashleft':0x21e0,'arrowdashright':0x21e2,'arrowdashup':0x21e1,'arrowdblboth':0x21d4,'arrowdbldown':0x21d3,'arrowdblleft':0x21d0,'arrowdblright':0x21d2,'arrowdblup':0x21d1,'arrowdown':0x2193,'arrowdownleft':0x2199,'arrowdownright':0x2198,'arrowdownwhite':0x21e9,'arrowheaddownmod':0x2c5,'arrowheadleftmod':0x2c2,'arrowheadrightmod':0x2c3,'arrowheadupmod':0x2c4,'arrowhorizex':0xf8e7,'arrowleft':0x2190,'arrowleftdbl':0x21d0,'arrowleftdblstroke':0x21cd,'arrowleftoverright':0x21c6,'arrowleftwhite':0x21e6,'arrowright':0x2192,'arrowrightdblstroke':0x21cf,'arrowrightheavy':0x279e,'arrowrightoverleft':0x21c4,'arrowrightwhite':0x21e8,'arrowtableft':0x21e4,'arrowtabright':0x21e5,'arrowup':0x2191,'arrowupdn':0x2195,'arrowupdnbse':0x21a8,'arrowupdownbase':0x21a8,'arrowupleft':0x2196,'arrowupleftofdown':0x21c5,'arrowupright':0x2197,'arrowupwhite':0x21e7,'arrowvertex':0xf8e6,'asciicircum':0x5e,'asciicircummonospace':0xff3e,'asciitilde':0x7e,'asciitildemonospace':0xff5e,'ascript':0x251,'ascriptturned':0x252,'asmallhiragana':0x3041,'asmallkatakana':0x30a1,'asmallkatakanahalfwidth':0xff67,'asterisk':0x2a,'asteriskaltonearabic':0x66d,'asteriskarabic':0x66d,'asteriskmath':0x2217,'asteriskmonospace':0xff0a,'asterisksmall':0xfe61,'asterism':0x2042,'asuperior':0xf6e9,'asymptoticallyequal':0x2243,'at':0x40,'atilde':0xe3,'atmonospace':0xff20,'atsmall':0xfe6b,'aturned':0x250,'aubengali':0x994,'aubopomofo':0x3120,'audeva':0x914,'augujarati':0xa94,'augurmukhi':0xa14,'aulengthmarkbengali':0x9d7,'aumatragurmukhi':0xa4c,'auvowelsignbengali':0x9cc,'auvowelsigndeva':0x94c,'auvowelsigngujarati':0xacc,'avagrahadeva':0x93d,'aybarmenian':0x561,'ayin':0x5e2,'ayinaltonehebrew':0xfb20,'ayinhebrew':0x5e2,'b':0x62,'babengali':0x9ac,'backslash':0x5c,'backslashmonospace':0xff3c,'badeva':0x92c,'bagujarati':0xaac,'bagurmukhi':0xa2c,'bahiragana':0x3070,'bahtthai':0xe3f,'bakatakana':0x30d0,'bar':0x7c,'barmonospace':0xff5c,'bbopomofo':0x3105,'bcircle':0x24d1,'bdotaccent':0x1e03,'bdotbelow':0x1e05,'beamedsixteenthnotes':0x266c,'because':0x2235,'becyrillic':0x431,'beharabic':0x628,'behfinalarabic':0xfe90,'behinitialarabic':0xfe91,'behiragana':0x3079,'behmedialarabic':0xfe92,'behmeeminitialarabic':0xfc9f,'behmeemisolatedarabic':0xfc08,'behnoonfinalarabic':0xfc6d,'bekatakana':0x30d9,'benarmenian':0x562,'bet':0x5d1,'beta':0x3b2,'betasymbolgreek':0x3d0,'betdagesh':0xfb31,'betdageshhebrew':0xfb31,'bethebrew':0x5d1,'betrafehebrew':0xfb4c,'bhabengali':0x9ad,'bhadeva':0x92d,'bhagujarati':0xaad,'bhagurmukhi':0xa2d,'bhook':0x253,'bihiragana':0x3073,'bikatakana':0x30d3,'bilabialclick':0x298,'bindigurmukhi':0xa02,'birusquare':0x3331,'blackcircle':0x25cf,'blackdiamond':0x25c6,'blackdownpointingtriangle':0x25bc,'blackleftpointingpointer':0x25c4,'blackleftpointingtriangle':0x25c0,'blacklenticularbracketleft':0x3010,'blacklenticularbracketleftvertical':0xfe3b,'blacklenticularbracketright':0x3011,'blacklenticularbracketrightvertical':0xfe3c,'blacklowerlefttriangle':0x25e3,'blacklowerrighttriangle':0x25e2,'blackrectangle':0x25ac,'blackrightpointingpointer':0x25ba,'blackrightpointingtriangle':0x25b6,'blacksmallsquare':0x25aa,'blacksmilingface':0x263b,'blacksquare':0x25a0,'blackstar':0x2605,'blackupperlefttriangle':0x25e4,'blackupperrighttriangle':0x25e5,'blackuppointingsmalltriangle':0x25b4,'blackuppointingtriangle':0x25b2,'blank':0x2423,'blinebelow':0x1e07,'block':0x2588,'bmonospace':0xff42,'bobaimaithai':0xe1a,'bohiragana':0x307c,'bokatakana':0x30dc,'bparen':0x249d,'bqsquare':0x33c3,'braceex':0xf8f4,'braceleft':0x7b,'braceleftbt':0xf8f3,'braceleftmid':0xf8f2,'braceleftmonospace':0xff5b,'braceleftsmall':0xfe5b,'bracelefttp':0xf8f1,'braceleftvertical':0xfe37,'braceright':0x7d,'bracerightbt':0xf8fe,'bracerightmid':0xf8fd,'bracerightmonospace':0xff5d,'bracerightsmall':0xfe5c,'bracerighttp':0xf8fc,'bracerightvertical':0xfe38,'bracketleft':0x5b,'bracketleftbt':0xf8f0,'bracketleftex':0xf8ef,'bracketleftmonospace':0xff3b,'bracketlefttp':0xf8ee,'bracketright':0x5d,'bracketrightbt':0xf8fb,'bracketrightex':0xf8fa,'bracketrightmonospace':0xff3d,'bracketrighttp':0xf8f9,'breve':0x2d8,'brevebelowcmb':0x32e,'brevecmb':0x306,'breveinvertedbelowcmb':0x32f,'breveinvertedcmb':0x311,'breveinverteddoublecmb':0x361,'bridgebelowcmb':0x32a,'bridgeinvertedbelowcmb':0x33a,'brokenbar':0xa6,'bstroke':0x180,'bsuperior':0xf6ea,'btopbar':0x183,'buhiragana':0x3076,'bukatakana':0x30d6,'bullet':0x2022,'bulletinverse':0x25d8,'bulletoperator':0x2219,'bullseye':0x25ce,'c':0x63,'caarmenian':0x56e,'cabengali':0x99a,'cacute':0x107,'cadeva':0x91a,'cagujarati':0xa9a,'cagurmukhi':0xa1a,'calsquare':0x3388,'candrabindubengali':0x981,'candrabinducmb':0x310,'candrabindudeva':0x901,'candrabindugujarati':0xa81,'capslock':0x21ea,'careof':0x2105,'caron':0x2c7,'caronbelowcmb':0x32c,'caroncmb':0x30c,'carriagereturn':0x21b5,'cbopomofo':0x3118,'ccaron':0x10d,'ccedilla':0xe7,'ccedillaacute':0x1e09,'ccircle':0x24d2,'ccircumflex':0x109,'ccurl':0x255,'cdot':0x10b,'cdotaccent':0x10b,'cdsquare':0x33c5,'cedilla':0xb8,'cedillacmb':0x327,'cent':0xa2,'centigrade':0x2103,'centinferior':0xf6df,'centmonospace':0xffe0,'centoldstyle':0xf7a2,'centsuperior':0xf6e0,'chaarmenian':0x579,'chabengali':0x99b,'chadeva':0x91b,'chagujarati':0xa9b,'chagurmukhi':0xa1b,'chbopomofo':0x3114,'cheabkhasiancyrillic':0x4bd,'checkmark':0x2713,'checyrillic':0x447,'chedescenderabkhasiancyrillic':0x4bf,'chedescendercyrillic':0x4b7,'chedieresiscyrillic':0x4f5,'cheharmenian':0x573,'chekhakassiancyrillic':0x4cc,'cheverticalstrokecyrillic':0x4b9,'chi':0x3c7,'chieuchacirclekorean':0x3277,'chieuchaparenkorean':0x3217,'chieuchcirclekorean':0x3269,'chieuchkorean':0x314a,'chieuchparenkorean':0x3209,'chochangthai':0xe0a,'chochanthai':0xe08,'chochingthai':0xe09,'chochoethai':0xe0c,'chook':0x188,'cieucacirclekorean':0x3276,'cieucaparenkorean':0x3216,'cieuccirclekorean':0x3268,'cieuckorean':0x3148,'cieucparenkorean':0x3208,'cieucuparenkorean':0x321c,'circle':0x25cb,'circlemultiply':0x2297,'circleot':0x2299,'circleplus':0x2295,'circlepostalmark':0x3036,'circlewithlefthalfblack':0x25d0,'circlewithrighthalfblack':0x25d1,'circumflex':0x2c6,'circumflexbelowcmb':0x32d,'circumflexcmb':0x302,'clear':0x2327,'clickalveolar':0x1c2,'clickdental':0x1c0,'clicklateral':0x1c1,'clickretroflex':0x1c3,'club':0x2663,'clubsuitblack':0x2663,'clubsuitwhite':0x2667,'cmcubedsquare':0x33a4,'cmonospace':0xff43,'cmsquaredsquare':0x33a0,'coarmenian':0x581,'colon':0x3a,'colonmonetary':0x20a1,'colonmonospace':0xff1a,'colonsign':0x20a1,'colonsmall':0xfe55,'colontriangularhalfmod':0x2d1,'colontriangularmod':0x2d0,'comma':0x2c,'commaabovecmb':0x313,'commaaboverightcmb':0x315,'commaaccent':0xf6c3,'commaarabic':0x60c,'commaarmenian':0x55d,'commainferior':0xf6e1,'commamonospace':0xff0c,'commareversedabovecmb':0x314,'commareversedmod':0x2bd,'commasmall':0xfe50,'commasuperior':0xf6e2,'commaturnedabovecmb':0x312,'commaturnedmod':0x2bb,'compass':0x263c,'congruent':0x2245,'contourintegral':0x222e,'control':0x2303,'controlACK':0x6,'controlBEL':0x7,'controlBS':0x8,'controlCAN':0x18,'controlCR':0xd,'controlDC1':0x11,'controlDC2':0x12,'controlDC3':0x13,'controlDC4':0x14,'controlDEL':0x7f,'controlDLE':0x10,'controlEM':0x19,'controlENQ':0x5,'controlEOT':0x4,'controlESC':0x1b,'controlETB':0x17,'controlETX':0x3,'controlFF':0xc,'controlFS':0x1c,'controlGS':0x1d,'controlHT':0x9,'controlLF':0xa,'controlNAK':0x15,'controlRS':0x1e,'controlSI':0xf,'controlSO':0xe,'controlSOT':0x2,'controlSTX':0x1,'controlSUB':0x1a,'controlSYN':0x16,'controlUS':0x1f,'controlVT':0xb,'copyright':0xa9,'copyrightsans':0xf8e9,'copyrightserif':0xf6d9,'cornerbracketleft':0x300c,'cornerbracketlefthalfwidth':0xff62,'cornerbracketleftvertical':0xfe41,'cornerbracketright':0x300d,'cornerbracketrighthalfwidth':0xff63,'cornerbracketrightvertical':0xfe42,'corporationsquare':0x337f,'cosquare':0x33c7,'coverkgsquare':0x33c6,'cparen':0x249e,'cruzeiro':0x20a2,'cstretched':0x297,'curlyand':0x22cf,'curlyor':0x22ce,'currency':0xa4,'cyrBreve':0xf6d1,'cyrFlex':0xf6d2,'cyrbreve':0xf6d4,'cyrflex':0xf6d5,'d':0x64,'daarmenian':0x564,'dabengali':0x9a6,'dadarabic':0x636,'dadeva':0x926,'dadfinalarabic':0xfebe,'dadinitialarabic':0xfebf,'dadmedialarabic':0xfec0,'dagesh':0x5bc,'dageshhebrew':0x5bc,'dagger':0x2020,'daggerdbl':0x2021,'dagujarati':0xaa6,'dagurmukhi':0xa26,'dahiragana':0x3060,'dakatakana':0x30c0,'dalarabic':0x62f,'dalet':0x5d3,'daletdagesh':0xfb33,'daletdageshhebrew':0xfb33,'dalethebrew':0x5d3,'dalfinalarabic':0xfeaa,'dammaarabic':0x64f,'dammalowarabic':0x64f,'dammatanaltonearabic':0x64c,'dammatanarabic':0x64c,'danda':0x964,'dargahebrew':0x5a7,'dargalefthebrew':0x5a7,'dasiapneumatacyrilliccmb':0x485,'dblGrave':0xf6d3,'dblanglebracketleft':0x300a,'dblanglebracketleftvertical':0xfe3d,'dblanglebracketright':0x300b,'dblanglebracketrightvertical':0xfe3e,'dblarchinvertedbelowcmb':0x32b,'dblarrowleft':0x21d4,'dblarrowright':0x21d2,'dbldanda':0x965,'dblgrave':0xf6d6,'dblgravecmb':0x30f,'dblintegral':0x222c,'dbllowline':0x2017,'dbllowlinecmb':0x333,'dbloverlinecmb':0x33f,'dblprimemod':0x2ba,'dblverticalbar':0x2016,'dblverticallineabovecmb':0x30e,'dbopomofo':0x3109,'dbsquare':0x33c8,'dcaron':0x10f,'dcedilla':0x1e11,'dcircle':0x24d3,'dcircumflexbelow':0x1e13,'dcroat':0x111,'ddabengali':0x9a1,'ddadeva':0x921,'ddagujarati':0xaa1,'ddagurmukhi':0xa21,'ddalarabic':0x688,'ddalfinalarabic':0xfb89,'dddhadeva':0x95c,'ddhabengali':0x9a2,'ddhadeva':0x922,'ddhagujarati':0xaa2,'ddhagurmukhi':0xa22,'ddotaccent':0x1e0b,'ddotbelow':0x1e0d,'decimalseparatorarabic':0x66b,'decimalseparatorpersian':0x66b,'decyrillic':0x434,'degree':0xb0,'dehihebrew':0x5ad,'dehiragana':0x3067,'deicoptic':0x3ef,'dekatakana':0x30c7,'deleteleft':0x232b,'deleteright':0x2326,'delta':0x3b4,'deltaturned':0x18d,'denominatorminusonenumeratorbengali':0x9f8,'dezh':0x2a4,'dhabengali':0x9a7,'dhadeva':0x927,'dhagujarati':0xaa7,'dhagurmukhi':0xa27,'dhook':0x257,'dialytikatonos':0x385,'dialytikatonoscmb':0x344,'diamond':0x2666,'diamondsuitwhite':0x2662,'dieresis':0xa8,'dieresisacute':0xf6d7,'dieresisbelowcmb':0x324,'dieresiscmb':0x308,'dieresisgrave':0xf6d8,'dieresistonos':0x385,'dihiragana':0x3062,'dikatakana':0x30c2,'dittomark':0x3003,'divide':0xf7,'divides':0x2223,'divisionslash':0x2215,'djecyrillic':0x452,'dkshade':0x2593,'dlinebelow':0x1e0f,'dlsquare':0x3397,'dmacron':0x111,'dmonospace':0xff44,'dnblock':0x2584,'dochadathai':0xe0e,'dodekthai':0xe14,'dohiragana':0x3069,'dokatakana':0x30c9,'dollar':0x24,'dollarinferior':0xf6e3,'dollarmonospace':0xff04,'dollaroldstyle':0xf724,'dollarsmall':0xfe69,'dollarsuperior':0xf6e4,'dong':0x20ab,'dorusquare':0x3326,'dotaccent':0x2d9,'dotaccentcmb':0x307,'dotbelowcmb':0x323,'dotbelowcomb':0x323,'dotkatakana':0x30fb,'dotlessi':0x131,'dotlessj':0xf6be,'dotlessjstrokehook':0x284,'dotmath':0x22c5,'dottedcircle':0x25cc,'doubleyodpatah':0xfb1f,'doubleyodpatahhebrew':0xfb1f,'downtackbelowcmb':0x31e,'downtackmod':0x2d5,'dparen':0x249f,'dsuperior':0xf6eb,'dtail':0x256,'dtopbar':0x18c,'duhiragana':0x3065,'dukatakana':0x30c5,'dz':0x1f3,'dzaltone':0x2a3,'dzcaron':0x1c6,'dzcurl':0x2a5,'dzeabkhasiancyrillic':0x4e1,'dzecyrillic':0x455,'dzhecyrillic':0x45f,'e':0x65,'eacute':0xe9,'earth':0x2641,'ebengali':0x98f,'ebopomofo':0x311c,'ebreve':0x115,'ecandradeva':0x90d,'ecandragujarati':0xa8d,'ecandravowelsigndeva':0x945,'ecandravowelsigngujarati':0xac5,'ecaron':0x11b,'ecedillabreve':0x1e1d,'echarmenian':0x565,'echyiwnarmenian':0x587,'ecircle':0x24d4,'ecircumflex':0xea,'ecircumflexacute':0x1ebf,'ecircumflexbelow':0x1e19,'ecircumflexdotbelow':0x1ec7,'ecircumflexgrave':0x1ec1,'ecircumflexhookabove':0x1ec3,'ecircumflextilde':0x1ec5,'ecyrillic':0x454,'edblgrave':0x205,'edeva':0x90f,'edieresis':0xeb,'edot':0x117,'edotaccent':0x117,'edotbelow':0x1eb9,'eegurmukhi':0xa0f,'eematragurmukhi':0xa47,'efcyrillic':0x444,'egrave':0xe8,'egujarati':0xa8f,'eharmenian':0x567,'ehbopomofo':0x311d,'ehiragana':0x3048,'ehookabove':0x1ebb,'eibopomofo':0x311f,'eight':0x38,'eightarabic':0x668,'eightbengali':0x9ee,'eightcircle':0x2467,'eightcircleinversesansserif':0x2791,'eightdeva':0x96e,'eighteencircle':0x2471,'eighteenparen':0x2485,'eighteenperiod':0x2499,'eightgujarati':0xaee,'eightgurmukhi':0xa6e,'eighthackarabic':0x668,'eighthangzhou':0x3028,'eighthnotebeamed':0x266b,'eightideographicparen':0x3227,'eightinferior':0x2088,'eightmonospace':0xff18,'eightoldstyle':0xf738,'eightparen':0x247b,'eightperiod':0x248f,'eightpersian':0x6f8,'eightroman':0x2177,'eightsuperior':0x2078,'eightthai':0xe58,'einvertedbreve':0x207,'eiotifiedcyrillic':0x465,'ekatakana':0x30a8,'ekatakanahalfwidth':0xff74,'ekonkargurmukhi':0xa74,'ekorean':0x3154,'elcyrillic':0x43b,'element':0x2208,'elevencircle':0x246a,'elevenparen':0x247e,'elevenperiod':0x2492,'elevenroman':0x217a,'ellipsis':0x2026,'ellipsisvertical':0x22ee,'emacron':0x113,'emacronacute':0x1e17,'emacrongrave':0x1e15,'emcyrillic':0x43c,'emdash':0x2014,'emdashvertical':0xfe31,'emonospace':0xff45,'emphasismarkarmenian':0x55b,'emptyset':0x2205,'enbopomofo':0x3123,'encyrillic':0x43d,'endash':0x2013,'endashvertical':0xfe32,'endescendercyrillic':0x4a3,'eng':0x14b,'engbopomofo':0x3125,'enghecyrillic':0x4a5,'enhookcyrillic':0x4c8,'enspace':0x2002,'eogonek':0x119,'eokorean':0x3153,'eopen':0x25b,'eopenclosed':0x29a,'eopenreversed':0x25c,'eopenreversedclosed':0x25e,'eopenreversedhook':0x25d,'eparen':0x24a0,'epsilon':0x3b5,'epsilontonos':0x3ad,'equal':0x3d,'equalmonospace':0xff1d,'equalsmall':0xfe66,'equalsuperior':0x207c,'equivalence':0x2261,'erbopomofo':0x3126,'ercyrillic':0x440,'ereversed':0x258,'ereversedcyrillic':0x44d,'escyrillic':0x441,'esdescendercyrillic':0x4ab,'esh':0x283,'eshcurl':0x286,'eshortdeva':0x90e,'eshortvowelsigndeva':0x946,'eshreversedloop':0x1aa,'eshsquatreversed':0x285,'esmallhiragana':0x3047,'esmallkatakana':0x30a7,'esmallkatakanahalfwidth':0xff6a,'estimated':0x212e,'esuperior':0xf6ec,'eta':0x3b7,'etarmenian':0x568,'etatonos':0x3ae,'eth':0xf0,'etilde':0x1ebd,'etildebelow':0x1e1b,'etnahtafoukhhebrew':0x591,'etnahtafoukhlefthebrew':0x591,'etnahtahebrew':0x591,'etnahtalefthebrew':0x591,'eturned':0x1dd,'eukorean':0x3161,'Euro':0x20ac,'evowelsignbengali':0x9c7,'evowelsigndeva':0x947,'evowelsigngujarati':0xac7,'exclam':0x21,'exclamarmenian':0x55c,'exclamdbl':0x203c,'exclamdown':0xa1,'exclamdownsmall':0xf7a1,'exclammonospace':0xff01,'exclamsmall':0xf721,'existential':0x2203,'ezh':0x292,'ezhcaron':0x1ef,'ezhcurl':0x293,'ezhreversed':0x1b9,'ezhtail':0x1ba,'f':0x66,'fadeva':0x95e,'fagurmukhi':0xa5e,'fahrenheit':0x2109,'fathaarabic':0x64e,'fathalowarabic':0x64e,'fathatanarabic':0x64b,'fbopomofo':0x3108,'fcircle':0x24d5,'fdotaccent':0x1e1f,'feharabic':0x641,'feharmenian':0x586,'fehfinalarabic':0xfed2,'fehinitialarabic':0xfed3,'fehmedialarabic':0xfed4,'feicoptic':0x3e5,'female':0x2640,'ff':0xfb00,'ffi':0xfb03,'ffl':0xfb04,'fi':0xfb01,'fifteencircle':0x246e,'fifteenparen':0x2482,'fifteenperiod':0x2496,'figuredash':0x2012,'filledbox':0x25a0,'filledrect':0x25ac,'finalkaf':0x5da,'finalkafdagesh':0xfb3a,'finalkafdageshhebrew':0xfb3a,'finalkafhebrew':0x5da,'finalmem':0x5dd,'finalmemhebrew':0x5dd,'finalnun':0x5df,'finalnunhebrew':0x5df,'finalpe':0x5e3,'finalpehebrew':0x5e3,'finaltsadi':0x5e5,'finaltsadihebrew':0x5e5,'firsttonechinese':0x2c9,'fisheye':0x25c9,'fitacyrillic':0x473,'five':0x35,'fivearabic':0x665,'fivebengali':0x9eb,'fivecircle':0x2464,'fivecircleinversesansserif':0x278e,'fivedeva':0x96b,'fiveeighths':0x215d,'fivegujarati':0xaeb,'fivegurmukhi':0xa6b,'fivehackarabic':0x665,'fivehangzhou':0x3025,'fiveideographicparen':0x3224,'fiveinferior':0x2085,'fivemonospace':0xff15,'fiveoldstyle':0xf735,'fiveparen':0x2478,'fiveperiod':0x248c,'fivepersian':0x6f5,'fiveroman':0x2174,'fivesuperior':0x2075,'fivethai':0xe55,'fl':0xfb02,'florin':0x192,'fmonospace':0xff46,'fmsquare':0x3399,'fofanthai':0xe1f,'fofathai':0xe1d,'fongmanthai':0xe4f,'forall':0x2200,'four':0x34,'fourarabic':0x664,'fourbengali':0x9ea,'fourcircle':0x2463,'fourcircleinversesansserif':0x278d,'fourdeva':0x96a,'fourgujarati':0xaea,'fourgurmukhi':0xa6a,'fourhackarabic':0x664,'fourhangzhou':0x3024,'fourideographicparen':0x3223,'fourinferior':0x2084,'fourmonospace':0xff14,'fournumeratorbengali':0x9f7,'fouroldstyle':0xf734,'fourparen':0x2477,'fourperiod':0x248b,'fourpersian':0x6f4,'fourroman':0x2173,'foursuperior':0x2074,'fourteencircle':0x246d,'fourteenparen':0x2481,'fourteenperiod':0x2495,'fourthai':0xe54,'fourthtonechinese':0x2cb,'fparen':0x24a1,'fraction':0x2044,'franc':0x20a3,'g':0x67,'gabengali':0x997,'gacute':0x1f5,'gadeva':0x917,'gafarabic':0x6af,'gaffinalarabic':0xfb93,'gafinitialarabic':0xfb94,'gafmedialarabic':0xfb95,'gagujarati':0xa97,'gagurmukhi':0xa17,'gahiragana':0x304c,'gakatakana':0x30ac,'gamma':0x3b3,'gammalatinsmall':0x263,'gammasuperior':0x2e0,'gangiacoptic':0x3eb,'gbopomofo':0x310d,'gbreve':0x11f,'gcaron':0x1e7,'gcedilla':0x123,'gcircle':0x24d6,'gcircumflex':0x11d,'gcommaaccent':0x123,'gdot':0x121,'gdotaccent':0x121,'gecyrillic':0x433,'gehiragana':0x3052,'gekatakana':0x30b2,'geometricallyequal':0x2251,'gereshaccenthebrew':0x59c,'gereshhebrew':0x5f3,'gereshmuqdamhebrew':0x59d,'germandbls':0xdf,'gershayimaccenthebrew':0x59e,'gershayimhebrew':0x5f4,'getamark':0x3013,'ghabengali':0x998,'ghadarmenian':0x572,'ghadeva':0x918,'ghagujarati':0xa98,'ghagurmukhi':0xa18,'ghainarabic':0x63a,'ghainfinalarabic':0xfece,'ghaininitialarabic':0xfecf,'ghainmedialarabic':0xfed0,'ghemiddlehookcyrillic':0x495,'ghestrokecyrillic':0x493,'gheupturncyrillic':0x491,'ghhadeva':0x95a,'ghhagurmukhi':0xa5a,'ghook':0x260,'ghzsquare':0x3393,'gihiragana':0x304e,'gikatakana':0x30ae,'gimarmenian':0x563,'gimel':0x5d2,'gimeldagesh':0xfb32,'gimeldageshhebrew':0xfb32,'gimelhebrew':0x5d2,'gjecyrillic':0x453,'glottalinvertedstroke':0x1be,'glottalstop':0x294,'glottalstopinverted':0x296,'glottalstopmod':0x2c0,'glottalstopreversed':0x295,'glottalstopreversedmod':0x2c1,'glottalstopreversedsuperior':0x2e4,'glottalstopstroke':0x2a1,'glottalstopstrokereversed':0x2a2,'gmacron':0x1e21,'gmonospace':0xff47,'gohiragana':0x3054,'gokatakana':0x30b4,'gparen':0x24a2,'gpasquare':0x33ac,'gradient':0x2207,'grave':0x60,'gravebelowcmb':0x316,'gravecmb':0x300,'gravecomb':0x300,'gravedeva':0x953,'gravelowmod':0x2ce,'gravemonospace':0xff40,'gravetonecmb':0x340,'greater':0x3e,'greaterequal':0x2265,'greaterequalorless':0x22db,'greatermonospace':0xff1e,'greaterorequivalent':0x2273,'greaterorless':0x2277,'greateroverequal':0x2267,'greatersmall':0xfe65,'gscript':0x261,'gstroke':0x1e5,'guhiragana':0x3050,'guillemotleft':0xab,'guillemotright':0xbb,'guilsinglleft':0x2039,'guilsinglright':0x203a,'gukatakana':0x30b0,'guramusquare':0x3318,'gysquare':0x33c9,'h':0x68,'haabkhasiancyrillic':0x4a9,'haaltonearabic':0x6c1,'habengali':0x9b9,'hadescendercyrillic':0x4b3,'hadeva':0x939,'hagujarati':0xab9,'hagurmukhi':0xa39,'haharabic':0x62d,'hahfinalarabic':0xfea2,'hahinitialarabic':0xfea3,'hahiragana':0x306f,'hahmedialarabic':0xfea4,'haitusquare':0x332a,'hakatakana':0x30cf,'hakatakanahalfwidth':0xff8a,'halantgurmukhi':0xa4d,'hamzaarabic':0x621,'hamzalowarabic':0x621,'hangulfiller':0x3164,'hardsigncyrillic':0x44a,'harpoonleftbarbup':0x21bc,'harpoonrightbarbup':0x21c0,'hasquare':0x33ca,'hatafpatah':0x5b2,'hatafpatah16':0x5b2,'hatafpatah23':0x5b2,'hatafpatah2f':0x5b2,'hatafpatahhebrew':0x5b2,'hatafpatahnarrowhebrew':0x5b2,'hatafpatahquarterhebrew':0x5b2,'hatafpatahwidehebrew':0x5b2,'hatafqamats':0x5b3,'hatafqamats1b':0x5b3,'hatafqamats28':0x5b3,'hatafqamats34':0x5b3,'hatafqamatshebrew':0x5b3,'hatafqamatsnarrowhebrew':0x5b3,'hatafqamatsquarterhebrew':0x5b3,'hatafqamatswidehebrew':0x5b3,'hatafsegol':0x5b1,'hatafsegol17':0x5b1,'hatafsegol24':0x5b1,'hatafsegol30':0x5b1,'hatafsegolhebrew':0x5b1,'hatafsegolnarrowhebrew':0x5b1,'hatafsegolquarterhebrew':0x5b1,'hatafsegolwidehebrew':0x5b1,'hbar':0x127,'hbopomofo':0x310f,'hbrevebelow':0x1e2b,'hcedilla':0x1e29,'hcircle':0x24d7,'hcircumflex':0x125,'hdieresis':0x1e27,'hdotaccent':0x1e23,'hdotbelow':0x1e25,'he':0x5d4,'heart':0x2665,'heartsuitblack':0x2665,'heartsuitwhite':0x2661,'hedagesh':0xfb34,'hedageshhebrew':0xfb34,'hehaltonearabic':0x6c1,'heharabic':0x647,'hehebrew':0x5d4,'hehfinalaltonearabic':0xfba7,'hehfinalalttwoarabic':0xfeea,'hehfinalarabic':0xfeea,'hehhamzaabovefinalarabic':0xfba5,'hehhamzaaboveisolatedarabic':0xfba4,'hehinitialaltonearabic':0xfba8,'hehinitialarabic':0xfeeb,'hehiragana':0x3078,'hehmedialaltonearabic':0xfba9,'hehmedialarabic':0xfeec,'heiseierasquare':0x337b,'hekatakana':0x30d8,'hekatakanahalfwidth':0xff8d,'hekutaarusquare':0x3336,'henghook':0x267,'herutusquare':0x3339,'het':0x5d7,'hethebrew':0x5d7,'hhook':0x266,'hhooksuperior':0x2b1,'hieuhacirclekorean':0x327b,'hieuhaparenkorean':0x321b,'hieuhcirclekorean':0x326d,'hieuhkorean':0x314e,'hieuhparenkorean':0x320d,'hihiragana':0x3072,'hikatakana':0x30d2,'hikatakanahalfwidth':0xff8b,'hiriq':0x5b4,'hiriq14':0x5b4,'hiriq21':0x5b4,'hiriq2d':0x5b4,'hiriqhebrew':0x5b4,'hiriqnarrowhebrew':0x5b4,'hiriqquarterhebrew':0x5b4,'hiriqwidehebrew':0x5b4,'hlinebelow':0x1e96,'hmonospace':0xff48,'hoarmenian':0x570,'hohipthai':0xe2b,'hohiragana':0x307b,'hokatakana':0x30db,'hokatakanahalfwidth':0xff8e,'holam':0x5b9,'holam19':0x5b9,'holam26':0x5b9,'holam32':0x5b9,'holamhebrew':0x5b9,'holamnarrowhebrew':0x5b9,'holamquarterhebrew':0x5b9,'holamwidehebrew':0x5b9,'honokhukthai':0xe2e,'hookabovecomb':0x309,'hookcmb':0x309,'hookpalatalizedbelowcmb':0x321,'hookretroflexbelowcmb':0x322,'hoonsquare':0x3342,'horicoptic':0x3e9,'horizontalbar':0x2015,'horncmb':0x31b,'hotsprings':0x2668,'house':0x2302,'hparen':0x24a3,'hsuperior':0x2b0,'hturned':0x265,'huhiragana':0x3075,'huiitosquare':0x3333,'hukatakana':0x30d5,'hukatakanahalfwidth':0xff8c,'hungarumlaut':0x2dd,'hungarumlautcmb':0x30b,'hv':0x195,'hyphen':0x2d,'hypheninferior':0xf6e5,'hyphenmonospace':0xff0d,'hyphensmall':0xfe63,'hyphensuperior':0xf6e6,'hyphentwo':0x2010,'i':0x69,'iacute':0xed,'iacyrillic':0x44f,'ibengali':0x987,'ibopomofo':0x3127,'ibreve':0x12d,'icaron':0x1d0,'icircle':0x24d8,'icircumflex':0xee,'icyrillic':0x456,'idblgrave':0x209,'ideographearthcircle':0x328f,'ideographfirecircle':0x328b,'ideographicallianceparen':0x323f,'ideographiccallparen':0x323a,'ideographiccentrecircle':0x32a5,'ideographicclose':0x3006,'ideographiccomma':0x3001,'ideographiccommaleft':0xff64,'ideographiccongratulationparen':0x3237,'ideographiccorrectcircle':0x32a3,'ideographicearthparen':0x322f,'ideographicenterpriseparen':0x323d,'ideographicexcellentcircle':0x329d,'ideographicfestivalparen':0x3240,'ideographicfinancialcircle':0x3296,'ideographicfinancialparen':0x3236,'ideographicfireparen':0x322b,'ideographichaveparen':0x3232,'ideographichighcircle':0x32a4,'ideographiciterationmark':0x3005,'ideographiclaborcircle':0x3298,'ideographiclaborparen':0x3238,'ideographicleftcircle':0x32a7,'ideographiclowcircle':0x32a6,'ideographicmedicinecircle':0x32a9,'ideographicmetalparen':0x322e,'ideographicmoonparen':0x322a,'ideographicnameparen':0x3234,'ideographicperiod':0x3002,'ideographicprintcircle':0x329e,'ideographicreachparen':0x3243,'ideographicrepresentparen':0x3239,'ideographicresourceparen':0x323e,'ideographicrightcircle':0x32a8,'ideographicsecretcircle':0x3299,'ideographicselfparen':0x3242,'ideographicsocietyparen':0x3233,'ideographicspace':0x3000,'ideographicspecialparen':0x3235,'ideographicstockparen':0x3231,'ideographicstudyparen':0x323b,'ideographicsunparen':0x3230,'ideographicsuperviseparen':0x323c,'ideographicwaterparen':0x322c,'ideographicwoodparen':0x322d,'ideographiczero':0x3007,'ideographmetalcircle':0x328e,'ideographmooncircle':0x328a,'ideographnamecircle':0x3294,'ideographsuncircle':0x3290,'ideographwatercircle':0x328c,'ideographwoodcircle':0x328d,'ideva':0x907,'idieresis':0xef,'idieresisacute':0x1e2f,'idieresiscyrillic':0x4e5,'idotbelow':0x1ecb,'iebrevecyrillic':0x4d7,'iecyrillic':0x435,'ieungacirclekorean':0x3275,'ieungaparenkorean':0x3215,'ieungcirclekorean':0x3267,'ieungkorean':0x3147,'ieungparenkorean':0x3207,'igrave':0xec,'igujarati':0xa87,'igurmukhi':0xa07,'ihiragana':0x3044,'ihookabove':0x1ec9,'iibengali':0x988,'iicyrillic':0x438,'iideva':0x908,'iigujarati':0xa88,'iigurmukhi':0xa08,'iimatragurmukhi':0xa40,'iinvertedbreve':0x20b,'iishortcyrillic':0x439,'iivowelsignbengali':0x9c0,'iivowelsigndeva':0x940,'iivowelsigngujarati':0xac0,'ij':0x133,'ikatakana':0x30a4,'ikatakanahalfwidth':0xff72,'ikorean':0x3163,'ilde':0x2dc,'iluyhebrew':0x5ac,'imacron':0x12b,'imacroncyrillic':0x4e3,'imageorapproximatelyequal':0x2253,'imatragurmukhi':0xa3f,'imonospace':0xff49,'increment':0x2206,'infinity':0x221e,'iniarmenian':0x56b,'integral':0x222b,'integralbottom':0x2321,'integralbt':0x2321,'integralex':0xf8f5,'integraltop':0x2320,'integraltp':0x2320,'intersection':0x2229,'intisquare':0x3305,'invbullet':0x25d8,'invcircle':0x25d9,'invsmileface':0x263b,'iocyrillic':0x451,'iogonek':0x12f,'iota':0x3b9,'iotadieresis':0x3ca,'iotadieresistonos':0x390,'iotalatin':0x269,'iotatonos':0x3af,'iparen':0x24a4,'irigurmukhi':0xa72,'ismallhiragana':0x3043,'ismallkatakana':0x30a3,'ismallkatakanahalfwidth':0xff68,'issharbengali':0x9fa,'istroke':0x268,'isuperior':0xf6ed,'iterationhiragana':0x309d,'iterationkatakana':0x30fd,'itilde':0x129,'itildebelow':0x1e2d,'iubopomofo':0x3129,'iucyrillic':0x44e,'ivowelsignbengali':0x9bf,'ivowelsigndeva':0x93f,'ivowelsigngujarati':0xabf,'izhitsacyrillic':0x475,'izhitsadblgravecyrillic':0x477,'j':0x6a,'jaarmenian':0x571,'jabengali':0x99c,'jadeva':0x91c,'jagujarati':0xa9c,'jagurmukhi':0xa1c,'jbopomofo':0x3110,'jcaron':0x1f0,'jcircle':0x24d9,'jcircumflex':0x135,'jcrossedtail':0x29d,'jdotlessstroke':0x25f,'jecyrillic':0x458,'jeemarabic':0x62c,'jeemfinalarabic':0xfe9e,'jeeminitialarabic':0xfe9f,'jeemmedialarabic':0xfea0,'jeharabic':0x698,'jehfinalarabic':0xfb8b,'jhabengali':0x99d,'jhadeva':0x91d,'jhagujarati':0xa9d,'jhagurmukhi':0xa1d,'jheharmenian':0x57b,'jis':0x3004,'jmonospace':0xff4a,'jparen':0x24a5,'jsuperior':0x2b2,'k':0x6b,'kabashkircyrillic':0x4a1,'kabengali':0x995,'kacute':0x1e31,'kacyrillic':0x43a,'kadescendercyrillic':0x49b,'kadeva':0x915,'kaf':0x5db,'kafarabic':0x643,'kafdagesh':0xfb3b,'kafdageshhebrew':0xfb3b,'kaffinalarabic':0xfeda,'kafhebrew':0x5db,'kafinitialarabic':0xfedb,'kafmedialarabic':0xfedc,'kafrafehebrew':0xfb4d,'kagujarati':0xa95,'kagurmukhi':0xa15,'kahiragana':0x304b,'kahookcyrillic':0x4c4,'kakatakana':0x30ab,'kakatakanahalfwidth':0xff76,'kappa':0x3ba,'kappasymbolgreek':0x3f0,'kapyeounmieumkorean':0x3171,'kapyeounphieuphkorean':0x3184,'kapyeounpieupkorean':0x3178,'kapyeounssangpieupkorean':0x3179,'karoriisquare':0x330d,'kashidaautoarabic':0x640,'kashidaautonosidebearingarabic':0x640,'kasmallkatakana':0x30f5,'kasquare':0x3384,'kasraarabic':0x650,'kasratanarabic':0x64d,'kastrokecyrillic':0x49f,'katahiraprolongmarkhalfwidth':0xff70,'kaverticalstrokecyrillic':0x49d,'kbopomofo':0x310e,'kcalsquare':0x3389,'kcaron':0x1e9,'kcedilla':0x137,'kcircle':0x24da,'kcommaaccent':0x137,'kdotbelow':0x1e33,'keharmenian':0x584,'kehiragana':0x3051,'kekatakana':0x30b1,'kekatakanahalfwidth':0xff79,'kenarmenian':0x56f,'kesmallkatakana':0x30f6,'kgreenlandic':0x138,'khabengali':0x996,'khacyrillic':0x445,'khadeva':0x916,'khagujarati':0xa96,'khagurmukhi':0xa16,'khaharabic':0x62e,'khahfinalarabic':0xfea6,'khahinitialarabic':0xfea7,'khahmedialarabic':0xfea8,'kheicoptic':0x3e7,'khhadeva':0x959,'khhagurmukhi':0xa59,'khieukhacirclekorean':0x3278,'khieukhaparenkorean':0x3218,'khieukhcirclekorean':0x326a,'khieukhkorean':0x314b,'khieukhparenkorean':0x320a,'khokhaithai':0xe02,'khokhonthai':0xe05,'khokhuatthai':0xe03,'khokhwaithai':0xe04,'khomutthai':0xe5b,'khook':0x199,'khorakhangthai':0xe06,'khzsquare':0x3391,'kihiragana':0x304d,'kikatakana':0x30ad,'kikatakanahalfwidth':0xff77,'kiroguramusquare':0x3315,'kiromeetorusquare':0x3316,'kirosquare':0x3314,'kiyeokacirclekorean':0x326e,'kiyeokaparenkorean':0x320e,'kiyeokcirclekorean':0x3260,'kiyeokkorean':0x3131,'kiyeokparenkorean':0x3200,'kiyeoksioskorean':0x3133,'kjecyrillic':0x45c,'klinebelow':0x1e35,'klsquare':0x3398,'kmcubedsquare':0x33a6,'kmonospace':0xff4b,'kmsquaredsquare':0x33a2,'kohiragana':0x3053,'kohmsquare':0x33c0,'kokaithai':0xe01,'kokatakana':0x30b3,'kokatakanahalfwidth':0xff7a,'kooposquare':0x331e,'koppacyrillic':0x481,'koreanstandardsymbol':0x327f,'koroniscmb':0x343,'kparen':0x24a6,'kpasquare':0x33aa,'ksicyrillic':0x46f,'ktsquare':0x33cf,'kturned':0x29e,'kuhiragana':0x304f,'kukatakana':0x30af,'kukatakanahalfwidth':0xff78,'kvsquare':0x33b8,'kwsquare':0x33be,'l':0x6c,'labengali':0x9b2,'lacute':0x13a,'ladeva':0x932,'lagujarati':0xab2,'lagurmukhi':0xa32,'lakkhangyaothai':0xe45,'lamaleffinalarabic':0xfefc,'lamalefhamzaabovefinalarabic':0xfef8,'lamalefhamzaaboveisolatedarabic':0xfef7,'lamalefhamzabelowfinalarabic':0xfefa,'lamalefhamzabelowisolatedarabic':0xfef9,'lamalefisolatedarabic':0xfefb,'lamalefmaddaabovefinalarabic':0xfef6,'lamalefmaddaaboveisolatedarabic':0xfef5,'lamarabic':0x644,'lambda':0x3bb,'lambdastroke':0x19b,'lamed':0x5dc,'lameddagesh':0xfb3c,'lameddageshhebrew':0xfb3c,'lamedhebrew':0x5dc,'lamfinalarabic':0xfede,'lamhahinitialarabic':0xfcca,'laminitialarabic':0xfedf,'lamjeeminitialarabic':0xfcc9,'lamkhahinitialarabic':0xfccb,'lamlamhehisolatedarabic':0xfdf2,'lammedialarabic':0xfee0,'lammeemhahinitialarabic':0xfd88,'lammeeminitialarabic':0xfccc,'largecircle':0x25ef,'lbar':0x19a,'lbelt':0x26c,'lbopomofo':0x310c,'lcaron':0x13e,'lcedilla':0x13c,'lcircle':0x24db,'lcircumflexbelow':0x1e3d,'lcommaaccent':0x13c,'ldot':0x140,'ldotaccent':0x140,'ldotbelow':0x1e37,'ldotbelowmacron':0x1e39,'leftangleabovecmb':0x31a,'lefttackbelowcmb':0x318,'less':0x3c,'lessequal':0x2264,'lessequalorgreater':0x22da,'lessmonospace':0xff1c,'lessorequivalent':0x2272,'lessorgreater':0x2276,'lessoverequal':0x2266,'lesssmall':0xfe64,'lezh':0x26e,'lfblock':0x258c,'lhookretroflex':0x26d,'lira':0x20a4,'liwnarmenian':0x56c,'lj':0x1c9,'ljecyrillic':0x459,'ll':0xf6c0,'lladeva':0x933,'llagujarati':0xab3,'llinebelow':0x1e3b,'llladeva':0x934,'llvocalicbengali':0x9e1,'llvocalicdeva':0x961,'llvocalicvowelsignbengali':0x9e3,'llvocalicvowelsigndeva':0x963,'lmiddletilde':0x26b,'lmonospace':0xff4c,'lmsquare':0x33d0,'lochulathai':0xe2c,'logicaland':0x2227,'logicalnot':0xac,'logicalnotreversed':0x2310,'logicalor':0x2228,'lolingthai':0xe25,'longs':0x17f,'lowlinecenterline':0xfe4e,'lowlinecmb':0x332,'lowlinedashed':0xfe4d,'lozenge':0x25ca,'lparen':0x24a7,'lslash':0x142,'lsquare':0x2113,'lsuperior':0xf6ee,'ltshade':0x2591,'luthai':0xe26,'lvocalicbengali':0x98c,'lvocalicdeva':0x90c,'lvocalicvowelsignbengali':0x9e2,'lvocalicvowelsigndeva':0x962,'lxsquare':0x33d3,'m':0x6d,'mabengali':0x9ae,'macron':0xaf,'macronbelowcmb':0x331,'macroncmb':0x304,'macronlowmod':0x2cd,'macronmonospace':0xffe3,'macute':0x1e3f,'madeva':0x92e,'magujarati':0xaae,'magurmukhi':0xa2e,'mahapakhhebrew':0x5a4,'mahapakhlefthebrew':0x5a4,'mahiragana':0x307e,'maichattawalowleftthai':0xf895,'maichattawalowrightthai':0xf894,'maichattawathai':0xe4b,'maichattawaupperleftthai':0xf893,'maieklowleftthai':0xf88c,'maieklowrightthai':0xf88b,'maiekthai':0xe48,'maiekupperleftthai':0xf88a,'maihanakatleftthai':0xf884,'maihanakatthai':0xe31,'maitaikhuleftthai':0xf889,'maitaikhuthai':0xe47,'maitholowleftthai':0xf88f,'maitholowrightthai':0xf88e,'maithothai':0xe49,'maithoupperleftthai':0xf88d,'maitrilowleftthai':0xf892,'maitrilowrightthai':0xf891,'maitrithai':0xe4a,'maitriupperleftthai':0xf890,'maiyamokthai':0xe46,'makatakana':0x30de,'makatakanahalfwidth':0xff8f,'male':0x2642,'mansyonsquare':0x3347,'maqafhebrew':0x5be,'mars':0x2642,'masoracirclehebrew':0x5af,'masquare':0x3383,'mbopomofo':0x3107,'mbsquare':0x33d4,'mcircle':0x24dc,'mcubedsquare':0x33a5,'mdotaccent':0x1e41,'mdotbelow':0x1e43,'meemarabic':0x645,'meemfinalarabic':0xfee2,'meeminitialarabic':0xfee3,'meemmedialarabic':0xfee4,'meemmeeminitialarabic':0xfcd1,'meemmeemisolatedarabic':0xfc48,'meetorusquare':0x334d,'mehiragana':0x3081,'meizierasquare':0x337e,'mekatakana':0x30e1,'mekatakanahalfwidth':0xff92,'mem':0x5de,'memdagesh':0xfb3e,'memdageshhebrew':0xfb3e,'memhebrew':0x5de,'menarmenian':0x574,'merkhahebrew':0x5a5,'merkhakefulahebrew':0x5a6,'merkhakefulalefthebrew':0x5a6,'merkhalefthebrew':0x5a5,'mhook':0x271,'mhzsquare':0x3392,'middledotkatakanahalfwidth':0xff65,'middot':0xb7,'mieumacirclekorean':0x3272,'mieumaparenkorean':0x3212,'mieumcirclekorean':0x3264,'mieumkorean':0x3141,'mieumpansioskorean':0x3170,'mieumparenkorean':0x3204,'mieumpieupkorean':0x316e,'mieumsioskorean':0x316f,'mihiragana':0x307f,'mikatakana':0x30df,'mikatakanahalfwidth':0xff90,'minus':0x2212,'minusbelowcmb':0x320,'minuscircle':0x2296,'minusmod':0x2d7,'minusplus':0x2213,'minute':0x2032,'miribaarusquare':0x334a,'mirisquare':0x3349,'mlonglegturned':0x270,'mlsquare':0x3396,'mmcubedsquare':0x33a3,'mmonospace':0xff4d,'mmsquaredsquare':0x339f,'mohiragana':0x3082,'mohmsquare':0x33c1,'mokatakana':0x30e2,'mokatakanahalfwidth':0xff93,'molsquare':0x33d6,'momathai':0xe21,'moverssquare':0x33a7,'moverssquaredsquare':0x33a8,'mparen':0x24a8,'mpasquare':0x33ab,'mssquare':0x33b3,'msuperior':0xf6ef,'mturned':0x26f,'mu':0xb5,'mu1':0xb5,'muasquare':0x3382,'muchgreater':0x226b,'muchless':0x226a,'mufsquare':0x338c,'mugreek':0x3bc,'mugsquare':0x338d,'muhiragana':0x3080,'mukatakana':0x30e0,'mukatakanahalfwidth':0xff91,'mulsquare':0x3395,'multiply':0xd7,'mumsquare':0x339b,'munahhebrew':0x5a3,'munahlefthebrew':0x5a3,'musicalnote':0x266a,'musicalnotedbl':0x266b,'musicflatsign':0x266d,'musicsharpsign':0x266f,'mussquare':0x33b2,'muvsquare':0x33b6,'muwsquare':0x33bc,'mvmegasquare':0x33b9,'mvsquare':0x33b7,'mwmegasquare':0x33bf,'mwsquare':0x33bd,'n':0x6e,'nabengali':0x9a8,'nabla':0x2207,'nacute':0x144,'nadeva':0x928,'nagujarati':0xaa8,'nagurmukhi':0xa28,'nahiragana':0x306a,'nakatakana':0x30ca,'nakatakanahalfwidth':0xff85,'napostrophe':0x149,'nasquare':0x3381,'nbopomofo':0x310b,'nbspace':0xa0,'ncaron':0x148,'ncedilla':0x146,'ncircle':0x24dd,'ncircumflexbelow':0x1e4b,'ncommaaccent':0x146,'ndotaccent':0x1e45,'ndotbelow':0x1e47,'nehiragana':0x306d,'nekatakana':0x30cd,'nekatakanahalfwidth':0xff88,'newsheqelsign':0x20aa,'nfsquare':0x338b,'ngabengali':0x999,'ngadeva':0x919,'ngagujarati':0xa99,'ngagurmukhi':0xa19,'ngonguthai':0xe07,'nhiragana':0x3093,'nhookleft':0x272,'nhookretroflex':0x273,'nieunacirclekorean':0x326f,'nieunaparenkorean':0x320f,'nieuncieuckorean':0x3135,'nieuncirclekorean':0x3261,'nieunhieuhkorean':0x3136,'nieunkorean':0x3134,'nieunpansioskorean':0x3168,'nieunparenkorean':0x3201,'nieunsioskorean':0x3167,'nieuntikeutkorean':0x3166,'nihiragana':0x306b,'nikatakana':0x30cb,'nikatakanahalfwidth':0xff86,'nikhahitleftthai':0xf899,'nikhahitthai':0xe4d,'nine':0x39,'ninearabic':0x669,'ninebengali':0x9ef,'ninecircle':0x2468,'ninecircleinversesansserif':0x2792,'ninedeva':0x96f,'ninegujarati':0xaef,'ninegurmukhi':0xa6f,'ninehackarabic':0x669,'ninehangzhou':0x3029,'nineideographicparen':0x3228,'nineinferior':0x2089,'ninemonospace':0xff19,'nineoldstyle':0xf739,'nineparen':0x247c,'nineperiod':0x2490,'ninepersian':0x6f9,'nineroman':0x2178,'ninesuperior':0x2079,'nineteencircle':0x2472,'nineteenparen':0x2486,'nineteenperiod':0x249a,'ninethai':0xe59,'nj':0x1cc,'njecyrillic':0x45a,'nkatakana':0x30f3,'nkatakanahalfwidth':0xff9d,'nlegrightlong':0x19e,'nlinebelow':0x1e49,'nmonospace':0xff4e,'nmsquare':0x339a,'nnabengali':0x9a3,'nnadeva':0x923,'nnagujarati':0xaa3,'nnagurmukhi':0xa23,'nnnadeva':0x929,'nohiragana':0x306e,'nokatakana':0x30ce,'nokatakanahalfwidth':0xff89,'nonbreakingspace':0xa0,'nonenthai':0xe13,'nonuthai':0xe19,'noonarabic':0x646,'noonfinalarabic':0xfee6,'noonghunnaarabic':0x6ba,'noonghunnafinalarabic':0xfb9f,'nooninitialarabic':0xfee7,'noonjeeminitialarabic':0xfcd2,'noonjeemisolatedarabic':0xfc4b,'noonmedialarabic':0xfee8,'noonmeeminitialarabic':0xfcd5,'noonmeemisolatedarabic':0xfc4e,'noonnoonfinalarabic':0xfc8d,'notcontains':0x220c,'notelement':0x2209,'notelementof':0x2209,'notequal':0x2260,'notgreater':0x226f,'notgreaternorequal':0x2271,'notgreaternorless':0x2279,'notidentical':0x2262,'notless':0x226e,'notlessnorequal':0x2270,'notparallel':0x2226,'notprecedes':0x2280,'notsubset':0x2284,'notsucceeds':0x2281,'notsuperset':0x2285,'nowarmenian':0x576,'nparen':0x24a9,'nssquare':0x33b1,'nsuperior':0x207f,'ntilde':0xf1,'nu':0x3bd,'nuhiragana':0x306c,'nukatakana':0x30cc,'nukatakanahalfwidth':0xff87,'nuktabengali':0x9bc,'nuktadeva':0x93c,'nuktagujarati':0xabc,'nuktagurmukhi':0xa3c,'numbersign':0x23,'numbersignmonospace':0xff03,'numbersignsmall':0xfe5f,'numeralsigngreek':0x374,'numeralsignlowergreek':0x375,'numero':0x2116,'nun':0x5e0,'nundagesh':0xfb40,'nundageshhebrew':0xfb40,'nunhebrew':0x5e0,'nvsquare':0x33b5,'nwsquare':0x33bb,'nyabengali':0x99e,'nyadeva':0x91e,'nyagujarati':0xa9e,'nyagurmukhi':0xa1e,'o':0x6f,'oacute':0xf3,'oangthai':0xe2d,'obarred':0x275,'obarredcyrillic':0x4e9,'obarreddieresiscyrillic':0x4eb,'obengali':0x993,'obopomofo':0x311b,'obreve':0x14f,'ocandradeva':0x911,'ocandragujarati':0xa91,'ocandravowelsigndeva':0x949,'ocandravowelsigngujarati':0xac9,'ocaron':0x1d2,'ocircle':0x24de,'ocircumflex':0xf4,'ocircumflexacute':0x1ed1,'ocircumflexdotbelow':0x1ed9,'ocircumflexgrave':0x1ed3,'ocircumflexhookabove':0x1ed5,'ocircumflextilde':0x1ed7,'ocyrillic':0x43e,'odblacute':0x151,'odblgrave':0x20d,'odeva':0x913,'odieresis':0xf6,'odieresiscyrillic':0x4e7,'odotbelow':0x1ecd,'oe':0x153,'oekorean':0x315a,'ogonek':0x2db,'ogonekcmb':0x328,'ograve':0xf2,'ogujarati':0xa93,'oharmenian':0x585,'ohiragana':0x304a,'ohookabove':0x1ecf,'ohorn':0x1a1,'ohornacute':0x1edb,'ohorndotbelow':0x1ee3,'ohorngrave':0x1edd,'ohornhookabove':0x1edf,'ohorntilde':0x1ee1,'ohungarumlaut':0x151,'oi':0x1a3,'oinvertedbreve':0x20f,'okatakana':0x30aa,'okatakanahalfwidth':0xff75,'okorean':0x3157,'olehebrew':0x5ab,'omacron':0x14d,'omacronacute':0x1e53,'omacrongrave':0x1e51,'omdeva':0x950,'omega':0x3c9,'omega1':0x3d6,'omegacyrillic':0x461,'omegalatinclosed':0x277,'omegaroundcyrillic':0x47b,'omegatitlocyrillic':0x47d,'omegatonos':0x3ce,'omgujarati':0xad0,'omicron':0x3bf,'omicrontonos':0x3cc,'omonospace':0xff4f,'one':0x31,'onearabic':0x661,'onebengali':0x9e7,'onecircle':0x2460,'onecircleinversesansserif':0x278a,'onedeva':0x967,'onedotenleader':0x2024,'oneeighth':0x215b,'onefitted':0xf6dc,'onegujarati':0xae7,'onegurmukhi':0xa67,'onehackarabic':0x661,'onehalf':0xbd,'onehangzhou':0x3021,'oneideographicparen':0x3220,'oneinferior':0x2081,'onemonospace':0xff11,'onenumeratorbengali':0x9f4,'oneoldstyle':0xf731,'oneparen':0x2474,'oneperiod':0x2488,'onepersian':0x6f1,'onequarter':0xbc,'oneroman':0x2170,'onesuperior':0xb9,'onethai':0xe51,'onethird':0x2153,'oogonek':0x1eb,'oogonekmacron':0x1ed,'oogurmukhi':0xa13,'oomatragurmukhi':0xa4b,'oopen':0x254,'oparen':0x24aa,'openbullet':0x25e6,'option':0x2325,'ordfeminine':0xaa,'ordmasculine':0xba,'orthogonal':0x221f,'oshortdeva':0x912,'oshortvowelsigndeva':0x94a,'oslash':0xf8,'oslashacute':0x1ff,'osmallhiragana':0x3049,'osmallkatakana':0x30a9,'osmallkatakanahalfwidth':0xff6b,'ostrokeacute':0x1ff,'osuperior':0xf6f0,'otcyrillic':0x47f,'otilde':0xf5,'otildeacute':0x1e4d,'otildedieresis':0x1e4f,'oubopomofo':0x3121,'overline':0x203e,'overlinecenterline':0xfe4a,'overlinecmb':0x305,'overlinedashed':0xfe49,'overlinedblwavy':0xfe4c,'overlinewavy':0xfe4b,'overscore':0xaf,'ovowelsignbengali':0x9cb,'ovowelsigndeva':0x94b,'ovowelsigngujarati':0xacb,'p':0x70,'paampssquare':0x3380,'paasentosquare':0x332b,'pabengali':0x9aa,'pacute':0x1e55,'padeva':0x92a,'pagedown':0x21df,'pageup':0x21de,'pagujarati':0xaaa,'pagurmukhi':0xa2a,'pahiragana':0x3071,'paiyannoithai':0xe2f,'pakatakana':0x30d1,'palatalizationcyrilliccmb':0x484,'palochkacyrillic':0x4c0,'pansioskorean':0x317f,'paragraph':0xb6,'parallel':0x2225,'parenleft':0x28,'parenleftaltonearabic':0xfd3e,'parenleftbt':0xf8ed,'parenleftex':0xf8ec,'parenleftinferior':0x208d,'parenleftmonospace':0xff08,'parenleftsmall':0xfe59,'parenleftsuperior':0x207d,'parenlefttp':0xf8eb,'parenleftvertical':0xfe35,'parenright':0x29,'parenrightaltonearabic':0xfd3f,'parenrightbt':0xf8f8,'parenrightex':0xf8f7,'parenrightinferior':0x208e,'parenrightmonospace':0xff09,'parenrightsmall':0xfe5a,'parenrightsuperior':0x207e,'parenrighttp':0xf8f6,'parenrightvertical':0xfe36,'partialdiff':0x2202,'paseqhebrew':0x5c0,'pashtahebrew':0x599,'pasquare':0x33a9,'patah':0x5b7,'patah11':0x5b7,'patah1d':0x5b7,'patah2a':0x5b7,'patahhebrew':0x5b7,'patahnarrowhebrew':0x5b7,'patahquarterhebrew':0x5b7,'patahwidehebrew':0x5b7,'pazerhebrew':0x5a1,'pbopomofo':0x3106,'pcircle':0x24df,'pdotaccent':0x1e57,'pe':0x5e4,'pecyrillic':0x43f,'pedagesh':0xfb44,'pedageshhebrew':0xfb44,'peezisquare':0x333b,'pefinaldageshhebrew':0xfb43,'peharabic':0x67e,'peharmenian':0x57a,'pehebrew':0x5e4,'pehfinalarabic':0xfb57,'pehinitialarabic':0xfb58,'pehiragana':0x307a,'pehmedialarabic':0xfb59,'pekatakana':0x30da,'pemiddlehookcyrillic':0x4a7,'perafehebrew':0xfb4e,'percent':0x25,'percentarabic':0x66a,'percentmonospace':0xff05,'percentsmall':0xfe6a,'period':0x2e,'periodarmenian':0x589,'periodcentered':0xb7,'periodhalfwidth':0xff61,'periodinferior':0xf6e7,'periodmonospace':0xff0e,'periodsmall':0xfe52,'periodsuperior':0xf6e8,'perispomenigreekcmb':0x342,'perpendicular':0x22a5,'perthousand':0x2030,'peseta':0x20a7,'pfsquare':0x338a,'phabengali':0x9ab,'phadeva':0x92b,'phagujarati':0xaab,'phagurmukhi':0xa2b,'phi':0x3c6,'phi1':0x3d5,'phieuphacirclekorean':0x327a,'phieuphaparenkorean':0x321a,'phieuphcirclekorean':0x326c,'phieuphkorean':0x314d,'phieuphparenkorean':0x320c,'philatin':0x278,'phinthuthai':0xe3a,'phisymbolgreek':0x3d5,'phook':0x1a5,'phophanthai':0xe1e,'phophungthai':0xe1c,'phosamphaothai':0xe20,'pi':0x3c0,'pieupacirclekorean':0x3273,'pieupaparenkorean':0x3213,'pieupcieuckorean':0x3176,'pieupcirclekorean':0x3265,'pieupkiyeokkorean':0x3172,'pieupkorean':0x3142,'pieupparenkorean':0x3205,'pieupsioskiyeokkorean':0x3174,'pieupsioskorean':0x3144,'pieupsiostikeutkorean':0x3175,'pieupthieuthkorean':0x3177,'pieuptikeutkorean':0x3173,'pihiragana':0x3074,'pikatakana':0x30d4,'pisymbolgreek':0x3d6,'piwrarmenian':0x583,'plus':0x2b,'plusbelowcmb':0x31f,'pluscircle':0x2295,'plusminus':0xb1,'plusmod':0x2d6,'plusmonospace':0xff0b,'plussmall':0xfe62,'plussuperior':0x207a,'pmonospace':0xff50,'pmsquare':0x33d8,'pohiragana':0x307d,'pointingindexdownwhite':0x261f,'pointingindexleftwhite':0x261c,'pointingindexrightwhite':0x261e,'pointingindexupwhite':0x261d,'pokatakana':0x30dd,'poplathai':0xe1b,'postalmark':0x3012,'postalmarkface':0x3020,'pparen':0x24ab,'precedes':0x227a,'prescription':0x211e,'primemod':0x2b9,'primereversed':0x2035,'product':0x220f,'projective':0x2305,'prolongedkana':0x30fc,'propellor':0x2318,'propersubset':0x2282,'propersuperset':0x2283,'proportion':0x2237,'proportional':0x221d,'psi':0x3c8,'psicyrillic':0x471,'psilipneumatacyrilliccmb':0x486,'pssquare':0x33b0,'puhiragana':0x3077,'pukatakana':0x30d7,'pvsquare':0x33b4,'pwsquare':0x33ba,'q':0x71,'qadeva':0x958,'qadmahebrew':0x5a8,'qafarabic':0x642,'qaffinalarabic':0xfed6,'qafinitialarabic':0xfed7,'qafmedialarabic':0xfed8,'qamats':0x5b8,'qamats10':0x5b8,'qamats1a':0x5b8,'qamats1c':0x5b8,'qamats27':0x5b8,'qamats29':0x5b8,'qamats33':0x5b8,'qamatsde':0x5b8,'qamatshebrew':0x5b8,'qamatsnarrowhebrew':0x5b8,'qamatsqatanhebrew':0x5b8,'qamatsqatannarrowhebrew':0x5b8,'qamatsqatanquarterhebrew':0x5b8,'qamatsqatanwidehebrew':0x5b8,'qamatsquarterhebrew':0x5b8,'qamatswidehebrew':0x5b8,'qarneyparahebrew':0x59f,'qbopomofo':0x3111,'qcircle':0x24e0,'qhook':0x2a0,'qmonospace':0xff51,'qof':0x5e7,'qofdagesh':0xfb47,'qofdageshhebrew':0xfb47,'qofhebrew':0x5e7,'qparen':0x24ac,'quarternote':0x2669,'qubuts':0x5bb,'qubuts18':0x5bb,'qubuts25':0x5bb,'qubuts31':0x5bb,'qubutshebrew':0x5bb,'qubutsnarrowhebrew':0x5bb,'qubutsquarterhebrew':0x5bb,'qubutswidehebrew':0x5bb,'question':0x3f,'questionarabic':0x61f,'questionarmenian':0x55e,'questiondown':0xbf,'questiondownsmall':0xf7bf,'questiongreek':0x37e,'questionmonospace':0xff1f,'questionsmall':0xf73f,'quotedbl':0x22,'quotedblbase':0x201e,'quotedblleft':0x201c,'quotedblmonospace':0xff02,'quotedblprime':0x301e,'quotedblprimereversed':0x301d,'quotedblright':0x201d,'quoteleft':0x2018,'quoteleftreversed':0x201b,'quotereversed':0x201b,'quoteright':0x2019,'quoterightn':0x149,'quotesinglbase':0x201a,'quotesingle':0x27,'quotesinglemonospace':0xff07,'r':0x72,'raarmenian':0x57c,'rabengali':0x9b0,'racute':0x155,'radeva':0x930,'radical':0x221a,'radicalex':0xf8e5,'radoverssquare':0x33ae,'radoverssquaredsquare':0x33af,'radsquare':0x33ad,'rafe':0x5bf,'rafehebrew':0x5bf,'ragujarati':0xab0,'ragurmukhi':0xa30,'rahiragana':0x3089,'rakatakana':0x30e9,'rakatakanahalfwidth':0xff97,'ralowerdiagonalbengali':0x9f1,'ramiddlediagonalbengali':0x9f0,'ramshorn':0x264,'ratio':0x2236,'rbopomofo':0x3116,'rcaron':0x159,'rcedilla':0x157,'rcircle':0x24e1,'rcommaaccent':0x157,'rdblgrave':0x211,'rdotaccent':0x1e59,'rdotbelow':0x1e5b,'rdotbelowmacron':0x1e5d,'referencemark':0x203b,'reflexsubset':0x2286,'reflexsuperset':0x2287,'registered':0xae,'registersans':0xf8e8,'registerserif':0xf6da,'reharabic':0x631,'reharmenian':0x580,'rehfinalarabic':0xfeae,'rehiragana':0x308c,'rekatakana':0x30ec,'rekatakanahalfwidth':0xff9a,'resh':0x5e8,'reshdageshhebrew':0xfb48,'reshhebrew':0x5e8,'reversedtilde':0x223d,'reviahebrew':0x597,'reviamugrashhebrew':0x597,'revlogicalnot':0x2310,'rfishhook':0x27e,'rfishhookreversed':0x27f,'rhabengali':0x9dd,'rhadeva':0x95d,'rho':0x3c1,'rhook':0x27d,'rhookturned':0x27b,'rhookturnedsuperior':0x2b5,'rhosymbolgreek':0x3f1,'rhotichookmod':0x2de,'rieulacirclekorean':0x3271,'rieulaparenkorean':0x3211,'rieulcirclekorean':0x3263,'rieulhieuhkorean':0x3140,'rieulkiyeokkorean':0x313a,'rieulkiyeoksioskorean':0x3169,'rieulkorean':0x3139,'rieulmieumkorean':0x313b,'rieulpansioskorean':0x316c,'rieulparenkorean':0x3203,'rieulphieuphkorean':0x313f,'rieulpieupkorean':0x313c,'rieulpieupsioskorean':0x316b,'rieulsioskorean':0x313d,'rieulthieuthkorean':0x313e,'rieultikeutkorean':0x316a,'rieulyeorinhieuhkorean':0x316d,'rightangle':0x221f,'righttackbelowcmb':0x319,'righttriangle':0x22bf,'rihiragana':0x308a,'rikatakana':0x30ea,'rikatakanahalfwidth':0xff98,'ring':0x2da,'ringbelowcmb':0x325,'ringcmb':0x30a,'ringhalfleft':0x2bf,'ringhalfleftarmenian':0x559,'ringhalfleftbelowcmb':0x31c,'ringhalfleftcentered':0x2d3,'ringhalfright':0x2be,'ringhalfrightbelowcmb':0x339,'ringhalfrightcentered':0x2d2,'rinvertedbreve':0x213,'rittorusquare':0x3351,'rlinebelow':0x1e5f,'rlongleg':0x27c,'rlonglegturned':0x27a,'rmonospace':0xff52,'rohiragana':0x308d,'rokatakana':0x30ed,'rokatakanahalfwidth':0xff9b,'roruathai':0xe23,'rparen':0x24ad,'rrabengali':0x9dc,'rradeva':0x931,'rragurmukhi':0xa5c,'rreharabic':0x691,'rrehfinalarabic':0xfb8d,'rrvocalicbengali':0x9e0,'rrvocalicdeva':0x960,'rrvocalicgujarati':0xae0,'rrvocalicvowelsignbengali':0x9c4,'rrvocalicvowelsigndeva':0x944,'rrvocalicvowelsigngujarati':0xac4,'rsuperior':0xf6f1,'rtblock':0x2590,'rturned':0x279,'rturnedsuperior':0x2b4,'ruhiragana':0x308b,'rukatakana':0x30eb,'rukatakanahalfwidth':0xff99,'rupeemarkbengali':0x9f2,'rupeesignbengali':0x9f3,'rupiah':0xf6dd,'ruthai':0xe24,'rvocalicbengali':0x98b,'rvocalicdeva':0x90b,'rvocalicgujarati':0xa8b,'rvocalicvowelsignbengali':0x9c3,'rvocalicvowelsigndeva':0x943,'rvocalicvowelsigngujarati':0xac3,'s':0x73,'sabengali':0x9b8,'sacute':0x15b,'sacutedotaccent':0x1e65,'sadarabic':0x635,'sadeva':0x938,'sadfinalarabic':0xfeba,'sadinitialarabic':0xfebb,'sadmedialarabic':0xfebc,'sagujarati':0xab8,'sagurmukhi':0xa38,'sahiragana':0x3055,'sakatakana':0x30b5,'sakatakanahalfwidth':0xff7b,'sallallahoualayhewasallamarabic':0xfdfa,'samekh':0x5e1,'samekhdagesh':0xfb41,'samekhdageshhebrew':0xfb41,'samekhhebrew':0x5e1,'saraaathai':0xe32,'saraaethai':0xe41,'saraaimaimalaithai':0xe44,'saraaimaimuanthai':0xe43,'saraamthai':0xe33,'saraathai':0xe30,'saraethai':0xe40,'saraiileftthai':0xf886,'saraiithai':0xe35,'saraileftthai':0xf885,'saraithai':0xe34,'saraothai':0xe42,'saraueeleftthai':0xf888,'saraueethai':0xe37,'saraueleftthai':0xf887,'sarauethai':0xe36,'sarauthai':0xe38,'sarauuthai':0xe39,'sbopomofo':0x3119,'scaron':0x161,'scarondotaccent':0x1e67,'scedilla':0x15f,'schwa':0x259,'schwacyrillic':0x4d9,'schwadieresiscyrillic':0x4db,'schwahook':0x25a,'scircle':0x24e2,'scircumflex':0x15d,'scommaaccent':0x219,'sdotaccent':0x1e61,'sdotbelow':0x1e63,'sdotbelowdotaccent':0x1e69,'seagullbelowcmb':0x33c,'second':0x2033,'secondtonechinese':0x2ca,'section':0xa7,'seenarabic':0x633,'seenfinalarabic':0xfeb2,'seeninitialarabic':0xfeb3,'seenmedialarabic':0xfeb4,'segol':0x5b6,'segol13':0x5b6,'segol1f':0x5b6,'segol2c':0x5b6,'segolhebrew':0x5b6,'segolnarrowhebrew':0x5b6,'segolquarterhebrew':0x5b6,'segoltahebrew':0x592,'segolwidehebrew':0x5b6,'seharmenian':0x57d,'sehiragana':0x305b,'sekatakana':0x30bb,'sekatakanahalfwidth':0xff7e,'semicolon':0x3b,'semicolonarabic':0x61b,'semicolonmonospace':0xff1b,'semicolonsmall':0xfe54,'semivoicedmarkkana':0x309c,'semivoicedmarkkanahalfwidth':0xff9f,'sentisquare':0x3322,'sentosquare':0x3323,'seven':0x37,'sevenarabic':0x667,'sevenbengali':0x9ed,'sevencircle':0x2466,'sevencircleinversesansserif':0x2790,'sevendeva':0x96d,'seveneighths':0x215e,'sevengujarati':0xaed,'sevengurmukhi':0xa6d,'sevenhackarabic':0x667,'sevenhangzhou':0x3027,'sevenideographicparen':0x3226,'seveninferior':0x2087,'sevenmonospace':0xff17,'sevenoldstyle':0xf737,'sevenparen':0x247a,'sevenperiod':0x248e,'sevenpersian':0x6f7,'sevenroman':0x2176,'sevensuperior':0x2077,'seventeencircle':0x2470,'seventeenparen':0x2484,'seventeenperiod':0x2498,'seventhai':0xe57,'sfthyphen':0xad,'shaarmenian':0x577,'shabengali':0x9b6,'shacyrillic':0x448,'shaddaarabic':0x651,'shaddadammaarabic':0xfc61,'shaddadammatanarabic':0xfc5e,'shaddafathaarabic':0xfc60,'shaddakasraarabic':0xfc62,'shaddakasratanarabic':0xfc5f,'shade':0x2592,'shadedark':0x2593,'shadelight':0x2591,'shademedium':0x2592,'shadeva':0x936,'shagujarati':0xab6,'shagurmukhi':0xa36,'shalshelethebrew':0x593,'shbopomofo':0x3115,'shchacyrillic':0x449,'sheenarabic':0x634,'sheenfinalarabic':0xfeb6,'sheeninitialarabic':0xfeb7,'sheenmedialarabic':0xfeb8,'sheicoptic':0x3e3,'sheqel':0x20aa,'sheqelhebrew':0x20aa,'sheva':0x5b0,'sheva115':0x5b0,'sheva15':0x5b0,'sheva22':0x5b0,'sheva2e':0x5b0,'shevahebrew':0x5b0,'shevanarrowhebrew':0x5b0,'shevaquarterhebrew':0x5b0,'shevawidehebrew':0x5b0,'shhacyrillic':0x4bb,'shimacoptic':0x3ed,'shin':0x5e9,'shindagesh':0xfb49,'shindageshhebrew':0xfb49,'shindageshshindot':0xfb2c,'shindageshshindothebrew':0xfb2c,'shindageshsindot':0xfb2d,'shindageshsindothebrew':0xfb2d,'shindothebrew':0x5c1,'shinhebrew':0x5e9,'shinshindot':0xfb2a,'shinshindothebrew':0xfb2a,'shinsindot':0xfb2b,'shinsindothebrew':0xfb2b,'shook':0x282,'sigma':0x3c3,'sigma1':0x3c2,'sigmafinal':0x3c2,'sigmalunatesymbolgreek':0x3f2,'sihiragana':0x3057,'sikatakana':0x30b7,'sikatakanahalfwidth':0xff7c,'siluqhebrew':0x5bd,'siluqlefthebrew':0x5bd,'similar':0x223c,'sindothebrew':0x5c2,'siosacirclekorean':0x3274,'siosaparenkorean':0x3214,'sioscieuckorean':0x317e,'sioscirclekorean':0x3266,'sioskiyeokkorean':0x317a,'sioskorean':0x3145,'siosnieunkorean':0x317b,'siosparenkorean':0x3206,'siospieupkorean':0x317d,'siostikeutkorean':0x317c,'six':0x36,'sixarabic':0x666,'sixbengali':0x9ec,'sixcircle':0x2465,'sixcircleinversesansserif':0x278f,'sixdeva':0x96c,'sixgujarati':0xaec,'sixgurmukhi':0xa6c,'sixhackarabic':0x666,'sixhangzhou':0x3026,'sixideographicparen':0x3225,'sixinferior':0x2086,'sixmonospace':0xff16,'sixoldstyle':0xf736,'sixparen':0x2479,'sixperiod':0x248d,'sixpersian':0x6f6,'sixroman':0x2175,'sixsuperior':0x2076,'sixteencircle':0x246f,'sixteencurrencydenominatorbengali':0x9f9,'sixteenparen':0x2483,'sixteenperiod':0x2497,'sixthai':0xe56,'slash':0x2f,'slashmonospace':0xff0f,'slong':0x17f,'slongdotaccent':0x1e9b,'smileface':0x263a,'smonospace':0xff53,'sofpasuqhebrew':0x5c3,'softhyphen':0xad,'softsigncyrillic':0x44c,'sohiragana':0x305d,'sokatakana':0x30bd,'sokatakanahalfwidth':0xff7f,'soliduslongoverlaycmb':0x338,'solidusshortoverlaycmb':0x337,'sorusithai':0xe29,'sosalathai':0xe28,'sosothai':0xe0b,'sosuathai':0xe2a,'space':0x20,'spacehackarabic':0x20,'spade':0x2660,'spadesuitblack':0x2660,'spadesuitwhite':0x2664,'sparen':0x24ae,'squarebelowcmb':0x33b,'squarecc':0x33c4,'squarecm':0x339d,'squarediagonalcrosshatchfill':0x25a9,'squarehorizontalfill':0x25a4,'squarekg':0x338f,'squarekm':0x339e,'squarekmcapital':0x33ce,'squareln':0x33d1,'squarelog':0x33d2,'squaremg':0x338e,'squaremil':0x33d5,'squaremm':0x339c,'squaremsquared':0x33a1,'squareorthogonalcrosshatchfill':0x25a6,'squareupperlefttolowerrightfill':0x25a7,'squareupperrighttolowerleftfill':0x25a8,'squareverticalfill':0x25a5,'squarewhitewithsmallblack':0x25a3,'srsquare':0x33db,'ssabengali':0x9b7,'ssadeva':0x937,'ssagujarati':0xab7,'ssangcieuckorean':0x3149,'ssanghieuhkorean':0x3185,'ssangieungkorean':0x3180,'ssangkiyeokkorean':0x3132,'ssangnieunkorean':0x3165,'ssangpieupkorean':0x3143,'ssangsioskorean':0x3146,'ssangtikeutkorean':0x3138,'ssuperior':0xf6f2,'sterling':0xa3,'sterlingmonospace':0xffe1,'strokelongoverlaycmb':0x336,'strokeshortoverlaycmb':0x335,'subset':0x2282,'subsetnotequal':0x228a,'subsetorequal':0x2286,'succeeds':0x227b,'suchthat':0x220b,'suhiragana':0x3059,'sukatakana':0x30b9,'sukatakanahalfwidth':0xff7d,'sukunarabic':0x652,'summation':0x2211,'sun':0x263c,'superset':0x2283,'supersetnotequal':0x228b,'supersetorequal':0x2287,'svsquare':0x33dc,'syouwaerasquare':0x337c,'t':0x74,'tabengali':0x9a4,'tackdown':0x22a4,'tackleft':0x22a3,'tadeva':0x924,'tagujarati':0xaa4,'tagurmukhi':0xa24,'taharabic':0x637,'tahfinalarabic':0xfec2,'tahinitialarabic':0xfec3,'tahiragana':0x305f,'tahmedialarabic':0xfec4,'taisyouerasquare':0x337d,'takatakana':0x30bf,'takatakanahalfwidth':0xff80,'tatweelarabic':0x640,'tau':0x3c4,'tav':0x5ea,'tavdages':0xfb4a,'tavdagesh':0xfb4a,'tavdageshhebrew':0xfb4a,'tavhebrew':0x5ea,'tbar':0x167,'tbopomofo':0x310a,'tcaron':0x165,'tccurl':0x2a8,'tcedilla':0x163,'tcheharabic':0x686,'tchehfinalarabic':0xfb7b,'tchehinitialarabic':0xfb7c,'tchehmedialarabic':0xfb7d,'tcircle':0x24e3,'tcircumflexbelow':0x1e71,'tcommaaccent':0x163,'tdieresis':0x1e97,'tdotaccent':0x1e6b,'tdotbelow':0x1e6d,'tecyrillic':0x442,'tedescendercyrillic':0x4ad,'teharabic':0x62a,'tehfinalarabic':0xfe96,'tehhahinitialarabic':0xfca2,'tehhahisolatedarabic':0xfc0c,'tehinitialarabic':0xfe97,'tehiragana':0x3066,'tehjeeminitialarabic':0xfca1,'tehjeemisolatedarabic':0xfc0b,'tehmarbutaarabic':0x629,'tehmarbutafinalarabic':0xfe94,'tehmedialarabic':0xfe98,'tehmeeminitialarabic':0xfca4,'tehmeemisolatedarabic':0xfc0e,'tehnoonfinalarabic':0xfc73,'tekatakana':0x30c6,'tekatakanahalfwidth':0xff83,'telephone':0x2121,'telephoneblack':0x260e,'telishagedolahebrew':0x5a0,'telishaqetanahebrew':0x5a9,'tencircle':0x2469,'tenideographicparen':0x3229,'tenparen':0x247d,'tenperiod':0x2491,'tenroman':0x2179,'tesh':0x2a7,'tet':0x5d8,'tetdagesh':0xfb38,'tetdageshhebrew':0xfb38,'tethebrew':0x5d8,'tetsecyrillic':0x4b5,'tevirhebrew':0x59b,'tevirlefthebrew':0x59b,'thabengali':0x9a5,'thadeva':0x925,'thagujarati':0xaa5,'thagurmukhi':0xa25,'thalarabic':0x630,'thalfinalarabic':0xfeac,'thanthakhatlowleftthai':0xf898,'thanthakhatlowrightthai':0xf897,'thanthakhatthai':0xe4c,'thanthakhatupperleftthai':0xf896,'theharabic':0x62b,'thehfinalarabic':0xfe9a,'thehinitialarabic':0xfe9b,'thehmedialarabic':0xfe9c,'thereexists':0x2203,'therefore':0x2234,'theta':0x3b8,'theta1':0x3d1,'thetasymbolgreek':0x3d1,'thieuthacirclekorean':0x3279,'thieuthaparenkorean':0x3219,'thieuthcirclekorean':0x326b,'thieuthkorean':0x314c,'thieuthparenkorean':0x320b,'thirteencircle':0x246c,'thirteenparen':0x2480,'thirteenperiod':0x2494,'thonangmonthothai':0xe11,'thook':0x1ad,'thophuthaothai':0xe12,'thorn':0xfe,'thothahanthai':0xe17,'thothanthai':0xe10,'thothongthai':0xe18,'thothungthai':0xe16,'thousandcyrillic':0x482,'thousandsseparatorarabic':0x66c,'thousandsseparatorpersian':0x66c,'three':0x33,'threearabic':0x663,'threebengali':0x9e9,'threecircle':0x2462,'threecircleinversesansserif':0x278c,'threedeva':0x969,'threeeighths':0x215c,'threegujarati':0xae9,'threegurmukhi':0xa69,'threehackarabic':0x663,'threehangzhou':0x3023,'threeideographicparen':0x3222,'threeinferior':0x2083,'threemonospace':0xff13,'threenumeratorbengali':0x9f6,'threeoldstyle':0xf733,'threeparen':0x2476,'threeperiod':0x248a,'threepersian':0x6f3,'threequarters':0xbe,'threequartersemdash':0xf6de,'threeroman':0x2172,'threesuperior':0xb3,'threethai':0xe53,'thzsquare':0x3394,'tihiragana':0x3061,'tikatakana':0x30c1,'tikatakanahalfwidth':0xff81,'tikeutacirclekorean':0x3270,'tikeutaparenkorean':0x3210,'tikeutcirclekorean':0x3262,'tikeutkorean':0x3137,'tikeutparenkorean':0x3202,'tilde':0x2dc,'tildebelowcmb':0x330,'tildecmb':0x303,'tildecomb':0x303,'tildedoublecmb':0x360,'tildeoperator':0x223c,'tildeoverlaycmb':0x334,'tildeverticalcmb':0x33e,'timescircle':0x2297,'tipehahebrew':0x596,'tipehalefthebrew':0x596,'tippigurmukhi':0xa70,'titlocyrilliccmb':0x483,'tiwnarmenian':0x57f,'tlinebelow':0x1e6f,'tmonospace':0xff54,'toarmenian':0x569,'tohiragana':0x3068,'tokatakana':0x30c8,'tokatakanahalfwidth':0xff84,'tonebarextrahighmod':0x2e5,'tonebarextralowmod':0x2e9,'tonebarhighmod':0x2e6,'tonebarlowmod':0x2e8,'tonebarmidmod':0x2e7,'tonefive':0x1bd,'tonesix':0x185,'tonetwo':0x1a8,'tonos':0x384,'tonsquare':0x3327,'topatakthai':0xe0f,'tortoiseshellbracketleft':0x3014,'tortoiseshellbracketleftsmall':0xfe5d,'tortoiseshellbracketleftvertical':0xfe39,'tortoiseshellbracketright':0x3015,'tortoiseshellbracketrightsmall':0xfe5e,'tortoiseshellbracketrightvertical':0xfe3a,'totaothai':0xe15,'tpalatalhook':0x1ab,'tparen':0x24af,'trademark':0x2122,'trademarksans':0xf8ea,'trademarkserif':0xf6db,'tretroflexhook':0x288,'triagdn':0x25bc,'triaglf':0x25c4,'triagrt':0x25ba,'triagup':0x25b2,'ts':0x2a6,'tsadi':0x5e6,'tsadidagesh':0xfb46,'tsadidageshhebrew':0xfb46,'tsadihebrew':0x5e6,'tsecyrillic':0x446,'tsere':0x5b5,'tsere12':0x5b5,'tsere1e':0x5b5,'tsere2b':0x5b5,'tserehebrew':0x5b5,'tserenarrowhebrew':0x5b5,'tserequarterhebrew':0x5b5,'tserewidehebrew':0x5b5,'tshecyrillic':0x45b,'tsuperior':0xf6f3,'ttabengali':0x99f,'ttadeva':0x91f,'ttagujarati':0xa9f,'ttagurmukhi':0xa1f,'tteharabic':0x679,'ttehfinalarabic':0xfb67,'ttehinitialarabic':0xfb68,'ttehmedialarabic':0xfb69,'tthabengali':0x9a0,'tthadeva':0x920,'tthagujarati':0xaa0,'tthagurmukhi':0xa20,'tturned':0x287,'tuhiragana':0x3064,'tukatakana':0x30c4,'tukatakanahalfwidth':0xff82,'tusmallhiragana':0x3063,'tusmallkatakana':0x30c3,'tusmallkatakanahalfwidth':0xff6f,'twelvecircle':0x246b,'twelveparen':0x247f,'twelveperiod':0x2493,'twelveroman':0x217b,'twentycircle':0x2473,'twentyhangzhou':0x5344,'twentyparen':0x2487,'twentyperiod':0x249b,'two':0x32,'twoarabic':0x662,'twobengali':0x9e8,'twocircle':0x2461,'twocircleinversesansserif':0x278b,'twodeva':0x968,'twodotenleader':0x2025,'twodotleader':0x2025,'twodotleadervertical':0xfe30,'twogujarati':0xae8,'twogurmukhi':0xa68,'twohackarabic':0x662,'twohangzhou':0x3022,'twoideographicparen':0x3221,'twoinferior':0x2082,'twomonospace':0xff12,'twonumeratorbengali':0x9f5,'twooldstyle':0xf732,'twoparen':0x2475,'twoperiod':0x2489,'twopersian':0x6f2,'tworoman':0x2171,'twostroke':0x1bb,'twosuperior':0xb2,'twothai':0xe52,'twothirds':0x2154,'u':0x75,'uacute':0xfa,'ubar':0x289,'ubengali':0x989,'ubopomofo':0x3128,'ubreve':0x16d,'ucaron':0x1d4,'ucircle':0x24e4,'ucircumflex':0xfb,'ucircumflexbelow':0x1e77,'ucyrillic':0x443,'udattadeva':0x951,'udblacute':0x171,'udblgrave':0x215,'udeva':0x909,'udieresis':0xfc,'udieresisacute':0x1d8,'udieresisbelow':0x1e73,'udieresiscaron':0x1da,'udieresiscyrillic':0x4f1,'udieresisgrave':0x1dc,'udieresismacron':0x1d6,'udotbelow':0x1ee5,'ugrave':0xf9,'ugujarati':0xa89,'ugurmukhi':0xa09,'uhiragana':0x3046,'uhookabove':0x1ee7,'uhorn':0x1b0,'uhornacute':0x1ee9,'uhorndotbelow':0x1ef1,'uhorngrave':0x1eeb,'uhornhookabove':0x1eed,'uhorntilde':0x1eef,'uhungarumlaut':0x171,'uhungarumlautcyrillic':0x4f3,'uinvertedbreve':0x217,'ukatakana':0x30a6,'ukatakanahalfwidth':0xff73,'ukcyrillic':0x479,'ukorean':0x315c,'umacron':0x16b,'umacroncyrillic':0x4ef,'umacrondieresis':0x1e7b,'umatragurmukhi':0xa41,'umonospace':0xff55,'underscore':0x5f,'underscoredbl':0x2017,'underscoremonospace':0xff3f,'underscorevertical':0xfe33,'underscorewavy':0xfe4f,'union':0x222a,'universal':0x2200,'uogonek':0x173,'uparen':0x24b0,'upblock':0x2580,'upperdothebrew':0x5c4,'upsilon':0x3c5,'upsilondieresis':0x3cb,'upsilondieresistonos':0x3b0,'upsilonlatin':0x28a,'upsilontonos':0x3cd,'uptackbelowcmb':0x31d,'uptackmod':0x2d4,'uragurmukhi':0xa73,'uring':0x16f,'ushortcyrillic':0x45e,'usmallhiragana':0x3045,'usmallkatakana':0x30a5,'usmallkatakanahalfwidth':0xff69,'ustraightcyrillic':0x4af,'ustraightstrokecyrillic':0x4b1,'utilde':0x169,'utildeacute':0x1e79,'utildebelow':0x1e75,'uubengali':0x98a,'uudeva':0x90a,'uugujarati':0xa8a,'uugurmukhi':0xa0a,'uumatragurmukhi':0xa42,'uuvowelsignbengali':0x9c2,'uuvowelsigndeva':0x942,'uuvowelsigngujarati':0xac2,'uvowelsignbengali':0x9c1,'uvowelsigndeva':0x941,'uvowelsigngujarati':0xac1,'v':0x76,'vadeva':0x935,'vagujarati':0xab5,'vagurmukhi':0xa35,'vakatakana':0x30f7,'vav':0x5d5,'vavdagesh':0xfb35,'vavdagesh65':0xfb35,'vavdageshhebrew':0xfb35,'vavhebrew':0x5d5,'vavholam':0xfb4b,'vavholamhebrew':0xfb4b,'vavvavhebrew':0x5f0,'vavyodhebrew':0x5f1,'vcircle':0x24e5,'vdotbelow':0x1e7f,'vecyrillic':0x432,'veharabic':0x6a4,'vehfinalarabic':0xfb6b,'vehinitialarabic':0xfb6c,'vehmedialarabic':0xfb6d,'vekatakana':0x30f9,'venus':0x2640,'verticalbar':0x7c,'verticallineabovecmb':0x30d,'verticallinebelowcmb':0x329,'verticallinelowmod':0x2cc,'verticallinemod':0x2c8,'vewarmenian':0x57e,'vhook':0x28b,'vikatakana':0x30f8,'viramabengali':0x9cd,'viramadeva':0x94d,'viramagujarati':0xacd,'visargabengali':0x983,'visargadeva':0x903,'visargagujarati':0xa83,'vmonospace':0xff56,'voarmenian':0x578,'voicediterationhiragana':0x309e,'voicediterationkatakana':0x30fe,'voicedmarkkana':0x309b,'voicedmarkkanahalfwidth':0xff9e,'vokatakana':0x30fa,'vparen':0x24b1,'vtilde':0x1e7d,'vturned':0x28c,'vuhiragana':0x3094,'vukatakana':0x30f4,'w':0x77,'wacute':0x1e83,'waekorean':0x3159,'wahiragana':0x308f,'wakatakana':0x30ef,'wakatakanahalfwidth':0xff9c,'wakorean':0x3158,'wasmallhiragana':0x308e,'wasmallkatakana':0x30ee,'wattosquare':0x3357,'wavedash':0x301c,'wavyunderscorevertical':0xfe34,'wawarabic':0x648,'wawfinalarabic':0xfeee,'wawhamzaabovearabic':0x624,'wawhamzaabovefinalarabic':0xfe86,'wbsquare':0x33dd,'wcircle':0x24e6,'wcircumflex':0x175,'wdieresis':0x1e85,'wdotaccent':0x1e87,'wdotbelow':0x1e89,'wehiragana':0x3091,'weierstrass':0x2118,'wekatakana':0x30f1,'wekorean':0x315e,'weokorean':0x315d,'wgrave':0x1e81,'whitebullet':0x25e6,'whitecircle':0x25cb,'whitecircleinverse':0x25d9,'whitecornerbracketleft':0x300e,'whitecornerbracketleftvertical':0xfe43,'whitecornerbracketright':0x300f,'whitecornerbracketrightvertical':0xfe44,'whitediamond':0x25c7,'whitediamondcontainingblacksmalldiamond':0x25c8,'whitedownpointingsmalltriangle':0x25bf,'whitedownpointingtriangle':0x25bd,'whiteleftpointingsmalltriangle':0x25c3,'whiteleftpointingtriangle':0x25c1,'whitelenticularbracketleft':0x3016,'whitelenticularbracketright':0x3017,'whiterightpointingsmalltriangle':0x25b9,'whiterightpointingtriangle':0x25b7,'whitesmallsquare':0x25ab,'whitesmilingface':0x263a,'whitesquare':0x25a1,'whitestar':0x2606,'whitetelephone':0x260f,'whitetortoiseshellbracketleft':0x3018,'whitetortoiseshellbracketright':0x3019,'whiteuppointingsmalltriangle':0x25b5,'whiteuppointingtriangle':0x25b3,'wihiragana':0x3090,'wikatakana':0x30f0,'wikorean':0x315f,'wmonospace':0xff57,'wohiragana':0x3092,'wokatakana':0x30f2,'wokatakanahalfwidth':0xff66,'won':0x20a9,'wonmonospace':0xffe6,'wowaenthai':0xe27,'wparen':0x24b2,'wring':0x1e98,'wsuperior':0x2b7,'wturned':0x28d,'wynn':0x1bf,'x':0x78,'xabovecmb':0x33d,'xbopomofo':0x3112,'xcircle':0x24e7,'xdieresis':0x1e8d,'xdotaccent':0x1e8b,'xeharmenian':0x56d,'xi':0x3be,'xmonospace':0xff58,'xparen':0x24b3,'xsuperior':0x2e3,'y':0x79,'yaadosquare':0x334e,'yabengali':0x9af,'yacute':0xfd,'yadeva':0x92f,'yaekorean':0x3152,'yagujarati':0xaaf,'yagurmukhi':0xa2f,'yahiragana':0x3084,'yakatakana':0x30e4,'yakatakanahalfwidth':0xff94,'yakorean':0x3151,'yamakkanthai':0xe4e,'yasmallhiragana':0x3083,'yasmallkatakana':0x30e3,'yasmallkatakanahalfwidth':0xff6c,'yatcyrillic':0x463,'ycircle':0x24e8,'ycircumflex':0x177,'ydieresis':0xff,'ydotaccent':0x1e8f,'ydotbelow':0x1ef5,'yeharabic':0x64a,'yehbarreearabic':0x6d2,'yehbarreefinalarabic':0xfbaf,'yehfinalarabic':0xfef2,'yehhamzaabovearabic':0x626,'yehhamzaabovefinalarabic':0xfe8a,'yehhamzaaboveinitialarabic':0xfe8b,'yehhamzaabovemedialarabic':0xfe8c,'yehinitialarabic':0xfef3,'yehmedialarabic':0xfef4,'yehmeeminitialarabic':0xfcdd,'yehmeemisolatedarabic':0xfc58,'yehnoonfinalarabic':0xfc94,'yehthreedotsbelowarabic':0x6d1,'yekorean':0x3156,'yen':0xa5,'yenmonospace':0xffe5,'yeokorean':0x3155,'yeorinhieuhkorean':0x3186,'yerahbenyomohebrew':0x5aa,'yerahbenyomolefthebrew':0x5aa,'yericyrillic':0x44b,'yerudieresiscyrillic':0x4f9,'yesieungkorean':0x3181,'yesieungpansioskorean':0x3183,'yesieungsioskorean':0x3182,'yetivhebrew':0x59a,'ygrave':0x1ef3,'yhook':0x1b4,'yhookabove':0x1ef7,'yiarmenian':0x575,'yicyrillic':0x457,'yikorean':0x3162,'yinyang':0x262f,'yiwnarmenian':0x582,'ymonospace':0xff59,'yod':0x5d9,'yoddagesh':0xfb39,'yoddageshhebrew':0xfb39,'yodhebrew':0x5d9,'yodyodhebrew':0x5f2,'yodyodpatahhebrew':0xfb1f,'yohiragana':0x3088,'yoikorean':0x3189,'yokatakana':0x30e8,'yokatakanahalfwidth':0xff96,'yokorean':0x315b,'yosmallhiragana':0x3087,'yosmallkatakana':0x30e7,'yosmallkatakanahalfwidth':0xff6e,'yotgreek':0x3f3,'yoyaekorean':0x3188,'yoyakorean':0x3187,'yoyakthai':0xe22,'yoyingthai':0xe0d,'yparen':0x24b4,'ypogegrammeni':0x37a,'ypogegrammenigreekcmb':0x345,'yr':0x1a6,'yring':0x1e99,'ysuperior':0x2b8,'ytilde':0x1ef9,'yturned':0x28e,'yuhiragana':0x3086,'yuikorean':0x318c,'yukatakana':0x30e6,'yukatakanahalfwidth':0xff95,'yukorean':0x3160,'yusbigcyrillic':0x46b,'yusbigiotifiedcyrillic':0x46d,'yuslittlecyrillic':0x467,'yuslittleiotifiedcyrillic':0x469,'yusmallhiragana':0x3085,'yusmallkatakana':0x30e5,'yusmallkatakanahalfwidth':0xff6d,'yuyekorean':0x318b,'yuyeokorean':0x318a,'yyabengali':0x9df,'yyadeva':0x95f,'z':0x7a,'zaarmenian':0x566,'zacute':0x17a,'zadeva':0x95b,'zagurmukhi':0xa5b,'zaharabic':0x638,'zahfinalarabic':0xfec6,'zahinitialarabic':0xfec7,'zahiragana':0x3056,'zahmedialarabic':0xfec8,'zainarabic':0x632,'zainfinalarabic':0xfeb0,'zakatakana':0x30b6,'zaqefgadolhebrew':0x595,'zaqefqatanhebrew':0x594,'zarqahebrew':0x598,'zayin':0x5d6,'zayindagesh':0xfb36,'zayindageshhebrew':0xfb36,'zayinhebrew':0x5d6,'zbopomofo':0x3117,'zcaron':0x17e,'zcircle':0x24e9,'zcircumflex':0x1e91,'zcurl':0x291,'zdot':0x17c,'zdotaccent':0x17c,'zdotbelow':0x1e93,'zecyrillic':0x437,'zedescendercyrillic':0x499,'zedieresiscyrillic':0x4df,'zehiragana':0x305c,'zekatakana':0x30bc,'zero':0x30,'zeroarabic':0x660,'zerobengali':0x9e6,'zerodeva':0x966,'zerogujarati':0xae6,'zerogurmukhi':0xa66,'zerohackarabic':0x660,'zeroinferior':0x2080,'zeromonospace':0xff10,'zerooldstyle':0xf730,'zeropersian':0x6f0,'zerosuperior':0x2070,'zerothai':0xe50,'zerowidthjoiner':0xfeff,'zerowidthnonjoiner':0x200c,'zerowidthspace':0x200b,'zeta':0x3b6,'zhbopomofo':0x3113,'zhearmenian':0x56a,'zhebrevecyrillic':0x4c2,'zhecyrillic':0x436,'zhedescendercyrillic':0x497,'zhedieresiscyrillic':0x4dd,'zihiragana':0x3058,'zikatakana':0x30b8,'zinorhebrew':0x5ae,'zlinebelow':0x1e95,'zmonospace':0xff5a,'zohiragana':0x305e,'zokatakana':0x30be,'zparen':0x24b5,'zretroflexhook':0x290,'zstroke':0x1b6,'zuhiragana':0x305a,'zukatakana':0x30ba }

unicode_to_glyph_name = dict(map(lambda tpl: (tpl[1], tpl[0],),
                                 glyph_name_to_unicode.iteritems()))

encoding_tables = { "AppleStandard": apple_roman_to_unicode,
                    "AdobeStandardEncoding": adobe_standard_to_unicode,
                    "ISOLatin1Encoding": iso_latin1_to_unicode,
                    "Symbol": adobe_symbol_to_unicode }


# Local variables:
# mode: python
# ispell-local-dictionary: "english"
# End:

