# test__hotshot.py -- unittests for _hotshot module

# Copyright (c) 2005 Floris Bruynooghe

# All rights reserved.

# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, provided
# that the above copyright notice(s) and this permission notice appear
# in all copies of the Software and that both the above copyright
# notice(s) and this permission notice appear in supporting
# documentation.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE
# COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR
# ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
# ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
# OF THIS SOFTWARE.

# Except as contained in this notice, the name of a copyright holder
# shall not be used in advertising or otherwise to promote the sale,
# use or other dealings in this Software without prior written
# authorization of the copyright holder.


import unittest
import time
import os
from test import test_support

import _hotshot


class Changes(unittest.TestCase):
    def test_version(self):
        # Version written in profile file has -hprof attached to it?
        p = _hotshot.profiler(test_support.TESTFN)
        p.close()
        l = _hotshot.logreader(test_support.TESTFN)
        try:
            self.failUnlessEqual(l.info['hotshot-version'][0][-6:], '-hprof')
        finally:
            l.close()
            test_support.unlink(test_support.TESTFN)

    def test_builtin_timer(self):
        # Builtin timer still works?
        def root():
            return True
        p = _hotshot.profiler(test_support.TESTFN)
        try:
            self.failUnless(p.runcall(root))
        finally:
            p.close()
            test_support.unlink(test_support.TESTFN)

    def test_settimer(self):
        # profiler.settimer() works?
        p = _hotshot.profiler(test_support.TESTFN)
        try:
            self.failUnlessEqual(None, p.settimer(time.time))
        finally:
            p.close()
            test_support.unlink(test_support.TESTFN)

    def test_float_timer(self):
        # Works with a timer returning float?
        def root():
            return True
        p = _hotshot.profiler(test_support.TESTFN)
        p.settimer(time.time)
        try:
            self.failUnless(p.runcall(root))
        finally:
            p.close()
            test_support.unlink(test_support.TESTFN)

    def test_sequence_timer(self):
        # Works with a timer returning a sequence?
        def root():
            return True
        p = _hotshot.profiler(test_support.TESTFN)
        p.settimer(os.times)
        try:
            self.failUnless(p.runcall(root))
        finally:
            p.close()
            test_support.unlink(test_support.TESTFN)

    def test_wrong_timer_string(self):
        # A timer function returning a string gets handled correctly?
        def root():
            return True
        def timer():
            return "random"
        p = _hotshot.profiler(test_support.TESTFN)
        p.settimer(timer)
        try:
            self.failUnlessRaises(TypeError, p.runcall, root)
        finally:
            p.close()
            test_support.unlink(test_support.TESTFN)

    def test_wrong_timer_bool(self):
        # A timer function returning a bool gets handled correctly?
        def root():
            return True
        def timer():
            return False
        p = _hotshot.profiler(test_support.TESTFN)
        p.settimer(timer)
        try:
            self.failUnlessRaises(TypeError, p.runcall, root)
        finally:
            p.close()
            test_support.unlink(test_support.TESTFN)

    def test_wrong_timer(self):
        # A bad timer function gets handled correctly?
        def root():
            return True
        def timer():
            return None
        p = _hotshot.profiler(test_support.TESTFN)
        p.settimer(timer)
        try:
            self.failUnlessRaises(TypeError, p.runcall, root)
        finally:
            p.close()
            test_support.unlink(test_support.TESTFN)

def test_main():
    test_support.run_unittest(Changes)


if __name__ == '__main__':
    test_main()
