#
# NPI - Calculatrice en Notation Polonaise Inverse. 
# Copyright (C) 2005-2011 MiKael NAVARRO
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""NPI - Reverse Polish Notation Calculator.
Copyright (C) 2005-2011 MiKael NAVARRO

Stack class.
"""

try: # try to inherit from list class
  class _Temp(list):
    pass
except: # no: we use UserList as base class
  from collections import UserList as List
else: # yes: we delete _Temp and we use list as base class
  del _Temp
  List = list


class Stack(List):
  """A Stack :)
  Herited from UserList or list class.

  Usage:
  >>> stack = Stack()
  >>> stack
  []
  >>> stack = Stack([4, 3, 2])
  >>> stack
  [4, 3, 2]
  >>> stack.push(5)
  >>> stack
  [4, 3, 2, 5]
  >>> stack.pop()
  5
  >>> stack.push(1)
  >>> stack.display()
  '4: 4\\n3: 3\\n2: 2\\n1: 1'
  """
  
  # Constructor:
  def __init__(self, list=None):
    if list is not None:
      List.__init__(self, list)
    else:
      List.__init__(self)

  # Accesses:
  push = List.append

  # Display:
  def display(self):
    s = []
    self_len = len(self)

    for i in range(self_len):
      s.append("%s: %s" % ((self_len-i), self[i]))

    return "\n".join(s)

  def aff(self):
    s = self.display()
    if s: print(s)
  

#
# Self-test.
#
def test():
  import doctest
  print("Testing 'Stack' module...", end="")
  doctest.testmod()
  print("Okey")


if __name__ == "__main__":
  test()
  
