#
# NPI - Calculatrice en Notation Polonaise Inverse. 
# Copyright (C) 2005-2011 MiKael NAVARRO
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""NPI - Reverse Polish Notation Calculator. 
Copyright (C) 2005-2011 MiKael NAVARRO

Self tests.
"""

# Include directives
import os
import sys
import glob

import unittest
import doctest


dirname = os.path.dirname(__file__)  # get current directory
if dirname == '':
  dirname = '.'
dirname = os.path.realpath(dirname)
if dirname not in sys.path:
  sys.path.append(dirname)

# Get modules list to test
files = glob.glob(os.path.join(dirname, "cmd_*.py"))
modules = [os.path.splitext(os.path.basename(module))[0] for module in files]
for module in modules:
  module = __import__(module)


#
# Build test suite.
#
def test_suite():
  tests = unittest.TestSuite()
  for module in modules:
      tests.addTest(doctest.DocTestSuite(module))
  return unittest.TestSuite(tests)


#
# External entry point.
#
if __name__ == "__main__":
  unittest.main(defaultTest='test_suite')
