#
# NPI - Calculatrice en Notation Polonaise Inverse. 
# Copyright (C) 2005-2016 MiKael NAVARRO
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""NPI - Reverse Polish Notation Calculator. 
Copyright (C) 2005-2016 MiKael NAVARRO

Additional arithmetic commands.
"""

# Include directives
from npi_errors import TooFewArguments, InfiniteResult  # NPI errors
from npi_utils import func_name  # decorator: set func_name


#
# PGCD
#
@func_name("pgcd")
def npi_pgcd(stack):
  """PGCD between X and Y
  
  >>> from stack import Stack
  >>> npi_pgcd(Stack([1071, 1029]))  # 1071 1029 pgcd
  [21]
  >>> npi_pgcd(Stack([3]))
  Traceback (most recent call last):
  ...
  npi_errors.TooFewArguments: pgcd Error: Too Few Arguments
  """

  if len(stack) >= 2:
    op1, op2 = stack.pop(), stack.pop()
    while op2 > 0:
        op1, op2 = op2, op1 % op2
    stack.push(op1)
  else:
    raise TooFewArguments(npi_pgcd)

  return stack



#
# Self-test.
#
def _test():
  import doctest
  print("Testing 'Arithmetic' additional commands...", end="")
  (failure_count, test_count) = doctest.testmod()
  if not failure_count: print("Okey")
  else: print("Ko!")


#
# External entry point.
#
if __name__ == "__main__":
  _test()
