#! /usr/bin/env python
#
# NPI - Calculatrice en Notation Polonaise Inverse. 
# Copyright (C) 2011 MiKael NAVARRO
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import sys
from distutils.core import setup

# Patch distutils if it can't cope with
# the "classifiers" or "download_url" keywords.
if sys.version < '2.2.3':
  from distutils.dist import DistributionMetadata
  DistributionMetadata.classifiers = None
  DistributionMetadata.download_url = None

#
# Setup.
#
setup(name = 'npi',
      version = '0.3.4',
      description = 'NPI - Calculatrice en Notation Polonaise Inverse.',
      author = 'MiKael NAVARRO',
      author_email = 'klnavarro@gmail.com',
      maintainer = 'MiKael NAVARRO',
      maintainer_email = 'klnavarro@gmail.com',
      long_description = 'NPI is an unpretentious calculator in RPN mode.',
      license = 'GNU General Public License v2 or later',
      url = 'https://gna.org/projects/npi',
      download_url = 'http://download.gna.org/npi',
      platforms = 'Theorically all platforms.',
      package_dir = {'': 'src'},
      packages = [''],
      data_files = [('share/doc/npi', ['AUTHORS', 'PKG-INFO', 'MANIFEST',
                                       'README', 'LISEZMOI', 'INSTALL',
                                       'COPYING',
                                       'NEWS', 'ChangeLog']),
                    ('share/doc/npi/rest', ['doc/npi.fr.rest', 'COPYING'])],
      scripts=['src/npi.py', 'tools/ircnpi.py', 'tools/npibot.py'],
      classifiers = ['Development Status :: 5 - Production/Stable',
                     'Environment :: Console (Text Based)',
                     'Intended Audience :: End Users/Desktop',
                     'License :: OSI Approved :: GNU General Public License v2 or later',
                     'Operating System :: OS Independent',
                     'Programming Language :: Python',
                     'Topic :: Scientific/Engineering']
      )
