# pygsear
# Copyright (C) 2003 Lee Harr
#
#
# This file is part of pygsear.
#
# pygsear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# pygsear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with pygsear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


import random

from pygsear import Game, Drawable, Path, conf



class C2(Drawable.Circle):
    def __init__(self):
        Drawable.Circle.__init__(self, color='random')
        self.path.set_restriction(onscreen=1,
                                    xMax=conf.WINWIDTH-30,
                                    yMax=conf.WINHEIGHT-30,
                                    vxMax = 50,
                                    vyMax = 50,
                                    vxMin = -50,
                                    vyMin = -50
                                    )
        self.center()

        self.set_turn_until()
        self.set_acc_until()

    def set_turn(self):
        path = self.path
        left = path.turn_left
        right = path.turn_right
        straight = path.turn_straight
        choices = [(left, 1000, 3000), (straight, 1000, 3000), (right, 1000, 3000)]
        #choices = [(right, 100, 300)]
        turn, tmin, tmax = random.choice(choices)
        #print turn
        turn()
        self.set_turn_until(tmin, tmax)

    def set_turn_until(self, tmin=100, tmax=1000):
        self.turn_until = random.randrange(tmin, tmax)

    def set_acc(self):
        a = random.randrange(-5, 6)
        #print 'a', a
        self.path.set_speed(accelerate=a)
        self.set_acc_until()

    def set_acc_until(self, tmin=100, tmax=1000):
        self.acc_until = random.randrange(tmin, tmax)

    def move(self):
        self.turn_until -= conf.ticks
        if self.turn_until <= 0:
            self.set_turn()
        self.acc_until -= conf.ticks
        if self.acc_until <= 0:
            self.set_acc()
        Drawable.Circle.move(self)


class AccelGame(Game.Game):
    def checkEvents(self):
        Game.Game.checkEvents(self)
        if self.tot_time < 500:
            self.tot_time += conf.ticks
        else:
            raw = self.clock.get_rawtime()
            maxfps = conf.MAX_FPS
            #print raw, maxfps
            if raw < maxfps:
                #print 'dot'
                self.make_dot()
                self.tot_time = 0

    def make_dot(self):
        dot = C2()
        self.sprites.add(dot)


    def initialize(self):
        self.set_background(color=(95, 0, 0))
        self.make_dot()
        self.tot_time = 0


if __name__ == '__main__':
    game = AccelGame()
    game.mainloop()

