#!/usr/bin/env pyformex
##
##  SPDX-FileCopyrightText: © 2007-2023 Benedict Verhegghe <bverheg@gmail.com>
##  SPDX-License-Identifier: GPL-3.0-or-later
##
##  This file is part of pyFormex 3.4  (Thu Nov 16 18:07:39 CET 2023)
##  pyFormex is a tool for generating, manipulating and transforming 3D
##  geometrical models by sequences of mathematical operations.
##  Home page: https://pyformex.org
##  Project page: https://savannah.nongnu.org/projects/pyformex/
##  Development: https://gitlab.com/bverheg/pyformex
##  Distributed under the GNU General Public License version 3 or later.
##
##  This program is free software: you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##
##  You should have received a copy of the GNU General Public License
##  along with this program.  If not, see http://www.gnu.org/licenses/.
##
# Created by postabq 0.2 (C) 2008,2014 Benedict Verhegghe
from plugins.fe_post import FeResult
D = FeResult()
D.Abqver('6.11-1')
D.Date('27-Aug-2014','10:04:51')
D.Size(nelems=36,nnodes=52,length=1.000000)
D.Element(1,'CPS4',[16,21,22,17,])
D.Element(2,'CPS4',[21,25,26,22,])
D.Element(3,'CPS4',[25,29,30,26,])
D.Element(4,'CPS4',[29,33,34,30,])
D.Element(5,'CPS4',[17,22,23,18,])
D.Element(6,'CPS4',[22,26,27,23,])
D.Element(7,'CPS4',[26,30,31,27,])
D.Element(8,'CPS4',[30,34,35,31,])
D.Element(9,'CPS4',[18,23,24,19,])
D.Element(10,'CPS4',[23,27,28,24,])
D.Element(11,'CPS4',[27,31,32,28,])
D.Element(12,'CPS4',[31,35,36,32,])
D.Element(13,'CPS4',[33,38,39,34,])
D.Element(14,'CPS4',[38,43,44,39,])
D.Element(15,'CPS4',[43,48,49,44,])
D.Element(16,'CPS4',[34,39,40,35,])
D.Element(17,'CPS4',[39,44,45,40,])
D.Element(18,'CPS4',[44,49,50,45,])
D.Element(19,'CPS4',[35,40,41,36,])
D.Element(20,'CPS4',[40,45,46,41,])
D.Element(21,'CPS4',[45,50,51,46,])
D.Element(22,'CPS4',[36,41,42,37,])
D.Element(23,'CPS4',[41,46,47,42,])
D.Element(24,'CPS4',[46,51,52,47,])
D.Element(25,'CPS4',[16,17,12,11,])
D.Element(26,'CPS4',[17,18,13,12,])
D.Element(27,'CPS4',[18,19,14,13,])
D.Element(28,'CPS4',[19,20,15,14,])
D.Element(29,'CPS4',[11,12,7,6,])
D.Element(30,'CPS4',[12,13,8,7,])
D.Element(31,'CPS4',[13,14,9,8,])
D.Element(32,'CPS4',[14,15,10,9,])
D.Element(33,'CPS4',[6,7,2,1,])
D.Element(34,'CPS4',[7,8,3,2,])
D.Element(35,'CPS4',[8,9,4,3,])
D.Element(36,'CPS4',[9,10,5,4,])
D.Node(1,[-3.000000e+00,1.836970e-16,])
D.Node(2,[-3.000000e+00,1.000000e+00,])
D.Node(3,[-3.000000e+00,2.000000e+00,])
D.Node(4,[-3.000000e+00,3.000000e+00,])
D.Node(5,[-3.000000e+00,4.000000e+00,])
D.Node(6,[-2.000000e+00,1.224647e-16,])
D.Node(7,[-2.000000e+00,1.000000e+00,])
D.Node(8,[-2.000000e+00,2.000000e+00,])
D.Node(9,[-2.000000e+00,3.000000e+00,])
D.Node(10,[-2.000000e+00,4.000000e+00,])
D.Node(11,[-1.000000e+00,6.123234e-17,])
D.Node(12,[-1.000000e+00,1.000000e+00,])
D.Node(13,[-1.000000e+00,2.000000e+00,])
D.Node(14,[-1.000000e+00,3.000000e+00,])
D.Node(15,[-1.000000e+00,4.000000e+00,])
D.Node(16,[0.000000e+00,0.000000e+00,])
D.Node(17,[0.000000e+00,1.000000e+00,])
D.Node(18,[1.224647e-16,2.000000e+00,])
D.Node(19,[1.836970e-16,3.000000e+00,])
D.Node(20,[2.449294e-16,4.000000e+00,])
D.Node(21,[1.000000e+00,0.000000e+00,])
D.Node(22,[1.000000e+00,1.000000e+00,])
D.Node(23,[1.000000e+00,2.000000e+00,])
D.Node(24,[1.000000e+00,3.000000e+00,])
D.Node(25,[2.000000e+00,0.000000e+00,])
D.Node(26,[2.000000e+00,1.000000e+00,])
D.Node(27,[2.000000e+00,2.000000e+00,])
D.Node(28,[2.000000e+00,3.000000e+00,])
D.Node(29,[3.000000e+00,0.000000e+00,])
D.Node(30,[3.000000e+00,1.000000e+00,])
D.Node(31,[3.000000e+00,2.000000e+00,])
D.Node(32,[3.000000e+00,3.000000e+00,])
D.Node(33,[4.000000e+00,0.000000e+00,])
D.Node(34,[4.000000e+00,1.000000e+00,])
D.Node(35,[4.000000e+00,2.000000e+00,])
D.Node(36,[4.000000e+00,3.000000e+00,])
D.Node(37,[4.000000e+00,4.000000e+00,])
D.Node(38,[5.000000e+00,0.000000e+00,])
D.Node(39,[5.000000e+00,1.000000e+00,])
D.Node(40,[5.000000e+00,2.000000e+00,])
D.Node(41,[5.000000e+00,3.000000e+00,])
D.Node(42,[5.000000e+00,4.000000e+00,])
D.Node(43,[6.000000e+00,0.000000e+00,])
D.Node(44,[6.000000e+00,1.000000e+00,])
D.Node(45,[6.000000e+00,2.000000e+00,])
D.Node(46,[6.000000e+00,3.000000e+00,])
D.Node(47,[6.000000e+00,4.000000e+00,])
D.Node(48,[7.000000e+00,0.000000e+00,])
D.Node(49,[7.000000e+00,1.000000e+00,])
D.Node(50,[7.000000e+00,2.000000e+00,])
D.Node(51,[7.000000e+00,3.000000e+00,])
D.Node(52,[7.000000e+00,4.000000e+00,])
D.Elemset('ESET_0',[1,2,3,4,5,6,7,8,9,10,11,12,])
D.Elemset('ESET_1',[13,15,17,19,21,23,])
D.Elemset('ESET_2',[14,16,18,20,22,24,])
D.Elemset('ESET_3',[25,26,27,28,29,30,31,32,33,34,35,36,])
D.Elemset('1',[1,2,3,4,5,6,7,8,9,10,11,12,])
D.Elemset('2',[1,2,3,4,5,6,7,8,9,10,11,12,])
D.Elemset('3',[13,15,17,19,21,23,])
D.Elemset('4',[13,14,15,16,17,18,19,20,21,22,23,24,])
D.Elemset('5',[14,16,18,20,22,24,])
D.Elemset('6',[25,26,27,28,29,30,31,32,33,34,35,36,])
D.Elemset('7',[25,26,27,28,29,30,31,32,33,34,35,36,])
D.Elemset('EALL',[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,])
D.Nodeset('LOADED',[1,2,3,4,5,])
D.Nodeset('NALL',[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,])
D.Nodeset('NSET_0',[48,49,50,51,52,])
D.Label(tag='1',value='ESET_0_GRP_0_ESET_0')
D.Label(tag='2',value='ESET_GRP_0')
D.Label(tag='3',value='ESET_1_GRP_1_ESET_1')
D.Label(tag='4',value='ESET_GRP_1')
D.Label(tag='5',value='ESET_2_GRP_1_ESET_2')
D.Label(tag='6',value='ESET_3_GRP_2_ESET_3')
D.Label(tag='7',value='ESET_GRP_2')
D.Label(tag='8',value='ANTIALIASING')
D.Dofs([1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,])
D.Heading('Model: feabq1     Date: 2014-08-27 12:02:25.880206      Created by pyFormex')
D.EndIncrement()
D.Increment(step=1,inc=1,tottime=1.000000e+00,steptime=1.000000e+00,timeinc=1.000000e+00,type=1,heading='',maxcreep=0.000000e+00,solamp=0.000000e+00,linpert=0,loadfactor=0.000000e+00,frequency=0.000000e+00,)
D.OutputRequest(flag=0,set='EALL',eltyp='CPS4',)
D.ElemHeader(loc='gp',i=1,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[4.295042e+02,-2.009713e+01,2.487716e+01,])
D.ElemHeader(loc='gp',i=1,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[4.293347e+02,-2.066207e+01,2.118330e+02,])
D.ElemHeader(loc='gp',i=1,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.636636e+02,1.401507e+02,2.467943e+01,])
D.ElemHeader(loc='gp',i=1,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.634941e+02,1.395858e+02,2.116352e+02,])
D.ElemHeader(loc='gp',i=2,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.672964e+02,-7.091963e+01,-8.760816e+01,])
D.ElemHeader(loc='gp',i=2,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.659833e+02,-7.529665e+01,1.477087e+02,])
D.ElemHeader(loc='gp',i=2,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.396304e+02,1.307806e+02,-8.914011e+01,])
D.ElemHeader(loc='gp',i=2,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.383173e+02,1.264035e+02,1.461768e+02,])
D.ElemHeader(loc='gp',i=3,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.566298e+02,-7.874532e+01,-1.414266e+02,])
D.ElemHeader(loc='gp',i=3,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.573641e+02,-7.629758e+01,9.842758e+01,])
D.ElemHeader(loc='gp',i=3,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.419275e+02,1.268440e+02,-1.405699e+02,])
D.ElemHeader(loc='gp',i=3,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.426618e+02,1.292917e+02,9.928429e+01,])
D.ElemHeader(loc='gp',i=4,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.916794e+02,-3.122900e+01,-2.030566e+02,])
D.ElemHeader(loc='gp',i=4,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.952449e+02,-1.934405e+01,-5.337111e+00,])
D.ElemHeader(loc='gp',i=4,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.565922e+02,1.382448e+02,-1.988969e+02,])
D.ElemHeader(loc='gp',i=4,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.601577e+02,1.501298e+02,-1.177378e+00,])
D.ElemHeader(loc='gp',i=5,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.305317e+03,1.863369e+02,4.984711e+01,])
D.ElemHeader(loc='gp',i=5,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.274576e+03,8.386577e+01,2.073377e+02,])
D.ElemHeader(loc='gp',i=5,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.755290e+03,3.213288e+02,1.398223e+01,])
D.ElemHeader(loc='gp',i=5,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.724549e+03,2.188577e+02,1.714728e+02,])
D.ElemHeader(loc='gp',i=6,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.362118e+03,4.065189e+01,-1.045470e+02,])
D.ElemHeader(loc='gp',i=6,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.330284e+03,-6.546338e+01,1.324937e+02,])
D.ElemHeader(loc='gp',i=6,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.039377e+03,2.438296e+02,-1.416873e+02,])
D.ElemHeader(loc='gp',i=6,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.007543e+03,1.377143e+02,9.535332e+01,])
D.ElemHeader(loc='gp',i=7,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.337813e+03,-6.921574e+01,-1.285707e+02,])
D.ElemHeader(loc='gp',i=7,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.364233e+03,1.885286e+01,1.093721e+02,])
D.ElemHeader(loc='gp',i=7,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.017649e+03,1.347352e+02,-9.774673e+01,])
D.ElemHeader(loc='gp',i=7,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.044070e+03,2.228038e+02,1.401961e+02,])
D.ElemHeader(loc='gp',i=8,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.286531e+03,6.019220e+01,-1.948342e+02,])
D.ElemHeader(loc='gp',i=8,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.318339e+03,1.662198e+02,-2.125310e+01,])
D.ElemHeader(loc='gp',i=8,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.782477e+03,2.089760e+02,-1.577246e+02,])
D.ElemHeader(loc='gp',i=8,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.814285e+03,3.150037e+02,1.585656e+01,])
D.ElemHeader(loc='gp',i=9,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.295192e+03,3.896935e+02,-3.515278e+02,])
D.ElemHeader(loc='gp',i=9,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.172571e+03,-1.904109e+01,3.675262e+01,])
D.ElemHeader(loc='gp',i=9,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.404564e+03,7.225053e+02,-4.945849e+02,])
D.ElemHeader(loc='gp',i=9,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.281944e+03,3.137707e+02,-1.063045e+02,])
D.ElemHeader(loc='gp',i=10,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.383384e+03,-8.773298e+01,-1.413771e+02,])
D.ElemHeader(loc='gp',i=10,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.387173e+03,-7.510313e+01,8.758163e+01,])
D.ElemHeader(loc='gp',i=10,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.037552e+03,1.085173e+02,-1.369566e+02,])
D.ElemHeader(loc='gp',i=10,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.041341e+03,1.211472e+02,9.200208e+01,])
D.ElemHeader(loc='gp',i=11,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.393450e+03,-7.524946e+01,-9.303483e+01,])
D.ElemHeader(loc='gp',i=11,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.387833e+03,-9.397231e+01,1.301048e+02,])
D.ElemHeader(loc='gp',i=11,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.030992e+03,1.160131e+02,-9.958782e+01,])
D.ElemHeader(loc='gp',i=11,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.025375e+03,9.729025e+01,1.235518e+02,])
D.ElemHeader(loc='gp',i=12,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.212797e+03,-2.138330e+01,-5.300352e+01,])
D.ElemHeader(loc='gp',i=12,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.331088e+03,3.729218e+02,2.982084e+02,])
D.ElemHeader(loc='gp',i=12,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.216259e+03,2.796555e+02,8.500324e+01,])
D.ElemHeader(loc='gp',i=12,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.334551e+03,6.739606e+02,4.362151e+02,])
D.ElemHeader(loc='gp',i=13,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.326604e+02,-3.741986e+01,-1.055032e+02,])
D.ElemHeader(loc='gp',i=13,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.297250e+02,-4.720460e+01,-3.807167e+01,])
D.ElemHeader(loc='gp',i=13,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.253220e+02,2.037862e+01,-1.089279e+02,])
D.ElemHeader(loc='gp',i=13,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.223865e+02,1.059387e+01,-4.149633e+01,])
D.ElemHeader(loc='gp',i=14,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[4.740867e+02,-1.394483e+01,-7.749619e+01,])
D.ElemHeader(loc='gp',i=14,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[4.679715e+02,-3.432894e+01,-3.336085e+01,])
D.ElemHeader(loc='gp',i=14,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.001877e+02,2.388547e+01,-8.463063e+01,])
D.ElemHeader(loc='gp',i=14,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.940724e+02,3.501354e+00,-4.049529e+01,])
D.ElemHeader(loc='gp',i=15,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.293136e+02,4.564167e+01,-1.119073e+02,])
D.ElemHeader(loc='gp',i=15,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.638613e+02,1.608008e+02,-1.252806e+02,])
D.ElemHeader(loc='gp',i=15,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.911044e+02,3.417890e+01,-7.160164e+01,])
D.ElemHeader(loc='gp',i=15,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.256521e+02,1.493381e+02,-8.497487e+01,])
D.ElemHeader(loc='gp',i=16,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.539554e+02,-1.565236e+01,-1.568038e+02,])
D.ElemHeader(loc='gp',i=16,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.378575e+02,-6.931213e+01,-7.771050e+01,])
D.ElemHeader(loc='gp',i=16,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.799363e+02,5.214190e+01,-1.755847e+02,])
D.ElemHeader(loc='gp',i=16,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.638384e+02,-1.517862e+00,-9.649142e+01,])
D.ElemHeader(loc='gp',i=17,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.466515e+02,-6.529929e+01,-1.078049e+02,])
D.ElemHeader(loc='gp',i=17,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.639875e+02,-7.512518e+00,-7.500231e+01,])
D.ElemHeader(loc='gp',i=17,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.403733e+02,-3.718275e+01,-8.757957e+01,])
D.ElemHeader(loc='gp',i=17,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.577094e+02,2.060403e+01,-5.477694e+01,])
D.ElemHeader(loc='gp',i=18,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.878184e+02,2.849972e+01,-7.587745e+01,])
D.ElemHeader(loc='gp',i=18,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.234989e+02,1.474345e+02,-6.416672e+01,])
D.ElemHeader(loc='gp',i=18,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.212776e+02,3.853749e+01,-3.425027e+01,])
D.ElemHeader(loc='gp',i=18,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.569581e+02,1.574723e+02,-2.253955e+01,])
D.ElemHeader(loc='gp',i=19,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.407440e+02,5.412762e+01,5.336847e+01,])
D.ElemHeader(loc='gp',i=19,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.109971e+02,-4.502860e+01,3.754525e+01,])
D.ElemHeader(loc='gp',i=19,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.955348e+02,4.056485e+01,1.866380e+01,])
D.ElemHeader(loc='gp',i=19,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.657880e+02,-5.859136e+01,2.840574e+00,])
D.ElemHeader(loc='gp',i=20,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.403271e+02,-9.828139e+01,3.362783e+01,])
D.ElemHeader(loc='gp',i=20,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.682260e+02,-5.285073e+00,2.003714e+01,])
D.ElemHeader(loc='gp',i=20,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.014965e+02,-1.099305e+02,6.617654e+01,])
D.ElemHeader(loc='gp',i=20,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.293954e+02,-1.693424e+01,5.258585e+01,])
D.ElemHeader(loc='gp',i=21,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.180136e+02,2.390128e+01,2.800722e+01,])
D.ElemHeader(loc='gp',i=21,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.569900e+02,1.538224e+02,1.748056e+01,])
D.ElemHeader(loc='gp',i=21,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.879374e+02,1.487842e+01,7.347963e+01,])
D.ElemHeader(loc='gp',i=21,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.269138e+02,1.447996e+02,6.295297e+01,])
D.ElemHeader(loc='gp',i=22,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.516437e+02,2.899495e+02,3.206050e+02,])
D.ElemHeader(loc='gp',i=22,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.803866e+02,5.242579e+01,1.066140e+02,])
D.ElemHeader(loc='gp',i=22,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.402406e+02,1.065285e+02,2.374718e+02,])
D.ElemHeader(loc='gp',i=22,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.898354e+01,-1.309951e+02,2.348068e+01,])
D.ElemHeader(loc='gp',i=23,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.373829e+02,-3.092230e+01,1.319684e+02,])
D.ElemHeader(loc='gp',i=23,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.451901e+02,-4.898357e+00,5.328293e+01,])
D.ElemHeader(loc='gp',i=23,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[4.125674e+02,-9.836697e+01,1.410768e+02,])
D.ElemHeader(loc='gp',i=23,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[4.203746e+02,-7.234303e+01,6.239132e+01,])
D.ElemHeader(loc='gp',i=24,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.929890e+02,2.821621e+01,7.528254e+01,])
D.ElemHeader(loc='gp',i=24,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.291122e+02,1.486269e+02,8.691273e+01,])
D.ElemHeader(loc='gp',i=24,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.262181e+02,3.818494e+01,1.174263e+02,])
D.ElemHeader(loc='gp',i=24,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.623413e+02,1.585956e+02,1.290565e+02,])
D.ElemHeader(loc='gp',i=25,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.314916e+02,-2.107707e-02,1.671600e+02,])
D.ElemHeader(loc='gp',i=25,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.085349e+02,5.309191e+01,1.784122e+02,])
D.ElemHeader(loc='gp',i=25,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.218468e+02,-3.217022e+01,1.051948e+02,])
D.ElemHeader(loc='gp',i=25,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.988901e+02,2.094277e+01,1.164470e+02,])
D.ElemHeader(loc='gp',i=26,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.495410e+02,6.300897e+01,2.319278e+02,])
D.ElemHeader(loc='gp',i=26,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.086902e+03,1.342173e+02,2.537068e+02,])
D.ElemHeader(loc='gp',i=26,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.308732e+02,7.831141e-01,1.488514e+02,])
D.ElemHeader(loc='gp',i=26,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.068234e+03,7.199139e+01,1.706305e+02,])
D.ElemHeader(loc='gp',i=27,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.177490e+03,1.453754e+02,-7.818899e+01,])
D.ElemHeader(loc='gp',i=27,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.202048e+03,1.527427e+02,-3.074560e+01,])
D.ElemHeader(loc='gp',i=27,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.136824e+03,9.822892e+00,-8.678416e+01,])
D.ElemHeader(loc='gp',i=27,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.161382e+03,1.719019e+01,-3.934077e+01,])
D.ElemHeader(loc='gp',i=28,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.035778e+03,4.416100e+02,-4.845046e+02,])
D.ElemHeader(loc='gp',i=28,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.518620e+02,2.064351e+02,-3.585017e+02,])
D.ElemHeader(loc='gp',i=28,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.277759e+02,8.160176e+01,-2.101339e+02,])
D.ElemHeader(loc='gp',i=28,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.438595e+02,-1.535731e+02,-8.413097e+01,])
D.ElemHeader(loc='gp',i=29,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.759938e+02,4.952654e+01,1.535389e+02,])
D.ElemHeader(loc='gp',i=29,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.025480e+02,2.749279e+01,1.680808e+02,])
D.ElemHeader(loc='gp',i=29,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.635294e+02,7.978293e+00,1.792449e+02,])
D.ElemHeader(loc='gp',i=29,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.900836e+02,-1.405546e+01,1.937868e+02,])
D.ElemHeader(loc='gp',i=30,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.810210e+02,-3.423738e+01,1.680747e+02,])
D.ElemHeader(loc='gp',i=30,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.454361e+02,-1.491284e+01,1.673795e+02,])
D.ElemHeader(loc='gp',i=30,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.816169e+02,-3.225119e+01,1.455294e+02,])
D.ElemHeader(loc='gp',i=30,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.460320e+02,-1.292665e+01,1.448342e+02,])
D.ElemHeader(loc='gp',i=31,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.452112e+02,-1.050615e+02,-8.900255e+01,])
D.ElemHeader(loc='gp',i=31,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.613156e+02,-1.002302e+02,-1.076538e+02,])
D.ElemHeader(loc='gp',i=31,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.611980e+02,-5.177214e+01,-9.463906e+01,])
D.ElemHeader(loc='gp',i=31,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.773023e+02,-4.694085e+01,-1.132903e+02,])
D.ElemHeader(loc='gp',i=32,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.575767e+02,-5.107288e+01,-2.371420e+02,])
D.ElemHeader(loc='gp',i=32,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.859725e+02,-7.255414e+01,-2.458612e+02,])
D.ElemHeader(loc='gp',i=32,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.650503e+02,-2.616083e+01,-2.120805e+02,])
D.ElemHeader(loc='gp',i=32,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.934461e+02,-4.764209e+01,-2.207998e+02,])
D.ElemHeader(loc='gp',i=33,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.258728e+03,6.021972e+01,4.087966e+01,])
D.ElemHeader(loc='gp',i=33,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.984272e+02,-7.787053e+01,9.602417e+01,])
D.ElemHeader(loc='gp',i=33,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.211461e+03,-9.733603e+01,2.019849e+02,])
D.ElemHeader(loc='gp',i=33,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.511605e+02,-2.354263e+02,2.571295e+02,])
D.ElemHeader(loc='gp',i=34,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.527599e+02,-1.432193e+02,3.836400e+00,])
D.ElemHeader(loc='gp',i=34,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.345883e+02,-1.186708e+02,8.051515e+01,])
D.ElemHeader(loc='gp',i=34,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.870352e+02,-3.623014e+02,-2.480354e+01,])
D.ElemHeader(loc='gp',i=34,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.688636e+02,-3.377529e+02,5.187521e+01,])
D.ElemHeader(loc='gp',i=35,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.303891e+02,-1.401969e+02,-7.178125e+01,])
D.ElemHeader(loc='gp',i=35,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.553417e+02,-1.627111e+02,-1.449984e+00,])
D.ElemHeader(loc='gp',i=35,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.701052e+02,-3.411434e+02,-4.551468e+01,])
D.ElemHeader(loc='gp',i=35,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.950578e+02,-3.636576e+02,2.481659e+01,])
D.ElemHeader(loc='gp',i=36,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.027988e+02,-8.672349e+01,-1.011156e+02,])
D.ElemHeader(loc='gp',i=36,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.252109e+03,4.806968e+01,-4.838176e+01,])
D.ElemHeader(loc='gp',i=36,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.575984e+02,-2.373916e+02,-2.583743e+02,])
D.ElemHeader(loc='gp',i=36,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.206909e+03,-1.025984e+02,-2.056405e+02,])
D.OutputRequest(flag=0,set='EALL',eltyp='CPS4',)
D.ElemHeader(loc='na',i=1,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.362642e+03,-1.044609e+02,2.407693e+02,])
D.ElemHeader(loc='na',i=2,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.492025e+02,-3.975583e+02,1.364648e+02,])
D.ElemHeader(loc='na',i=3,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.751335e+02,-4.077056e+02,3.907576e+00,])
D.ElemHeader(loc='na',i=4,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.610590e+02,-3.936638e+02,-1.375315e+02,])
D.ElemHeader(loc='na',i=5,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.354823e+03,-1.084090e+02,-2.438992e+02,])
D.ElemHeader(loc='na',i=6,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.165180e+03,8.463457e+01,7.252901e+01,])
D.ElemHeader(loc='na',i=7,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.027519e+02,-5.467156e+01,9.738578e+01,])
D.ElemHeader(loc='na',i=8,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.248757e+02,-3.176551e+01,1.459457e+01,])
D.ElemHeader(loc='na',i=9,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.719663e+02,-5.329003e+01,-9.251857e+01,])
D.ElemHeader(loc='na',i=10,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.101543e+03,5.308471e+01,-9.316863e+01,])
D.ElemHeader(loc='na',i=11,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.804767e+02,4.710425e+00,1.086013e+02,])
D.ElemHeader(loc='na',i=12,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.586938e+02,-6.710787e+00,1.372331e+02,])
D.ElemHeader(loc='na',i=13,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.908732e+02,-2.552798e+01,3.404077e+01,])
D.ElemHeader(loc='na',i=14,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.018268e+03,-4.102876e+01,-1.341225e+02,])
D.ElemHeader(loc='na',i=15,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.872113e+02,-2.304803e+02,-9.790494e+01,])
D.ElemHeader(loc='na',i=16,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.521349e+02,-4.311975e+01,7.112059e+01,])
D.ElemHeader(loc='na',i=17,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.643677e+02,1.293667e+02,1.052703e+02,])
D.ElemHeader(loc='na',i=18,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.557315e+03,3.002704e+02,-7.459960e+01,])
D.ElemHeader(loc='na',i=19,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.147890e+03,6.194824e+02,-4.434512e+02,])
D.ElemHeader(loc='na',i=20,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[4.460372e+00,2.521273e+02,-4.128081e+02,])
D.ElemHeader(loc='na',i=21,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.277212e+02,-1.113343e+02,5.357826e+01,])
D.ElemHeader(loc='na',i=22,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.142412e+03,1.015792e+02,5.113894e+01,])
D.ElemHeader(loc='na',i=23,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.010277e+03,3.328636e+01,-5.404423e+00,])
D.ElemHeader(loc='na',i=24,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.459364e+03,2.308540e+02,-1.178449e+02,])
D.ElemHeader(loc='na',i=25,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.246797e+01,-1.528092e+02,2.434256e+00,])
D.ElemHeader(loc='na',i=26,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.131616e+03,1.126326e+01,2.400898e+00,])
D.ElemHeader(loc='na',i=27,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.202967e+03,1.741912e+01,-1.894569e+00,])
D.ElemHeader(loc='na',i=28,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.274287e+03,1.952378e+02,-3.118199e+00,])
D.ElemHeader(loc='na',i=29,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.519920e+01,-1.241317e+02,-4.552138e+01,])
D.ElemHeader(loc='na',i=30,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.143563e+03,8.618167e+01,-4.228091e+01,])
D.ElemHeader(loc='na',i=31,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.052392e+03,2.689680e+01,3.250776e+00,])
D.ElemHeader(loc='na',i=32,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.398465e+03,2.029809e+02,1.048964e+02,])
D.ElemHeader(loc='na',i=33,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.264967e+02,-6.600984e+01,-3.171035e+01,])
D.ElemHeader(loc='na',i=34,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.726841e+02,9.784288e+01,-5.308207e+01,])
D.ElemHeader(loc='na',i=35,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.487818e+03,2.518284e+02,8.241886e+01,])
D.ElemHeader(loc='na',i=36,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.878844e+03,4.814647e+02,3.521315e+02,])
D.ElemHeader(loc='na',i=37,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[-5.746651e+01,1.263315e+02,2.853690e+02,])
D.ElemHeader(loc='na',i=38,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.441502e+02,-4.613617e+01,-5.158798e+01,])
D.ElemHeader(loc='na',i=39,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.989163e+02,-3.428699e+01,-7.264136e+01,])
D.ElemHeader(loc='na',i=40,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.424946e+02,-6.220039e+01,-2.386341e+01,])
D.ElemHeader(loc='na',i=41,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.775828e+02,-5.780532e+01,7.089071e+01,])
D.ElemHeader(loc='na',i=42,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.326707e+01,-2.088252e+02,4.396857e+01,])
D.ElemHeader(loc='na',i=43,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.251154e+02,-2.397537e+01,-6.818006e+01,])
D.ElemHeader(loc='na',i=44,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.002509e+02,-4.410202e+00,-6.117625e+01,])
D.ElemHeader(loc='na',i=45,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.065576e+02,1.584812e+01,-1.007557e+01,])
D.ElemHeader(loc='na',i=46,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.464992e+02,-3.332545e+00,5.756244e+01,])
D.ElemHeader(loc='na',i=47,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[4.830514e+02,-4.487184e+01,8.275968e+01,])
D.ElemHeader(loc='na',i=48,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.904922e+02,2.071477e+02,-1.449284e+02,])
D.ElemHeader(loc='na',i=49,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.243119e+02,1.872936e+02,-7.511689e+01,])
D.ElemHeader(loc='na',i=50,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.822650e+02,2.046795e+02,-3.016525e+00,])
D.ElemHeader(loc='na',i=51,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.301715e+02,1.890514e+02,7.574401e+01,])
D.ElemHeader(loc='na',i=52,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.877260e+02,2.063178e+02,1.487391e+02,])
D.OutputRequest(flag=0,set='       4',eltyp='CPS4',)
D.ElemHeader(loc='gp',i=13,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=13,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=13,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=13,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=14,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=14,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=14,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=14,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=15,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=15,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=15,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=15,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=16,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=16,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=16,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=16,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=17,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=17,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=17,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=17,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=18,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=18,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=18,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=18,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=19,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=19,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=19,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=19,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=20,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=20,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=20,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=20,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=21,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=21,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=21,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=21,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=22,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=22,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=22,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=22,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=23,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=23,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=23,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=23,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=24,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=24,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=24,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=24,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.OutputRequest(flag=0,set='       4',eltyp='CPS4',)
D.ElemHeader(loc='gp',i=13,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[3.973715e+02,4.260084e+02,-9.841351e+01,-6.538390e+01,0.000000e+00,3.606244e+02,3.849894e+02,])
D.ElemHeader(loc='gp',i=13,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[3.617454e+02,3.845435e+02,-9.417346e+01,-5.101157e+01,0.000000e+00,3.335319e+02,3.535176e+02,])
D.ElemHeader(loc='gp',i=13,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.488797e+02,5.499354e+02,-1.819002e+02,-2.117395e+00,0.000000e+00,5.478180e+02,5.488705e+02,])
D.ElemHeader(loc='gp',i=13,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.221414e+02,5.257292e+02,-1.776601e+02,0.000000e+00,7.251170e+00,5.257292e+02,5.220281e+02,])
D.ElemHeader(loc='gp',i=14,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[4.995805e+02,5.120522e+02,-1.533806e+02,-2.595514e+01,0.000000e+00,4.860970e+02,4.980601e+02,])
D.ElemHeader(loc='gp',i=14,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[4.894687e+02,5.067124e+02,-1.445475e+02,-3.653495e+01,0.000000e+00,4.701775e+02,4.863867e+02,])
D.ElemHeader(loc='gp',i=14,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[6.065864e+02,6.123587e+02,-2.080244e+02,0.000000e+00,1.171441e+01,6.123587e+02,6.063318e+02,])
D.ElemHeader(loc='gp',i=14,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.964678e+02,5.968363e+02,-1.991913e+02,0.000000e+00,7.375381e-01,5.968363e+02,5.964668e+02,])
D.ElemHeader(loc='gp',i=15,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[6.379386e+02,6.500340e+02,-2.249851e+02,0.000000e+00,2.492126e+01,6.500340e+02,6.368419e+02,])
D.ElemHeader(loc='gp',i=15,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[6.378910e+02,6.933341e+02,-2.748874e+02,0.000000e+00,1.313281e+02,6.933341e+02,6.063453e+02,])
D.ElemHeader(loc='gp',i=15,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.880048e+02,6.001626e+02,-2.084278e+02,0.000000e+00,2.512070e+01,6.001626e+02,5.867957e+02,])
D.ElemHeader(loc='gp',i=15,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.847828e+02,6.403577e+02,-2.583301e+02,0.000000e+00,1.346325e+02,6.403577e+02,5.482621e+02,])
D.ElemHeader(loc='gp',i=16,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[7.154725e+02,7.394081e+02,-2.127677e+02,-5.055251e+01,0.000000e+00,6.888556e+02,7.114378e+02,])
D.ElemHeader(loc='gp',i=16,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[6.884725e+02,7.240473e+02,-1.895151e+02,-7.775099e+01,0.000000e+00,6.462963e+02,6.784897e+02,])
D.ElemHeader(loc='gp',i=16,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[9.075325e+02,9.156400e+02,-3.106927e+02,0.000000e+00,1.643829e+01,9.156400e+02,9.071974e+02,])
D.ElemHeader(loc='gp',i=16,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[8.806032e+02,8.866137e+02,-2.874402e+02,-1.214658e+01,0.000000e+00,8.744671e+02,8.804147e+02,])
D.ElemHeader(loc='gp',i=17,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[7.067629e+02,7.438827e+02,-1.937841e+02,-8.126528e+01,0.000000e+00,6.626175e+02,6.961353e+02,])
D.ElemHeader(loc='gp',i=17,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[6.802942e+02,6.880507e+02,-2.188250e+02,-1.578782e+01,0.000000e+00,6.722629e+02,6.798818e+02,])
D.ElemHeader(loc='gp',i=17,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[7.746450e+02,7.970409e+02,-2.343968e+02,-4.692515e+01,0.000000e+00,7.501157e+02,7.714375e+02,])
D.ElemHeader(loc='gp',i=17,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[7.536164e+02,7.617578e+02,-2.594378e+02,0.000000e+00,1.655559e+01,7.617578e+02,7.532071e+02,])
D.ElemHeader(loc='gp',i=18,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.889501e+02,5.979292e+02,-2.054394e+02,0.000000e+00,1.838892e+01,5.979292e+02,5.883037e+02,])
D.ElemHeader(loc='gp',i=18,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.752518e+02,6.319960e+02,-2.569778e+02,0.000000e+00,1.389374e+02,6.319960e+02,5.355140e+02,])
D.ElemHeader(loc='gp',i=18,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[6.058447e+02,6.232838e+02,-2.199384e+02,0.000000e+00,3.653135e+01,6.232838e+02,6.033592e+02,])
D.ElemHeader(loc='gp',i=18,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.953679e+02,6.579732e+02,-2.714768e+02,0.000000e+00,1.564572e+02,6.579732e+02,5.461701e+02,])
D.ElemHeader(loc='gp',i=19,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[9.195398e+02,9.439449e+02,-3.316239e+02,0.000000e+00,5.092674e+01,9.439449e+02,9.163588e+02,])
D.ElemHeader(loc='gp',i=19,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[9.365859e+02,9.589702e+02,-2.886562e+02,-4.650082e+01,0.000000e+00,9.124693e+02,9.339834e+02,])
D.ElemHeader(loc='gp',i=19,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[8.765534e+02,8.959420e+02,-3.120332e+02,0.000000e+00,4.015762e+01,8.959420e+02,8.744801e+02,])
D.ElemHeader(loc='gp',i=19,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[8.965342e+02,9.243968e+02,-2.690655e+02,-5.860009e+01,0.000000e+00,8.657967e+02,8.922101e+02,])
D.ElemHeader(loc='gp',i=20,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[7.961760e+02,8.413011e+02,-2.140152e+02,-9.962769e+01,0.000000e+00,7.416734e+02,7.819678e+02,])
D.ElemHeader(loc='gp',i=20,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[7.716629e+02,7.745484e+02,-2.543136e+02,-5.803770e+00,0.000000e+00,7.687446e+02,7.716138e+02,])
D.ElemHeader(loc='gp',i=20,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[7.709968e+02,8.221504e+02,-1.971887e+02,-1.152922e+02,0.000000e+00,7.068582e+02,7.512352e+02,])
D.ElemHeader(loc='gp',i=20,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[7.436075e+02,7.537036e+02,-2.374871e+02,-2.062119e+01,0.000000e+00,7.330824e+02,7.429637e+02,])
D.ElemHeader(loc='gp',i=21,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[6.083535e+02,6.193310e+02,-2.139716e+02,0.000000e+00,2.258390e+01,6.193310e+02,6.074093e+02,])
D.ElemHeader(loc='gp',i=21,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.959481e+02,6.575966e+02,-2.702708e+02,0.000000e+00,1.532159e+02,6.575966e+02,5.489503e+02,])
D.ElemHeader(loc='gp',i=21,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.944258e+02,5.972092e+02,-2.009386e+02,0.000000e+00,5.606621e+00,5.972092e+02,5.943663e+02,])
D.ElemHeader(loc='gp',i=21,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.788784e+02,6.349984e+02,-2.572378e+02,0.000000e+00,1.367150e+02,6.349984e+02,5.407355e+02,])
D.ElemHeader(loc='gp',i=22,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[8.599204e+02,9.158637e+02,-3.471977e+02,0.000000e+00,1.257295e+02,9.158637e+02,8.388670e+02,])
D.ElemHeader(loc='gp',i=22,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[6.812519e+02,6.979936e+02,-2.442708e+02,0.000000e+00,3.481875e+01,6.979936e+02,6.792456e+02,])
D.ElemHeader(loc='gp',i=22,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[4.304122e+02,4.761385e+02,-8.225640e+01,-1.146846e+02,0.000000e+00,3.614538e+02,3.937770e+02,])
D.ElemHeader(loc='gp',i=22,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[1.805796e+02,2.054187e+02,2.067053e+01,-1.337151e+02,0.000000e+00,7.170355e+01,-1.428330e+02,])
D.ElemHeader(loc='gp',i=23,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[6.922207e+02,7.185364e+02,-2.021535e+02,-5.603786e+01,0.000000e+00,6.624985e+02,6.870897e+02,])
D.ElemHeader(loc='gp',i=23,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[6.541956e+02,6.587650e+02,-2.134306e+02,-9.236613e+00,0.000000e+00,6.495284e+02,6.540489e+02,])
D.ElemHeader(loc='gp',i=23,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.293192e+02,5.836647e+02,-1.047335e+02,-1.347322e+02,0.000000e+00,4.489326e+02,4.884544e+02,])
D.ElemHeader(loc='gp',i=23,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[4.733260e+02,5.082729e+02,-1.160105e+02,-8.012067e+01,0.000000e+00,4.281522e+02,4.576954e+02,])
D.ElemHeader(loc='gp',i=24,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.938877e+02,6.028517e+02,-2.070684e+02,0.000000e+00,1.835350e+01,6.028517e+02,5.932491e+02,])
D.ElemHeader(loc='gp',i=24,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.890930e+02,6.443502e+02,-2.592464e+02,0.000000e+00,1.333889e+02,6.443502e+02,5.535639e+02,])
D.ElemHeader(loc='gp',i=24,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[6.411411e+02,6.488002e+02,-2.214677e+02,0.000000e+00,1.560291e+01,6.488002e+02,6.407137e+02,])
D.ElemHeader(loc='gp',i=24,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[6.393519e+02,6.934800e+02,-2.736456e+02,0.000000e+00,1.274570e+02,6.934800e+02,6.097774e+02,])
D.OutputRequest(flag=1,set='NALL')
D.NodeOutput('U',1,[-2.262588e-02,-1.131096e-01,])
D.NodeOutput('U',2,[-4.075221e-02,-1.155891e-01,])
D.NodeOutput('U',3,[-6.389810e-02,-1.185427e-01,])
D.NodeOutput('U',4,[-8.869069e-02,-1.214852e-01,])
D.NodeOutput('U',5,[-1.184498e-01,-1.239724e-01,])
D.NodeOutput('U',6,[-1.589168e-02,-9.195916e-02,])
D.NodeOutput('U',7,[-3.752288e-02,-9.323897e-02,])
D.NodeOutput('U',8,[-6.004571e-02,-9.452435e-02,])
D.NodeOutput('U',9,[-8.540973e-02,-9.593682e-02,])
D.NodeOutput('U',10,[-1.117476e-01,-9.727681e-02,])
D.NodeOutput('U',11,[-1.161342e-02,-6.802524e-02,])
D.NodeOutput('U',12,[-3.380387e-02,-6.898869e-02,])
D.NodeOutput('U',13,[-5.583621e-02,-7.028920e-02,])
D.NodeOutput('U',14,[-8.107761e-02,-7.210743e-02,])
D.NodeOutput('U',15,[-1.079607e-01,-7.363711e-02,])
D.NodeOutput('U',16,[-9.330678e-03,-4.485012e-02,])
D.NodeOutput('U',17,[-3.017306e-02,-4.556877e-02,])
D.NodeOutput('U',18,[-5.039806e-02,-4.639547e-02,])
D.NodeOutput('U',19,[-7.545247e-02,-4.718156e-02,])
D.NodeOutput('U',20,[-1.083046e-01,-4.597002e-02,])
D.NodeOutput('U',21,[-8.086167e-03,-2.455388e-02,])
D.NodeOutput('U',22,[-2.486128e-02,-2.527683e-02,])
D.NodeOutput('U',23,[-4.166004e-02,-2.688378e-02,])
D.NodeOutput('U',24,[-5.826732e-02,-3.078212e-02,])
D.NodeOutput('U',25,[-7.773949e-03,-9.953970e-03,])
D.NodeOutput('U',26,[-1.942969e-02,-1.071025e-02,])
D.NodeOutput('U',27,[-3.107158e-02,-1.312519e-02,])
D.NodeOutput('U',28,[-4.269781e-02,-1.692736e-02,])
D.NodeOutput('U',29,[-7.522779e-03,-1.181251e-03,])
D.NodeOutput('U',30,[-1.396044e-02,-1.918892e-03,])
D.NodeOutput('U',31,[-2.042582e-02,-3.663254e-03,])
D.NodeOutput('U',32,[-2.719760e-02,-7.607981e-03,])
D.NodeOutput('U',33,[-6.494348e-03,1.777813e-03,])
D.NodeOutput('U',34,[-8.630573e-03,1.130669e-03,])
D.NodeOutput('U',35,[-1.131966e-02,1.936363e-04,])
D.NodeOutput('U',36,[-1.045075e-02,-7.487227e-04,])
D.NodeOutput('U',37,[-4.336522e-03,-5.514069e-05,])
D.NodeOutput('U',38,[-5.143072e-03,2.294611e-03,])
D.NodeOutput('U',39,[-5.812309e-03,1.572963e-03,])
D.NodeOutput('U',40,[-6.780707e-03,2.273466e-04,])
D.NodeOutput('U',41,[-6.256029e-03,-1.470021e-03,])
D.NodeOutput('U',42,[-4.797227e-03,-2.585022e-03,])
D.NodeOutput('U',43,[-3.035497e-03,1.820357e-03,])
D.NodeOutput('U',44,[-2.744560e-03,9.434973e-04,])
D.NodeOutput('U',45,[-2.999329e-03,3.788869e-05,])
D.NodeOutput('U',46,[-2.770319e-03,-9.513739e-04,])
D.NodeOutput('U',47,[-3.023337e-03,-1.868221e-03,])
D.NodeOutput('U',48,[-7.408145e-36,2.408098e-36,])
D.NodeOutput('U',49,[-1.172708e-35,1.446171e-36,])
D.NodeOutput('U',50,[-1.174924e-35,-6.256323e-39,])
D.NodeOutput('U',51,[-1.168769e-35,-1.423005e-36,])
D.NodeOutput('U',52,[-7.427844e-36,-2.425008e-36,])
D.EndIncrement()
D.Increment(step=2,inc=1,tottime=2.000000e+00,steptime=1.000000e+00,timeinc=1.000000e+00,type=1,heading='',maxcreep=0.000000e+00,solamp=0.000000e+00,linpert=0,loadfactor=0.000000e+00,frequency=0.000000e+00,)
D.OutputRequest(flag=0,set='EALL',eltyp='CPS4',)
D.ElemHeader(loc='gp',i=1,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[4.295042e+02,-2.009713e+01,2.487716e+01,])
D.ElemHeader(loc='gp',i=1,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[4.293347e+02,-2.066207e+01,2.118330e+02,])
D.ElemHeader(loc='gp',i=1,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.636636e+02,1.401507e+02,2.467943e+01,])
D.ElemHeader(loc='gp',i=1,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.634941e+02,1.395858e+02,2.116352e+02,])
D.ElemHeader(loc='gp',i=2,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.672964e+02,-7.091963e+01,-8.760816e+01,])
D.ElemHeader(loc='gp',i=2,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.659833e+02,-7.529665e+01,1.477087e+02,])
D.ElemHeader(loc='gp',i=2,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.396304e+02,1.307806e+02,-8.914011e+01,])
D.ElemHeader(loc='gp',i=2,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.383173e+02,1.264035e+02,1.461768e+02,])
D.ElemHeader(loc='gp',i=3,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.566298e+02,-7.874532e+01,-1.414266e+02,])
D.ElemHeader(loc='gp',i=3,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.573641e+02,-7.629758e+01,9.842758e+01,])
D.ElemHeader(loc='gp',i=3,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.419275e+02,1.268440e+02,-1.405699e+02,])
D.ElemHeader(loc='gp',i=3,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.426618e+02,1.292917e+02,9.928429e+01,])
D.ElemHeader(loc='gp',i=4,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.916794e+02,-3.122900e+01,-2.030566e+02,])
D.ElemHeader(loc='gp',i=4,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.952449e+02,-1.934405e+01,-5.337111e+00,])
D.ElemHeader(loc='gp',i=4,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.565922e+02,1.382448e+02,-1.988969e+02,])
D.ElemHeader(loc='gp',i=4,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.601577e+02,1.501298e+02,-1.177378e+00,])
D.ElemHeader(loc='gp',i=5,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.305317e+03,1.863369e+02,4.984711e+01,])
D.ElemHeader(loc='gp',i=5,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.274576e+03,8.386577e+01,2.073377e+02,])
D.ElemHeader(loc='gp',i=5,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.755290e+03,3.213288e+02,1.398223e+01,])
D.ElemHeader(loc='gp',i=5,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.724549e+03,2.188577e+02,1.714728e+02,])
D.ElemHeader(loc='gp',i=6,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.362118e+03,4.065189e+01,-1.045470e+02,])
D.ElemHeader(loc='gp',i=6,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.330284e+03,-6.546338e+01,1.324937e+02,])
D.ElemHeader(loc='gp',i=6,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.039377e+03,2.438296e+02,-1.416873e+02,])
D.ElemHeader(loc='gp',i=6,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.007543e+03,1.377143e+02,9.535332e+01,])
D.ElemHeader(loc='gp',i=7,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.337813e+03,-6.921574e+01,-1.285707e+02,])
D.ElemHeader(loc='gp',i=7,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.364233e+03,1.885286e+01,1.093721e+02,])
D.ElemHeader(loc='gp',i=7,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.017649e+03,1.347352e+02,-9.774673e+01,])
D.ElemHeader(loc='gp',i=7,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.044070e+03,2.228038e+02,1.401961e+02,])
D.ElemHeader(loc='gp',i=8,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.286531e+03,6.019220e+01,-1.948342e+02,])
D.ElemHeader(loc='gp',i=8,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.318339e+03,1.662198e+02,-2.125310e+01,])
D.ElemHeader(loc='gp',i=8,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.782477e+03,2.089760e+02,-1.577246e+02,])
D.ElemHeader(loc='gp',i=8,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.814285e+03,3.150037e+02,1.585656e+01,])
D.ElemHeader(loc='gp',i=9,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.295192e+03,3.896935e+02,-3.515278e+02,])
D.ElemHeader(loc='gp',i=9,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.172571e+03,-1.904109e+01,3.675262e+01,])
D.ElemHeader(loc='gp',i=9,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.404564e+03,7.225053e+02,-4.945849e+02,])
D.ElemHeader(loc='gp',i=9,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.281944e+03,3.137707e+02,-1.063045e+02,])
D.ElemHeader(loc='gp',i=10,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.383384e+03,-8.773298e+01,-1.413771e+02,])
D.ElemHeader(loc='gp',i=10,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.387173e+03,-7.510313e+01,8.758163e+01,])
D.ElemHeader(loc='gp',i=10,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.037552e+03,1.085173e+02,-1.369566e+02,])
D.ElemHeader(loc='gp',i=10,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.041341e+03,1.211472e+02,9.200208e+01,])
D.ElemHeader(loc='gp',i=11,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.393450e+03,-7.524946e+01,-9.303483e+01,])
D.ElemHeader(loc='gp',i=11,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.387833e+03,-9.397231e+01,1.301048e+02,])
D.ElemHeader(loc='gp',i=11,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.030992e+03,1.160131e+02,-9.958782e+01,])
D.ElemHeader(loc='gp',i=11,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.025375e+03,9.729025e+01,1.235518e+02,])
D.ElemHeader(loc='gp',i=12,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.212797e+03,-2.138330e+01,-5.300352e+01,])
D.ElemHeader(loc='gp',i=12,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.331088e+03,3.729218e+02,2.982084e+02,])
D.ElemHeader(loc='gp',i=12,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.216259e+03,2.796555e+02,8.500324e+01,])
D.ElemHeader(loc='gp',i=12,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.334551e+03,6.739606e+02,4.362151e+02,])
D.ElemHeader(loc='gp',i=13,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.326604e+02,-3.741986e+01,-1.055032e+02,])
D.ElemHeader(loc='gp',i=13,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.297250e+02,-4.720460e+01,-3.807167e+01,])
D.ElemHeader(loc='gp',i=13,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.253220e+02,2.037862e+01,-1.089279e+02,])
D.ElemHeader(loc='gp',i=13,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.223865e+02,1.059387e+01,-4.149633e+01,])
D.ElemHeader(loc='gp',i=14,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[4.740867e+02,-1.394483e+01,-7.749619e+01,])
D.ElemHeader(loc='gp',i=14,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[4.679715e+02,-3.432894e+01,-3.336085e+01,])
D.ElemHeader(loc='gp',i=14,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.001877e+02,2.388547e+01,-8.463063e+01,])
D.ElemHeader(loc='gp',i=14,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.940724e+02,3.501354e+00,-4.049529e+01,])
D.ElemHeader(loc='gp',i=15,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.293136e+02,4.564167e+01,-1.119073e+02,])
D.ElemHeader(loc='gp',i=15,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.638613e+02,1.608008e+02,-1.252806e+02,])
D.ElemHeader(loc='gp',i=15,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.911044e+02,3.417890e+01,-7.160164e+01,])
D.ElemHeader(loc='gp',i=15,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.256521e+02,1.493381e+02,-8.497487e+01,])
D.ElemHeader(loc='gp',i=16,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.539554e+02,-1.565236e+01,-1.568038e+02,])
D.ElemHeader(loc='gp',i=16,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.378575e+02,-6.931213e+01,-7.771050e+01,])
D.ElemHeader(loc='gp',i=16,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.799363e+02,5.214190e+01,-1.755847e+02,])
D.ElemHeader(loc='gp',i=16,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.638384e+02,-1.517862e+00,-9.649142e+01,])
D.ElemHeader(loc='gp',i=17,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.466515e+02,-6.529929e+01,-1.078049e+02,])
D.ElemHeader(loc='gp',i=17,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.639875e+02,-7.512518e+00,-7.500231e+01,])
D.ElemHeader(loc='gp',i=17,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.403733e+02,-3.718275e+01,-8.757957e+01,])
D.ElemHeader(loc='gp',i=17,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.577094e+02,2.060403e+01,-5.477694e+01,])
D.ElemHeader(loc='gp',i=18,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.878184e+02,2.849972e+01,-7.587745e+01,])
D.ElemHeader(loc='gp',i=18,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.234989e+02,1.474345e+02,-6.416672e+01,])
D.ElemHeader(loc='gp',i=18,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.212776e+02,3.853749e+01,-3.425027e+01,])
D.ElemHeader(loc='gp',i=18,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.569581e+02,1.574723e+02,-2.253955e+01,])
D.ElemHeader(loc='gp',i=19,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.407440e+02,5.412762e+01,5.336847e+01,])
D.ElemHeader(loc='gp',i=19,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.109971e+02,-4.502860e+01,3.754525e+01,])
D.ElemHeader(loc='gp',i=19,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.955348e+02,4.056485e+01,1.866380e+01,])
D.ElemHeader(loc='gp',i=19,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.657880e+02,-5.859136e+01,2.840574e+00,])
D.ElemHeader(loc='gp',i=20,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.403271e+02,-9.828139e+01,3.362783e+01,])
D.ElemHeader(loc='gp',i=20,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.682260e+02,-5.285073e+00,2.003714e+01,])
D.ElemHeader(loc='gp',i=20,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.014965e+02,-1.099305e+02,6.617654e+01,])
D.ElemHeader(loc='gp',i=20,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.293954e+02,-1.693424e+01,5.258585e+01,])
D.ElemHeader(loc='gp',i=21,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.180136e+02,2.390128e+01,2.800722e+01,])
D.ElemHeader(loc='gp',i=21,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.569900e+02,1.538224e+02,1.748056e+01,])
D.ElemHeader(loc='gp',i=21,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.879374e+02,1.487842e+01,7.347963e+01,])
D.ElemHeader(loc='gp',i=21,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.269138e+02,1.447996e+02,6.295297e+01,])
D.ElemHeader(loc='gp',i=22,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.516437e+02,2.899495e+02,3.206050e+02,])
D.ElemHeader(loc='gp',i=22,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.803866e+02,5.242579e+01,1.066140e+02,])
D.ElemHeader(loc='gp',i=22,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.402406e+02,1.065285e+02,2.374718e+02,])
D.ElemHeader(loc='gp',i=22,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.898354e+01,-1.309951e+02,2.348068e+01,])
D.ElemHeader(loc='gp',i=23,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.373829e+02,-3.092230e+01,1.319684e+02,])
D.ElemHeader(loc='gp',i=23,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.451901e+02,-4.898357e+00,5.328293e+01,])
D.ElemHeader(loc='gp',i=23,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[4.125674e+02,-9.836697e+01,1.410768e+02,])
D.ElemHeader(loc='gp',i=23,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[4.203746e+02,-7.234303e+01,6.239132e+01,])
D.ElemHeader(loc='gp',i=24,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.929890e+02,2.821621e+01,7.528254e+01,])
D.ElemHeader(loc='gp',i=24,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.291122e+02,1.486269e+02,8.691273e+01,])
D.ElemHeader(loc='gp',i=24,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.262181e+02,3.818494e+01,1.174263e+02,])
D.ElemHeader(loc='gp',i=24,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.623413e+02,1.585956e+02,1.290565e+02,])
D.ElemHeader(loc='gp',i=25,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.314916e+02,-2.107707e-02,1.671600e+02,])
D.ElemHeader(loc='gp',i=25,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.085349e+02,5.309191e+01,1.784122e+02,])
D.ElemHeader(loc='gp',i=25,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.218468e+02,-3.217022e+01,1.051948e+02,])
D.ElemHeader(loc='gp',i=25,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.988901e+02,2.094277e+01,1.164470e+02,])
D.ElemHeader(loc='gp',i=26,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.495410e+02,6.300897e+01,2.319278e+02,])
D.ElemHeader(loc='gp',i=26,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.086902e+03,1.342173e+02,2.537068e+02,])
D.ElemHeader(loc='gp',i=26,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.308732e+02,7.831141e-01,1.488514e+02,])
D.ElemHeader(loc='gp',i=26,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.068234e+03,7.199139e+01,1.706305e+02,])
D.ElemHeader(loc='gp',i=27,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.177490e+03,1.453754e+02,-7.818899e+01,])
D.ElemHeader(loc='gp',i=27,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.202048e+03,1.527427e+02,-3.074560e+01,])
D.ElemHeader(loc='gp',i=27,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.136824e+03,9.822892e+00,-8.678416e+01,])
D.ElemHeader(loc='gp',i=27,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.161382e+03,1.719019e+01,-3.934077e+01,])
D.ElemHeader(loc='gp',i=28,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.035778e+03,4.416100e+02,-4.845046e+02,])
D.ElemHeader(loc='gp',i=28,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.518620e+02,2.064351e+02,-3.585017e+02,])
D.ElemHeader(loc='gp',i=28,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.277759e+02,8.160176e+01,-2.101339e+02,])
D.ElemHeader(loc='gp',i=28,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.438595e+02,-1.535731e+02,-8.413097e+01,])
D.ElemHeader(loc='gp',i=29,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.759938e+02,4.952654e+01,1.535389e+02,])
D.ElemHeader(loc='gp',i=29,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.025480e+02,2.749279e+01,1.680808e+02,])
D.ElemHeader(loc='gp',i=29,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.635294e+02,7.978293e+00,1.792449e+02,])
D.ElemHeader(loc='gp',i=29,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.900836e+02,-1.405546e+01,1.937868e+02,])
D.ElemHeader(loc='gp',i=30,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.810210e+02,-3.423738e+01,1.680747e+02,])
D.ElemHeader(loc='gp',i=30,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.454361e+02,-1.491284e+01,1.673795e+02,])
D.ElemHeader(loc='gp',i=30,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.816169e+02,-3.225119e+01,1.455294e+02,])
D.ElemHeader(loc='gp',i=30,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.460320e+02,-1.292665e+01,1.448342e+02,])
D.ElemHeader(loc='gp',i=31,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.452112e+02,-1.050615e+02,-8.900255e+01,])
D.ElemHeader(loc='gp',i=31,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.613156e+02,-1.002302e+02,-1.076538e+02,])
D.ElemHeader(loc='gp',i=31,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.611980e+02,-5.177214e+01,-9.463906e+01,])
D.ElemHeader(loc='gp',i=31,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.773023e+02,-4.694085e+01,-1.132903e+02,])
D.ElemHeader(loc='gp',i=32,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.575767e+02,-5.107288e+01,-2.371420e+02,])
D.ElemHeader(loc='gp',i=32,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.859725e+02,-7.255414e+01,-2.458612e+02,])
D.ElemHeader(loc='gp',i=32,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.650503e+02,-2.616083e+01,-2.120805e+02,])
D.ElemHeader(loc='gp',i=32,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.934461e+02,-4.764209e+01,-2.207998e+02,])
D.ElemHeader(loc='gp',i=33,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.258728e+03,6.021972e+01,4.087966e+01,])
D.ElemHeader(loc='gp',i=33,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.984272e+02,-7.787053e+01,9.602417e+01,])
D.ElemHeader(loc='gp',i=33,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.211461e+03,-9.733603e+01,2.019849e+02,])
D.ElemHeader(loc='gp',i=33,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.511605e+02,-2.354263e+02,2.571295e+02,])
D.ElemHeader(loc='gp',i=34,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.527599e+02,-1.432193e+02,3.836400e+00,])
D.ElemHeader(loc='gp',i=34,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.345883e+02,-1.186708e+02,8.051515e+01,])
D.ElemHeader(loc='gp',i=34,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.870352e+02,-3.623014e+02,-2.480354e+01,])
D.ElemHeader(loc='gp',i=34,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.688636e+02,-3.377529e+02,5.187521e+01,])
D.ElemHeader(loc='gp',i=35,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.303891e+02,-1.401969e+02,-7.178125e+01,])
D.ElemHeader(loc='gp',i=35,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.553417e+02,-1.627111e+02,-1.449984e+00,])
D.ElemHeader(loc='gp',i=35,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.701052e+02,-3.411434e+02,-4.551468e+01,])
D.ElemHeader(loc='gp',i=35,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.950578e+02,-3.636576e+02,2.481659e+01,])
D.ElemHeader(loc='gp',i=36,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.027988e+02,-8.672349e+01,-1.011156e+02,])
D.ElemHeader(loc='gp',i=36,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.252109e+03,4.806968e+01,-4.838176e+01,])
D.ElemHeader(loc='gp',i=36,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.575984e+02,-2.373916e+02,-2.583743e+02,])
D.ElemHeader(loc='gp',i=36,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.206909e+03,-1.025984e+02,-2.056405e+02,])
D.OutputRequest(flag=0,set='EALL',eltyp='CPS4',)
D.ElemHeader(loc='na',i=1,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.362642e+03,-1.044609e+02,2.407693e+02,])
D.ElemHeader(loc='na',i=2,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.492025e+02,-3.975583e+02,1.364648e+02,])
D.ElemHeader(loc='na',i=3,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.751335e+02,-4.077056e+02,3.907576e+00,])
D.ElemHeader(loc='na',i=4,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.610590e+02,-3.936638e+02,-1.375315e+02,])
D.ElemHeader(loc='na',i=5,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.354823e+03,-1.084090e+02,-2.438992e+02,])
D.ElemHeader(loc='na',i=6,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.165180e+03,8.463457e+01,7.252901e+01,])
D.ElemHeader(loc='na',i=7,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.027519e+02,-5.467156e+01,9.738578e+01,])
D.ElemHeader(loc='na',i=8,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.248757e+02,-3.176551e+01,1.459457e+01,])
D.ElemHeader(loc='na',i=9,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.719663e+02,-5.329003e+01,-9.251857e+01,])
D.ElemHeader(loc='na',i=10,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.101543e+03,5.308471e+01,-9.316863e+01,])
D.ElemHeader(loc='na',i=11,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.804767e+02,4.710425e+00,1.086013e+02,])
D.ElemHeader(loc='na',i=12,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.586938e+02,-6.710787e+00,1.372331e+02,])
D.ElemHeader(loc='na',i=13,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.908732e+02,-2.552798e+01,3.404077e+01,])
D.ElemHeader(loc='na',i=14,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.018268e+03,-4.102876e+01,-1.341225e+02,])
D.ElemHeader(loc='na',i=15,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.872113e+02,-2.304803e+02,-9.790494e+01,])
D.ElemHeader(loc='na',i=16,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.521349e+02,-4.311975e+01,7.112059e+01,])
D.ElemHeader(loc='na',i=17,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.643677e+02,1.293667e+02,1.052703e+02,])
D.ElemHeader(loc='na',i=18,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.557315e+03,3.002704e+02,-7.459960e+01,])
D.ElemHeader(loc='na',i=19,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.147890e+03,6.194824e+02,-4.434512e+02,])
D.ElemHeader(loc='na',i=20,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[4.460372e+00,2.521273e+02,-4.128081e+02,])
D.ElemHeader(loc='na',i=21,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.277212e+02,-1.113343e+02,5.357826e+01,])
D.ElemHeader(loc='na',i=22,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.142412e+03,1.015792e+02,5.113894e+01,])
D.ElemHeader(loc='na',i=23,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.010277e+03,3.328636e+01,-5.404423e+00,])
D.ElemHeader(loc='na',i=24,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.459364e+03,2.308540e+02,-1.178449e+02,])
D.ElemHeader(loc='na',i=25,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.246797e+01,-1.528092e+02,2.434256e+00,])
D.ElemHeader(loc='na',i=26,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.131616e+03,1.126326e+01,2.400898e+00,])
D.ElemHeader(loc='na',i=27,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.202967e+03,1.741912e+01,-1.894569e+00,])
D.ElemHeader(loc='na',i=28,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.274287e+03,1.952378e+02,-3.118199e+00,])
D.ElemHeader(loc='na',i=29,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[9.519920e+01,-1.241317e+02,-4.552138e+01,])
D.ElemHeader(loc='na',i=30,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.143563e+03,8.618167e+01,-4.228091e+01,])
D.ElemHeader(loc='na',i=31,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.052392e+03,2.689680e+01,3.250776e+00,])
D.ElemHeader(loc='na',i=32,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.398465e+03,2.029809e+02,1.048964e+02,])
D.ElemHeader(loc='na',i=33,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[2.264967e+02,-6.600984e+01,-3.171035e+01,])
D.ElemHeader(loc='na',i=34,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.726841e+02,9.784288e+01,-5.308207e+01,])
D.ElemHeader(loc='na',i=35,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.487818e+03,2.518284e+02,8.241886e+01,])
D.ElemHeader(loc='na',i=36,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[1.878844e+03,4.814647e+02,3.521315e+02,])
D.ElemHeader(loc='na',i=37,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[-5.746651e+01,1.263315e+02,2.853690e+02,])
D.ElemHeader(loc='na',i=38,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[3.441502e+02,-4.613617e+01,-5.158798e+01,])
D.ElemHeader(loc='na',i=39,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.989163e+02,-3.428699e+01,-7.264136e+01,])
D.ElemHeader(loc='na',i=40,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[8.424946e+02,-6.220039e+01,-2.386341e+01,])
D.ElemHeader(loc='na',i=41,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.775828e+02,-5.780532e+01,7.089071e+01,])
D.ElemHeader(loc='na',i=42,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.326707e+01,-2.088252e+02,4.396857e+01,])
D.ElemHeader(loc='na',i=43,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[5.251154e+02,-2.397537e+01,-6.818006e+01,])
D.ElemHeader(loc='na',i=44,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.002509e+02,-4.410202e+00,-6.117625e+01,])
D.ElemHeader(loc='na',i=45,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[7.065576e+02,1.584812e+01,-1.007557e+01,])
D.ElemHeader(loc='na',i=46,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.464992e+02,-3.332545e+00,5.756244e+01,])
D.ElemHeader(loc='na',i=47,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[4.830514e+02,-4.487184e+01,8.275968e+01,])
D.ElemHeader(loc='na',i=48,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.904922e+02,2.071477e+02,-1.449284e+02,])
D.ElemHeader(loc='na',i=49,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.243119e+02,1.872936e+02,-7.511689e+01,])
D.ElemHeader(loc='na',i=50,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.822650e+02,2.046795e+02,-3.016525e+00,])
D.ElemHeader(loc='na',i=51,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.301715e+02,1.890514e+02,7.574401e+01,])
D.ElemHeader(loc='na',i=52,ip=0,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('S',[6.877260e+02,2.063178e+02,1.487391e+02,])
D.OutputRequest(flag=0,set='       4',eltyp='CPS4',)
D.ElemHeader(loc='gp',i=13,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=13,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=13,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=13,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=14,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=14,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=14,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=14,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=15,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=15,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=15,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=15,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=16,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=16,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=16,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=16,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=17,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=17,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=17,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=17,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=18,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=18,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=18,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=18,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=19,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=19,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=19,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=19,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=20,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=20,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=20,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=20,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=21,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=21,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=21,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=21,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=22,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=22,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=22,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=22,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=23,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=23,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=23,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=23,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=24,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=24,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=24,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.ElemHeader(loc='gp',i=24,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.Unknown(401)
D.OutputRequest(flag=0,set='       4',eltyp='CPS4',)
D.ElemHeader(loc='gp',i=13,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[3.973715e+02,4.260084e+02,-9.841351e+01,-6.538390e+01,0.000000e+00,3.606244e+02,3.849894e+02,])
D.ElemHeader(loc='gp',i=13,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[3.617454e+02,3.845435e+02,-9.417346e+01,-5.101157e+01,0.000000e+00,3.335319e+02,3.535176e+02,])
D.ElemHeader(loc='gp',i=13,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.488797e+02,5.499354e+02,-1.819002e+02,-2.117395e+00,0.000000e+00,5.478180e+02,5.488705e+02,])
D.ElemHeader(loc='gp',i=13,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.221414e+02,5.257292e+02,-1.776601e+02,0.000000e+00,7.251170e+00,5.257292e+02,5.220281e+02,])
D.ElemHeader(loc='gp',i=14,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[4.995805e+02,5.120522e+02,-1.533806e+02,-2.595514e+01,0.000000e+00,4.860970e+02,4.980601e+02,])
D.ElemHeader(loc='gp',i=14,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[4.894687e+02,5.067124e+02,-1.445475e+02,-3.653495e+01,0.000000e+00,4.701775e+02,4.863867e+02,])
D.ElemHeader(loc='gp',i=14,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[6.065864e+02,6.123587e+02,-2.080244e+02,0.000000e+00,1.171441e+01,6.123587e+02,6.063318e+02,])
D.ElemHeader(loc='gp',i=14,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.964678e+02,5.968363e+02,-1.991913e+02,0.000000e+00,7.375381e-01,5.968363e+02,5.964668e+02,])
D.ElemHeader(loc='gp',i=15,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[6.379386e+02,6.500340e+02,-2.249851e+02,0.000000e+00,2.492126e+01,6.500340e+02,6.368419e+02,])
D.ElemHeader(loc='gp',i=15,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[6.378910e+02,6.933341e+02,-2.748874e+02,0.000000e+00,1.313281e+02,6.933341e+02,6.063453e+02,])
D.ElemHeader(loc='gp',i=15,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.880048e+02,6.001626e+02,-2.084278e+02,0.000000e+00,2.512070e+01,6.001626e+02,5.867957e+02,])
D.ElemHeader(loc='gp',i=15,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.847828e+02,6.403577e+02,-2.583301e+02,0.000000e+00,1.346325e+02,6.403577e+02,5.482621e+02,])
D.ElemHeader(loc='gp',i=16,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[7.154725e+02,7.394081e+02,-2.127677e+02,-5.055251e+01,0.000000e+00,6.888556e+02,7.114378e+02,])
D.ElemHeader(loc='gp',i=16,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[6.884725e+02,7.240473e+02,-1.895151e+02,-7.775099e+01,0.000000e+00,6.462963e+02,6.784897e+02,])
D.ElemHeader(loc='gp',i=16,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[9.075325e+02,9.156400e+02,-3.106927e+02,0.000000e+00,1.643829e+01,9.156400e+02,9.071974e+02,])
D.ElemHeader(loc='gp',i=16,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[8.806032e+02,8.866137e+02,-2.874402e+02,-1.214658e+01,0.000000e+00,8.744671e+02,8.804147e+02,])
D.ElemHeader(loc='gp',i=17,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[7.067629e+02,7.438827e+02,-1.937841e+02,-8.126528e+01,0.000000e+00,6.626175e+02,6.961353e+02,])
D.ElemHeader(loc='gp',i=17,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[6.802942e+02,6.880507e+02,-2.188250e+02,-1.578782e+01,0.000000e+00,6.722629e+02,6.798818e+02,])
D.ElemHeader(loc='gp',i=17,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[7.746450e+02,7.970409e+02,-2.343968e+02,-4.692515e+01,0.000000e+00,7.501157e+02,7.714375e+02,])
D.ElemHeader(loc='gp',i=17,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[7.536164e+02,7.617578e+02,-2.594378e+02,0.000000e+00,1.655559e+01,7.617578e+02,7.532071e+02,])
D.ElemHeader(loc='gp',i=18,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.889501e+02,5.979292e+02,-2.054394e+02,0.000000e+00,1.838892e+01,5.979292e+02,5.883037e+02,])
D.ElemHeader(loc='gp',i=18,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.752518e+02,6.319960e+02,-2.569778e+02,0.000000e+00,1.389374e+02,6.319960e+02,5.355140e+02,])
D.ElemHeader(loc='gp',i=18,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[6.058447e+02,6.232838e+02,-2.199384e+02,0.000000e+00,3.653135e+01,6.232838e+02,6.033592e+02,])
D.ElemHeader(loc='gp',i=18,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.953679e+02,6.579732e+02,-2.714768e+02,0.000000e+00,1.564572e+02,6.579732e+02,5.461701e+02,])
D.ElemHeader(loc='gp',i=19,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[9.195398e+02,9.439449e+02,-3.316239e+02,0.000000e+00,5.092674e+01,9.439449e+02,9.163588e+02,])
D.ElemHeader(loc='gp',i=19,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[9.365859e+02,9.589702e+02,-2.886562e+02,-4.650082e+01,0.000000e+00,9.124693e+02,9.339834e+02,])
D.ElemHeader(loc='gp',i=19,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[8.765534e+02,8.959420e+02,-3.120332e+02,0.000000e+00,4.015762e+01,8.959420e+02,8.744801e+02,])
D.ElemHeader(loc='gp',i=19,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[8.965342e+02,9.243968e+02,-2.690655e+02,-5.860009e+01,0.000000e+00,8.657967e+02,8.922101e+02,])
D.ElemHeader(loc='gp',i=20,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[7.961760e+02,8.413011e+02,-2.140152e+02,-9.962769e+01,0.000000e+00,7.416734e+02,7.819678e+02,])
D.ElemHeader(loc='gp',i=20,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[7.716629e+02,7.745484e+02,-2.543136e+02,-5.803770e+00,0.000000e+00,7.687446e+02,7.716138e+02,])
D.ElemHeader(loc='gp',i=20,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[7.709968e+02,8.221504e+02,-1.971887e+02,-1.152922e+02,0.000000e+00,7.068582e+02,7.512352e+02,])
D.ElemHeader(loc='gp',i=20,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[7.436075e+02,7.537036e+02,-2.374871e+02,-2.062119e+01,0.000000e+00,7.330824e+02,7.429637e+02,])
D.ElemHeader(loc='gp',i=21,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[6.083535e+02,6.193310e+02,-2.139716e+02,0.000000e+00,2.258390e+01,6.193310e+02,6.074093e+02,])
D.ElemHeader(loc='gp',i=21,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.959481e+02,6.575966e+02,-2.702708e+02,0.000000e+00,1.532159e+02,6.575966e+02,5.489503e+02,])
D.ElemHeader(loc='gp',i=21,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.944258e+02,5.972092e+02,-2.009386e+02,0.000000e+00,5.606621e+00,5.972092e+02,5.943663e+02,])
D.ElemHeader(loc='gp',i=21,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.788784e+02,6.349984e+02,-2.572378e+02,0.000000e+00,1.367150e+02,6.349984e+02,5.407355e+02,])
D.ElemHeader(loc='gp',i=22,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[8.599204e+02,9.158637e+02,-3.471977e+02,0.000000e+00,1.257295e+02,9.158637e+02,8.388670e+02,])
D.ElemHeader(loc='gp',i=22,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[6.812519e+02,6.979936e+02,-2.442708e+02,0.000000e+00,3.481875e+01,6.979936e+02,6.792456e+02,])
D.ElemHeader(loc='gp',i=22,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[4.304122e+02,4.761385e+02,-8.225640e+01,-1.146846e+02,0.000000e+00,3.614538e+02,3.937770e+02,])
D.ElemHeader(loc='gp',i=22,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[1.805796e+02,2.054187e+02,2.067053e+01,-1.337151e+02,0.000000e+00,7.170355e+01,-1.428330e+02,])
D.ElemHeader(loc='gp',i=23,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[6.922207e+02,7.185364e+02,-2.021535e+02,-5.603786e+01,0.000000e+00,6.624985e+02,6.870897e+02,])
D.ElemHeader(loc='gp',i=23,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[6.541956e+02,6.587650e+02,-2.134306e+02,-9.236613e+00,0.000000e+00,6.495284e+02,6.540489e+02,])
D.ElemHeader(loc='gp',i=23,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.293192e+02,5.836647e+02,-1.047335e+02,-1.347322e+02,0.000000e+00,4.489326e+02,4.884544e+02,])
D.ElemHeader(loc='gp',i=23,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[4.733260e+02,5.082729e+02,-1.160105e+02,-8.012067e+01,0.000000e+00,4.281522e+02,4.576954e+02,])
D.ElemHeader(loc='gp',i=24,gp=1,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.938877e+02,6.028517e+02,-2.070684e+02,0.000000e+00,1.835350e+01,6.028517e+02,5.932491e+02,])
D.ElemHeader(loc='gp',i=24,gp=2,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[5.890930e+02,6.443502e+02,-2.592464e+02,0.000000e+00,1.333889e+02,6.443502e+02,5.535639e+02,])
D.ElemHeader(loc='gp',i=24,gp=3,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[6.411411e+02,6.488002e+02,-2.214677e+02,0.000000e+00,1.560291e+01,6.488002e+02,6.407137e+02,])
D.ElemHeader(loc='gp',i=24,gp=4,sp=0,ndi=2,nshr=1,nsfc=0,)
D.ElemOutput('SINV',[6.393519e+02,6.934800e+02,-2.736456e+02,0.000000e+00,1.274570e+02,6.934800e+02,6.097774e+02,])
D.OutputRequest(flag=1,set='NALL')
D.NodeOutput('U',1,[-2.262588e-02,-1.131096e-01,])
D.NodeOutput('U',2,[-4.075221e-02,-1.155891e-01,])
D.NodeOutput('U',3,[-6.389810e-02,-1.185427e-01,])
D.NodeOutput('U',4,[-8.869069e-02,-1.214852e-01,])
D.NodeOutput('U',5,[-1.184498e-01,-1.239724e-01,])
D.NodeOutput('U',6,[-1.589168e-02,-9.195916e-02,])
D.NodeOutput('U',7,[-3.752288e-02,-9.323897e-02,])
D.NodeOutput('U',8,[-6.004571e-02,-9.452435e-02,])
D.NodeOutput('U',9,[-8.540973e-02,-9.593682e-02,])
D.NodeOutput('U',10,[-1.117476e-01,-9.727681e-02,])
D.NodeOutput('U',11,[-1.161342e-02,-6.802524e-02,])
D.NodeOutput('U',12,[-3.380387e-02,-6.898869e-02,])
D.NodeOutput('U',13,[-5.583621e-02,-7.028920e-02,])
D.NodeOutput('U',14,[-8.107761e-02,-7.210743e-02,])
D.NodeOutput('U',15,[-1.079607e-01,-7.363711e-02,])
D.NodeOutput('U',16,[-9.330678e-03,-4.485012e-02,])
D.NodeOutput('U',17,[-3.017306e-02,-4.556877e-02,])
D.NodeOutput('U',18,[-5.039806e-02,-4.639547e-02,])
D.NodeOutput('U',19,[-7.545247e-02,-4.718156e-02,])
D.NodeOutput('U',20,[-1.083046e-01,-4.597002e-02,])
D.NodeOutput('U',21,[-8.086167e-03,-2.455388e-02,])
D.NodeOutput('U',22,[-2.486128e-02,-2.527683e-02,])
D.NodeOutput('U',23,[-4.166004e-02,-2.688378e-02,])
D.NodeOutput('U',24,[-5.826732e-02,-3.078212e-02,])
D.NodeOutput('U',25,[-7.773949e-03,-9.953970e-03,])
D.NodeOutput('U',26,[-1.942969e-02,-1.071025e-02,])
D.NodeOutput('U',27,[-3.107158e-02,-1.312519e-02,])
D.NodeOutput('U',28,[-4.269781e-02,-1.692736e-02,])
D.NodeOutput('U',29,[-7.522779e-03,-1.181251e-03,])
D.NodeOutput('U',30,[-1.396044e-02,-1.918892e-03,])
D.NodeOutput('U',31,[-2.042582e-02,-3.663254e-03,])
D.NodeOutput('U',32,[-2.719760e-02,-7.607981e-03,])
D.NodeOutput('U',33,[-6.494348e-03,1.777813e-03,])
D.NodeOutput('U',34,[-8.630573e-03,1.130669e-03,])
D.NodeOutput('U',35,[-1.131966e-02,1.936363e-04,])
D.NodeOutput('U',36,[-1.045075e-02,-7.487227e-04,])
D.NodeOutput('U',37,[-4.336522e-03,-5.514069e-05,])
D.NodeOutput('U',38,[-5.143072e-03,2.294611e-03,])
D.NodeOutput('U',39,[-5.812309e-03,1.572963e-03,])
D.NodeOutput('U',40,[-6.780707e-03,2.273466e-04,])
D.NodeOutput('U',41,[-6.256029e-03,-1.470021e-03,])
D.NodeOutput('U',42,[-4.797227e-03,-2.585022e-03,])
D.NodeOutput('U',43,[-3.035497e-03,1.820357e-03,])
D.NodeOutput('U',44,[-2.744560e-03,9.434973e-04,])
D.NodeOutput('U',45,[-2.999329e-03,3.788869e-05,])
D.NodeOutput('U',46,[-2.770319e-03,-9.513739e-04,])
D.NodeOutput('U',47,[-3.023337e-03,-1.868221e-03,])
D.NodeOutput('U',48,[-8.419209e-50,2.405488e-50,])
D.NodeOutput('U',49,[-6.585573e-36,1.885447e-36,])
D.NodeOutput('U',50,[-5.887047e-36,8.950210e-37,])
D.NodeOutput('U',51,[-5.125459e-36,3.816183e-37,])
D.NodeOutput('U',52,[0.000000e+00,-3.340956e-52,])
D.EndIncrement()
D.Export()
# End
