# This can only be run as an app!

import random
import pyformex as pf
from pyformex import script
from pyformex.gui.draw import scriptRelease, askItems, _I


def runAll(self, startfrom='A', stopat='[', count=-1, recursive=True,
           timeout=1.0, pause=1.0, shuffle=False):
    """Run all apps with a name in the range [startfrom,stopat[.

    Runs the apps with a name >= `startfrom` and < `stopat`.
    The default will run all apps starting with a capital (like
    the examples). Specify None to disable the limit.
    If count is positive, at most count scripts are executed.
    If recursive is True, also the files in submenu are played.
    If random is True, the files in any submenu are shuffled before running.
    """
    from pyformex.gui.draw import layout, reset, sleep
    from pyformex.gui import widgets

    if self.mode != 'app':
        print("I can only do this in 'App' mode, not 'Script' mode")
        return

    files = self.listApps()
    print(f"Total number of apps: {len(files)}")
    print(f"Start from {startfrom}; stop at {stopat}; count {count}; random {shuffle}")
    if startfrom is not None:
        files = [f for f in files if f.split('.')[-1] >= startfrom]
    if stopat is not None:
        files = [f for f in files if f.split('.')[-1] < stopat]
    if shuffle:
        random.shuffle(files)
    if count >= 0:
        files = files[:count]

    print(f"Apps to play: {len(files)}" )
    print(files)

    if files:
        # Run these appss
        pf.GUI.enableButtons(pf.GUI.actions, ['Stop'], True)
        pf.GUI.runallmode = True
        save = widgets.input_timeout
        pf.GUI.drawlock.free()
        widgets.input_timeout = timeout
        try:
            for f in files:
                layout(1)
                reset()
                pf.PF.clear()
                print("Running app '%s'" % f)
                #self.runApp(f)
                script.runAny(f, wait=True)
                script.breakpt(msg="Breakpoint from runall")
                if script.exitrequested:
                    break
                sleep(pause)
        finally:
            widgets.input_timeout = save
            pf.GUI.drawlock.allow()
            pf.GUI.runallmode = False
            pf.GUI.enableButtons(pf.GUI.actions, ['Stop'], False)


def run():
    my_name = pf.GUI.curfile.bg.buttons()[1].text()
    appmenu = pf.GUI.menu['App']
    ex_menu = appmenu['Examples']['Byname']
    res = askItems([
        _I('startfrom', 'A', text='Start from'),
        _I('stopat', '[', text='Stop at'),
        _I('count', -1, text='Count'),
        _I('shuffle', False, text='Play in random order'),
        _I('timeout', 0.5, text='Timeout dialogs after (secs)'),
        _I('pause', 1.0, text='Time to pause after each app'),
    ])
    if res:
        print(res)
        scriptRelease('__auto/app__')
        runAll(ex_menu, **res)
#        ex_menu.runAll(**res)
    pf.GUI.setcurfile(my_name)


if __name__ == "__draw__":

    pf.warning("This can only be run as an App, not as a Script!")
