#
##
##  This file is part of pyFormex 1.0.6  (Tue Mar 19 11:06:48 CET 2019)
##  pyFormex is a tool for generating, manipulating and transforming 3D
##  geometrical models by sequences of mathematical operations.
##  Home page: http://pyformex.org
##  Project page:  http://savannah.nongnu.org/projects/pyformex/
##  Copyright 2004-2018 (C) Benedict Verhegghe (benedict.verhegghe@ugent.be)
##  Distributed under the GNU General Public License version 3 or later.
##
##  This program is free software: you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##
##  You should have received a copy of the GNU General Public License
##  along with this program.  If not, see http://www.gnu.org/licenses/.
##

# This helps in getting used to future Python print syntax
from __future__ import print_function

from pyformex.gui.draw import *


# Definitions
def run():

    """
    Problem for Benedict.
    Mesh.connect is not working well:
    If I add/remove the .compact() the result is different.
    Without .compact() the result is wrong because the hex degenerates into a quad mesh. Why?

    Please do not share the pgf because they are confidential
    """
    chdir(__file__)
    clear()
    Q0=Mesh.read('q0').select([0,]).compact()
    print(Q0.elems)
    print(Q0.coords[Q0.elems])
    F0 = Q0.toFormex()
    print(F0.coords)
    draw(F0,color=blue)
    drawNumbers(F0.coords)
    Q1=Mesh.read('q1').select([0,]).compact()
    print(Q1.elems)
    print(Q1.coords[Q0.elems])
    F1 = Q1.toFormex()
    print(F1.coords)
    draw(F1,color=red)
    drawNumbers(F1.coords)
    #return


    #### WITH COMPACT
    q0=Q0.compact()
    q1=Q1.compact()
    clear()
    draw(q0,color=blue)
    drawNumbers(q0.coords)
    draw(q1,color=red)
    drawNumbers(q1.coords)
    print(q0.elems)
    print(q1.elems)
    return
    h0=q0.connect(q1,1)
    draw(h0,color='blue',mode='wireframe')
    C0 =h0.coords[h0.elems]
    print (C0)
    return

    ## WITHOUT COMPACT
    h1=Q0.connect(Q1,1)
    draw(h1,color='red')
    C1 = h1.coords[h1.elems]
    print (C1)
    print(C0-C1)
    return

    clear()
    draw(F0,color=red)
    drawNumbers(F0.coords)
    draw(F1,color=blue)
    drawNumbers(F1.coords)

    F = connect([F0,F0,F0,F0,F1,F1,F1,F1],nodid=[0,1,2,3,0,1,2,3])
    F.eltype = 'hex8'
    print(F.coords)
    print(F.coords-C0)
    #()
    draw(F,color=yellow)
    #return
    """why C0 and C1 are not the same?
    Is there a hidden fuse() ??
    Zoom to the black points to see h1 (red)
    """
    return
    draw(h1.compact().coords,marksize=10)
    drawNumbers(h1.compact().coords,mode='smooth')



if __name__ == '__draw__':
    print("Running as a script")
    run()


# End
