import gtk
import string
import gobject

#from plugins.ftp import Ftp

class GenericTask(gtk.VBox):
    # Constructor of the class. Calls the self.initWidget method to
    # initialize internal widget object
    def __init__(self):
        #gobject.GObject.__init__(self)
        gtk.VBox.__init__(self)
        self.command = ""
        self.arguments = []
        self.widget = self.initWidget()
        return

    # Well, see Python documentation to learn more about this method ;-)
    def __str__(self):
        return "Generic task"


    # Returns a command line ready to be executed by a shell
    # WARNING: Role of this method has to be defined. Not clear at the
    #          moment
    def getCmdLine(self):
        if len(self.arguments) > 0:
            return self.command+" "+string.join(self.arguments," ")
        else:
            return self.command

    # This method should be called whenever the Task widget
    # elements are changed.
    def on_changed(self,obj):
        self.changedSignalPreProcessing()
        self.emit('task-changed')

    #def getWidget(self):
    #    return self.widget

    ###########################################################
    #                                                         #
    # Class methods that has to be overwritten by child class #
    #                                                         #
    ###########################################################

    def initWidget(self):
        tmp = gtk.Label("Widget not set")
        self.pack_start(tmp)

    def changedSignalPreProcessing(self):
        return

    
# Add a new signal to our GenericTask object
gobject.signal_new("task-changed", GenericTask,
                   gobject.SIGNAL_RUN_LAST,
                   gobject.TYPE_NONE,
                   ())


# This class is used to build Task objects according to the command passed
# to the Taskfactory::getTask() method
class TaskFactory:
    def getTask(self,command):
        return CmdLineTask(command)



class CmdLineTask(GenericTask):
    def __init__(self,cmdLine):
        # Call parent constructor
        GenericTask.__init__(self)

        # Parse command line provided as parameter
        self.__parseCmdLine(cmdLine)

        # Set entries of text entry widgets
        self.cmdEntry.set_text(self.command)
        self.optionsEntry.set_text(string.join(self.arguments," "))

        # and connect 'changed' signals to those entries

        self.cmdEntry.connect('changed',self.on_changed)
        self.optionsEntry.connect('changed',self.on_changed)

        return

    def __str__(self):
        return "Command line task: " + self.command


    def __parseCmdLine(self,cmdLine):
        self.command = string.split(cmdLine,' ')[0]
        self.arguments = string.split(cmdLine,' ')[1:]

    def initWidget (self):
        self.cmdEntry = gtk.Entry(max = 0)
        self.cmdEntry.set_text(self.command)

        self.optionsEntry = gtk.Entry(max = 0)
        self.optionsEntry.set_text(string.join(self.arguments))
        
        table = gtk.Table(2,2)
        table.attach(gtk.Label("Command to run:"),0,1,0,1,
                     xpadding = 10,ypadding=10)
        table.attach(gtk.Label("Command options:"),0,1,1,2,
                     xpadding = 10,ypadding=10)
        table.attach(self.cmdEntry,1,2,0,1)
        table.attach(self.optionsEntry,1,2,1,2)

        table.show_all()

        self.pack_start(table)

    def changedSignalPreProcessing(self):
        self.__parseCmdLine(self.cmdEntry.get_text()+" "+
                          self.optionsEntry.get_text())

# This class will be the parent class of all the plugin class. Its API
# still have to be defined ;-)
class PluginTask(GenericTask):
    def __init__(self):
        return
