import time


class SyntacticEngine:
    def __init__(self,scheduler):
        self.scheduler = scheduler
        return

    def getSchedulerName(self):
        return str(self.scheduler)

    def getNextRunString(self):
        # Determine when the task will occur next
        values = self.scheduler.getAttributes ()

        baseTimeStamp = time.time()
        baseTime = time.gmtime(baseTimeStamp)

        nextTimeStamp = -1
        found = False
        year = baseTime.tm_year

        while (not found):
            for month in values [3]:
                for day in values [2]:
                    for weekday in values [4]:
                        weekday = weekday - 1
                        try:
                            testTimeStamp = time.mktime ([year, month, day,
                                                          baseTime.tm_hour,
                                                          baseTime.tm_min,
                                                          baseTime.tm_sec,
                                                          weekday, -1, -1])
                        except OverflowError, ValueError:
                            return "Value outside of system limits"


                        testTimeStamp = testTimeStamp + 1
                        test = time.gmtime(testTimeStamp)
                            
                        if (test.tm_mday != day or test.tm_wday != weekday):
                            testTimeStamp = -1
 
                        if (testTimeStamp > 0):
                            if (testTimeStamp > baseTimeStamp and
                                (testTimeStamp < nextTimeStamp or
                                 nextTimeStamp < 0)):
                                nextTimeStamp = testTimeStamp

                                # Now we have the day, try to find a time
                                nextTime = time.gmtime(nextTimeStamp)
                                if (nextTime.tm_mday == baseTime.tm_mday and
                                    nextTime.tm_mon == baseTime.tm_mon and
                                    nextTime.year == baseTime.year):
                                    minMinute = baseTime.minute
                                    minHour = baseTime.hour
                                else:
                                    minMinute = 0
                                    minHour = 0

                                hour = -1
                                for val in values [1]:
                                    if (val >= minHour and
                                        (val < hour or hour < 0)):
                                        hour = val

                                    if (hour >= 0):
                                        minute = -1
                                        for val in values [0]:
                                            if ((val > minMinute or
                                                 hour > minHour) and
                                                (val < minute or minute < 0)):
                                                minute = val

                                        if (minute >= 0):
                                            nextTimeStamp =  time.mktime( \
                                                [nextTime.tm_year,
                                                 nextTime.tm_mon,
                                                 nextTime.tm_mday,
                                                 hour, minute,0,
                                                 nextTime.tm_wday, -1, -1])
                                        else:
                                            nextTimeStamp = -1
                                    else:
                                        nextTimeStamp = -1
                                         
                                if (nextTimeStamp > 0):
                                    found = True

            year = year + 1

        if (nextTimeStamp > 0):
            entryNextTime = time.strftime ("%x %X",
                                           time.localtime(nextTimeStamp))
        else:
            entryNextTime = "Never"

        return entryNextTime

