import gtk
import gtk.glade
import gobject

# import glade file path string from config module
from config import GLADE_FILE_PATH

from lib.task import GenericTask
from lib.task import CmdLineTask
from lib.scheduler import Scheduler

# The new task assistant's class.
class NewTask(gobject.GObject):

    def __init__ (self, parent):
        # Initialize parent GObject
        gobject.GObject.__init__(self)

        # Store the assistant's caller window
        self.parent = parent

        # Store the current page.
        self.currentPage = 1

        # Store a dictionnary of page definitions
        self.pages = {}
        
        # We load the widgets and the callbacks from the glade file.
        self.widgetTree = gtk.glade.XML (GLADE_FILE_PATH + "/newtask.glade")

    	dict = {}
    	for key in dir(self.__class__):
    	    dict[key] = getattr(self, key)
        self.widgetTree.signal_autoconnect (dict)

        # It's the base widget.
        self.win = self.widgetTree.get_widget ("newtask")

        # Center the window on the parent.
        self.win.set_transient_for (self.parent.win)
        self.win.set_position (gtk.WIN_POS_CENTER_ON_PARENT)

        # Sets the color of the bars.
        frameBackground = gtk.gdk.color_parse (self.parent.normalColor)
        mainBackground = gtk.gdk.color_parse (self.parent.selectedColor)

        self.widgetTree.get_widget ("titlebar").modify_bg (gtk.STATE_NORMAL, frameBackground)
        self.widgetTree.get_widget ("topbar").modify_bg (gtk.STATE_NORMAL, frameBackground)
        self.widgetTree.get_widget ("bottombar").modify_bg (gtk.STATE_NORMAL, frameBackground)
        self.widgetTree.get_widget ("leftbar").modify_bg (gtk.STATE_NORMAL, frameBackground)
        self.widgetTree.get_widget ("rightbar").modify_bg (gtk.STATE_NORMAL, frameBackground)
        self.widgetTree.get_widget ("mainbar").modify_bg (gtk.STATE_NORMAL, mainBackground)
        self.widgetTree.get_widget ("widgetbar").modify_bg (gtk.STATE_NORMAL, mainBackground)

        # intialize page widgets
        self.__initPageWidgets()

        # Displays the assistant.
        self.win.show ()

        # Update the currently viewed page
        self.__updatePage ()


    ###############################################
    #                                             #
    #            SIGNALS CALLBACKS                #
    #                                             #
    ###############################################

    def on_newtask_delete_event (self, obj, event):
        self.quit ()

    def on_back_button_clicked (self, obj):
        self.goBack ()

    def on_forward_button_clicked (self, obj):
        self.goForward ()

    def on_cancel_button_clicked (self, obj):
        self.quit ()

    def on_task_type_selection_changed(self,obj,data):
        model, iter = data.get_selected()
        self.taskTypeChanged(model.get_value(iter,0))
    
    ###############################################
    #                                             #
    #            CLASS METHODS                    #
    #                                             #
    ###############################################

    # returns a task type selector
    def __getTaskTypeSelector(self):
        test = {}
        test[1] = "Basic command line"
        return(TaskTypeSelector(test))

    # initialize page widgets known at build time
    def __initPageWidgets(self):
        # The first page is the task type selection page.
        frame = gtk.Viewport ()

        self.taskTypeSelector = self.__getTaskTypeSelector()
        selection = self.taskTypeSelector.getSelection()
        selection.connect("changed",
                          self.on_task_type_selection_changed,
                          selection)
        frame.add (self.taskTypeSelector)

        # This is the place where we display comments about of each task type
        comment = gtk.Label ("Use the list on the left to choose the type of task you would like to add.")
        comment.set_padding (4, 4)
        comment.set_alignment (0.0, 0.0)
        comment.set_line_wrap (gtk.TRUE)
        comment.set_size_request (340, -1)

        # The page is assembled and displayed.
        box = gtk.HBox ()        
        box.add (frame)
        box.set_child_packing (frame, False, False, 0, 0)
        box.add (comment)
        box.show_all()

        self.pages[1] = { "title" : "Choose the type of task",
                          "widget" : box }


        # This page is the properties page. It depends on the task type.
        label = gtk.Label("PAGE 2 NOT SET")
        label.show()
        self.pages[2] = { "title" : "Configure the task",
                          "widget" :  label }

        label = gtk.Label ("PAGE 3 NOT SET")
        label.show()
        self.pages[3] = { "title" : "Configure the task",
                          "widget" :  label }


    def __updateNavButtons(self):
        #If we are of the first page, make the back button insensitive
        backButton =  self.widgetTree.get_widget ("back_button")
        backButton.set_sensitive (self.currentPage != 1)

        # Prevent from going forward without selecting a task type.
        forwardButton = self.widgetTree.get_widget ("forward_button")
        taskType = self.taskTypeSelector.getSelected()
        forwardButton.set_sensitive (taskType != None)
        # If we are of the last page, the button's text to "OK".
        # else, it's "Forward".
        forwardButton.set_use_stock (True)
        if (self.currentPage == len(self.pages)):
            forwardButton.set_label (eval('gtk.STOCK_OK'))
        else:
            forwardButton.set_label (eval('gtk.STOCK_GO_FORWARD'))

    def __updatePage (self,lastPage = None):
        self.__updateNavButtons()

        # Set the assistant's title.
        title = '<span size="xx-large" color="' + self.parent.selectedColor + '"><b>' + self.pages [self.currentPage]["title"] + '</b></span>'
        #title = self.pages [self.currentPage]["title"]
        self.widgetTree.get_widget ("title").set_markup (title)

        # if lastPage is not None, remove it from widgetbar
        if(lastPage != None):
            page = self.pages[lastPage]["widget"]
            self.widgetTree.get_widget ("widgetbar").remove(page)
        page = self.pages[self.currentPage]["widget"]
        page.show_all()
        self.widgetTree.get_widget ("widgetbar").add (page)

        return

    def goForward (self):
        # If we're on the first page, build the second page according
        # to the selected task type
        if (self.currentPage == 1):
            self.pages [2]["widget"] = CmdLineTask("")

        # If we are on the 2nd page, build the third page according
        # to the defined task
        if (self.currentPage == 2):
            self.pages [3]["widget"] = Scheduler ([[0],[0],[1],[1],[0],[]],
                                                  self.pages [2]["widget"])

        if(self.currentPage == 3):
            # create new Scheduler object to be sent as signal data.
            # this is to avoid it to be destroyed with NewTask window :-(
            scheduler = self.pages[3]["widget"]
            data = Scheduler(scheduler.getAttributes()[0:6],
                             scheduler.getAttributes()[6],
                             scheduler.isRecurrent(),
                             scheduler.isActive())
            self.emit("newtask-validate",data)
            self.quit()

        # If we're not on the last page, go forward.
        # Else, finish the assistant.
        if (self.currentPage < len(self.pages)):
            self.currentPage = self.currentPage + 1
            self.__updatePage (self.currentPage - 1)

    def goBack (self):
        # If we're not on the first page, go back
        if (self.currentPage > 1):
            self.currentPage = self.currentPage - 1
            self.__updatePage (self.currentPage + 1)



    # Unreferences the main window's widgets.
    def quit (self):
        self.win.destroy ()

    ###############################################
    #                                             #
    #         TO BE REWRITEN OR DELETED           #
    #                                             #
    ###############################################


    # Display the comment matching the selected type of task, and activate/deactivate the forward button.
    def taskTypeChanged (self, className):
        self.__updateNavButtons()
        #taskTypeList = self.widgetTree.get_widget ("widgetbar").get_child ().get_children () [0].get_child ()

        #commentWidget = self.widgetTree.get_widget ("widgetbar").get_child ().get_children () [1]

        #iter = obj.get_selected () [1]

        # Display the right comment, or the default text.
        #if (iter == None):
            #comment = self.taskTypeSelectionText
            # No task selected
            #self.taskTypeId = None
        #else:
            # Set the taskTypeId
            #self.taskTypeId = taskTypeList.get_model ().get_value (iter, 0)
            #comment = taskTypeList.get_model ().get_value (iter, 2)
        #commentWidget.set_text (comment)

        # You can't go forward without selectiong a task type
        #self.widgetTree.get_widget ("forward_button").set_sensitive ((self.taskTypeId != None))
        return




# Add a new signal to our NewTask object
gobject.signal_new("newtask-validate", NewTask,
                   gobject.SIGNAL_RUN_LAST,
                   gobject.TYPE_NONE,
                   (gobject.TYPE_PYOBJECT,))


class TaskTypeSelector(gtk.VBox):
    def __init__(self,dict,title = ""):
        gtk.VBox.__init__(self)

        # create a ListStore as model with two columns
        model = gtk.ListStore(gobject.TYPE_INT,gobject.TYPE_STRING)
        # create a TreeView with this model
        self.tree = gtk.TreeView(model)
        self.tree.set_headers_visible(False)
        
        # create a CellRenderer
        renderer = gtk.CellRendererText()
        # and a column with this renderer
        column = gtk.TreeViewColumn("Value",renderer,text=1)
        # append the TreeViewColumn to our internal TreeView
        self.tree.append_column(column)
        # And add the TreeView to a ScrolledWindow
        scrolled = gtk.ScrolledWindow()
        scrolled.add(self.tree)
        # set policy for ScrolledView adjustments
        scrolled.set_policy(gtk.POLICY_NEVER,gtk.POLICY_AUTOMATIC)
        # and its minimum height
        scrolled.set_size_request(-1,150)
        # and pack the ScrolledWindow to ourself
        self.pack_start(scrolled)

        # Fill in the ListStore values passed as parameter
        for key in dict:
            iter = model.append(None)
            model.set_value(iter,0,key)
            model.set_value(iter,1,dict[key])

        # and finally show ourself
        self.show_all()
        return

    def getSelection(self):
        return self.tree.get_selection()

    def getSelected(self):
        model, iter = self.tree.get_selection().get_selected()
        if(iter == None):
            return None
        return iter

