/*
  Copyright (C) 2011 Stefan Stäglich

  This file is part of pung. Pung is a free game based on the pong game.
  It is written in C++ using OpenGL and SDL.

  Pung is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Pung is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with pung.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "./Ball.h"
#include "./Paddle.h"
#include "./Pong.h"

// Main function.
int main(int argc, char** argv)
{
  Pong pongGame;
  if (pongGame.parseCommandLineArguments(argc, argv))
  {
    if (pongGame.initializeScreen())
      pongGame.playGame();
  }
  else
    pongGame.printUsage();
}
