/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.tabs;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import org.nongnu.pulsefire.device.ui.JComponentFactory;
import org.nongnu.pulsefire.device.ui.PatternLogFormatter;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.device.ui.PulseFireUISettingKeys;
import org.nongnu.pulsefire.device.ui.PulseFireUISettingListener;
import org.nongnu.pulsefire.device.ui.SpringLayoutGrid;
import org.nongnu.pulsefire.device.ui.tabs.AbstractFireTabPanel;

public class JTabPanelUILog
extends AbstractFireTabPanel
implements ActionListener,
PulseFireUISettingListener {
    private static final long serialVersionUID = 4858978467459212054L;
    private UILogHandler logHandler = null;
    private JButton clearButton = null;
    private JComboBox levelBox = null;
    private JTextArea logTextArea = null;
    private JCheckBox autoScrollBox = null;
    private int logLinesMax = 255;

    public JTabPanelUILog() {
        this.setLayout(new FlowLayout(0));
        JPanel wrap = new JPanel();
        wrap.setLayout(new SpringLayout());
        wrap.add(this.createHeader());
        wrap.add(this.createEditor());
        SpringLayoutGrid.makeCompactGrid(wrap, 2, 1);
        this.add(wrap);
        Logger rootLogger = Logger.getAnonymousLogger();
        while (rootLogger.getParent() != null) {
            rootLogger = rootLogger.getParent();
        }
        this.logHandler = new UILogHandler();
        this.logHandler.setFormatter(new PatternLogFormatter());
        rootLogger.addHandler(this.logHandler);
        this.logLinesMax = new Integer(PulseFireUI.getInstance().getSettingsManager().getSettingString(PulseFireUISettingKeys.CONSOLE_LINES));
        PulseFireUI.getInstance().getSettingsManager().addSettingListener(PulseFireUISettingKeys.CONSOLE_LINES, this);
    }

    @Override
    public void release() {
        PulseFireUI.getInstance().getSettingsManager().removeSettingListener(PulseFireUISettingKeys.CONSOLE_LINES, this);
        Logger rootLogger = Logger.getAnonymousLogger();
        while (rootLogger.getParent() != null) {
            rootLogger = rootLogger.getParent();
        }
        rootLogger.removeHandler(this.logHandler);
    }

    private JPanel createHeader() {
        JPanel result = JComponentFactory.createJFirePanel("Options");
        result.setLayout(new FlowLayout(0));
        result.add(new JLabel("Log Level"));
        this.levelBox = new JComboBox<Level>(new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.FINE, Level.FINER, Level.FINEST, Level.ALL});
        this.levelBox.setSelectedItem(Level.INFO);
        this.levelBox.addActionListener(this);
        result.add(this.levelBox);
        this.clearButton = new JButton("Clear");
        this.clearButton.addActionListener(this);
        result.add(this.clearButton);
        this.autoScrollBox = new JCheckBox("Autoscroll");
        this.autoScrollBox.setSelected(true);
        result.add(this.autoScrollBox);
        return result;
    }

    private JPanel createEditor() {
        JPanel result = JComponentFactory.createJFirePanel("UILog");
        this.logTextArea = new JTextArea(25, 120);
        this.logTextArea.setAutoscrolls(true);
        this.logTextArea.setEditable(false);
        JScrollPane logScrollPane = new JScrollPane(this.logTextArea);
        logScrollPane.setHorizontalScrollBarPolicy(30);
        logScrollPane.setVerticalScrollBarPolicy(22);
        logScrollPane.getViewport().setOpaque(false);
        result.add(logScrollPane);
        return result;
    }

    @Override
    public Class<?> getTabClassName() {
        return this.getClass();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.clearButton.equals(e.getSource())) {
            this.logTextArea.setText("");
        } else if (this.levelBox.equals(e.getSource()) && this.levelBox.getSelectedIndex() != -1) {
            Level level = (Level)this.levelBox.getSelectedItem();
            this.logHandler.setLevel(level);
            Enumeration<String> loggers = LogManager.getLogManager().getLoggerNames();
            while (loggers.hasMoreElements()) {
                String name = loggers.nextElement();
                Logger logger = LogManager.getLogManager().getLogger(name);
                if (!name.contains("pulsefire")) continue;
                logger.setLevel(level);
            }
        }
    }

    @Override
    public void settingUpdated(PulseFireUISettingKeys key, String value) {
        this.logLinesMax = new Integer(value);
        this.logTextArea.setText("");
    }

    class UILogHandler
    extends Handler {
        UILogHandler() {
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        @Override
        public void publish(LogRecord record) {
            final String recordStr = this.getFormatter().format(record);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JTabPanelUILog.this.logTextArea.append(recordStr);
                    if (JTabPanelUILog.this.logTextArea.getLineCount() > JTabPanelUILog.this.logLinesMax) {
                        int ll;
                        String t = JTabPanelUILog.this.logTextArea.getText();
                        int l = 0;
                        int rm = JTabPanelUILog.this.logLinesMax / 2;
                        for (int i = 0; i < rm && (ll = t.indexOf(10, l + 1)) != -1; ++i) {
                            l = ll;
                        }
                        String tt = t.substring(l, t.length());
                        JTabPanelUILog.this.logTextArea.setText(tt);
                    }
                    if (JTabPanelUILog.this.autoScrollBox.isSelected()) {
                        JTabPanelUILog.this.logTextArea.setCaretPosition(JTabPanelUILog.this.logTextArea.getText().length());
                    }
                }
            });
        }
    }
}

