/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.BadLocationException;
import org.nongnu.pulsefire.device.ui.JComponentFactory;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.device.ui.SpringLayoutGrid;
import org.nongnu.pulsefire.device.ui.components.JIntegerTextField;
import org.nongnu.pulsefire.wire.CommandName;
import org.nongnu.pulsefire.wire.MalCommand;

public class JMalEditor
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 6107809207895017949L;
    private List<MalCommand> programLines = new ArrayList<MalCommand>(32);
    private MalCommandTableModel tableModel = new MalCommandTableModel();
    private JTable cmdTable = new JTable(this.tableModel);
    private int maxProgramSize = -1;
    private JButton addLineButton = null;
    private JButton editLineButton = null;
    private JButton delLineButton = null;

    public JMalEditor() {
        this.cmdTable.getTableHeader().setReorderingAllowed(false);
        this.cmdTable.getTableHeader().setResizingAllowed(false);
        this.cmdTable.setSelectionMode(0);
        this.cmdTable.setAutoResizeMode(0);
        this.cmdTable.setFillsViewportHeight(true);
        this.cmdTable.setShowHorizontalLines(true);
        this.cmdTable.setRowMargin(2);
        this.cmdTable.setRowHeight(26);
        this.cmdTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    MalCommand cmd = (MalCommand)JMalEditor.this.programLines.get(JMalEditor.this.cmdTable.getSelectedRow());
                    JNewLineDialog newLine = new JNewLineDialog(PulseFireUI.getInstance().getMainFrame(), cmd);
                    newLine.setVisible(true);
                }
            }
        });
        ToolTipManager.sharedInstance().unregisterComponent(this.cmdTable);
        ToolTipManager.sharedInstance().unregisterComponent(this.cmdTable.getTableHeader());
        TableColumn lineNumber = this.cmdTable.getColumnModel().getColumn(0);
        lineNumber.setPreferredWidth(50);
        TableColumn lineCode = this.cmdTable.getColumnModel().getColumn(1);
        lineCode.setPreferredWidth(600);
        lineCode.setMinWidth(500);
        lineCode.setCellRenderer(new LineCodeCellRenderer());
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setLayout(new BorderLayout());
        this.add((Component)this.cmdTable.getTableHeader(), "First");
        this.add((Component)this.cmdTable, "Center");
        this.add((Component)this.createTableActions(), "South");
    }

    private JPanel createTableActions() {
        JPanel tableActions = new JPanel();
        tableActions.setLayout(new FlowLayout(2));
        this.addLineButton = new JButton("Add");
        this.editLineButton = new JButton("Edit");
        this.delLineButton = new JButton("Delete");
        this.addLineButton.addActionListener(this);
        this.editLineButton.addActionListener(this);
        this.delLineButton.addActionListener(this);
        this.addLineButton.setEnabled(false);
        this.editLineButton.setEnabled(false);
        this.delLineButton.setEnabled(false);
        tableActions.add(this.addLineButton);
        tableActions.add(this.editLineButton);
        tableActions.add(this.delLineButton);
        return tableActions;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.addLineButton)) {
            JNewLineDialog newLine = new JNewLineDialog(PulseFireUI.getInstance().getMainFrame(), null);
            newLine.setVisible(true);
        } else if (e.getSource().equals(this.editLineButton) && this.cmdTable.getSelectedRow() != -1) {
            MalCommand cmd = this.programLines.get(this.cmdTable.getSelectedRow());
            JNewLineDialog newLine = new JNewLineDialog(PulseFireUI.getInstance().getMainFrame(), cmd);
            newLine.setVisible(true);
        } else if (e.getSource().equals(this.delLineButton) && this.cmdTable.getSelectedRow() != -1) {
            int row = this.cmdTable.getSelectedRow();
            this.cmdTable.getSelectionModel().clearSelection();
            this.programLines.remove(row);
            this.tableModel.fireTableDataChanged();
        }
    }

    public int getMaxProgramSize() {
        return this.maxProgramSize;
    }

    public void setMaxProgramSize(int maxProgramSize) {
        this.maxProgramSize = maxProgramSize;
    }

    public void clearData() {
        this.addLineButton.setEnabled(false);
        this.editLineButton.setEnabled(false);
        this.delLineButton.setEnabled(false);
        this.programLines.clear();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JMalEditor.this.tableModel.fireTableDataChanged();
            }
        });
    }

    public void checkCode() {
        int i;
        if (this.programLines.isEmpty()) {
            return;
        }
        int ops = 0;
        for (i = 0; i < this.programLines.size(); ++i) {
            ops += this.programLines.get(i).getOpcodeSize();
        }
        if (ops > this.getMaxProgramSize()) {
            this.programLines.remove(this.programLines.size() - 1);
            ops = 0;
            for (i = 0; i < this.programLines.size(); ++i) {
                ops += this.programLines.get(i).getOpcodeSize();
            }
            if (ops > this.getMaxProgramSize()) {
                this.programLines.remove(this.programLines.size() - 1);
            }
            this.tableModel.fireTableDataChanged();
        }
    }

    public List<Byte> saveData() {
        ArrayList<Byte> programData = new ArrayList<Byte>(this.programLines.size());
        for (MalCommand cmd : this.programLines) {
            programData.addAll(cmd.getOpcodes());
        }
        return programData;
    }

    public void loadData(List<Byte> programData) {
        MalCommand cmd;
        boolean result;
        this.programLines.clear();
        Iterator<Byte> data = programData.iterator();
        while (data.hasNext() && (result = (cmd = new MalCommand()).parse(data))) {
            this.programLines.add(cmd);
        }
        int ops = 0;
        for (int i = 0; i < this.programLines.size(); ++i) {
            ops += this.programLines.get(i).getOpcodeSize();
        }
        this.setMaxProgramSize(ops);
        this.addLineButton.setEnabled(true);
        this.editLineButton.setEnabled(true);
        this.delLineButton.setEnabled(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JMalEditor.this.tableModel.fireTableDataChanged();
            }
        });
    }

    class JEditPanel
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = -2473578115689529402L;
        private MalCommand malCommand = null;
        private JComboBox cmdTypeBox = null;
        private JComboBox varIdxBox = null;
        private JComboBox progIdxBox = null;
        private JComboBox valueTypeBox = null;
        private JComboBox valueTypeLoadBox = null;
        private JComboBox valueCommandBox = null;
        private JComboBox valueCommandIdxBox = null;
        private JComboBox extTypeComboBox = null;
        private JComboBox extOpComboBox = null;
        private JComboBox gotoLineComboBox = null;
        private JIntegerTextField valueRawTextField = null;
        private volatile boolean actions = true;
        private JLabel malCommandLabel = null;
        private JLabel malCommandDataLabel = null;
        private JLabel cmdTypeBoxLabel = null;
        private JLabel varIdxBoxLabel = null;
        private JLabel progIdxBoxLabel = null;
        private JLabel valueTypeBoxLabel = null;
        private JLabel valueCommandBoxLabel = null;
        private JLabel valueCommandIdxBoxLabel = null;
        private JLabel extTypeComboBoxLabel = null;
        private JLabel extOpComboBoxLabel = null;
        private JLabel gotoLineComboBoxLabel = null;
        private JLabel valueRawTextFieldLabel = null;

        public JEditPanel() {
            this.setLayout(new SpringLayout());
            this.valueRawTextField = new JIntegerTextField(-1, 6);
            this.cmdTypeBox = new JComboBox<MalCommand.CmdType>(MalCommand.CmdType.values());
            this.varIdxBox = new JComboBox<MalCommand.VarIndex>(MalCommand.VarIndex.values());
            this.progIdxBox = new JComboBox<MalCommand.VarIndex>(MalCommand.VarIndex.values());
            this.valueTypeBox = new JComboBox<MalCommand.ValueType>(MalCommand.ValueType.values());
            this.valueTypeLoadBox = new JComboBox<MalCommand.ValueType>(MalCommand.ValueType.values());
            this.extTypeComboBox = new JComboBox<MalCommand.ExtType>(MalCommand.ExtType.values());
            this.valueCommandBox = new JComboBox<Object>(CommandName.valuesMapIndex().toArray());
            this.valueCommandIdxBox = new JComboBox();
            this.extOpComboBox = new JComboBox();
            this.gotoLineComboBox = new JComboBox();
            this.valueTypeBox.removeItemAt(this.valueTypeBox.getItemCount() - 1);
            this.malCommandDataLabel = new JLabel();
            this.malCommandLabel = new JLabel("Command");
            this.cmdTypeBoxLabel = new JLabel("CmdType");
            this.varIdxBoxLabel = new JLabel("VarIndex");
            this.progIdxBoxLabel = new JLabel("ProgIndex");
            this.valueTypeBoxLabel = new JLabel("ValueType");
            this.valueCommandBoxLabel = new JLabel("ValueCmd");
            this.valueCommandIdxBoxLabel = new JLabel("ValueIdx");
            this.extTypeComboBoxLabel = new JLabel("ExtType");
            this.extOpComboBoxLabel = new JLabel("ExtOp");
            this.gotoLineComboBoxLabel = new JLabel("Goto");
            this.valueRawTextFieldLabel = new JLabel("ValueRaw");
            this.cmdTypeBox.addActionListener(this);
            this.varIdxBox.addActionListener(this);
            this.progIdxBox.addActionListener(this);
            this.valueTypeBox.addActionListener(this);
            this.valueTypeLoadBox.addActionListener(this);
            this.valueCommandBox.addActionListener(this);
            this.valueCommandIdxBox.addActionListener(this);
            this.extTypeComboBox.addActionListener(this);
            this.extOpComboBox.addActionListener(this);
            this.gotoLineComboBox.addActionListener(this);
            this.valueRawTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.update(e);
                }

                private void update(DocumentEvent event) {
                    if (JEditPanel.this.malCommand != null) {
                        try {
                            String value = event.getDocument().getText(0, event.getDocument().getLength());
                            if (value.isEmpty()) {
                                value = "0";
                            }
                            JEditPanel.this.malCommand.setCmdArgu(new Integer(value).intValue());
                            JEditPanel.this.malCommand.compile();
                            JEditPanel.this.malCommandDataLabel.setText(JEditPanel.this.malCommand.toString() + " [" + JEditPanel.this.malCommand.toStringHexOpcodes() + "]");
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }

        public MalCommand getMalCommand() {
            return this.malCommand;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.actions) {
                return;
            }
            if (e.getSource().equals(this.varIdxBox) && this.varIdxBox.getSelectedIndex() != -1) {
                this.malCommand.setVarIndex(MalCommand.VarIndex.values()[this.varIdxBox.getSelectedIndex()]);
            } else if (e.getSource().equals(this.cmdTypeBox) && this.cmdTypeBox.getSelectedIndex() != -1) {
                this.malCommand.setCmdType(MalCommand.CmdType.values()[this.cmdTypeBox.getSelectedIndex()]);
                this.malCommand.setCmdArgu(0);
                this.malCommand.setValueType(MalCommand.ValueType.RAW_VALUE);
            } else if (e.getSource().equals(this.progIdxBox) && this.progIdxBox.getSelectedIndex() != -1) {
                this.malCommand.setCmdArgu(MalCommand.VarIndex.values()[this.progIdxBox.getSelectedIndex()].ordinal());
            } else if (e.getSource().equals(this.valueTypeBox) && this.valueTypeBox.getSelectedIndex() != -1) {
                this.malCommand.setValueType(MalCommand.ValueType.values()[this.valueTypeBox.getSelectedIndex()]);
                this.malCommand.setCmdArgu(0);
            } else if (e.getSource().equals(this.valueTypeLoadBox) && this.valueTypeLoadBox.getSelectedIndex() != -1) {
                this.malCommand.setValueType(MalCommand.ValueType.values()[this.valueTypeLoadBox.getSelectedIndex()]);
                this.malCommand.setCmdArgu(0);
            } else if (e.getSource().equals(this.valueCommandBox) && this.valueCommandBox.getSelectedIndex() != -1) {
                this.malCommand.setCmdArgu(((CommandName)this.valueCommandBox.getSelectedItem()).getMapIndex());
            } else if (e.getSource().equals(this.valueCommandIdxBox) && this.valueCommandIdxBox.getSelectedIndex() != -1) {
                this.malCommand.setCmdArguIdx(((Integer)this.valueCommandIdxBox.getSelectedItem()).intValue());
            } else if (e.getSource().equals(this.extTypeComboBox) && this.extTypeComboBox.getSelectedIndex() != -1) {
                this.malCommand.setExtType(MalCommand.ExtType.values()[this.extTypeComboBox.getSelectedIndex()]);
            } else if (e.getSource().equals(this.gotoLineComboBox) && this.gotoLineComboBox.getSelectedIndex() != -1) {
                this.malCommand.setCmdArgu(((Integer)this.gotoLineComboBox.getSelectedItem()).intValue());
            } else if (e.getSource().equals(this.extOpComboBox) && this.extOpComboBox.getSelectedIndex() != -1) {
                switch (this.malCommand.getExtType()) {
                    case VOP: {
                        this.malCommand.setExtOp(MalCommand.ExtOpVar.values()[this.extOpComboBox.getSelectedIndex()].ordinal());
                        break;
                    }
                    case IF: {
                        this.malCommand.setExtOp(MalCommand.ExtOpIf.values()[this.extOpComboBox.getSelectedIndex()].ordinal());
                        break;
                    }
                }
            }
            this.malCommand.compile();
            this.configComponent(this.malCommand);
            this.doLayout();
            this.repaint();
        }

        private void configComponent(MalCommand cmd) {
            this.actions = false;
            this.malCommand = cmd;
            this.removeAll();
            this.malCommandDataLabel.setText(cmd.toString() + " [" + cmd.toStringHexOpcodes() + "]");
            this.add(this.malCommandLabel);
            this.add(this.malCommandDataLabel);
            this.cmdTypeBox.setSelectedItem(cmd.getCmdType());
            this.add(this.cmdTypeBoxLabel);
            this.add(this.cmdTypeBox);
            switch (cmd.getCmdType()) {
                case LOAD: {
                    switch (cmd.getValueType()) {
                        case RAW_VALUE: {
                            this.varIdxBox.setSelectedItem(cmd.getVarIndex());
                            this.add(this.varIdxBoxLabel);
                            this.add(this.varIdxBox);
                            this.valueRawTextField.setText("" + cmd.getCmdArgu());
                            this.add(this.valueRawTextFieldLabel);
                            this.add(this.valueRawTextField);
                            break;
                        }
                        case PROG_VALUE: {
                            this.varIdxBox.setSelectedItem(cmd.getVarIndex());
                            this.add(this.varIdxBoxLabel);
                            this.add(this.varIdxBox);
                            this.progIdxBox.setSelectedIndex(cmd.getCmdArgu());
                            this.add(this.progIdxBoxLabel);
                            this.add(this.progIdxBox);
                            break;
                        }
                        case PF_VALUE: {
                            this.varIdxBox.setSelectedItem(cmd.getVarIndex());
                            this.add(this.varIdxBoxLabel);
                            this.add(this.varIdxBox);
                            CommandName cmdA = CommandName.valueOfMapIndex((int)cmd.getCmdArgu());
                            this.valueCommandBox.setSelectedItem(cmdA);
                            if (cmdA.isIndexedA()) {
                                this.configValueIdx(cmdA);
                                this.add(this.valueCommandIdxBoxLabel);
                                this.add(this.valueCommandIdxBox);
                            }
                            this.add(this.valueCommandBoxLabel);
                            this.add(this.valueCommandBox);
                            break;
                        }
                        case PF_VALUE_SET: {
                            CommandName cmdB = CommandName.valueOfMapIndex((int)cmd.getCmdArgu());
                            this.valueCommandBox.setSelectedItem(cmdB);
                            this.add(this.valueCommandBoxLabel);
                            this.add(this.valueCommandBox);
                            if (cmdB.isIndexedA()) {
                                this.configValueIdx(cmdB);
                                this.add(this.valueCommandIdxBoxLabel);
                                this.add(this.valueCommandIdxBox);
                            }
                            this.varIdxBox.setSelectedItem(cmd.getVarIndex());
                            this.add(this.varIdxBoxLabel);
                            this.add(this.varIdxBox);
                        }
                    }
                    this.valueTypeLoadBox.setSelectedItem(cmd.getValueType());
                    this.add(this.valueTypeBoxLabel);
                    this.add(this.valueTypeLoadBox);
                    break;
                }
                case EXTENDED: {
                    switch (cmd.getExtType()) {
                        case VOP: {
                            this.extTypeComboBox.setSelectedItem(MalCommand.ExtType.VOP);
                            this.add(this.extTypeComboBoxLabel);
                            this.add(this.extTypeComboBox);
                            this.varIdxBox.setSelectedItem(cmd.getVarIndex());
                            this.add(this.varIdxBoxLabel);
                            this.add(this.varIdxBox);
                            this.extOpComboBox.removeAllItems();
                            for (MalCommand.ExtOpVar op : MalCommand.ExtOpVar.values()) {
                                this.extOpComboBox.addItem(op.getCharCode());
                            }
                            this.extOpComboBox.setSelectedIndex(cmd.getExtOp());
                            this.add(this.extOpComboBoxLabel);
                            this.add(this.extOpComboBox);
                            switch (cmd.getValueType()) {
                                case RAW_VALUE: {
                                    this.valueRawTextField.setText("" + cmd.getCmdArgu());
                                    this.add(this.valueRawTextFieldLabel);
                                    this.add(this.valueRawTextField);
                                    break;
                                }
                                case PROG_VALUE: {
                                    this.progIdxBox.setSelectedItem(cmd.getVarIndex());
                                    this.add(this.progIdxBoxLabel);
                                    this.add(this.progIdxBox);
                                    break;
                                }
                                case PF_VALUE: {
                                    CommandName cmdV = CommandName.valueOfMapIndex((int)cmd.getCmdArgu());
                                    this.valueCommandBox.setSelectedItem(cmdV);
                                    this.add(this.valueCommandBoxLabel);
                                    this.add(this.valueCommandBox);
                                    if (!cmdV.isIndexedA()) break;
                                    this.configValueIdx(cmdV);
                                    this.add(this.valueCommandIdxBoxLabel);
                                    this.add(this.valueCommandIdxBox);
                                    break;
                                }
                            }
                            this.add(this.valueTypeBoxLabel);
                            this.add(this.valueTypeBox);
                            break;
                        }
                        case STOP: {
                            this.extTypeComboBox.setSelectedItem(MalCommand.ExtType.STOP);
                            this.add(this.extTypeComboBoxLabel);
                            this.add(this.extTypeComboBox);
                            break;
                        }
                        case GOTO: {
                            this.extTypeComboBox.setSelectedItem(MalCommand.ExtType.GOTO);
                            this.add(this.extTypeComboBoxLabel);
                            this.add(this.extTypeComboBox);
                            this.gotoLineComboBox.removeAllItems();
                            int addr = 0;
                            for (int i = 0; i < JMalEditor.this.programLines.size(); ++i) {
                                this.gotoLineComboBox.addItem(addr);
                                if (addr == cmd.getCmdArgu()) {
                                    this.gotoLineComboBox.setSelectedIndex(i);
                                }
                                addr += ((MalCommand)JMalEditor.this.programLines.get(i)).getOpcodeSize();
                            }
                            this.add(this.gotoLineComboBoxLabel);
                            this.add(this.gotoLineComboBox);
                            break;
                        }
                        case IF: {
                            this.extTypeComboBox.setSelectedItem(MalCommand.ExtType.IF);
                            this.add(this.extTypeComboBoxLabel);
                            this.add(this.extTypeComboBox);
                            this.varIdxBox.setSelectedItem(cmd.getVarIndex());
                            this.add(this.varIdxBoxLabel);
                            this.add(this.varIdxBox);
                            this.extOpComboBox.removeAllItems();
                            for (MalCommand.ExtOpIf op : MalCommand.ExtOpIf.values()) {
                                this.extOpComboBox.addItem(op.getCharCode());
                            }
                            this.extOpComboBox.setSelectedIndex(cmd.getExtOp());
                            this.add(this.extOpComboBoxLabel);
                            this.add(this.extOpComboBox);
                            switch (cmd.getValueType()) {
                                case RAW_VALUE: {
                                    this.valueRawTextField.setText("" + cmd.getCmdArgu());
                                    this.add(this.valueRawTextFieldLabel);
                                    this.add(this.valueRawTextField);
                                    break;
                                }
                                case PROG_VALUE: {
                                    this.progIdxBox.setSelectedItem(cmd.getVarIndex());
                                    this.add(this.progIdxBoxLabel);
                                    this.add(this.progIdxBox);
                                    break;
                                }
                                case PF_VALUE: {
                                    CommandName cmdI = CommandName.valueOfMapIndex((int)cmd.getCmdArgu());
                                    this.valueCommandBox.setSelectedItem(cmd);
                                    this.add(this.valueCommandBoxLabel);
                                    this.add(this.valueCommandBox);
                                    if (!cmdI.isIndexedA()) break;
                                    this.configValueIdx(cmdI);
                                    this.add(this.valueCommandIdxBoxLabel);
                                    this.add(this.valueCommandIdxBox);
                                    break;
                                }
                            }
                            this.valueTypeBox.setSelectedItem(cmd.getValueType());
                            this.add(this.valueTypeBoxLabel);
                            this.add(this.valueTypeBox);
                            break;
                        }
                        case ENDIF: {
                            this.extTypeComboBox.setSelectedItem(MalCommand.ExtType.ENDIF);
                            this.add(this.extTypeComboBoxLabel);
                            this.add(this.extTypeComboBox);
                        }
                    }
                    break;
                }
                case RESERVED: {
                    break;
                }
            }
            this.actions = true;
            SpringLayoutGrid.makeCompactGrid(this, this.getComponentCount() / 2, 2);
            SwingUtilities.updateComponentTreeUI(this);
        }

        private void configValueIdx(CommandName cmd) {
            this.valueCommandIdxBox.removeAll();
            for (int i = 0; i < cmd.getMaxIndexA(); ++i) {
                this.valueCommandIdxBox.addItem(i);
                if (i != this.malCommand.getCmdArguIdx()) continue;
                this.valueCommandIdxBox.setSelectedIndex(i);
            }
            this.valueCommandIdxBox.addItem(255);
            if (255 == this.malCommand.getCmdArguIdx()) {
                this.valueCommandIdxBox.setSelectedIndex(this.valueCommandIdxBox.getItemCount() - 1);
            }
        }
    }

    public class LineCodeCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -4400164721185858628L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            MalCommand cmd = (MalCommand)value;
            this.setText(cmd.toString());
            return this;
        }
    }

    public class MalCommandTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -3225731793752475674L;
        private String[] columnNames = new String[]{"ADDR", "CMD", "HEX"};

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return JMalEditor.this.programLines.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (JMalEditor.this.programLines.isEmpty()) {
                return "";
            }
            if (JMalEditor.this.programLines.size() < row) {
                return "";
            }
            if (col == 0) {
                int addr = 0;
                for (int i = 0; i < row; ++i) {
                    addr += ((MalCommand)JMalEditor.this.programLines.get(i)).getOpcodeSize();
                }
                return addr;
            }
            if (col == 1) {
                return JMalEditor.this.programLines.get(row);
            }
            if (col == 2) {
                return ((MalCommand)JMalEditor.this.programLines.get(row)).toStringHexOpcodes();
            }
            return "";
        }
    }

    class JNewLineDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 8511082377154332785L;
        private JEditPanel editPanel;
        private JButton saveButton;
        private JButton cancelButton;

        public JNewLineDialog(Frame parentFrame, MalCommand malCommand) {
            super(parentFrame, true);
            this.editPanel = null;
            this.saveButton = null;
            this.cancelButton = null;
            this.editPanel = new JEditPanel();
            if (malCommand != null) {
                this.editPanel.configComponent(malCommand.clone());
            } else {
                malCommand = new MalCommand();
                malCommand.init();
                this.editPanel.configComponent(malCommand);
            }
            JPanel editBorder = JComponentFactory.createJFirePanel("Edit Command");
            editBorder.add(this.editPanel);
            this.setTitle("Edit Line");
            this.setMinimumSize(new Dimension(400, 350));
            this.setPreferredSize(new Dimension(450, 400));
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    JNewLineDialog.this.clearAndHide();
                }
            });
            JPanel mainPanel = new JPanel();
            mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            mainPanel.setLayout(new BorderLayout());
            mainPanel.add((Component)editBorder, "Center");
            mainPanel.add((Component)this.createPanelBottom(), "South");
            this.getContentPane().add(mainPanel);
            this.pack();
            this.setLocationRelativeTo(parentFrame);
        }

        public void clearAndHide() {
            this.setVisible(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.saveButton && JMalEditor.this.programLines.size() > JMalEditor.this.cmdTable.getSelectedRow()) {
                MalCommand cmd = this.editPanel.getMalCommand();
                JMalEditor.this.programLines.set(JMalEditor.this.cmdTable.getSelectedRow(), cmd);
                JMalEditor.this.tableModel.fireTableDataChanged();
                JMalEditor.this.checkCode();
                this.clearAndHide();
                return;
            }
            if (e.getSource() == this.cancelButton) {
                this.clearAndHide();
                return;
            }
        }

        private JPanel createPanelBottom() {
            JPanel panel = new JPanel();
            panel.setBorder(BorderFactory.createEmptyBorder());
            panel.setLayout(new FlowLayout(2));
            this.saveButton = new JButton("Save");
            this.saveButton.addActionListener(this);
            panel.add(this.saveButton);
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(this);
            panel.add(this.cancelButton);
            return panel;
        }
    }
}

