/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import org.nongnu.pulsefire.device.DeviceCommandListener;
import org.nongnu.pulsefire.device.DeviceConnectListener;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.device.ui.time.EventTimeTrigger;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;
import org.nongnu.pulsefire.wire.CommandVariableType;

public class PulseFireTimeData
implements DeviceConnectListener {
    private Logger logger = Logger.getLogger(PulseFireTimeData.class.getName());
    private Map<CommandName, TimeDataKey> timeDataQueueMap = Collections.synchronizedMap(new HashMap(20));
    private boolean onceAdd = false;

    public PulseFireTimeData() {
        PulseFireUI.getInstance().getDeviceManager().addDeviceConnectListener((DeviceConnectListener)this);
        PulseFireUI.getInstance().getEventTimeManager().addEventTimeTrigger(new EventTimeTrigger("refreshTimeData", new DataCommandAutoAdd(), 1000L));
    }

    public TimeDataKey getKeyFromName(CommandName name) {
        TimeDataKey result = this.timeDataQueueMap.get(name);
        if (result != null) {
            return result;
        }
        TimeDataKey key = new TimeDataKey();
        key.name = name;
        this.timeDataQueueMap.put(name, key);
        return key;
    }

    public void addTimeDataListener(CommandName name, TimeDataListener listener) {
        TimeDataKey k = this.getKeyFromName(name);
        k.timeDataListeners.add(listener);
    }

    public void removeTimeDataListener(CommandName name, TimeDataListener listener) {
        TimeDataKey k = this.getKeyFromName(name);
        k.timeDataListeners.remove(listener);
    }

    public int getTimeDataSize() {
        return this.timeDataQueueMap.size();
    }

    public List<CommandName> getTimeDataKeys() {
        ArrayList<CommandName> result = new ArrayList<CommandName>(10);
        result.addAll(this.timeDataQueueMap.keySet());
        Collections.sort(result);
        return result;
    }

    public List<TimeData> getTimeData(CommandName name) {
        TimeDataKey k = this.getKeyFromName(name);
        ArrayList<TimeData> result = new ArrayList<TimeData>(300);
        result.addAll(k.timeDataQueue);
        return result;
    }

    public void deviceConnect() {
        if (this.onceAdd) {
            return;
        }
        this.onceAdd = true;
        for (CommandName name : CommandName.values()) {
            if (name.isDisabled() || !(name.isMappable() | name.getType().equals((Object)CommandVariableType.DATA) | name.getType().equals((Object)CommandVariableType.PROG))) continue;
            this.logger.fine("Adding timedata for: " + name);
            this.getKeyFromName(name);
            PulseFireUI.getInstance().getDeviceManager().addDeviceCommandListener(name, (DeviceCommandListener)new DataCommandListener());
        }
    }

    public void deviceDisconnect() {
        this.timeDataQueueMap.clear();
    }

    public static interface TimeDataListener {
        public void updateTimeData();
    }

    class DataCommandListener
    implements DeviceCommandListener {
        DataCommandListener() {
        }

        public void commandReceived(Command command) {
            long now = System.currentTimeMillis();
            TimeDataKey k = PulseFireTimeData.this.getKeyFromName(command.getCommandName());
            Queue<TimeData> q = k.timeDataQueue;
            TimeData timeData = null;
            if (q.isEmpty()) {
                timeData = new TimeData();
                timeData.receivedTime = now;
                q.add(timeData);
            }
            timeData = new TimeData();
            timeData.receivedTime = now;
            if (k.timeDataLast != null) {
                timeData.dataPointIdx = (int[])k.timeDataLast.dataPointIdx.clone();
            }
            q.add(timeData);
            Integer arguValue = null;
            try {
                arguValue = new Integer(command.getArgu0());
            }
            catch (NumberFormatException nfe) {
                return;
            }
            if (command.getCommandName().isIndexedA()) {
                timeData.dataPointIdx[new Integer((String)command.getArgu1()).intValue()] = arguValue;
            } else {
                timeData.dataPoint = arguValue;
            }
            k.timeDataLast = timeData;
            if (q.size() > 100) {
                q.poll();
            }
            for (int i = 0; i < k.timeDataListeners.size(); ++i) {
                TimeDataListener l = k.timeDataListeners.get(i);
                l.updateTimeData();
            }
        }
    }

    class DataCommandAutoAdd
    implements Runnable {
        DataCommandAutoAdd() {
        }

        @Override
        public void run() {
            for (TimeDataKey key : PulseFireTimeData.this.timeDataQueueMap.values()) {
                long now = System.currentTimeMillis();
                if (key.timeDataLast == null || now - key.timeDataLast.receivedTime <= 1000L) continue;
                TimeData timeData = new TimeData();
                timeData.receivedTime = now;
                timeData.dataPoint = key.timeDataLast.dataPoint;
                timeData.dataPointIdx = (int[])key.timeDataLast.dataPointIdx.clone();
                key.timeDataLast = timeData;
                Queue<TimeData> q = key.timeDataQueue;
                q.add(timeData);
                if (q.size() > 100) {
                    q.poll();
                }
                for (TimeDataListener l : key.timeDataListeners) {
                    l.updateTimeData();
                }
            }
        }
    }

    public class TimeData {
        public long receivedTime = 0L;
        public int dataPoint = 0;
        public int[] dataPointIdx = new int[32];
    }

    public class TimeDataKey {
        CommandName name;
        TimeData timeDataLast = null;
        public List<TimeDataListener> timeDataListeners = new ArrayList<TimeDataListener>(4);
        public Color[] dataColorIdx = new Color[32];
        public Queue<TimeData> timeDataQueue = new LinkedBlockingQueue<TimeData>();
    }
}

