/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.flash.avr;

import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Logger;
import org.nongnu.pulsefire.device.flash.AbstractFlashProgramController;
import org.nongnu.pulsefire.device.flash.FlashControllerConfig;
import org.nongnu.pulsefire.device.flash.FlashException;
import org.nongnu.pulsefire.device.flash.avr.FlashCommandToken;
import org.nongnu.pulsefire.device.flash.avr.FlashMessage;

public abstract class AbstractStk500Controller
extends AbstractFlashProgramController {
    protected Logger logger = Logger.getLogger(AbstractStk500Controller.class.getName());
    private SerialPort serialPort = null;
    protected BufferedInputStream input = null;
    protected BufferedOutputStream output = null;

    public abstract FlashMessage sendFlashMessage(FlashMessage var1) throws IOException;

    public abstract void prepareMessagePrefix(FlashMessage var1, FlashCommandToken var2);

    public abstract void prepareMessagePostfix(FlashMessage var1, FlashCommandToken var2);

    public FlashMessage doFlashCommand(FlashCommandToken command, Integer ... param) throws IOException {
        FlashMessage msg = new FlashMessage();
        this.prepareMessagePrefix(msg, command);
        for (Integer data : param) {
            msg.getRequest().add(data);
        }
        this.prepareMessagePostfix(msg, command);
        return this.sendFlashMessage(msg);
    }

    protected void rebootDevice() {
        this.logMessage("Reboot device.");
        this.serialPort.setRTS(false);
        this.serialPort.setDTR(false);
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.serialPort.setRTS(true);
        this.serialPort.setDTR(true);
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void disconnectPort() throws FlashException {
        if (this.serialPort == null) {
            return;
        }
        if (this.input == null) {
            return;
        }
        try {
            this.output.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.input.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.serialPort.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.output = null;
        this.input = null;
        this.serialPort = null;
        this.logMessage("Disconnected from port.");
    }

    protected void connectPort(FlashControllerConfig flashControllerConfig) throws FlashException {
        Enumeration e = CommPortIdentifier.getPortIdentifiers();
        while (e.hasMoreElements()) {
            e.nextElement();
        }
        try {
            CommPortIdentifier cpi = CommPortIdentifier.getPortIdentifier((String)flashControllerConfig.getPort());
            this.serialPort = (SerialPort)cpi.open("FlashManager", 2000);
            this.serialPort.setSerialPortParams(115200, 8, 1, 0);
            this.serialPort.setFlowControlMode(0);
            this.input = new BufferedInputStream(this.serialPort.getInputStream());
            this.output = new BufferedOutputStream(this.serialPort.getOutputStream());
            this.logMessage("Connected to port: " + this.serialPort.getName());
        }
        catch (Exception e1) {
            throw new FlashException("Error while connect to port: " + e1.getMessage(), e1);
        }
    }

    protected void logConfig(FlashControllerConfig flashControllerConfig) {
        this.logMessage("Flash data size: " + flashControllerConfig.getFlashData().length);
        this.logMessage("Flash protocol: " + flashControllerConfig.getPortProtocol());
        this.logMessage("Flash verify: " + flashControllerConfig.isFlashVerify());
    }

    protected abstract void flashSafe(FlashControllerConfig var1) throws IOException, FlashException;

    protected void flashSafeDisconnect(FlashControllerConfig flashControllerConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flash(FlashControllerConfig flashControllerConfig) throws IOException, FlashException {
        try {
            this.flashSafe(flashControllerConfig);
        }
        catch (IOException ie) {
            this.logMessage("IOError: " + ie.getMessage());
            throw ie;
        }
        catch (FlashException flashException) {
            this.logMessage("Error: " + flashException.getMessage());
            throw flashException;
        }
        catch (Exception codeException) {
            this.logMessage("CError: " + codeException.getMessage());
            throw new FlashException(codeException.getMessage(), codeException);
        }
        finally {
            try {
                this.flashSafeDisconnect(flashControllerConfig);
            }
            finally {
                this.disconnectPort();
            }
        }
    }
}

