/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.wire.serial;

import gnu.io.SerialPort;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.nongnu.pulsefire.device.DeviceCommandRequest;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;
import org.nongnu.pulsefire.wire.CommandNameVersionFactory;
import org.nongnu.pulsefire.wire.CommandWire;
import org.nongnu.pulsefire.wire.CommandWireException;
import org.nongnu.pulsefire.wire.serial.SerialDeviceWireManager;

public class SerialDeviceWireThread
extends Thread {
    private Logger logger = null;
    private SerialDeviceWireManager deviceManager = null;
    private SerialPort serialPort = null;
    private Reader reader = null;
    private Writer writer = null;
    private volatile boolean running = false;
    private volatile boolean seenPromt = false;
    private StringBuffer readBuffer = null;
    private DeviceCommandRequest sendCommand = null;
    private static final String PULSE_FIRE_PROMT = "root@pulsefire:";
    private static final String PULSE_FIRE_ERROR = "# Err:";
    private int newLineEchos = 2;

    public SerialDeviceWireThread(SerialDeviceWireManager deviceManager, SerialPort serialPort) throws IOException {
        if (deviceManager == null) {
            throw new NullPointerException("do not set null deviceManager !!");
        }
        if (serialPort == null) {
            throw new NullPointerException("do not set null serialPort !!");
        }
        this.logger = Logger.getLogger(SerialDeviceWireThread.class.getName());
        this.deviceManager = deviceManager;
        this.serialPort = serialPort;
        this.readBuffer = new StringBuffer();
        this.reader = new InputStreamReader(serialPort.getInputStream(), Charset.forName("US-ASCII"));
        this.writer = new OutputStreamWriter(serialPort.getOutputStream(), Charset.forName("US-ASCII"));
        this.logger.info("Connected to port: " + serialPort.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.running = true;
            while (this.running) {
                this.pollInputReader();
                if (this.sendCommand != null) {
                    this.softReconnectDevice(true);
                    Thread.sleep(5L);
                    continue;
                }
                this.pollCommandRequest();
            }
        }
        catch (Exception runException) {
            this.logger.log(Level.WARNING, runException.getMessage(), runException);
        }
        finally {
            this.logger.info("Closing port: " + this.serialPort.getName());
            try {
                this.reader.close();
            }
            catch (IOException e) {}
            try {
                this.writer.close();
            }
            catch (IOException iOException) {}
            this.serialPort.close();
        }
    }

    private void softReconnectDevice(boolean testSendCommand) {
        long currTime = System.currentTimeMillis();
        if (testSendCommand && currTime < this.sendCommand.getRequestTime() + 15000L) {
            return;
        }
        if (testSendCommand) {
            this.logger.info("In system reboot detected trying soft reconnect. timeout of: " + this.sendCommand.getRequest().getLineRaw());
        } else {
            this.logger.info("In system reboot requested trying soft reconnect.");
        }
        if (this.sendCommand != null) {
            this.sendCommand = null;
        }
        DeviceCommandRequest poll = this.deviceManager.pollCommandRequest();
        while (poll != null) {
            poll.setResponse(poll.getRequest());
            poll = this.deviceManager.pollCommandRequest();
        }
        this.deviceManager.requestCommand(new Command(CommandName.req_tx_echo, "0"));
        this.deviceManager.requestCommand(new Command(CommandName.req_tx_promt, "0"));
        this.deviceManager.requestCommand(new Command(CommandName.info_conf, "all"));
        this.deviceManager.requestCommand(new Command(CommandName.info_data));
        this.deviceManager.requestCommand(new Command(CommandName.info_prog));
        this.deviceManager.requestCommand(new Command(CommandName.req_tx_push, "1"));
    }

    private void pollCommandRequest() throws InterruptedException, IOException {
        DeviceCommandRequest send = this.deviceManager.pollCommandRequest();
        if (send == null) {
            Thread.sleep(10L);
            return;
        }
        DeviceCommandRequest peek = this.deviceManager.peekCommandRequest();
        while (peek != null && send.getRequest().getCommandName().equals((Object)peek.getRequest().getCommandName())) {
            send.setResponse(send.getRequest());
            send = this.deviceManager.pollCommandRequest();
            peek = this.deviceManager.peekCommandRequest();
        }
        try {
            this.logger.fine("Send cmd: " + send.getRequest().getCommandName() + " with argu0: " + send.getRequest().getArgu0());
            String writeOut = CommandWire.encodeCommand((Command)send.getRequest());
            this.logger.finer("Write to COMM: " + writeOut);
            this.writer.write(writeOut);
            this.writer.write(10);
            this.writer.flush();
            this.sendCommand = send;
            this.deviceManager.fireDataSend(writeOut);
        }
        catch (IOException sendException) {
            this.logger.log(Level.WARNING, sendException.getMessage(), sendException);
            this.deviceManager.disconnect();
        }
    }

    private void pollInputReader() throws IOException {
        int c = 0;
        boolean lineEnd = false;
        while (this.reader.ready()) {
            c = this.reader.read();
            if (c == 10) {
                if (this.newLineEchos == 0) {
                    lineEnd = true;
                    break;
                }
                --this.newLineEchos;
                continue;
            }
            this.readBuffer.append((char)c);
        }
        if (!lineEnd) {
            return;
        }
        String scannedInput = this.readBuffer.toString().trim();
        this.readBuffer = new StringBuffer();
        this.logger.finer("Read from COMM: " + scannedInput);
        this.deviceManager.fireDataReceived(scannedInput);
        if (scannedInput.startsWith(PULSE_FIRE_ERROR) && this.sendCommand != null) {
            this.sendCommand.setResponse(this.sendCommand.getRequest());
            this.sendCommand = null;
        }
        if (scannedInput.startsWith(PULSE_FIRE_PROMT)) {
            this.seenPromt = true;
            if (!(scannedInput = scannedInput.substring(scannedInput.indexOf(58) + 1, scannedInput.length()).trim()).contains("=")) {
                return;
            }
        }
        if (scannedInput.startsWith("#")) {
            return;
        }
        if (scannedInput.isEmpty()) {
            return;
        }
        if (!scannedInput.contains("=")) {
            return;
        }
        if (scannedInput.startsWith(CommandName.info_chip.name() + CommandName.chip_version)) {
            scannedInput = scannedInput.substring(CommandName.info_chip.name().length(), scannedInput.length());
        }
        int t = 0;
        if (scannedInput.startsWith("max.")) {
            scannedInput = scannedInput.substring(4);
            t = 1;
        } else if (scannedInput.startsWith("map.")) {
            scannedInput = scannedInput.substring(4);
            t = 2;
        } else if (scannedInput.startsWith("idx.")) {
            scannedInput = scannedInput.substring(4);
            t = 3;
        }
        Command cmd = null;
        try {
            cmd = CommandWire.decodeCommand((String)scannedInput);
            this.logger.finer("Got cmd: " + cmd.getCommandName() + " with argu0: " + cmd.getArgu0());
            if (this.sendCommand != null && this.sendCommand.getRequest().getCommandName().equals((Object)cmd.getCommandName())) {
                this.sendCommand.setResponse(cmd);
                this.sendCommand = null;
            }
        }
        catch (CommandWireException cwe) {
            this.logger.log(Level.WARNING, cwe.getMessage());
        }
        catch (Exception parseException) {
            this.logger.log(Level.WARNING, parseException.getMessage(), parseException);
        }
        if (cmd == null) {
            return;
        }
        try {
            this.updateDeviceData(cmd, t);
            if (t == 0) {
                this.deviceManager.fireCommandReceived(cmd);
                if (cmd.getCommandName().equals((Object)CommandName.reset_data)) {
                    this.deviceManager.requestCommand(new Command(CommandName.info_data));
                }
                if (cmd.getCommandName().equals((Object)CommandName.reset_conf)) {
                    this.deviceManager.requestCommand(new Command(CommandName.info_conf, "all"));
                    this.deviceManager.requestCommand(new Command(CommandName.info_data));
                    this.deviceManager.requestCommand(new Command(CommandName.info_prog));
                }
                if (cmd.getCommandName().equals((Object)CommandName.reset_chip)) {
                    Thread.sleep(2000L);
                    this.newLineEchos = 1;
                    this.deviceManager.requestCommand(new Command(CommandName.req_tx_echo, "0"));
                    this.deviceManager.requestCommand(new Command(CommandName.req_tx_promt, "0"));
                    this.deviceManager.requestCommand(new Command(CommandName.req_tx_push, "1"));
                    this.deviceManager.requestCommand(new Command(CommandName.info_conf, "all"));
                    this.deviceManager.requestCommand(new Command(CommandName.info_data));
                    this.deviceManager.requestCommand(new Command(CommandName.info_prog));
                }
            }
        }
        catch (Exception updateException) {
            this.logger.log(Level.WARNING, updateException.getMessage(), updateException);
        }
    }

    private void updateDeviceData(Command cmd, int t) {
        if (t == 0) {
            this.deviceManager.getDeviceData().setDeviceParameter(cmd);
            return;
        }
        String res = cmd.getArgu0();
        if (t == 0 && cmd.getCommandName().isIndexedA() && !cmd.getCommandName().isIndexedB()) {
            res = cmd.getArgu1();
        }
        if (res == null) {
            return;
        }
        if ("null".equals(res)) {
            return;
        }
        int deviceVersion = this.deviceManager.getDeviceVersion();
        Integer value = new Integer(res);
        CommandName cmdName = cmd.getCommandName();
        if (t == 1) {
            CommandNameVersionFactory.configCommandMax((int)deviceVersion, (CommandName)cmdName, (int)value);
        } else if (t == 2) {
            CommandNameVersionFactory.configCommandMapIndex((int)deviceVersion, (CommandName)cmdName, (int)value);
            if (cmd.getArgu1() != null) {
                CommandNameVersionFactory.configCommandMaxIndexTrigger((int)deviceVersion, (CommandName)cmdName, (boolean)true);
            }
        } else if (t == 3) {
            CommandNameVersionFactory.configCommandMaxIndexA((int)deviceVersion, (CommandName)cmdName, (int)value);
            if (cmd.getArgu1() != null && !"null".equals(cmd.getArgu1())) {
                CommandNameVersionFactory.configCommandMaxIndexB((int)deviceVersion, (CommandName)cmdName, (int)new Integer(cmd.getArgu1()));
            }
        }
    }

    public void shutdown() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean hasSeenPromt() {
        return this.seenPromt;
    }
}

