/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.nongnu.pulsefire.device.ui.JComponentFactory;
import org.nongnu.pulsefire.device.ui.SpringLayoutGrid;
import org.nongnu.pulsefire.device.ui.components.JCommandButton;
import org.nongnu.pulsefire.device.ui.components.JCommandCheckBox;
import org.nongnu.pulsefire.device.ui.components.JCommandDial;
import org.nongnu.pulsefire.device.ui.tabs.AbstractTabPanel;
import org.nongnu.pulsefire.wire.CommandName;

public class JTabPanelLPM
extends AbstractTabPanel
implements ListSelectionListener {
    private static final long serialVersionUID = -6711428986888517858L;
    private JTable table = null;
    private LpmTestStepsTableModel tableModel = null;

    public JTabPanelLPM() {
        this.setLayout(new FlowLayout(0));
        JPanel wrap = new JPanel();
        wrap.setLayout(new SpringLayout());
        wrap.add(this.createLPM());
        wrap.add(this.createLPMTune());
        SpringLayoutGrid.makeCompactGrid(wrap, 1, 2);
        this.add(wrap);
    }

    private JPanel createLPM() {
        JPanel inputPanel = JComponentFactory.createJFirePanel("LPM");
        inputPanel.setLayout(new SpringLayout());
        inputPanel.add(JComponentFactory.createJLabel("Lpm Start"));
        inputPanel.add(JComponentFactory.createJPanelJWrap(new JCommandDial(CommandName.lpm_start)));
        inputPanel.add(JComponentFactory.createJLabel("Lpm Stop"));
        inputPanel.add(JComponentFactory.createJPanelJWrap(new JCommandDial(CommandName.lpm_stop)));
        inputPanel.add(JComponentFactory.createJLabel("Lpm Size"));
        inputPanel.add(JComponentFactory.createJPanelJWrap(new JCommandDial(CommandName.lpm_size)));
        inputPanel.add(JComponentFactory.createJLabel("Relay Invert"));
        inputPanel.add(new JCommandCheckBox(CommandName.lpm_relay_inv));
        inputPanel.add(JComponentFactory.createJLabel("Start Lpm"));
        inputPanel.add(new JCommandButton("Start", CommandName.req_auto_lpm));
        JProgressBar bar = new JProgressBar();
        bar.setIndeterminate(true);
        inputPanel.add(JComponentFactory.createJLabel("Lpm progress"));
        inputPanel.add(bar);
        SpringLayoutGrid.makeCompactGrid(inputPanel, 6, 2);
        return inputPanel;
    }

    private JPanel createLPMTune() {
        JPanel panel = JComponentFactory.createJFirePanel("Auto Tune");
        panel.setLayout(new BorderLayout());
        this.tableModel = new LpmTestStepsTableModel();
        this.table = new JTable(this.tableModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().setResizingAllowed(false);
        this.table.setAutoResizeMode(0);
        this.table.setFillsViewportHeight(true);
        this.table.setShowHorizontalLines(true);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.setRowMargin(2);
        this.table.setRowHeight(26);
        TableColumn nameColumn = this.table.getColumnModel().getColumn(0);
        nameColumn.setPreferredWidth(150);
        TableColumn speedColumn = this.table.getColumnModel().getColumn(1);
        speedColumn.setPreferredWidth(130);
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
        JScrollPane scroll = new JScrollPane(this.table);
        panel.add((Component)scroll, "Center");
        JPanel tableActions = new JPanel();
        tableActions.setLayout(new FlowLayout(2));
        JButton editButton = new JButton("Edit");
        JButton addButton = new JButton("Add");
        JButton delButton = new JButton("Delete");
        editButton.setEnabled(false);
        addButton.setEnabled(false);
        delButton.setEnabled(false);
        tableActions.add(editButton);
        tableActions.add(addButton);
        tableActions.add(delButton);
        panel.add((Component)tableActions, "South");
        JPanel testActions = new JPanel();
        testActions.setLayout(new FlowLayout(0));
        JButton startButton = new JButton("Start");
        JButton stopButton = new JButton("Stop");
        startButton.setEnabled(false);
        stopButton.setEnabled(false);
        testActions.add(startButton);
        testActions.add(stopButton);
        panel.add((Component)testActions, "North");
        return panel;
    }

    @Override
    public Class<?> getTabClassName() {
        return this.getClass();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    public class LpmTestStepsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -1432038909521987705L;
        private String[] columnNames = new String[]{"Command", "Argument", "Order"};
        private List<LpmTestStep> data = new ArrayList<LpmTestStep>(100);

        public LpmTestStepsTableModel() {
            LpmTestStep s = new LpmTestStep();
            s.setCommandName(CommandName.pwm_clock);
            s.setCommandArgument("1 5 1 34 4");
            s.setOrder(1);
            s.setId(1);
            this.data.add(s);
        }

        public List<LpmTestStep> getData() {
            return this.data;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            LpmTestStep step = this.data.get(row);
            switch (col) {
                default: {
                    return step.commandName.name();
                }
                case 1: {
                    return step.commandArgument;
                }
                case 2: 
            }
            return step.order;
        }
    }

    public class LpmTestStep {
        private Integer id = null;
        private Integer order = null;
        private CommandName commandName = null;
        private String commandArgument = null;

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public Integer getOrder() {
            return this.order;
        }

        public void setOrder(Integer order) {
            this.order = order;
        }

        public CommandName getCommandName() {
            return this.commandName;
        }

        public void setCommandName(CommandName commandName) {
            this.commandName = commandName;
        }

        public String getCommandArgument() {
            return this.commandArgument;
        }

        public void setCommandArgument(String commandArgument) {
            this.commandArgument = commandArgument;
        }
    }
}

