/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import org.nongnu.pulsefire.device.ui.JComponentEnableStateListener;
import org.nongnu.pulsefire.device.ui.JComponentFactory;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.device.ui.PulseFireUISettingKeys;
import org.nongnu.pulsefire.device.ui.PulseFireUISettingListener;
import org.nongnu.pulsefire.device.ui.SpringLayoutGrid;
import org.nongnu.pulsefire.device.ui.components.JCommandSettingListDialog;
import org.nongnu.pulsefire.device.ui.components.JFireGraph;
import org.nongnu.pulsefire.device.ui.tabs.AbstractTabPanel;
import org.nongnu.pulsefire.wire.CommandName;

public class JTabPanelGraphs
extends AbstractTabPanel
implements ActionListener,
PulseFireUISettingListener {
    private static final long serialVersionUID = -1416072133032318563L;
    private JPanel graphPanel = null;
    private JButton graphListButton = null;
    private JButton graphListInfoButton = null;
    private JComboBox sizeBox = null;
    private JComboBox columnBox = null;

    public JTabPanelGraphs() {
        this.setLayout(new BorderLayout());
        this.add((Component)JComponentFactory.createJPanelJWrap(this.createPanelGraphConfig()), "North");
        this.add((Component)JComponentFactory.createJPanelJWrap(this.createPanelGraph()), "Center");
        PulseFireUI.getInstance().getSettingsManager().addSettingListener(PulseFireUISettingKeys.GRAPH_LIST, this);
    }

    private JPanel createPanelGraph() {
        JPanel resultPanel = JComponentFactory.createJFirePanel("Graphs");
        this.graphPanel = new JPanel();
        this.graphPanel.setLayout(new SpringLayout());
        SpringLayoutGrid.makeCompactGrid(this.graphPanel, 0, 0);
        resultPanel.add(this.graphPanel);
        return resultPanel;
    }

    private JPanel createPanelGraphConfig() {
        JPanel resultPanel = JComponentFactory.createJFirePanel("Config");
        resultPanel.setLayout(new FlowLayout(0));
        resultPanel.add(new JLabel("Size"));
        this.sizeBox = new JComboBox<String>(new String[]{"Large", "Medium", "Small"});
        this.sizeBox.setSelectedIndex(PulseFireUI.getInstance().getSettingsManager().getSettingInteger(PulseFireUISettingKeys.GRAPH_SIZE));
        this.sizeBox.addActionListener(this);
        JComponentEnableStateListener.attach(this.sizeBox, null);
        resultPanel.add(this.sizeBox);
        resultPanel.add(new JLabel("Columns"));
        this.columnBox = new JComboBox<Integer>(new Integer[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13});
        this.columnBox.setSelectedIndex(PulseFireUI.getInstance().getSettingsManager().getSettingInteger(PulseFireUISettingKeys.GRAPH_COLS));
        this.columnBox.addActionListener(this);
        JComponentEnableStateListener.attach(this.columnBox, null);
        resultPanel.add(this.columnBox);
        resultPanel.add(new JLabel("Select"));
        this.graphListButton = new JButton("Graphs");
        this.graphListButton.addActionListener(this);
        JComponentEnableStateListener.attach(this.graphListButton, null);
        resultPanel.add(this.graphListButton);
        this.graphListInfoButton = new JButton("GraphsFront");
        this.graphListInfoButton.addActionListener(this);
        JComponentEnableStateListener.attach(this.graphListInfoButton, null);
        resultPanel.add(this.graphListInfoButton);
        return resultPanel;
    }

    @Override
    public Class<?> getTabClassName() {
        return this.getClass();
    }

    @Override
    public void deviceConnect() {
        String graphStr = PulseFireUI.getInstance().getSettingsManager().getSettingString(PulseFireUISettingKeys.GRAPH_LIST);
        List<CommandName> graphs = null;
        graphs = !graphStr.isEmpty() ? CommandName.decodeCommandList((String)graphStr) : PulseFireUI.getInstance().getTimeData().getTimeDataKeys();
        List<CommandName> graphData = PulseFireUI.getInstance().getTimeData().getTimeDataKeys();
        for (CommandName name : graphs) {
            if (!graphData.contains(name)) continue;
            this.graphPanel.add(new JFireGraph(name));
        }
        this.resizeGraphs();
        this.makeGraphGrid();
        super.deviceConnect();
    }

    private void makeGraphGrid() {
        int columnCount;
        for (Component c : this.graphPanel.getComponents()) {
            if (!(c instanceof JLabel)) continue;
            this.graphPanel.remove(c);
        }
        int compomentCount = this.graphPanel.getComponentCount();
        int spaceSize = compomentCount / (columnCount = ((Integer)this.columnBox.getSelectedItem()).intValue()) * columnCount;
        if (spaceSize != compomentCount) {
            spaceSize += columnCount;
        }
        for (int i = compomentCount; i < spaceSize; ++i) {
            this.graphPanel.add(new JLabel(""));
            ++compomentCount;
        }
        SpringLayoutGrid.makeCompactGrid(this.graphPanel, compomentCount / columnCount, columnCount);
    }

    private void resizeGraphs() {
        for (Component c : this.graphPanel.getComponents()) {
            if (!(c instanceof JFireGraph)) continue;
            if (this.sizeBox.getSelectedIndex() == 0) {
                c.setPreferredSize(new Dimension(400, 200));
                continue;
            }
            if (this.sizeBox.getSelectedIndex() == 1) {
                c.setPreferredSize(new Dimension(300, 150));
                continue;
            }
            if (this.sizeBox.getSelectedIndex() != 2) continue;
            c.setPreferredSize(new Dimension(200, 100));
        }
    }

    @Override
    public void deviceDisconnect() {
        super.deviceDisconnect();
        for (Component c : this.graphPanel.getComponents()) {
            if (!(c instanceof JFireGraph)) continue;
            JFireGraph g = (JFireGraph)c;
            PulseFireUI.getInstance().getTimeData().removeTimeDataListener(g.getCommandName(), g);
        }
        this.graphPanel.removeAll();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.sizeBox.equals(e.getSource())) {
            this.resizeGraphs();
            PulseFireUI.getInstance().getSettingsManager().setSettingInteger(PulseFireUISettingKeys.GRAPH_SIZE, this.sizeBox.getSelectedIndex());
        } else if (this.columnBox.equals(e.getSource())) {
            this.makeGraphGrid();
            PulseFireUI.getInstance().getSettingsManager().setSettingInteger(PulseFireUISettingKeys.GRAPH_COLS, this.columnBox.getSelectedIndex());
        } else if (this.graphListButton.equals(e.getSource())) {
            List<CommandName> commands = PulseFireUI.getInstance().getTimeData().getTimeDataKeys();
            JCommandSettingListDialog dialog = new JCommandSettingListDialog(PulseFireUI.getInstance().getMainFrame(), "Select Graphs", "Select the graphs to use on graph tab to display.", PulseFireUISettingKeys.GRAPH_LIST, commands, commands);
            dialog.setVisible(true);
        } else if (this.graphListInfoButton.equals(e.getSource())) {
            List<CommandName> commands = PulseFireUI.getInstance().getTimeData().getTimeDataKeys();
            List commandDefaults = CommandName.decodeCommandList((String)PulseFireUISettingKeys.GRAPH_LIST_FRONT.getDefaultValue());
            JCommandSettingListDialog dialog = new JCommandSettingListDialog(PulseFireUI.getInstance().getMainFrame(), "Select Graphs Front", "Select the graphs to use on front info panel to display.", PulseFireUISettingKeys.GRAPH_LIST_FRONT, commands, commandDefaults);
            dialog.setVisible(true);
        }
        this.graphPanel.revalidate();
        super.deviceConnect();
    }

    @Override
    public void settingUpdated(PulseFireUISettingKeys key, String value) {
        this.deviceDisconnect();
        this.deviceConnect();
    }
}

