/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.flash;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;

public class FlashHexReader {
    private static int INTEGER_HEX = 16;
    private Charset charset = Charset.forName("US-ASCII");

    public byte[] loadHex(File hexFile) throws FileNotFoundException, IOException {
        return this.readHexData(new FileInputStream(hexFile));
    }

    public byte[] loadHex(String hexResource) throws IOException {
        InputStream input;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        if ((input = cl.getResourceAsStream(hexResource)) == null) {
            throw new NullPointerException("Could not find resource " + hexResource + " in classpath.");
        }
        return this.readHexData(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readHexData(InputStream input) throws IOException {
        ByteArrayOutputStream resultData = new ByteArrayOutputStream(32768);
        BufferedReader reader = null;
        try {
            reader = new LineNumberReader(new InputStreamReader(input, this.charset));
            String line = null;
            while ((line = ((LineNumberReader)reader).readLine()) != null) {
                if (!line.startsWith(":")) continue;
                int byteCount = Integer.parseInt(line.substring(1, 3), INTEGER_HEX);
                int address = Integer.parseInt(line.substring(3, 7), INTEGER_HEX);
                int recordType = Integer.parseInt(line.substring(7, 9), INTEGER_HEX);
                byte[] dataLine = new byte[byteCount];
                for (int i = 0; i < byteCount; ++i) {
                    byte dataByte;
                    int idx = 9 + 2 * i;
                    dataLine[i] = dataByte = (byte)Integer.parseInt(line.substring(idx, idx + 2), INTEGER_HEX);
                }
                byte checksumLine = new Integer(Integer.parseInt(line.substring(line.length() - 2, line.length()), INTEGER_HEX)).byteValue();
                byte checksumParsed = new Integer(byteCount + (address & 0xFF) + (address >> 8) + recordType).byteValue();
                for (int i = 0; i < byteCount; ++i) {
                    checksumParsed = (byte)(checksumParsed + dataLine[i]);
                }
                if (checksumLine != (checksumParsed = new Integer(checksumParsed % 255 * 255).byteValue())) {
                    throw new IllegalArgumentException("Invalid checksum on line: " + ((LineNumberReader)reader).getLineNumber() + " expected: " + Integer.toHexString(checksumLine) + " got: " + Integer.toHexString(checksumParsed));
                }
                resultData.write(dataLine);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (input != null) {
                input.close();
            }
        }
        return resultData.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHexData(byte[] data, OutputStream output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, this.charset));
        try {
            int lineSize = 16;
            for (int i = 0; i < data.length; i += lineSize) {
                String sizeStr;
                writer.append(':');
                if (i + lineSize > data.length) {
                    lineSize = data.length - i;
                }
                if ((sizeStr = Integer.toHexString(lineSize).toUpperCase()).length() == 1) {
                    writer.append("0");
                }
                writer.append(sizeStr);
                String address = Integer.toHexString(i).toUpperCase();
                if (address.length() == 1) {
                    writer.append("000");
                } else if (address.length() == 2) {
                    writer.append("00");
                } else if (address.length() == 3) {
                    writer.append("0");
                }
                writer.append(address);
                int recordType = 0;
                byte checksumParsed = new Integer(lineSize + (i & 0xFF) + (i >> 8) + recordType).byteValue();
                writer.append("00");
                for (int ii = i; ii < i + lineSize && ii < data.length; ++ii) {
                    String dataStr = Integer.toHexString(data[ii]).toUpperCase();
                    if (dataStr.length() == 1) {
                        writer.append("0");
                    }
                    if (dataStr.length() == 8) {
                        dataStr = dataStr.substring(6);
                    }
                    writer.append(dataStr);
                    checksumParsed = (byte)(checksumParsed + data[ii]);
                }
                String checkSumStr = Integer.toHexString(checksumParsed = new Integer(checksumParsed % 255 * 255).byteValue()).toUpperCase();
                if (checkSumStr.length() == 1) {
                    writer.append("0");
                }
                if (checkSumStr.length() == 8) {
                    checkSumStr = checkSumStr.substring(6);
                }
                writer.append(checkSumStr);
                writer.append("\n");
                ((Writer)writer).flush();
            }
            writer.append(":00000001FF");
            writer.append("\n");
            ((Writer)writer).flush();
        }
        finally {
            if (writer != null) {
                ((Writer)writer).close();
            }
            if (output != null) {
                output.close();
            }
        }
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

