/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.jdesktop.application.Application;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.View;
import org.nongnu.pulsefire.device.DeviceData;
import org.nongnu.pulsefire.device.DeviceWireManager;
import org.nongnu.pulsefire.device.DeviceWireManagerController;
import org.nongnu.pulsefire.device.ui.JMainPanel;
import org.nongnu.pulsefire.device.ui.PatternLogFormatter;
import org.nongnu.pulsefire.device.ui.PulseFireDataLogManager;
import org.nongnu.pulsefire.device.ui.PulseFireTimeData;
import org.nongnu.pulsefire.device.ui.PulseFireUIBuildInfo;
import org.nongnu.pulsefire.device.ui.PulseFireUISettingKeys;
import org.nongnu.pulsefire.device.ui.PulseFireUISettingManager;
import org.nongnu.pulsefire.device.ui.time.EventTimeManager;
import org.nongnu.pulsefire.device.ui.time.EventTimeTrigger;
import org.nongnu.pulsefire.device.ui.time.PulseFireDataPuller;
import org.nongnu.pulsefire.wire.serial.SerialDeviceWireManager;

public class PulseFireUI
extends SingleFrameApplication {
    private DeviceWireManagerController deviceManagerController = null;
    private PulseFireTimeData timeData = null;
    private EventTimeManager eventTimeManager = null;
    private PulseFireDataLogManager dataLogManager = null;
    private PulseFireUIBuildInfo buildInfo = null;
    private PulseFireUISettingManager settingsManager = null;
    private boolean fullScreen = false;
    private long startTimeTotal = System.currentTimeMillis();
    private Logger logger = null;

    public static void main(String[] args) {
        Application.launch(PulseFireUI.class, (String[])args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSerialLib() {
        PrintStream out = System.out;
        try {
            final StringBuffer buf = new StringBuffer(40);
            System.setOut(new PrintStream(new OutputStream(){

                @Override
                public void write(int b) {
                    buf.append(Character.toChars(b));
                }
            }));
            Class<?> clazz = Class.forName("gnu.io.CommPortIdentifier");
            clazz.getMethod("getPortIdentifiers", new Class[0]).invoke(null, new Object[0]);
            for (String line : buf.toString().split("\n")) {
                if (!line.contains("Version")) continue;
                this.logger.info(line);
            }
        }
        catch (Exception e1) {
            this.logger.warning("Could not init serial lib: " + e1.getMessage());
        }
        finally {
            System.setOut(out);
        }
    }

    private void loadSerialLib(boolean jniCopy, boolean jniCopyOs) {
        try {
            String arch;
            if (this.isWebStart()) {
                System.loadLibrary("rxtxSerial");
                return;
            }
            if (!jniCopy) {
                return;
            }
            String libName = System.mapLibraryName("rxtxSerial");
            File libFile = new File(libName);
            if (libFile.exists()) {
                return;
            }
            this.logger.info("Finding native lib: " + libName);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = libName.getClass().getClassLoader();
            }
            if ("amd64".endsWith(arch = System.getProperty("os.arch"))) {
                arch = "x86_64";
            }
            Enumeration<URL> libs = cl.getResources(libName);
            while (libs.hasMoreElements()) {
                URL jarResourceUrl = libs.nextElement();
                this.logger.info("Copy native lib from: " + jarResourceUrl + " for: " + arch);
                if (jniCopyOs && !jarResourceUrl.toExternalForm().contains(arch)) continue;
                InputStream is = jarResourceUrl.openStream();
                FileOutputStream os = new FileOutputStream(libName);
                byte[] buf = new byte[4096];
                int cnt = is.read(buf);
                while (cnt > 0) {
                    ((OutputStream)os).write(buf, 0, cnt);
                    cnt = is.read(buf);
                }
                ((OutputStream)os).close();
                is.close();
                break;
            }
            System.loadLibrary("rxtxSerial");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void setupBuildInfo() {
        if (this.buildInfo != null) {
            return;
        }
        try {
            Class<?> infoClass = Class.forName(PulseFireUIBuildInfo.class.getPackage().getName() + "." + PulseFireUIBuildInfo.class.getSimpleName() + "Impl");
            this.buildInfo = (PulseFireUIBuildInfo)infoClass.newInstance();
            return;
        }
        catch (Exception e) {
            this.logger.warning("Could not load build info impl fallback to local one.");
            this.buildInfo = new PulseFireUIBuildInfo(){

                @Override
                public String getVersion() {
                    return "0.0.0-NoInfo2";
                }

                @Override
                public String getBuildDate() {
                    return new Date().toString();
                }
            };
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupLogging() {
        File logConfig = new File("logfile.properties");
        if (logConfig.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(logConfig);
                LogManager.getLogManager().readConfiguration(in);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            Logger rootLogger = Logger.getAnonymousLogger();
            while (rootLogger.getParent() != null) {
                rootLogger = rootLogger.getParent();
            }
            for (Handler h : rootLogger.getHandlers()) {
                h.setFormatter(new PatternLogFormatter());
            }
        }
        this.logger = Logger.getLogger(PulseFireUI.class.getName());
    }

    protected void initialize(String[] args) {
        super.initialize(args);
        try {
            long startTime = System.currentTimeMillis();
            this.setupLogging();
            this.setupBuildInfo();
            this.logger.info("Starting PulseFire-UI version: " + this.buildInfo.getVersion() + " build: " + this.buildInfo.getBuildDate());
            boolean jniCopy = false;
            boolean jniCopyOs = false;
            for (String argu : args) {
                if ("-fs".equals(argu)) {
                    this.fullScreen = true;
                }
                if ("-jni-cp".equals(argu)) {
                    jniCopy = true;
                }
                if (!"-jni-cp-os".equals(argu)) continue;
                jniCopy = true;
                jniCopyOs = true;
            }
            this.loadSerialLib(jniCopy, jniCopyOs);
            this.initSerialLib();
            this.settingsManager = new PulseFireUISettingManager(this.getContext());
            this.settingsManager.loadSettings();
            this.deviceManagerController = new DeviceWireManagerController();
            this.deviceManagerController.addDeviceManager((DeviceWireManager)new SerialDeviceWireManager());
            this.eventTimeManager = new EventTimeManager();
            this.eventTimeManager.start();
            this.timeData = new PulseFireTimeData();
            this.dataLogManager = new PulseFireDataLogManager();
            this.dataLogManager.start();
            String colorName = this.installColorsLaF();
            this.logger.info("Color schema selected: " + colorName);
            long stopTime = System.currentTimeMillis();
            this.logger.info("PulseFireUI initialized in " + (stopTime - startTime) + " ms.");
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            JOptionPane.showMessageDialog(null, "Fatal Initialize Error:\n" + sw.getBuffer().toString(), "PulseFire Initialize Error", 0);
            e.printStackTrace();
            System.exit(1);
        }
    }

    protected void startup() {
        try {
            long startTime = System.currentTimeMillis();
            this.addExitListener(new ShutdownManager());
            FrameView mainView = this.getMainView();
            mainView.getFrame().setMinimumSize(new Dimension(960, 640));
            mainView.setComponent((JComponent)new JMainPanel());
            mainView.getFrame().setTitle(mainView.getFrame().getTitle() + " " + this.buildInfo.getVersion());
            if (this.fullScreen) {
                GraphicsDevice gd = mainView.getFrame().getGraphicsConfiguration().getDevice();
                mainView.getFrame().setUndecorated(true);
                gd.setFullScreenWindow(mainView.getFrame());
                mainView.getFrame().validate();
            } else {
                this.show((View)mainView);
            }
            this.eventTimeManager.addEventTimeTrigger(new EventTimeTrigger("refreshData", new PulseFireDataPuller(), 10000L));
            long stopTime = System.currentTimeMillis();
            this.logger.info("PulseFireUI startup in " + (stopTime - startTime) + " ms total startup in " + (stopTime - this.startTimeTotal) + " ms.");
        }
        catch (Exception e) {
            this.dataLogManager.stop();
            this.eventTimeManager.shutdown();
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            JOptionPane.showMessageDialog(null, "Fatal Startup Error:\n" + sw.getBuffer().toString(), "PulseFire Startup Error", 0);
            e.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String installColorsLaF() {
        InputStream in;
        UIManager.put("TabbedPane.font", Font.decode("SansSerif-BOLD-12"));
        UIManager.put("TitledBorder.font", Font.decode("SansSerif-BOLD-16"));
        UIManager.put("FireDial.font", Font.decode("SansSerif-9"));
        String colorName = this.getSettingsManager().getSettingString(PulseFireUISettingKeys.LAF_COLORS);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ((Object)((Object)this)).getClass().getClassLoader();
        }
        if ((in = cl.getResourceAsStream("org/nongnu/pulsefire/device/ui/resources/colors/" + colorName + ".properties")) == null) {
            this.logger.warning("Color schema not found: " + colorName);
            return "unknown";
        }
        try {
            Properties p = new Properties();
            p.load(in);
            for (Object key : p.keySet()) {
                String value = p.getProperty(key.toString());
                Color colorValue = Color.decode(value);
                UIManager.put(key, colorValue);
            }
        }
        catch (IOException e) {
            this.logger.warning("Could not load color schema: " + colorName + " error: " + e.getMessage());
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
        return colorName;
    }

    public static PulseFireUI getInstance() {
        return (PulseFireUI)PulseFireUI.getInstance(PulseFireUI.class);
    }

    public DeviceWireManagerController getDeviceManagerController() {
        return this.deviceManagerController;
    }

    public EventTimeManager getEventTimeManager() {
        return this.eventTimeManager;
    }

    public PulseFireTimeData getTimeData() {
        return this.timeData;
    }

    public DeviceWireManager getDeviceManager() {
        return this.getDeviceManagerController().getDefaultDeviceManager();
    }

    public DeviceData getDeviceData() {
        return this.getDeviceManager().getDeviceData();
    }

    public PulseFireUISettingManager getSettingsManager() {
        return this.settingsManager;
    }

    public boolean isWebStart() {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("javax.jnlp.BasicService");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    class ShutdownManager
    implements Application.ExitListener {
        ShutdownManager() {
        }

        public boolean canExit(EventObject e) {
            return true;
        }

        public void willExit(EventObject event) {
            PulseFireUI.this.logger.info("Shutdown requested.");
            long startTime = System.currentTimeMillis();
            PulseFireUI.this.getSettingsManager().setSettingInteger(PulseFireUISettingKeys.UI_SPLIT_BOTTOM, ((JMainPanel)PulseFireUI.this.getMainView().getComponent()).bottomSplitPane.getDividerLocation());
            PulseFireUI.this.getSettingsManager().setSettingInteger(PulseFireUISettingKeys.UI_SPLIT_BOTTOM_LOG, ((JMainPanel)PulseFireUI.this.getMainView().getComponent()).bottomLogSplitPane.getDividerLocation());
            PulseFireUI.this.getSettingsManager().saveSettings();
            PulseFireUI.this.dataLogManager.stop();
            PulseFireUI.this.eventTimeManager.shutdown();
            PulseFireUI.getInstance().getDeviceManager().disconnect();
            for (int i = 0; i < 20; ++i) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!PulseFireUI.getInstance().getDeviceManager().isConnected()) break;
            }
            long stopTime = System.currentTimeMillis();
            PulseFireUI.this.logger.info("PulseFireUI stopped in " + (stopTime - startTime) + " ms.");
        }
    }
}

