/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.time;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.nongnu.pulsefire.device.ui.time.EventTimeManager;
import org.nongnu.pulsefire.device.ui.time.EventTimeTrigger;

public class EventTimeThread
extends Thread {
    private Logger logger = null;
    private volatile boolean running = false;
    private EventTimeManager eventTimeManager = null;

    protected EventTimeThread(EventTimeManager eventTimeManager) {
        this.eventTimeManager = eventTimeManager;
        this.logger = Logger.getLogger(EventTimeThread.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.running = true;
            this.logger.info("EventTimer started");
            while (this.running) {
                Thread.sleep(100L);
                List<EventTimeTrigger> executeSteps = this.eventTimeManager.getEventExecuteSteps();
                for (EventTimeTrigger trig : executeSteps) {
                    trig.setRunStartTime(System.currentTimeMillis());
                    trig.setTimeNextRun(trig.getRunStartTime() + trig.getTimeStep());
                    try {
                        trig.getRunnable().run();
                    }
                    catch (Exception triggerException) {
                        this.logger.log(Level.WARNING, triggerException.getMessage(), triggerException);
                    }
                    finally {
                        trig.setRunStopTime(System.currentTimeMillis());
                        trig.setRunCounter(trig.getRunCounter() + 1L);
                        if (trig.getTimeRuns() == 0L || trig.getRunCounter() <= trig.getTimeRuns()) continue;
                        this.eventTimeManager.removeEventTimeTrigger(trig);
                    }
                }
            }
        }
        catch (Exception coreException) {
            this.logger.log(Level.WARNING, coreException.getMessage(), coreException);
        }
    }

    public void shutdown() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }
}

