/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.flash;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.nongnu.pulsefire.device.flash.AbstractFlashProgramController;
import org.nongnu.pulsefire.device.flash.FlashControllerConfig;
import org.nongnu.pulsefire.device.flash.FlashHexReader;
import org.nongnu.pulsefire.device.flash.FlashLogListener;
import org.nongnu.pulsefire.device.flash.FlashProgramController;
import org.nongnu.pulsefire.device.flash.avr.Stk500Controller;
import org.nongnu.pulsefire.device.flash.avr.Stk500v2Controller;
import org.nongnu.pulsefire.device.flash.avrdude.AvrdudeController;

public class FlashManager {
    public static void main(String[] argu) throws Exception {
        if (argu.length < 6) {
            System.out.println("\nUsage:\n  -P <port>     Serial port.\n  -c <proto>    Programmer protocol.\n  -f <file>     Flash hex file.\nOptional:\n  -v            Verbose output.\n  -V            Verify flash.\n  -PP <param>   Port parameters.\n  -s <sign>     Device signature in hex.\n  -nfc <cmd>    Native flash command as fallback.\n                For use prefix protocol with native-<proto>.\n");
            return;
        }
        ArrayList<String> arguList = new ArrayList<String>(argu.length);
        for (String a : argu) {
            arguList.add(a);
        }
        Iterator arguIterator = arguList.iterator();
        FlashControllerConfig config = new FlashControllerConfig();
        while (arguIterator.hasNext()) {
            String arg = (String)arguIterator.next();
            if ("-v".equals(arg)) {
                config.setLogDebug(true);
                continue;
            }
            if ("-V".equals(arg)) {
                config.setFlashVerify(true);
                continue;
            }
            if ("-P".equals(arg)) {
                if (!arguIterator.hasNext()) {
                    System.out.println("No argument for -P given");
                    return;
                }
                config.setPort((String)arguIterator.next());
                continue;
            }
            if ("-PP".equals(arg)) {
                if (!arguIterator.hasNext()) {
                    System.out.println("No argument for -PP given");
                    return;
                }
                config.setPortParameter((String)arguIterator.next());
                continue;
            }
            if ("-c".equals(arg)) {
                if (!arguIterator.hasNext()) {
                    System.out.println("No argument for -c given");
                    return;
                }
                config.setPortProtocol((String)arguIterator.next());
                continue;
            }
            if ("-f".equals(arg)) {
                if (!arguIterator.hasNext()) {
                    System.out.println("No argument for -f given");
                    return;
                }
                File hexFile = new File((String)arguIterator.next());
                try {
                    config.setFlashData(new FlashHexReader().loadHex(hexFile));
                    continue;
                }
                catch (FileNotFoundException e) {
                    System.out.println("Hex file not found: " + hexFile.getAbsolutePath());
                    return;
                }
                catch (IOException e) {
                    System.out.println("Error reading hex file: " + e.getMessage());
                    return;
                }
            }
            if ("-s".equals(arg)) {
                if (!arguIterator.hasNext()) {
                    System.out.println("No argument for -s given");
                    return;
                }
                String devSignStr = (String)arguIterator.next();
                if (devSignStr.startsWith("0x")) {
                    devSignStr = devSignStr.substring(2);
                }
                int deviceSign = Integer.parseInt(devSignStr, 16);
                config.setDeviceSignature(deviceSign);
            }
            if (!"-nfc".equals(arg)) continue;
            if (!arguIterator.hasNext()) {
                System.out.println("No argument for -nfc given");
                return;
            }
            String cmdStr = (String)arguIterator.next();
            config.setNativeFlashCmd(cmdStr);
        }
        FlashProgramController fm = FlashManager.createFlashController(config);
        fm.addFlashLogListener(new FlashLogListener(){

            @Override
            public void flashLogMessage(String message) {
                System.out.println(message);
            }
        });
        fm.flash(config);
    }

    public static FlashProgramController createFlashController(FlashControllerConfig flashControllerConfig) {
        if (flashControllerConfig == null) {
            throw new NullPointerException("Can't fill flash backend with null config.");
        }
        flashControllerConfig.verifyConfig();
        AbstractFlashProgramController backendController = null;
        if ("stk500".equals(flashControllerConfig.getPortProtocol())) {
            backendController = new Stk500Controller();
        } else if ("arduino".equals(flashControllerConfig.getPortProtocol())) {
            backendController = new Stk500Controller();
        } else if ("stk500v2".equals(flashControllerConfig.getPortProtocol())) {
            backendController = new Stk500v2Controller();
        } else if ("native-stk500".equals(flashControllerConfig.getPortProtocol())) {
            flashControllerConfig.setPortProtocol("stk500v1");
            backendController = new AvrdudeController();
        } else if ("native-arduino".equals(flashControllerConfig.getPortProtocol())) {
            flashControllerConfig.setPortProtocol("stk500v1");
            backendController = new AvrdudeController();
        } else if ("native-stk500v2".equals(flashControllerConfig.getPortProtocol())) {
            flashControllerConfig.setPortProtocol("stk500v2");
            backendController = new AvrdudeController();
        } else {
            throw new IllegalStateException("Unknow port protocol: " + flashControllerConfig.getPortProtocol());
        }
        return backendController;
    }
}

