/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.components;

import javax.swing.JPanel;
import org.nongnu.pulsefire.device.DeviceCommandListener;
import org.nongnu.pulsefire.device.DeviceConnectListener;
import org.nongnu.pulsefire.device.DeviceWireManager;
import org.nongnu.pulsefire.device.ui.JComponentEnableStateListener;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.device.ui.components.JFireDial;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;

public class JCommandDial
extends JPanel
implements JFireDial.DialListener,
DeviceCommandListener,
DeviceConnectListener {
    private static final long serialVersionUID = -2345234552345789002L;
    private JFireDial fireDial = null;
    private DeviceWireManager deviceManager = null;
    private Command command = null;
    private int idx = -1;

    public JCommandDial(CommandName commandName) {
        this(commandName, -1);
    }

    public JCommandDial(CommandName commandName, int idx) {
        this.idx = idx;
        this.deviceManager = PulseFireUI.getInstance().getDeviceManager();
        this.command = new Command(commandName);
        this.fireDial = new JFireDial(commandName.name());
        this.fireDial.setMaximum(commandName.getMaxValue());
        this.fireDial.addDialListener(this);
        JComponentEnableStateListener.attach(this.fireDial, commandName);
        this.deviceManager.addDeviceCommandListener(this.command.getCommandName(), (DeviceCommandListener)this);
        this.deviceManager.addDeviceConnectListener((DeviceConnectListener)this);
        this.add(this.fireDial);
    }

    @Override
    public void dialAdjusted(JFireDial.DialEvent e) {
        int v = e.getValue();
        this.command.setArgu0("" + v);
        if (this.idx != -1) {
            this.command.setArgu1("" + this.idx);
        }
        this.deviceManager.requestCommand(this.command);
    }

    public void commandReceived(Command command) {
        Integer valueOld;
        if (this.fireDial.isMouseDialing()) {
            return;
        }
        if (command.getArgu0() == null) {
            return;
        }
        if (command.getArgu0().isEmpty()) {
            return;
        }
        Integer valueNew = Integer.parseInt(command.getArgu0());
        if (valueNew == (valueOld = Integer.valueOf(this.fireDial.getValue()))) {
            return;
        }
        if (this.idx != -1) {
            if (command.getArgu1() == null) {
                return;
            }
            Integer idxNew = Integer.parseInt(command.getArgu1());
            if (this.idx != idxNew) {
                return;
            }
        }
        this.fireDial.setValue(valueNew);
    }

    public void deviceConnect() {
        int maxValue = this.command.getCommandName().getMaxValue();
        if (maxValue == 0) {
            maxValue = Integer.MAX_VALUE;
        }
        this.fireDial.setMaximum(maxValue);
    }

    public void deviceDisconnect() {
    }

    public JFireDial getFireDial() {
        return this.fireDial;
    }
}

