/* Copyright (C) 2012 Rudra Banerjee*/

/*
    This file is part of ptbl.

    ptbl is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    ptbl is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ptbl.  If not, see <http://www.gnu.org/licenses/>.

*/

#include <gtk/gtk.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>
void helpfhelp(GtkWidget *widget, gpointer data);

GtkWidget *window,
          *textview,
          *menubar,
          *filemenu,
          *filemenu_menu,
          *enew,
          *flabel,
          *open,
          *save,
          *separator_1,
          *quit,
          *editmenu,
          *editmenu_menu,
          *editcut,
          *editcopy,
          *editpaste,
          *separator_2,
          *editselectall,
          *editdeselect,
          *helpmenu,
          *helpmenu_menu,
          *helphelp,
          *helpabout,
          *toolbar1,
          *view,
          *dialog,
          *image;
GtkToolItem *tooleditcut;
GtkToolItem *tooleditcopy;
GtkToolItem *tooleditpaste;
GtkToolItem *separator_3;
GtkToolItem *tooleditselectall;
GtkAccelGroup *menuGroup;
GtkTextBuffer *textbuffer;
GtkTextBuffer *buffer;
GtkTextIter start, end;
GtkTextIter iter;

void helpabout_activated (GtkMenuItem *helpabout, GtkWindow *parentWindow);
#include "callbk_list.h"
int main(int argc,
        char *argv[]) {
    GtkWidget *grid,
              *button,
              *frame,
              *notebook,
              *label,
              *scrolledwindow,
              *filemenu, *helpmenu,
              *file,
              *new,*open,*save,*quit,
              *help, *about,//, *assistant;
              *sep,
              *table;
    GtkAccelGroup *accel_group = NULL;
#include "cwlst.h"

    gtk_init(&argc, &argv);
    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(window), "ptbl");
    gtk_container_set_border_width(GTK_CONTAINER(window), 5);
    g_signal_connect(window, "delete-event",
            G_CALLBACK(gtk_main_quit), NULL);


    GtkWidget *vbox1 = gtk_vbox_new(FALSE, 0);
    menubar = gtk_menu_bar_new();
    filemenu = gtk_menu_new();
    helpmenu = gtk_menu_new();
    gtk_box_pack_start(GTK_BOX(vbox1), menubar, FALSE, FALSE, 2);

    accel_group = gtk_accel_group_new();
    gtk_window_add_accel_group(GTK_WINDOW(window), accel_group);

    file = gtk_menu_item_new_with_mnemonic("_File");
    quit = gtk_image_menu_item_new_from_stock(GTK_STOCK_QUIT, accel_group);

    gtk_menu_item_set_submenu(GTK_MENU_ITEM(file), filemenu);
    gtk_menu_shell_append(GTK_MENU_SHELL(filemenu), quit);
    gtk_menu_shell_append(GTK_MENU_SHELL(menubar), file);


    help = gtk_menu_item_new_with_mnemonic("_Help");
    gtk_menu_shell_append(GTK_MENU_SHELL(menubar), help);
    about = gtk_image_menu_item_new_from_stock(GTK_STOCK_ABOUT, accel_group);
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(help), helpmenu);
    gtk_menu_shell_append(GTK_MENU_SHELL(helpmenu), about);

/*    GtkWidget *assist = gtk_image_menu_item_new_from_stock(GTK_STOCK_HELP, accel_group);
    gtk_menu_shell_append(GTK_MENU_SHELL(helpmenu), assist);*/
    
    GtkWidget *fhelp=gtk_menu_item_new_with_label(("Contents"));
    gtk_widget_add_accelerator(fhelp, "activate", accel_group, GDK_KEY_F1, 0, GTK_ACCEL_VISIBLE);    
    gtk_menu_shell_append(GTK_MENU_SHELL(helpmenu), fhelp);

    g_signal_connect(G_OBJECT(about), "activate", G_CALLBACK(helpabout_activated), (gpointer) window);
    g_signal_connect(G_OBJECT(quit), "activate", G_CALLBACK(gtk_main_quit), NULL);
    g_signal_connect_swapped(G_OBJECT(window), "destroy", G_CALLBACK(gtk_main_quit), NULL);
    g_signal_connect(G_OBJECT(fhelp), "activate", G_CALLBACK(helpfhelp), NULL);
 

    table = gtk_table_new(9, 17, TRUE);
    gtk_box_pack_start(GTK_BOX(vbox1), table, FALSE, FALSE, 2);
    gtk_container_add(GTK_CONTAINER(window), vbox1);

    /* Color Scheme */
    GdkColor colorRed = {0x0000, 60138, 17990, 17990};
    GdkColor colorRed2 = {0x0000, 65535, 29555, 24158};
    GdkColor colorDed = {0x0000, 65535, 0, 0};
    GdkColor colorGreen = {0x0000, 0x90ff, 0xeeff, 0x90ff};
    GdkColor colorRiron = {0x0000, 59881, 33667, 2570};
    GdkColor colorBlue = {0x0000, 3598, 57054, 61937};
    GdkColor colorYellow = {0x0000, 65535, 63222, 33667};
    GdkColor colorLvio = {0x0000, 52685, 37008, 65535};
    GdkColor colorIndi = {0x0000, 20817, 24672, 65535};
    GdkColor colorAsh = {0x0000, 62965, 51400, 51400};
    GdkColor colorLsh = {0x0000, 65535, 51143, 33924};
    GdkColor colorWht = {0x0000, 65535, 65535, 65535};
    GdkColor colorInt = {0x0000, 45000, 45000, 45000};


    /*
     * CREATING THE LAYOUT
     */

    /*  
     *    CREATE FIRST ROW   */


    /* Create first button */
    button = gtk_button_new_with_label("H");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_H), &child_window1);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 0, 1, 0, 1);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorBlue);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    /* Create second button */
    button = gtk_button_new_with_label("He");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_He), &child_window2);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 17, 18, 0, 1);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRed2);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);




    /*  
     *    CREATE SECOND ROW   */

    /* Create Li button */
    button = gtk_button_new_with_label("Li");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Li), &child_window3);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 0, 1, 1, 2);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRed);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    /* Create Be button */
    button = gtk_button_new_with_label("Be");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Be), &child_window4);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 1, 2, 1, 2);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorYellow);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    /* Create B button */
    button = gtk_button_new_with_label("B");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_B), &child_window5);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 12, 13, 1, 2);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorGreen);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    /* Create C button */
    button = gtk_button_new_with_label("C");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_C), &child_window6);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 13, 14, 1, 2);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorBlue);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    /* Create N button */
    button = gtk_button_new_with_label("N");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_N), &child_window7);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 14, 15, 1, 2);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorBlue);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    /* Create O button */
    button = gtk_button_new_with_label("O");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_O), &child_window8);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 15, 16, 1, 2);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorBlue);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    /* Create first button */
    button = gtk_button_new_with_label("F");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_F), &child_window9);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 16, 17, 01, 2);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorIndi);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    /* Create second button */
    button = gtk_button_new_with_label("Ne");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Ne), &child_window10);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 17, 18, 01, 2);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRed2);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    /*  
     *    CREATE THIRD ROW   */

    /* Create first button */
    button = gtk_button_new_with_label("Na");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Na), &child_window11);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 0, 1, 2, 3);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRed);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    /* Create second button */
    button = gtk_button_new_with_label("Mg");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Mg), &child_window12);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 1, 2, 2, 3);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorYellow);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    /* Create first button */
    button = gtk_button_new_with_label("Al");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Al), &child_window13);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 12, 13, 2, 3);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorLvio);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    /* Create second button */
    button = gtk_button_new_with_label("Si");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Si), &child_window14);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 13, 14, 2, 3);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorGreen);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    /* Create first button */
    button = gtk_button_new_with_label("P");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_P), &child_window15);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 14, 15, 2, 3);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorBlue);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    /* Create second button */
    button = gtk_button_new_with_label("S");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_S), &child_window16);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 15, 16, 2, 3);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorBlue);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    /* Create first button */
    button = gtk_button_new_with_label("Cl");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Cl), &child_window17);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 16, 17, 2, 3);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorIndi);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    /* Create second button */
    button = gtk_button_new_with_label("Ar");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Ar), &child_window18);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 17, 18, 2, 3);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRed2);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);




    /*  
     *    CREATE FORTH ROW   */

    /* Create first button */
    button = gtk_button_new_with_label("K ");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_K), &child_window19);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 0, 1, 3, 4);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRed);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    /* Create second button */
    button = gtk_button_new_with_label("Ca");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Ca), &child_window20);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 1, 2, 3, 4);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorYellow);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);




    button = gtk_button_new_with_label("Sc");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Sc), &child_window21);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 2, 3, 3, 4);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Ti");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Ti), &child_window22);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 3, 4, 3, 4);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("V ");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_V), &child_window23);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 4, 5, 3, 4);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Cr");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Cr), &child_window24);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 5, 6, 3, 4);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Mn");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Mn), &child_window25);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 6, 7, 3, 4);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Fe");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Fe), &child_window26);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 7, 8, 3, 4);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Co");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Co), &child_window27);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 8, 9, 3, 4);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("Ni");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Ni), &child_window28);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 9, 10, 3, 4);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("Cu");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Cu), &child_window29);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 10, 11, 3, 4);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("Zn");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Zn), &child_window30);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 11, 12, 3, 4);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);




    /* Create first button */
    button = gtk_button_new_with_label("Ga");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Ga), &child_window31);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 12, 13, 3, 4);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorLvio);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    /* Create second button */

    button = gtk_button_new_with_label("Ge");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Ge), &child_window32);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 13, 14, 3, 4);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorGreen);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    /* Create first button */
    button = gtk_button_new_with_label("As");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_As), &child_window33);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 14, 15, 3, 4);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorGreen);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    /* Create second button */
    button = gtk_button_new_with_label("Se");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Se), &child_window34);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 15, 16, 3, 4);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorBlue);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    /* Create first button */
    button = gtk_button_new_with_label("Br");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 1" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Br), &child_window35);


    /* Insert button 1 into the upper left quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 16, 17, 3, 4);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorIndi);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    /* Create second button */

    button = gtk_button_new_with_label("Kr");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Kr), &child_window36);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 17, 18, 3, 4);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRed2);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    /*  
     *    CREATE FIFTh ROW   */

    /* Create first button */
    button = gtk_button_new_with_label("Rb");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 1" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Rb), &child_window37);


    /* Insert button 1 into the upper left quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 0, 1, 4, 5);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRed);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    /* Create second button */

    button = gtk_button_new_with_label("Sr");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Sr), &child_window38);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 1, 2, 4, 5);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorYellow);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Y ");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Y), &child_window39);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 2, 3, 4, 5);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("Zr");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Zr), &child_window40);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 3, 4, 4, 5);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("Nb");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Nb), &child_window41);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 4, 5, 4, 5);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("Mo");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Mo), &child_window42);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 5, 6, 4, 5);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("Tc");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Tc), &child_window43);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 6, 7, 4, 5);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("Ru");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Ru), &child_window44);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 7, 8, 4, 5);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("Rh");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Rh), &child_window45);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 8, 9, 4, 5);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("Pd");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Pd), &child_window46);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 9, 10, 4, 5);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("Ag");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Ag), &child_window47);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 10, 11, 4, 5);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("Cd");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Cd), &child_window48);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 11, 12, 4, 5);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);




    /* Create first button */
    button = gtk_button_new_with_label("In");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 1" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_In), &child_window49);


    /* Insert button 1 into the upper left quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 12, 13, 4, 5);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorLvio);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    /* Create second button */

    button = gtk_button_new_with_label("Sn");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Sn), &child_window50);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 13, 14, 4, 5);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorLvio);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    /* Create first button */
    button = gtk_button_new_with_label("Sb");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 1" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Sb), &child_window51);


    /* Insert button 1 into the upper left quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 14, 15, 4, 5);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorGreen);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    /* Create second button */

    button = gtk_button_new_with_label("Te");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Te), &child_window52);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 15, 16, 4, 5);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorGreen);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    /* Create first button */
    button = gtk_button_new_with_label("I ");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_I), &child_window53);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 16, 17, 4, 5);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorIndi);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    /* Create second button */
    button = gtk_button_new_with_label("Xe");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Xe), &child_window54);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 17, 18, 4, 5);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRed2);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    /*  
     *    CREATE SIXTH ROW   */

    /* Create first button */
    button = gtk_button_new_with_label("Cs");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 1" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Cs), &child_window55);


    /* Insert button 1 into the upper left quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 0, 1, 5, 6);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRed);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    /* Create second button */

    button = gtk_button_new_with_label("Ba");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Ba), &child_window56);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 1, 2, 5, 6);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorYellow);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("La");

    /*  When the button is clicked, we call the "callback" function
      with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_La), &child_window57);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 2, 3, 5, 6);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorLsh);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("Hf");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Hf), &child_window72);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 3, 4, 5, 6);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("Ta");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Ta), &child_window73);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 4, 5, 5, 6);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("W ");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_W), &child_window74);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 5, 6, 5, 6);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("Re");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Re), &child_window75);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 6, 7, 5, 6);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("Os");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Os), &child_window76);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 7, 8, 5, 6);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("Ir");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Ir), &child_window77);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 8, 9, 5, 6);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("Pt");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Pt), &child_window78);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 9, 10, 5, 6);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("Au");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Au), &child_window79);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 10, 11, 5, 6);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("Hg");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Hg), &child_window80);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 11, 12, 5, 6);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);




    /* Create first button */
    button = gtk_button_new_with_label("Tl");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 1" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Tl), &child_window81);


    /* Insert button 1 into the upper left quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 12, 13, 5, 6);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorLvio);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    /* Create second button */

    button = gtk_button_new_with_label("Pb");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Pb), &child_window82);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 13, 14, 5, 6);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorLvio);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    /* Create first button */
    button = gtk_button_new_with_label("Bi");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 1" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Bi), &child_window83);


    /* Insert button 1 into the upper left quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 14, 15, 5, 6);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorLvio);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    /* Create second button */

    button = gtk_button_new_with_label("Po");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Po), &child_window84);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 15, 16, 5, 6);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorGreen);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    /* Create first button */
    button = gtk_button_new_with_label("At");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 1" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_At), &child_window85);


    /* Insert button 1 into the upper left quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 16, 17, 5, 6);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorIndi);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    /* Create second button */

    button = gtk_button_new_with_label("Rn");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Rn), &child_window86);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 17, 18, 5, 6);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRed2);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    /*  
     *    CREATE SEVENTH ROW   */

    /* Create first button */
    button = gtk_button_new_with_label("Fr");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 1" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Fr), &child_window87);


    /* Insert button 1 into the upper left quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 0, 1, 6, 7);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRed);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    /* Create second button */

    button = gtk_button_new_with_label("Ra");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Ra), &child_window88);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 1, 2, 6, 7);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorYellow);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Ac");

    /* When the button is clicked, we call the "callback" function
     with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Ac), &child_window89);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 2, 3, 6, 7);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorAsh);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("Rf");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Rf), &child_window104);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 3, 4, 6, 7);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("Db");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Db), &child_window105);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 4, 5, 6, 7);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("Sg");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Sg), &child_window106);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 5, 6, 6, 7);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("Bh");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Bh), &child_window107);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 6, 7, 6, 7);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("Hs");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Hs), &child_window108);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 7, 8, 6, 7);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("Mt");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Mt), &child_window109);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 8, 9, 6, 7);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorRiron);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);




    /*
     * The Lanthanides
     */

    button = gtk_button_new_with_label("La");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_La), &child_window57);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 2, 3, 7, 8);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorLsh);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    button = gtk_button_new_with_label("Ce");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Ce), &child_window58);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 3, 4, 7, 8);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorLsh);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Pr");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Pr), &child_window59);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 4, 5, 7, 8);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorLsh);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Nd");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Nd), &child_window60);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 5, 6, 7, 8);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorLsh);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Pm");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Pm), &child_window61);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 6, 7, 7, 8);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorLsh);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Sm");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Sm), &child_window62);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 7, 8, 7, 8);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorLsh);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Eu");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Eu), &child_window63);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 8, 9, 7, 8);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorLsh);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Gd");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Gd), &child_window64);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 9, 10, 7, 8);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorLsh);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Tb");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Tb), &child_window65);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 10, 11, 7, 8);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorLsh);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Dy");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Dy), &child_window66);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 11, 12, 7, 8);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorLsh);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Ho");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Ho), &child_window67);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 12, 13, 7, 8);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorLsh);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Er");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Er), &child_window68);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 13, 14, 7, 8);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorLsh);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Tm");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Tm), &child_window69);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 14, 15, 7, 8);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorLsh);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Yb");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Yb), &child_window70);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 15, 16, 7, 8);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorLsh);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Lu");

    /* When the button is clicked, we call the "callback" function
     * with a pointer to "button 2" as its argument */
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Lu), &child_window71);
    /* Insert button 2 into the upper right quadrant of the table */
    gtk_table_attach_defaults(GTK_TABLE(table), button, 16, 17, 7, 8);
    // without mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorLsh);
    // with mouse hovering
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    /* 
     * The Actenides Series
     */

    button = gtk_button_new_with_label("Ac");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Ac), &child_window89);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 2, 3, 8, 9);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorAsh);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Th");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Th), &child_window90);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 3, 4, 8, 9);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorAsh);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Pa");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Pa), &child_window91);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 4, 5, 8, 9);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorAsh);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("U ");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_U), &child_window92);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 5, 6, 8, 9);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorAsh);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Np");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Np), &child_window93);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 6, 7, 8, 9);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorAsh);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Pu");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Pu), &child_window94);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 7, 8, 8, 9);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorAsh);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Am");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Am), &child_window95);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 8, 9, 8, 9);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorAsh);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Cm");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Cm), &child_window96);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 9, 10, 8, 9);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorAsh);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Bk");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Bk), &child_window97);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 10, 11, 8, 9);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorAsh);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Cf");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Cf), &child_window98);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 11, 12, 8, 9);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorAsh);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Es");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Es), &child_window99);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 12, 13, 8, 9);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorAsh);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Fm");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Fm), &child_window100);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 13, 14, 8, 9);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorAsh);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Md");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Md), &child_window101);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 14, 15, 8, 9);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorAsh);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("No");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_No), &child_window102);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 15, 16, 8, 9);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorAsh);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);


    button = gtk_button_new_with_label("Lr");
    g_signal_connect(button, "clicked",
            G_CALLBACK(callback_Lr), &child_window103);
    gtk_table_attach_defaults(GTK_TABLE(table), button, 16, 17, 8, 9);
    gtk_widget_modify_bg(button, GTK_STATE_NORMAL, &colorAsh);
    gtk_widget_modify_bg(button, GTK_STATE_PRELIGHT, &colorWht);



    gtk_widget_show_all(window);
    gtk_main();

    return 0;
}
