/* Copyright (C) 2012 Rudra Banerjee*/

/*
    This file is part of ptbl.

    ptbl is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    ptbl is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ptbl.  If not, see <http://www.gnu.org/licenses/>.

*/

#include <gtk/gtk.h>

void callback_Eu(GtkWidget *button, gpointer user_data)
{
  GtkWidget **child_window63 = (GtkWidget**)user_data;  
  static GtkWidget *window = NULL;
  GtkWidget *hbox;
  GtkWidget *vbox;
  GtkWidget *frame;
  GtkWidget *label;


if (*child_window63) {
      gtk_window_present(GTK_WINDOW(*child_window63));
      return;
  }

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), "Eu");
  vbox = gtk_vbox_new (FALSE, 0);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), hbox);
  gtk_box_pack_start (GTK_BOX (hbox), vbox, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (window), 5);


  frame = gtk_frame_new ("Properties");
  label = gtk_label_new ("Name\nSymbol\nAtomic Number\n"                         "Atomic Weight\nElectron configuration\n"                          "Phase\nMelting point\nBoiling point\n"                          "Electronegativity\nElectronAffinity \n"                          "Valence \nAtomic radius \n"                         "Crystal structure\nLattice Constant\n"                         "Space Group");
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_container_add (GTK_CONTAINER (frame), label);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);

  frame = gtk_frame_new ("Values");
  label = gtk_label_new (NULL);
  char *str="Europium  \nEu\n"                          "63  \n151.964\n[Xe]4f<sup>7</sup>6s<sup>2</sup>\n"                          "Solid  \n822 °C \n1527 °C\n"                          "N/A \n50 kJ/mol\n"                          "3    \n231 pm \n"                          "Body Centered Cubic  \n458.1 pm\n"                          "Im_3m [229]";
  gtk_label_set_markup(GTK_LABEL(label), str);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_container_add (GTK_CONTAINER (frame), label);
  gtk_box_pack_start (GTK_BOX (hbox), frame, FALSE, FALSE, 0);

  gtk_window_set_resizable(GTK_WINDOW (window), FALSE);
  gtk_widget_show_all (window);
  gtk_window_present(GTK_WINDOW(window));
  *child_window63 = window;
  g_object_add_weak_pointer(G_OBJECT(window), (gpointer*)child_window63);


}

