/*
 * Copyright (C) 2005 Jia Wang (skyroam@gmail.com)
 *
 *
 *
 * This file is part of phc.
 * Phc is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by the 
 * Free Software Foundation; either version 2 of the License, or (at your 
 * option) any later version.
 *
 * Phc is distributed in the hope that it will be useful, but WITHOUT ANY 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
 * for more details.
 *
 *
 * You should have received a copy of the GNU General Public License 
 * along with Phc; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef HAVE_PHC_INCLUDE
#define HAVE_PHC_INCLUDE

/* global include */
#include<stdlib.h>
#include<stdio.h>
#include<pthread.h>
#include<errno.h>
#include <sys/socket.h>
#include<netdb.h>
extern int h_errno;
#include<netinet/in.h>
#include<arpa/inet.h>
/* #include<sys/select.h> */
#include<sys/time.h>
#include<sys/types.h>
#include<unistd.h>

/* local struct:loop.c */
struct queue
{
  char *testproxy;		/* As part of request to myproxy, thread  */

  /* if connection to testproxy directly or type of myproxy is socks5  */
  /*
     char *testhost; 
     char *testport; */

  /* reserved */
  /*
     char *protocol; 
     int proto; */
};

#define HTTP_GET 0
#define HTTP_CONNECT 1
#define SOCKS5_CONNECT 2
struct test
{
/*now only  HTTP_GET ,HTTP_CONNECT is supported*/
  int method;
  int testconreplysize;
  int testtagreplysize;
} test;
#define DIRECT -1
#define HTTP_CONNECT_AUTH 3
#define SOCKS5_CONNECT_AUTH 4
/* now only HTTP_CONNECT,HTTP_CONNECT_AUTH is permitted for mytype */
struct my
{
  int mytype;
  char *myhost;			/* read data from conf ,nouse after gethostbyname */
  int myport;
  int myconreplysize;
#define BASIC "Proxy-Authorization: Basic "
  unsigned char *header_auth;	/* auth header for myproxy,global if have */
  char *myuserpass;		/* nouse after header_auth is constructed */
  struct in_addr myip;
  struct sockaddr_in myaddr;
} my;
struct target
{
/* part of HTTP GET request to testproxy,global if need */
  char *target;
/* part of  HTTP CONNECT request to testproxy,global if need */
  char *target_host, *target_port, *target_path;
#define KEY "2005 Google"
  char *key;			/* global */
} target;

#define USER_AGENT "User-Agent: MSIE 6.0"
char *user_agent;		/* global */
#define NOCACHE "Pragma: no-cache"
#define CONNECT_SUCCESS0 "HTTP/1.0 200 Connection established"
#define CONNECT_SUCCESS1 "HTTP/1.1 200 Connection established"

#define THREADS  100
int threads;
#define PHC_IN "proxylist"
#define PHC_OUT "proxyout"
#define PHC_CONF "phc.conf"
FILE *out, *in;

#define time_sub(a,b) (((a).tv_usec-(b).tv_usec\
			+((a).tv_sec-(b).tv_sec)*1e6)*(double)(1e-6))
char *progname;			/* argv[1] here */

struct thread_mem
{
  char *line;
  struct queue queue;
  char *request;
  char *reply;
};
pthread_mutex_t counter_mutex_in;
pthread_mutex_t counter_mutex_out;
pthread_mutex_t counter_mutex_create;
pthread_mutex_t counter_mutex_malloc;

/* phc.c */
void INIT ();
void THREAD ();
void END ();


/* readconf.c */
int readint (char *line, char *flagstring, int *i, int *num);
int readstr (char *line, char *flagstring, char **s, int *num);
void READCONF ();

/* mem.c */
void mem_init (void);
void xexit (int status);
void *xmalloc (size_t size);
void xfree (void **p);
void *pxmalloc (size_t size, struct thread_mem *thread_mem);
void *pxrealloc (void *ptr, size_t size, struct thread_mem *thread_mem);
void thread_mem_init (struct thread_mem *thread_mem);
void x_pthread_exit (void *retval, struct thread_mem *thread_mem);
void pxfree (void **p);

/* base64en.c */
int base64en (unsigned char *dst, int dst_max, unsigned char *src,
	      int src_size);
/* getaline.c */
int getaline (unsigned char **line, int *size, FILE * f);
int getaline_r (char **line, int *size, FILE * f,
		struct thread_mem *thread_mem);

/* checkaline.c */
int checkaline (FILE * in, struct thread_mem *thread_mem);

/* loop.c */
int READAPROXY (struct thread_mem *thread_mem);
int CONNECTVIA (int sockfd, struct timeval *start,
		struct timeval *end, struct thread_mem *thread_mem);
int GET (int sockfd, struct timeval *send, struct thread_mem *thread_mem);
int CONN (int sockfd, struct timeval *start, struct timeval *end,
	  struct timeval *req, struct thread_mem *thread_mem);
int VERIFY (int sockfd, struct timeval *finddata,
	    struct timeval *findkey, struct thread_mem *thread_mem);
void *loop (void *arg);

#endif
