#include "Pan.hh"

Pan::Pan(int pSampleRate, int pChannels) : AudioFilter(pSampleRate, pChannels)
        {
	PENTERCONS;
	PEXITCONS;
        }

Pan::~Pan()
        {
	PENTERDES;
	PEXITDES;
        }


int Pan::load_data( char* audioFragment, int audioFragmentSize)
        {
        fragment = audioFragment;
        fragmentSize = audioFragmentSize;
        return 1;
        }

int Pan::prepare()
        {
        return 1;
        }

void Pan::set_pan(float p)
        {
        p = p>1.0?1.0:p;
        p = p<-1.0?-1.0:p;
        panFactor = p;
        }


float Pan::get_pan()
        {
        return panFactor;
        }


int Pan::process() // IMPROVE-ME. How to deal with many channels source ?
        {
        char* p = fragment;
        char* lastp = p + fragmentSize;
        while (p<lastp)
                {
                short* pshoL = (short*) p;
                short* pshoR = (short*) (p+sizeof(short));
                short sampleL = *pshoL;
                short sampleR = *pshoR;
                float panR = panFactor>=0 ? 1.0 : 1.0 + panFactor;
                float panL = panFactor>=0 ? 1.0 - panFactor : 1.0;
                float fsampleL = (float) sampleL * panL;
                float fsampleR = (float) sampleR * panR;
                *(pshoL)= (short) fsampleL;
                *(pshoR)= (short) fsampleR;
                p+=2*sizeof(short);
                }
        return 1;
        }

//eof
