/**************************************************************************************

        PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/
#include "NoiseGateController.hh"
#include <mustux.h>

NoiseGateController::NoiseGateController(FilterChain* chain )
        : FilterController(chain)
        {
        PENTERCONS;
	assocFilter = new NoiseGate(44100,2);
        curveThresholdIndex = get_curve_index(add_curve("Threshold"));
        curveAttackIndex = get_curve_index(add_curve("Attack"));
        curveReleaseIndex = get_curve_index(add_curve("Release"));
	set_current_curve(curveThresholdIndex);
        PEXITCONS;
        }

NoiseGateController::~NoiseGateController()
        {
        // standard routine to delete curves. Copy it to all xxxxController.cc destructors.
        for (int i=0; i<MAX_CURVES; i++)
                if (curve[i]) delete curve[i];
        }

void NoiseGateController::node_setup()
        {
        curve[currentCurveIndex]->get_current_curve_node()->setup();
        }


void NoiseGateController::setup()
        {
        FilterController::setup();

        }


QString NoiseGateController::get_type()
        {
        return "Noise Gate";
        }


void NoiseGateController::draw()
        {
        PENTER;
        FilterController::draw();
        PEXIT;
        }


int NoiseGateController::process(char* data, int size)
        {
	Song* parentSong = parentChain->assocTrack->parentSong;
        float th = -1.0 * (curve[curveThresholdIndex]->get_value_at(parentSong->get_playing_block()) - 100)/2; // 0..100%
        ((NoiseGate*) assocFilter)->set_threshold(th);
        if (assocFilter->load_data(data,size)<0) return -1;
        if (assocFilter->prepare()<0) return -1;
        if (assocFilter->process()<0) return -1;
        return 1;
        }

//eof
