#ifndef NOISEGATE_HH
#define NOISEGATE_HH

#include <mustux.h>
#include "AudioFilter.hh"

class NoiseGate : public AudioFilter
        {
        public:
                NoiseGate(int pSampleRate, int pChannels);
                ~NoiseGate();

                int load_data(   char* audioFragment, int audioFragmentSize ); // virtual
                int prepare(); // virtual
                int process(); // virtual

                void set_threshold(float value); // 0..100 %
                void set_attack(int value);
                void set_release(int value);

                float get_threshold(); // 0..100 %
                int get_attack();
                int get_release();

        private :

                int threshold;
                int release;
                int attack;
                bool *applying;
                int noiseCounter;


        };

#endif
