#include "NoiseGate.hh"
#include <stdlib.h>

NoiseGate::NoiseGate(int pSampleRate, int pChannels) : AudioFilter(pSampleRate, pChannels)
        {
        applying = new bool[channels];
        noiseCounter = 0;
        threshold = 0;
        release = 1000; // Aprox. 10 ms.
        }

NoiseGate::~NoiseGate()
        {
        delete applying;
        }


int NoiseGate::load_data(   char* audioFragment, int audioFragmentSize)
        {
        fragment = audioFragment;
        fragmentSize = audioFragmentSize;
        return 1;
        }

int NoiseGate::prepare()
        {
        return 1;
        }


void NoiseGate::set_attack(int value)
        {
        //TODO
        }


void NoiseGate::set_release(int value)
        {
        //TODO
        }

float NoiseGate::get_threshold()
        {
        return threshold;
        }

int NoiseGate::get_attack()
        {
        return attack;
        }

int NoiseGate::get_release()
        {
        return release;
        }


void NoiseGate::set_threshold(float value)
        {
        value = value > 100.0 ? 100.0 : value;
        value = value < 0.0 ? 0.0 : value;
        threshold = (int) (value * MAX_SAMPLE / 100);
        }

int NoiseGate::process() // IMPROVE-ME. threshold level and release time
                         // must be dinamically read from the curve
        {
        char* p = fragment;
        char* lastp = p + fragmentSize;
        while (p<lastp)
                {
                for (int k=0; k<channels; k++)
                        {
                        short* psho = (short*)p;
                        short sho = *(psho);
                        if (abs(sho)<threshold)
                                noiseCounter++;
                        else
                                {
                                noiseCounter=0;
                                applying[k]=false;
                                }
                        applying[k]=(noiseCounter>release);
                        if (applying[k])
                                *(psho)=0;
                        p+=sizeof(short);
                        }
                }
        return 1;
        }

//eof
