/**************************************************************************************

	PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
	AUTHOR : See AUTHORS file for details

	This software is distributed under the terms of the GNU General Public License
	as specified in the COPYING file.

***************************************************************************************/

#include <math.h>
#include "GainController.hh"
#include <math.h>
#include <mustux.h>

GainController::GainController(FilterChain* chain)
	: FilterController(chain)
	{
	PENTERCONS;
	assocFilter = new Gain(44100,2);
	Curve* c = add_curve("Amount");
	curveAmountIndex = get_curve_index(c);
	set_current_curve(curveAmountIndex);
	PEXITCONS;
	}

GainController::~GainController()
	{
	PENTERDES;
	// standard routine to delete curves.
	// Copy it to all xxxxController.cc destructors.
	for (int i=0; i<MAX_CURVES; i++)
		if (curve[i]) delete curve[i];
	delete assocFilter;
	PEXITDES;
	}

void GainController::node_setup()
	{
	curve[currentCurveIndex]->get_current_curve_node()->setup();
	}


void GainController::setup()
	{
	FilterController::setup();
	}

QString GainController::get_type()
	{
	return "Gain";
	}

void GainController::draw()
	{
	PENTER;
	FilterController::draw();
	PEXIT;
	}

int GainController::process(char* data, int size)
	{
	PENTER4;
	long long pb = parentChain->assocTrack->parentSong->get_playing_block();
	float v = curve[curveAmountIndex]->get_value_at(pb);
	float vdb = (v*25.0)/100;
	float gain = (vdb>=0.0)? 1.0f + vdb/6.0f : 1.0f / pow(2.0f,-1.0f*vdb/6.0f);
	assocFilter->set_wet_out(gain);
	if (assocFilter->load_data(data,size)<0) return -1;
	if (assocFilter->prepare()<0) return -1;
	if (assocFilter->process()<0) return -1;
	PEXIT4;
	return 1;
	}
//eof
