/**************************************************************************************

	PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
	AUTHOR : See AUTHORS file for details

	This software is distributed under the terms of the GNU General Public License
	as specified in the COPYING file.

***************************************************************************************/

#include "Gain.hh"


Gain::Gain(int pSampleRate, int pChannels) : AudioFilter(pSampleRate, pChannels)
	{
	PENTERCONS;
	wetOut=1;
	PEXITCONS;
	}

Gain::~Gain()
	{
	PENTERDES;
	PEXITDES;
	}


int Gain::load_data(   char* audioFragment, int audioFragmentSize)
	{
	fragment = audioFragment;
	fragmentSize = audioFragmentSize;
	return 1;
	}

int Gain::prepare()
	{
	return 1;
	}


void Gain::set_gain(float g)
	{
	g=g>MAX_GAIN ? MAX_GAIN : g;
	g=g<0.0 ? 0.0 : g;
	gain=g;
	}

float Gain::get_gain()
	{
	return gain;
	}

int Gain::process()
	{
	PENTER;
	char* p = fragment;
	char* lastp = p + fragmentSize;
	while (p<lastp)
		{
		for (int k=0; k<channels; k++)
			{
			short* psho = (short*)p;
			short sample = *(psho);
			float fsample = (float) sample * wetOut;
			CHECK_SAMPLE_OVERLOAD(fsample);
			*(psho)= (short) fsample;
			p+=sizeof(short);
			}
		}
	PEXIT;
	return 1;
	}

//eof
