/**************************************************************************************

        PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/

#ifndef FILTERCONTROLLER_HH
#define FILTERCONTROLLER_HH


#include  <mustux.h>
#include <qtimer.h>
class Curve;
class CurveNode;
class AudioFilter;
class FilterChain;

class FilterController : public MustuxDrawableRegion
        {
        Q_OBJECT

        public:

                static const int MAX_CURVES=10;

                FilterController ( FilterChain* chain );
                virtual ~FilterController();

                virtual int process(char* data, int size);

                virtual void setup();
                virtual void node_setup();
/*                virtual int get_baseX();
                virtual int get_baseY();
                virtual int get_width();
                virtual int get_height();
                virtual void set_baseX(int initialValue);
                virtual void set_baseY(int initialValue);
                virtual void set_width(int initialValue);
                virtual void set_height(int initialValue);
*/
		virtual QString get_type();

                void draw();

                void update_current_node(int x);

                void activate();
                void deactivate();

                int cleanup();
                void start_blinking();
                void stop_blinking();

                Curve* add_curve(QString type);
                Curve* get_curve(QString curveType);
                Curve* get_current_curve();
                AudioFilter* get_filter();

                QWidget* setupFrontend;

                QString get_schema();

                void set_current_curve(QString type);
                void set_current_curve(int index);

                int get_curve_index(Curve* c);

		FilterChain* parentChain;
        protected:
                int currentCurveIndex;
                AudioFilter* assocFilter;
                QTimer* blinkCurveTimer;
                QTimer* blinkCurveNodeTimer;
                Curve* curve[MAX_CURVES];

        public slots:

                void blink_curve();
                void blink_curve_node();


        };

#include "../Song.hh"
#include "Curve.hh"
#include "CurveNode.hh"
#include "AudioFilter.hh"
#include "FilterChain.hh"

#endif
