/**************************************************************************************

	PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
	AUTHOR : See AUTHORS file for details

	This software is distributed under the terms of the GNU General Public License
	as specified in the COPYING file.

***************************************************************************************/

#include "FilterController.hh"

FilterController::FilterController ( FilterChain* chain ) : MustuxDrawableRegion(chain->assocTrack->get_drawarea())
	{
	PENTERCONS;
	this->parentChain = chain;

	currentCurveIndex=-1;
	for (int i=0; i<MAX_CURVES; i++) curve[i]=(Curve*) 0;

	blinkCurveTimer = new QTimer(this);
	blinkCurveNodeTimer = new QTimer(this);

	connect( blinkCurveTimer , SIGNAL(timeout()), this, SLOT(blink_curve()));
	connect( blinkCurveNodeTimer , SIGNAL(timeout()), this, SLOT(blink_curve_node()));

	setupFrontend = new QWidget(0);
	setupFrontend->resize(300,200);
	PEXITCONS;
	}

FilterController::~FilterController()
	{
	PENTERDES;
	PEXITDES;
	}

void FilterController::setup()
	{
	PENTER2;
	setupFrontend->show();
	PEXIT2;
	}


void FilterController::node_setup()
	{
	PERROR("Ooops ! I should have not been called ... I am a virtual method!");
	}


QString FilterController::get_type()
	{
	PERROR("Ooops ! I should have not been called ... I am a virtual method!");
	return "";
	}


int FilterController::process(char* data, int size)
	{
	PERROR("Ooops ! I should have not been called ... I am a virtual method!");
	return -1;
	}


void FilterController::draw()
	{
	curve[currentCurveIndex]->show();
	}


void FilterController::update_current_node(int x)
	{
	PENTER4;
	long long blockPos = parentChain->assocTrack->parentSong->xpos_to_block(x);
	CurveNode* lastnode = curve[currentCurveIndex]->currentNode;
	if (blockPos>=0)
		{
		CurveNode* cn = curve[currentCurveIndex]->get_nearest_node(blockPos);
		if (cn) curve[currentCurveIndex]->currentNode=cn;
		if ((lastnode != curve[currentCurveIndex]->currentNode) && (lastnode->isHighLighted))
			lastnode->toggle_highlight();
		}
	PEXIT4;
	}

void FilterController::activate()
	{
	PENTER2;
	start_blinking();
	PEXIT2;
	}


void FilterController::deactivate()
	{
	PENTER2;
	stop_blinking();
	PEXIT2;
	}


void FilterController::blink_curve()
	{
	//curve[currentCurveIndex]->...
	}

void FilterController::blink_curve_node()
	{
	curve[currentCurveIndex]->currentNode->toggle_highlight();
	}


void FilterController::start_blinking()
	{
	PENTER2;
	blinkCurveTimer->start(250);
	blinkCurveNodeTimer->start(250);
	PEXIT2;
	}


void FilterController::stop_blinking()
	{
	PENTER2;
	blinkCurveTimer->stop();
	blinkCurveNodeTimer->stop();
	if (curve[currentCurveIndex]->currentNode && (curve[currentCurveIndex]->currentNode->isHighLighted))
		curve[currentCurveIndex]->currentNode->toggle_highlight();
	PEXIT2;
	}



Curve* FilterController::get_current_curve()
	{
	return curve[currentCurveIndex];
	}


void FilterController::set_current_curve(QString type)
	{
	PENTER3;
	for (int i=0; i<MAX_CURVES; i++)
		{
		if (curve[i] && (curve[i]->get_type()==type))
			{
			set_current_curve(i);
			break;
			}
		}
	PEXIT3;
	}

void FilterController::set_current_curve(int index)
	{
	PENTER3;
	currentCurveIndex=index;
	PEXIT3;
	}


Curve*  FilterController::get_curve(QString curveType)
	{
	PENTER3;
	for (int i=0; i<MAX_CURVES; i++)
		{
		if ((curve[i]) && (curveType==curve[i]->get_type()))
			{
			PEXIT3;
			return curve[i];
			}
		}
	PEXIT3;
	return (Curve*) 0;
	}


int FilterController::get_curve_index(Curve* c)
	{
	PENTER3;
	for (int i=0; i<MAX_CURVES; i++)
		{
		if ((curve[i]) && (c==curve[i]))
			{
			PEXIT3;
			return i;
			}
		}
	PEXIT3;
	return -1;
	}


Curve* FilterController::add_curve(QString type)
	{
	PENTER2;
	int ind=-1;
	for (int i=0; i<MAX_CURVES; i++)
		{
		// cannot add a same filter twice
		if (curve[i] && (curve[i]->get_type()==type))
			{
			PEXIT2;
			return (Curve* )0;
			}
		}
	for (int i=0; i<MAX_CURVES; i++)
		{
		if (!curve[i])
			{
			ind=i;
			break;
			}
		}
	if (ind>=0)
		{
		curve[ind]=new Curve(this,type);
		set_current_curve(ind);
		PEXIT2;
		return curve[ind];
		}
	PEXIT2;
	return (Curve*) 0;
	}


AudioFilter* FilterController::get_filter()
	{
	return assocFilter;
	}

int FilterController::cleanup()
	{
	assocFilter->cleanup();
	}

QString FilterController::get_schema()
	{
	PENTER2;
	QString schema="";
	for (int i=0; i<MAX_CURVES; i++)
		{
		if (curve[i])
			{
			schema=schema + "            <curve type=\"" + curve[i]->get_type()+"\">\n";
			schema=schema + curve[i]->get_schema();
			schema=schema + "            </curve>\n";
			}
		}
	PEXIT2;
	return schema;
	}

//eof
