/**************************************************************************************

        PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
        AUTHOR : See AUTHORS file for details

        This software is distributed under the terms of the GNU General Public License
        as specified in the COPYING file.

***************************************************************************************/
#include "DelayController.hh"

DelayController::DelayController(FilterChain* chain )
	: FilterController(chain)
	{
	PENTERCONS;
	assocFilter = new Delay(44100,2);
	curveWetOutIndex = get_curve_index(add_curve("WetOut"));
	curveDelayTimeIndex = get_curve_index(add_curve("DelayTime"));
	curveDelayReleaseIndex = get_curve_index(add_curve("DelayRelease"));
	set_current_curve(curveWetOutIndex);
 	PEXITCONS;
	}

DelayController::~DelayController()
	{
	PENTERDES;
	for (int i=0; i<MAX_CURVES; i++)
		if (curve[i]) delete curve[i];

	PEXITDES;
	}


void DelayController::node_setup()
	{
	curve[currentCurveIndex]->get_current_curve_node()->setup();
	}


void DelayController::setup()
	{
	FilterController::setup();
	}


QString DelayController::get_type()
	{
	return "Delay";
	}


void DelayController::draw()
	{
	PENTER;
	FilterController::draw();
	PEXIT;
	}


int DelayController::process(char* data, int size)
	{
	if (assocFilter->load_data(data,size)<0) return -1;
	if (assocFilter->prepare()<0) return -1;
	if (assocFilter->process()<0) return -1;
	return 1;
	}

//eof

